C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  hilbert
C
C**********************************************************************C
C
C hilbert READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C applies the hilbert transform to the trace,
C and writes either the transforms or the envelopes to output file
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, hilb
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     itr(SZLNHD)
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LUOUT,LBYTES,NBYTES,obytes
      integer     argis
      REAL        xtr( SZLNHD ), ytr(SZLNHD), f(SZLNHD)
      REAL        work(SZLNHD )
      CHARACTER   NAME * 4, ntap * 512, otap * 512
#include <f77/pid.h>
      logical     verbos,query,env,filt
 
      DATA NAME     /'HILB'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./,env/.true./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c-------------------------------------
c  open printout file
c-------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,nstr,nend,nrst,nred,
     &               lf,wc,verbos)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'HILB: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt ( ITR, LBYTEs, NAME, 4, LERR        )

c-------------------------------
c  save key header values
#include <f77/saveh.h>
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

c-------------------------
c  verbos printout
c     if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' Format of Data     =  ', iform
c     endif

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      iend=iend/nsi + .5
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
      call cmdchk (nstr,nend,nrst,nred,ntrc,nrec)
      jtrc=nend-nstr+1
      nrecc=nred-nrst+1

c-------------------------------------------------------
c  update line header & write out header
       call savew( itr, 'NumTrc', jtrc , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)
       call savew( itr, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo
      call savhlh ( itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

c----------------------------------------
c  verbos printout
c     if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Line header values after default check '
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsampo
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', jtrc 
         write(LERR,*) ' Records per Line   =  ', nrecc
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Length hilbert filter = ',lf
         write(LERR,*) ' Ross weight           = ',wc
c     endif

c----------------------------------
c  skip to start record
      call recskp(1,nrst-1,luin,ntrc,itr)

c----------------------------------
c  compute hilbert filter
c     call hilf ( 1.0, wc, lf, f )

c     use hilbertx
c----------------------------------

C**********************************************************************C
C
C     READ TRACE, DO hilbert transform, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      DO 100 JJ = NRST, NRED

c--------------------------------------
c  skip to start trace of this record
            call trcskp(jj,1,nstr-1,luin,ntrc,itr)

           DO 99 KK = NSTR, NEND

c-----------------
c  read data
                nbytes = 0
                CALL RTAPE  ( LUIN , ITR, NBYTES         )
                if(nbytes .eq. 0) then
                   write(LERR,*)'End of file on input:'
                   write(LERR,*)'  rec= ',jj,'  trace= ',kk
                   go to 999
                endif
                call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
c---------------
c  do hilbert
                call vmov (xtr(ist),1,ytr,1,nsampo)
c               call fold ( lf, f, nsampo, ytr, ndum, work )
c               call vmov (work(lf/2), 1, xtr, 1, nsampo)
                call hilbertx (ytr, nsampo, work, ierr, SZSMPD)
                call vmov (work, 1, xtr, 1, nsampo)

c---------------
c  write data
                call vmov  (xtr, 1, itr(ITHWP1), 1, nsampo)
                call wrtape(luout,itr,obytes)

   99      CONTINUE

c------------------------------------------
c  skip to end of current record
            call trcskp(jj,nend+1,ntrc,luin,ntrc,itr)

  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END



c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)'Here Are the Command Line Parameters for HILB'
        write(LER,*)'               -- local hilbert transformer'
        write(LER,*)' '
        write(LER,*)'Input........................................(def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-l[lf]     -- length of filter in samples  (63)'
        write(LER,*)'-w[wc]     -- ross weight on filter    (none)'
        write(LER,*)'-s[ist]    -- start time                    (0 ms)'
        write(LER,*)'-e[iend]   -- end time                 (last samp)'
        write(LER,*)'-ns[nstr]  -- start trace #             (first tr)'
        write(LER,*)'-ne[netr]  -- end trace #                (last tr)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)' hilb -N[] -O[] -l[] -w[] -s[] -e[] '
        write(LER,*)'       -ns[] -ne[] -rs[] -re[] -V'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c    nstr   - I      start trace
c    nend   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c      lf   - I      length of hilbert filter
c      wc   - R      ross weighting
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,nstr,nend,nrst,nred,
     &               lf,wc,verbos)
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     argis,ist,iend,nstr,nend,nrst,nred
      logical     verbos

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argi4('-l',lf,63,63)
          call argr4('-w',wc,0.0,0.0)
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argi4('-ns',nstr,0,0)
          call argi4('-ne',nend,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
