/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
#include <stdio.h>
#include <size_defs.h>
#include <save_defs.h>
#include <cu_defs.h>
#include <io_defs.h>
#include <ut_defs.h>
/*
	This code is a (hopefully) temporary module built to fix a
	problem caused during the introduction of the /apps/dist 
	structure and the scripts used for firing up USP binaries.
	Because of the way things are fired, the full path name of
	the binary is used, and, as a result, the full path name
	is used when creating the HLH entry. This has since been 
	fixed in the hlh utility routines in libut.a. However, fixing
	it in all codes would require a total re-linking on all 
	architectures of all USP codes. This program is designed to
	"clean" datasets containing directory names in HLH entries 
	until that time when it is no longer necessary.

					- joe m. wade 		1/15/97

*/

#define FILELEN 1024

void main(argc,argv)
int argc;
char **argv;
{
	char *ntap,*otap;
	int luin,luout;
	int nbytes;
	int i,k,position;
	int hlh_entries,hlh_bytes;
	int hlh_entry_length, new_hlh_entry_length;
	int bytes_removed = 0;
	char *hlh_entry,*new_hlh_entry;
	char *first_blank,*last_slash;
	char *outbuf;
	char *short_byte;
	void help();

	if (C_ARGIS("-h",&argc,argv) != 0) help();
	if (C_ARGIS("-?",&argc,argv) != 0) help();

	ntap = (char *)malloc(1024*sizeof(char));
	if (ntap == NULL) {
	  fprintf(stderr,"hlhclean ERROR: unable to allocate space;");
	  fprintf(stderr,"%d bytes requested\n",FILELEN);
	  exit(1);
	  }

	otap = (char *)malloc(1024*sizeof(char));
	if (otap == NULL) {
	  fprintf(stderr,"hlhclean ERROR: unable to allocate space;");
	  fprintf(stderr,"%d bytes requested\n",FILELEN);
	  exit(1);
	  }

	C_ARGSTR("-N",ntap,"","",&argc,argv);
	if (strlen(ntap) == 0) {
	  luin = 0;
	  }
	else {
	  C_LBOPEN(&luin,ntap,"r");
	  }

	C_ARGSTR("-O",otap,"","",&argc,argv);
	if (strlen(otap) == 0) {
	  luout = 1;
	  }
	else {
	  C_LBOPEN(&luout,otap,"w");
	  }

	nbytes = SZLNHD * sizeof(char);
	outbuf = (char *) malloc(nbytes);
	if (outbuf == NULL) {
	  fprintf(stderr,"hlhclean ERROR: unable to allocate space;");
	  fprintf(stderr,"%d bytes requested\n",nbytes);
	  exit(1);
	  }

	C_RTAPE(luin,outbuf,&nbytes);

	outbuf = (char *) realloc(outbuf,nbytes);

	C_SAVER(outbuf,"HlhEnt",&hlh_entries,LINEHEADER);
	C_SAVER(outbuf,"HlhByt",&hlh_bytes,LINEHEADER);

	position = HLHOFF + (2*HLHINT);

	short_byte = (char *) &hlh_entry_length;
	short_byte += sizeof(int) - HLHINT;

	for (i=0, hlh_entry=outbuf+position;
		i<hlh_entries; i++, hlh_entry+=hlh_entry_length) {

	   memset(&hlh_entry_length, 0, sizeof(int));
	   memcpy(short_byte, hlh_entry, HLHINT);

	   hlh_entry+=HLHINT;

	   if (*hlh_entry == '/') {
	     first_blank = (char *) strchr(hlh_entry,' ');
	     if (first_blank != NULL) {
		for (; first_blank > hlh_entry; first_blank--)
		  if (*first_blank == '/') {
		    last_slash = first_blank;
		    break;
		    }
		}
	     new_hlh_entry_length = hlh_entry_length+hlh_entry-last_slash;
	     new_hlh_entry = hlh_entry-HLHINT-bytes_removed;
	     memset(new_hlh_entry, 0, HLHINT);
	     memcpy(new_hlh_entry,
		(char *)(&new_hlh_entry_length) + sizeof(int) - HLHINT, HLHINT);
	     new_hlh_entry += HLHINT;
	     memcpy(new_hlh_entry,last_slash+1,new_hlh_entry_length);
#ifndef CRAYSYSTEM
	     bytes_removed += hlh_entry_length - new_hlh_entry_length;
#else
	     bytes_removed += 
		   ((int) ((hlh_entry_length+7) / 8) * 8) -
		   ((int) ((new_hlh_entry_length+7) / 8) * 8);
#endif
	     }
	   else if (bytes_removed != 0) {
	     new_hlh_entry = hlh_entry-HLHINT-bytes_removed;
	     memset(new_hlh_entry, 0, HLHINT);
	     memcpy(new_hlh_entry, short_byte, HLHINT);
	     new_hlh_entry += HLHINT;
	     memcpy(new_hlh_entry, hlh_entry, hlh_entry_length);
	     }
#ifdef CRAYSYSTEM
	   hlh_entry_length = (int) ((hlh_entry_length+7) / 8) * 8;
#endif
	   }

	nbytes -= bytes_removed;
	hlh_bytes -= bytes_removed;
	C_SAVEW(outbuf,"HlhByt",hlh_bytes,LINEHEADER);

	while (nbytes != 0) {
	  int recno, trcno;
	  C_SAVER(outbuf,"RecNum",&recno,TRACEHEADER);
	  C_SAVER(outbuf,"TrcNum",&trcno,TRACEHEADER);
	  C_WRTAPE(luout,outbuf,nbytes);
	  C_RTAPE(luin,outbuf,&nbytes);
	  }
	C_LBCLOS(luout);
	exit(0);
}
void help()
{
	fprintf(stderr,"Purpose: Remove full path names from HLH entries\n\n");
	fprintf(stderr,"Usage: hlhclean -N[ntap] -O[otap]\n\n");
	fprintf(stderr,"Options:\n");
	fprintf(stderr,"  -N  input data set ((default=stdin)\n");
	fprintf(stderr,"  -O  output data set ((default=stdout)\n");
	exit(0);
}
