C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getcolor(icolor,nh,nl,ns,ncolor,mincvalue,
     1                    uhmin,uhmax,chmin,chmax,
     2                    ulmin,ulmax,clmin,clmax,
     3                    usmin,usmax,csmin,csmax,luhls,lerr)
      integer    icolor(nh,0:nl,ns)
c_____________________________________________________________
c     generate the color table with hue varying fastest,
c     followed by lightness, then saturation
c_____________________________________________________________
      if(nh .gt. 1.) then
         if(abs(chmax-chmin) .eq. 360.) then
c_____________________________________________________________
c           don't repeat endmembers if 360 degrees apart.
c_____________________________________________________________
            dch=(chmax-chmin)/nh
         else
            dch=(chmax-chmin)/(nh-1)
         endif
      else
         dch=0.
         chmin=chmax
      endif
      if(nl .gt. 1.) then
         dcl=(clmax-clmin)/(nl-1)
      else
         dcl=0.
         clmin=clmax
      endif
      if(ns .gt. 1.) then
         dcs=(csmax-csmin)/(ns-1)
      else
         dcs=0.
         csmin=csmax
      endif
c
      write(luhls,'(i12,t40,a)') ncolor,'number of colors'
      write(luhls,'(4a12)') 'data value','hue','lightness',
     1                      'saturation'
c_____________________________________________________________
c     color 0 is black.
c_____________________________________________________________
      jcolor=0
      cl=0.
      ch=0.
      cs=0.
      do 8000 js=1,ns
       do 7000 jh=1,nh
        icolor(jh,0,js)=jcolor
        jvalue=mincvalue+4*(jcolor-0)               
7000   continue
8000  continue
      write(luhls,'(i12,3f12.6)') jvalue,ch,cl,cs
c_____________________________________________________________
c     set other colors. 
c_____________________________________________________________
      do 30000 js=1,ns
       do 20000 jl=1,nl
        do 10000 jh=1,nh
         jcolor=jcolor+1
         icolor(jh,jl,js)=jcolor
         ch=chmin+(jh-1)*dch
         cl=clmin+(jl-1)*dcl
         cs=csmin+(js-1)*dcs
         jvalue=mincvalue+4*(jcolor-0)
         write(luhls,'(i12,3f12.6)') jvalue,ch,cl,cs
10000   continue
20000  continue
30000 continue
      write(lerr,'(4a10)') 'jh','jl','js','icolor'
      write(lerr,'(4i10)') (((jh,jl,js,icolor(jh,jl,js),jh=1,nh),
     1                 jl=0,nl),js=1,ns)
c
      return
      end
