C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program hlsplot
c______________________________________________________________________
c     hlsplot reads in 2 or 3 USP format data sets and maps them into 
c     an HLS (hue, lightness, saturation) color display.
c______________________________________________________________________
c     Author
c
c     Kurt J. Marfurt (Amoco EPTG, Tulsa OK, USA)
c     February 1,1996.   
c______________________________________________________________________
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c______________________________________________________________________
c
      parameter   (pi=3.1415926,twopi=2.*pi)
      integer     startline,endline,starttrace,endtrace
      integer     sheader(SZLNHD)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
c
      character*120  file_h,file_l,file_s,file_out
      character*120  file_hls,file_legend
      character*6    name
      logical        verbose,query,IKP
      logical        hue,lightness,saturation
      integer        argis
      integer        stdin,stdout,stderr
      character*9    host,blank9
      integer        pipe(4)
      data           host/'         '/
      data           blank9/'         '/
      data           pipe/0,3,4,1/

c
      data           name/'HLSPLOT'/
      data           luhls/88/
c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
      else
         IKP=.false.
      endif

c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      do 10000 j=1,20
       cputim(j)=0.
       waltim(j)=0.
10000 continue
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query=(argis( '-?' ) .gt. 0 )
      if(query) then
         call help(ler)
         call exitfu(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     read input data set names from the command line.
c_______________________________________________________________
      call argstr('-H',file_h, ' ', ' ')
      call argstr('-L',file_l, ' ', ' ')
      call argstr('-S',file_s, ' ', ' ')
c_______________________________________________________________
c     read output data set names from the command line.
c_______________________________________________________________
      call argstr('-O',file_out,' ', ' ')
      call argstr('-hls',file_hls,'hls.table',
     1                            'hls.table')
      call argstr('-legend',file_legend,'color_legend',
     1            'color_legend')
      call argr4('-chmin',chmin,-180.,-180.)
      call argr4('-chmax',chmax,+180.,+180.)
      call argr4('-clmin',clmin,10.,10.)
      call argr4('-clmax',clmax,60.,60.)
      call argr4('-csmin',csmin,0.,0.)
      call argr4('-csmax',csmax,100.,100.)
      call argr4('-uhmin',uhmin,0.,0.)
      call argr4('-uhmax',uhmax,0.,0.)           
      call argr4('-ulmin',ulmin,0.,0.)
      call argr4('-ulmax',ulmax,0.,0.)
      call argr4('-usmin',usmin,0.,0.)
      call argr4('-usmax',usmax,0.,0.)
      call argi4('-nh',nh,1,1)       
      call argi4('-nl',nl,1,1)       
      call argi4('-ns',ns,1,1)       
      call argi4('-npix',npix,10,10) 
c_______________________________________________________________
c     open input files.
c_______________________________________________________________
      if(file_h .eq. ' ') then
         if (IKP) then
            hue = (pipcnt(pipe(1),1) .gt. 0)
            if (hue) call sisfdfit(luh,pipe(1))
         else
            hue=.false.
         endif
      else
         hue=.true.
         call getln(luh,file_h,'r',0)
      endif
      if(file_l .eq. ' ') then
         if (IKP) then
            lightness = (pipcnt(pipe(2),1) .gt. 0)
            if (lightness) call sisfdfit(lul,pipe(2))
         else
            lightness=.false.
         endif
      else
         lightness=.true.
         call getln(lul,file_l,'r',0)
      endif
      if(file_s .eq. ' ') then
         if (IKP) then
            saturation = (pipcnt(pipe(3),1) .gt. 0)
            if (saturation) call sisfdfit(lus,pipe(3))
         else
            saturation=.false.
         endif
      else
         saturation=.true.
         call getln(lus,file_s,'r',0)
      endif
c_______________________________________________________________
c     open output files.
c_______________________________________________________________
      if (IKP) then
         call sisfdfit(luout,pipe(4))
      else
         call getln(luout,file_out,'w',1)
      endif
      call lbopen(lulegend,file_legend,'w')
      open(luhls,file=file_hls,form='FORMATTED',status='UNKNOWN')
c
      if(hue) then
C_______________________________________________________________________
c        read in the line header for the hue file.
c_______________________________________________________________________
         lbytes=0
         call rtape(luh,sheader,lbytes)
         if(lbytes .eq. 0) then
            write(lerr,*)'HLSPLOT: no header read from unit ',lul
            write(ler,*)'HLSPLOT: no header read from unit ',lul
            call exitfu(1666)
         endif
         call hlhprt(sheader,lbytes,name,len(name),lerr)
         call saver(sheader,'NumSmp',nsamp_h,LINEHEADER)
         call saver(sheader,'NumTrc',ntr_h,LINEHEADER)
         call saver(sheader,'NumRec',nrec_h,LINEHEADER)
         call saver(sheader,'SmpInt',nsi_h,LINEHEADER)
         call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      endif
      if(lightness) then
C_______________________________________________________________________
c        read in the line header for the lightness file.
c_______________________________________________________________________
         lbytes=0
         call rtape(lul,sheader,lbytes)
         if(lbytes .eq. 0) then
            write(lerr,*)'HLSPLOT: no header read from unit ',lul
            write(ler,*)'HLSPLOT: no header read from unit ',lul
            call exitfu(1666)
         endif
         call hlhprt(sheader,lbytes,name,len(name),lerr)
         call saver(sheader,'NumSmp',nsamp_l,LINEHEADER)
         call saver(sheader,'NumTrc',ntr_l,LINEHEADER)
         call saver(sheader,'NumRec',nrec_l,LINEHEADER)
         call saver(sheader,'SmpInt',nsi_l,LINEHEADER)
         call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      endif
      if(saturation) then
C_______________________________________________________________________
c        read in the line header for the saturation file.
c_______________________________________________________________________
         lbytes=0
         call rtape(lus,sheader,lbytes)
         if(lbytes .eq. 0) then
            write(lerr,*)'HLSPLOT: no header read from unit ',lus
            write(ler,*)'HLSPLOT: no header read from unit ',lus
            call exitfu(1666)
         endif
         call hlhprt(sheader,lbytes,name,len(name),lerr)
         call saver(sheader,'NumSmp',nsamp_s,LINEHEADER)
         call saver(sheader,'NumTrc',ntr_s,LINEHEADER)
         call saver(sheader,'NumRec',nrec_s,LINEHEADER)
         call saver(sheader,'SmpInt',nsi_s,LINEHEADER)
         call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      endif
C_______________________________________________________________________
c     check for consistency of input files.
c_______________________________________________________________________
      ioerror=0
      if(hue) then
         if(lightness) then
            if(nsamp_h .ne. nsamp_l .or. ntr_h .ne. ntr_l .or.
     1         nrec_h .ne. nrec_l .or. nsi_h .ne. nsi_l) then
               write(lerr,*) 'data input error!'
     1                         //' inconsistent sized files!'
               write(lerr,'(a10,i10)') 'nsamp_h',nsamp_h,
     1                           'nsamp_l',nsamp_l,
     2                           'ntr_h',ntr_h,'ntr_l',ntr_l, 
     3                           'nrec_h',nrec_h,'nrec_l',nrec_l,
     4                           'nsi_h',nsi_h,'nsi_l',nsi_l
               ioerror=ioerror+1
            endif
         endif
         if(saturation) then
            if(nsamp_h .ne. nsamp_s .or. ntr_h .ne. ntr_s .or.
     1         nrec_h .ne. nrec_s .or. nsi_h .ne. nsi_s) then
               write(lerr,*) 'data input error!'
     1                         //' inconsistent sized files!'
               write(lerr,'(a10,i10)') 'nsamp_h',nsamp_h,
     1                           'nsamp_s',nsamp_s,
     2                           'ntr_h',ntr_h,'ntr_s',ntr_s,
     3                           'nrec_h',nrec_h,'nrec_s',nrec_s,
     4                           'nsi_h',nsi_h,'nsi_s',nsi_s
               ioerror=ioerror+1
            endif
         endif
         nsamp=nsamp_h
         ntr=ntr_h 
         nrec=nrec_h
         nsi=nsi_h
      elseif(lightness) then
         if(saturation) then
            if(nsamp_s .ne. nsamp_l .or. ntr_s .ne. ntr_l .or.
     1         nrec_s .ne. nrec_l  .or. nsi_s .ne. nsi_l) then
               write(lerr,*) 'data input error!'
     1                         //' inconsistent sized files!'
               write(lerr,'(a10,i10)') 'nsamp_l',nsamp_l,
     1                        'nsamp_s',nsamp_s,
     2                        'ntr_l',ntr_l,'ntr_s',ntr_s,
     3                        'nrec_l',nrec_l,'nrec_s',nrec_s,
     4                        'nsi_l',nsi_l,'nsi_s',nsi_s
               ioerror=ioerror+1
            endif
         endif
         nsamp=nsamp_l
         ntr=ntr_l 
         nrec=nrec_l
         nsi=nsi_l
      elseif(saturation) then
         nsamp=nsamp_s
         ntr=ntr_s
         nrec=nrec_s
         nsi=nsi_s
      else
         write(lerr,*) 'command line error!'
         write(lerr,*) 'must enter a file name after either '
     1                 //' -H, -L or -S options!'
      endif
      if(hue) then
         if(nh .le. 0) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'nh = ',nh,' must be > 0 !'
            ierror=ierror+1
         endif
      else
         nh=1
      endif
      if(lightness) then
         if(nl .le. 0) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'nl = ',nl,' must be > 0 !'
            ierror=ierror+1
         endif
      else
         nl=1
      endif
      if(saturation) then
         if(ns .le. 0) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'ns = ',ns,' must be > 0 !'
            ierror=ierror+1
         endif
      else
         ns=1
      endif


      if(ierror .ne. 0) then
         write(lerr,*) ierror,' command line errors! program aborted!'
         call exitfu(666)
      endif
c
      ncolor=nh*nl*ns+1
      mincvalue=-4*(ncolor/2)
      dtmsec=nsi
c_______________________________________________________________
c     read other necessary parameters from the command line
c_______________________________________________________________
      call argr4('-tstart',tstart,0.,0.)
      call argr4('-tend',tend,0.,0.)
      call argi4('-startline',startline,1,1)
      call argi4('-endline',endline,nrec,nrec)
      call argi4('-starttrace',starttrace,1,1)
      call argi4('-endtrace',endtrace,ntr,ntr)  
      verbose=(argis('-V') .gt. 0)
      ierror=0
      tend_orig=tstart_orig+(nsamp-1)*dtmsec
      if(tend .eq. 0) tend=tend_orig
      starttrace=max(starttrace,1)
      endtrace=min(endtrace,ntr)
      startline=max(startline,1)
      endline=min(endline,nrec)
c
      istart=nint((tstart-tstart_orig)/dtmsec)
      iend=nint((tend-tstart_orig)/dtmsec)
      istart=max(0,istart)
      iend=min(nsamp-1,iend)
      if(iend .lt. istart) then
         write(lerr,*) 'error in HLSPLOT!'
         write(lerr,*) 'istart exceeds iend !'
         write(lerr,*) 'tstart,istart ',tstart,istart
         write(lerr,*) 'tend,  iend   ',tend,iend       
         call exitfu(6666)
      endif
c
      nsamp_out=iend-istart+1
      nline_out=endline-startline+1
      ntr_out=endtrace-starttrace+1
      nbytes_out=(nsamp_out+ITRWRD)*szsmpd
      nbytes_out_legend=(npix*nh+ITRWRD)*szsmpd
c
      write(lerr,*)
      write(lerr,'(/,a,t40,a,t50,a,/)') 
     1                   'FILE DESCRIPTION','UNIT','NAME' 
      write(lerr,'(a,t40,i5,t50,a)') 'input hue file',luh,file_h,
     1 'input lightness file',lul,file_l,
     2 'input saturation file',lus,file_s,
     3 'output file',luout,file_out,
     4 'output hls table',luhls,file_hls
      write(lerr,'(a,t40,i5)') 'nh',nh,'nl',nl,'ns',ns,
     1                   'ncolor',ncolor,'mincvalue',mincvalue
      write(lerr,'(a,t40,f12.6)') 'chmin',chmin,'chmax',chmax,
     1  'clmin',clmin,'clmax',clmax,'csmin',csmin,'csmax',csmax
      write(lerr,'(a,t40,f12.6)') 'uhmin',uhmin,'uhmax',uhmax,
     1  'ulmin',ulmin,'ulmax',ulmax,'usmin',usmin,'usmax',usmax
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr  
      write(lerr,'(a,t40,i5)') 'number of input records',nrec 
      write(lerr,'(a,t40,i5)') 'number of output samples',nsamp_out
      write(lerr,'(a,t40,i5)') 'number of output traces',ntr_out  
      write(lerr,'(a,t40,f12.6)') 'sample interval (msec)', 
     1                         dtmsec
      write(lerr,'(a,t40,f12.6)') 'original start time (msec)',
     1                             tstart_orig
      write(lerr,'(a,t40,f12.6)') 'original end time (msec)',
     1                             tend_orig
      write(lerr,'(a,t40,f12.6)') 'output start time (msec)',
     1                             tstart
      write(lerr,'(a,t40,f12.6)') 'output end time (msec)',
     1                             tend
      write(lerr,'(a,t50,i5)') 'startline',startline,
     1         'endline',endline,'starttrace',starttrace,
     2         'endtrace',endtrace
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      lenu=nsamp_out*ntr_out
      lencolor=nh*(nl+1)*ns
      lentracebuf=ITRWRD+max(nsamp,nh*npix)
c
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uh',l_uh,l_free,lenu,lerr)
      call mapmem('ul',l_ul,l_free,lenu,lerr)
      call mapmem('us',l_us,l_free,lenu,lerr)
      call mapmem('uout',l_uout,l_free,lenu,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,lentracebuf,lerr)
      call mapmem('trchdr',l_trchdr,l_free,ITRWRD*ntr_out,lerr)
      call mapmem('icolor',l_icolor,l_free,lencolor,lerr)
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for HLSPLOT: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program HLSPLOT aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program HLSPLOT aborted'
         call exitfu(101)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of traces output
c     determine if the attributes will go to separate files or
c     one large files with attribute lines written back to back.
C_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      jtstart=nint(tstart)
      call savew(sheader,'TmMsFS',tstart,LINEHEADER)
      call savew(sheader,'TmMsSl',jtstart,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'NumTrc',ntr_out,LINEHEADER)
      call savew(sheader,'NumRec',nline_out,LINEHEADER)
      call savew(sheader,'SmpInt',nsi,LINEHEADER)
      call wrtape(luout,sheader,lbyout)
c
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c_____________________________________________________________   
c     write out the color map.
c     in order to store colors in top 6 bits of an 8 bit
c     seismic word we need to convert omega values from 
c     (1,ncolors) to (-4*(ncolors/2),+4*(ncolors/2))
c     in this way we can load a landmark seisworks color tables.
c     ncolors must be ODD!
c_____________________________________________________________   
      call getcolor(s(l_icolor),nh,nl,ns,ncolor,mincvalue,
     1              uhmin,uhmax,chmin,chmax,
     2              ulmin,ulmax,clmin,clmax,
     3              usmin,usmax,csmin,csmax,luhls,lerr)
      close (luhls)         
c
      call savew(sheader,'NumSmp',nh*npix,LINEHEADER)
      call savew(sheader,'NumTrc',nl*npix,LINEHEADER)
      call savew(sheader,'NumRec',ns*npix,LINEHEADER)
      call wrtape(lulegend,sheader,lbyout)
      call getlegnd(s(l_icolor),s(l_tracebuf),nh,nl,ns,npix,
     1              mincvalue,ITRWRD,TRACEHEADER,
     2              l_TrcNum,ifmt_TrcNum,ln_TrcNum,
     3              l_RecNum,ifmt_RecNum,ln_RecNum,
     4              lerr,lulegend,nbytes_out_legend)
      call lbclos(lulegend)
c_____________________________________________________________   
c     process the data
c_____________________________________________________________   
      call process(s(l_uh),s(l_ul),s(l_us),s(l_uout),s(l_tracebuf),
     1             s(l_trchdr),s(l_icolor),nh,nl,ns,
     2             nsamp,ITRWRD,nbytes_out,
     3             istart,iend,starttrace,endtrace,ntr,
     4             startline,endline,
     5             luh,lul,lus,luout,lerr,ler,
     6             hue,lightness,saturation,
     7             uhmin,uhmax,chmin,chmax,
     8             ulmin,ulmax,clmin,clmax,
     9             usmin,usmax,csmin,csmax,mincvalue,
     a             l_StaCor,ifmt_StaCor,ln_StaCor,TRACEHEADER)
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'process data',cputim(2),waltim(2),
     3         'write output',cputim(3),waltim(3)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      if(luout .ne. stdout) call lbclos(luout)
      if(hue) call lbclos(luh)
      if(lightness) call lbclos(lul)
      if(saturation) call lbclos(lus)

      write(ler,*)'normal completetion. routine HLSPLOT'           
      write(lerr,*)'normal completetion. routine HLSPLOT'           
      close(lerr)
      call exitfu(0)
c
      end
      subroutine help(ler)
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'plot 1,2 or 3 data sets using an HLS color map'      
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute hlsplot by typing hlsplot and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) correlation to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
        write(ler,*)
     1' -H [file_h]  (optional)   : input Hue USP-format file'        
        write(ler,*)
     1' -L [file_l]  (optional)   : input Lightness USP-format file'        
        write(ler,*)
     1' -S [file_s]  (optional)   : input Saturation USP-format file'        
        write(ler,*)
     1' -O [file_out]  (stdout)   : output composite HLS file'
     2                 //' (combination of dip and azimuth)'
        write(ler,*) 
     1' -hls [file_hls] (hls_table): output file hls table needed'
     2                 //' for generation of color table'      
        write(ler,*)
     1'                   (Default name = hls.table)'
        write(ler,*)
     1' -uhmin[uhmin] (0.)   : minimum clip value for file_h'    
        write(ler,*)
     1' -uhmax[uhmax] (0.)   : maximum clip value for file_h'    
        write(ler,*)
     1' -ulmin[ulmin] (0.)   : minimum clip value for file_l'    
        write(ler,*)
     1' -ulmax[ulmax] (0.)   : maximum clip value for file_l'    
        write(ler,*)
     1' -usmin[usmin] (0.)   : minimum clip value for file_s'    
        write(ler,*)
     1' -usmax[usmax] (0.)   : maximum clip value for file_s'    
        write(ler,*)
     1' -chmin[chmin] (-180.): minimum hue to be displayed' 
        write(ler,*)
     1' -chmax[chmax] (+180.): maximum hue to be displayed' 
        write(ler,*)
     1' -clmin[clmin] (10.)  : minimum lightness to be displayed'
        write(ler,*)
     1' -clmax[clmax] (60.)  : maximum lightness to be displayed'
        write(ler,*)
     1' -csmin[csmin] (0.)   : minimum saturation to be displayed'
        write(ler,*)
     1' -csmax[csmax] (100.) : maximum saturation to be displayed'
        write(ler,*)
     1' -tstart[tstart] (first sample) : starting time in ms'         
        write(ler,*)
     1' -tend[tend]   (last  sample) : ending   time in ms'         
        write(ler,*)
     1' -startline (1)       : first line to be processed'
        write(ler,*)
     1' -endline   (last)    : last line to be processed'
        write(ler,*)
     1' -starttrace (1)      : first trace to be processed'
        write(ler,*)
     1' -endtrace   (last)   : last trace to be processed'
        write(ler,*)
     1' -V                   : if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'hlsplot -H[file_h] -L[file_l] -S[file_s]'
       write(ler,*)'        -O[file_out] -hls[file_hls] '
       write(ler,*)'        -uhmin[uhmin] -uhmax[uhmax]'
       write(ler,*)'        -ulmin[ulmin] -ulmax[ulmax]'
       write(ler,*)'        -usmin[usmin] -usmax[usmax]'
       write(ler,*)'        -chmin[chmin] -chmax[chmax]'
       write(ler,*)'        -clmin[clmin] -clmax[clmax]'
       write(ler,*)'        -csmin[csmin] -csmax[csmax]'
       write(ler,*)'        -tstart[] -tend[] '
       write(ler,*)'        -startline[] -endline[]'
       write(ler,*)'        -starttrace[] -endtrace[]'
       write(ler,*)'        -V'
       write(ler,*)' '
       write(ler,*)

      return
      end
