C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Predictive Deconvolution
C
C**********************************************************************C
C
C PRED READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does a predictive deconvolution with optional filtering and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, predictive routines
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis
      integer     ps, pe
#include <f77/pid.h>
      real        xtr ( SZLNHD ), otrace(SZLNHD), wtrace(4*SZLNHD)
      real        pf(SZLNHD), weight(SZLNHD), vel(SZLNHD)
      real        work(SZLNHD)

      CHARACTER   NAME * 7, ntap * 256, otap * 256
      CHARACTER   hdrwrd * 6
      logical     verbos,query, gate, cost, bart, first, astart
      logical     reverse
 
      DATA  NAME     /'HORPRED'/
      DATA  LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data  verbos/.false./
      data  first/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = ( argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
              call help()
              stop
      endif

C**********************************************************************C
C     open printout files
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from the command line
C**********************************************************************C
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                 ps,pe,prew,verbos, gate,cost,bart,
     2                 hdrwrd,velval,astart)

C**********************************************************************C
C     open data units
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

C**********************************************************************C
C     read lineheader; save key parameters; modify parameters;
C     update header; write out header
C**********************************************************************C
      lbytes = 0
      CALL RTAPE  ( LUIN, lhed, LBYTES        )
      CALL HLHprt ( lhed , LBYTES, NAME, 7, LERR        )
      if(lbytes .eq. 0) then
         write(LERR,*)'WBPRED: no header read on unit ',ntap
         write(LERR,*)'check existence of data file'
         write(LERR,*)'FATAL'
         stop
      endif

c------
c     save certain parameters

      call saver(lhed, 'NumSmp', nsamp , LINHED)
      call saver(lhed, 'SmpInt', nsi   , LINHED)
      call saver(lhed, 'NumTrc', ntrc  , LINHED)
      call saver(lhed, 'NumRec', nrec  , LINHED)
      call saver(lhed, 'Format', iform , LINHED)

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)

      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)

      ntr   = ntrc
      nrecc = nrec

c------
c  dtmsec = millisecs or microsecs depending on the sample interval units
c  dt     = secs always
c------
      if (nsi .ge. 32) then
         dtmsec = nsi
         dt     = real (nsi) /1000000.
      else
         dtmsec = nsi
         dt     = real (nsi) /1000.
      endif

         iend  = iend/dtmsec + .5
         ist   = ist/dtmsec
         if(ist .le. 1) ist = 1
         ist0 = ist
         if(iend .eq. 0) iend = nsamp
         if(iend .gt. nsamp) iend = nsamp
         iend0 = iend
         iwnd = dtmsec * (iend - ist + 1)

       nsampo = iend - ist + 1

       call savew( lhed, 'NumSmp', nsamp , LINHED)
       call savew( lhed, 'NumTrc', ntr  , LINHED)
       call savew( lhed, 'NumRec', nrecc, LINHED)

       if (velval .ne. 0.0) then
          do  i = 1, nsamp
              vel (i) = velval
          enddo
       endif
C**********************************************************************C
C     print line header values
C**********************************************************************C
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi   
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform

        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval (ms)= ', dtmsec
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrecc 
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) 'Relative to trace header time:'
        write(LERR,*) 'Start prediction    =  ',ps
        write(LERR,*) 'End prediction      =  ',pe
c       if (velval .ne. 0.0)
c    1  write(LERR,*)'NMO velocity         =  ',velval
        write(LERR,*)'Prewhitening= ',prew,' %'
        write(LERR,*)'Design window start time =  ',ist0,' samples'
        write(LERR,*)'Design window end time   =  ',iend,' samples'
        write(LERR,*)'Cosine weighting of auto-corr  = ',cost
        write(LERR,*)'Bartlett weighting of auto-corr= ',bart
        write(LERR,*)'Start time stored in trc header wrd= ',hdrwrd
        write(LERR,*)'Start time stored in trc header pos= ',l_hdrwrd
        if (gate)
     1  write(LERR,*)'Apply decon only within design window'
        if (astart)
     1  write(LERR,*)'Auto-start design window at trace header time'

        prew = prew / 100.
        ps   = ps / nsi
        pe   = pe / nsi

      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh( lhed, lbytes, lbyout)
      CALL WRTAPE ( LUOUT, lhed, LBYOUT                 )


C**********************************************************************C
C     main processing loop:
C          read trace; deconvolve; write output
C**********************************************************************C
      JJ = 1
      KK = 1

      DO WHILE (1.eq.1)


                 nbytes = 0
                 CALL RTAPE  ( LUIN , lhed, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif
                 call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp) 

                 call vclr (pf, 1, lf2)

                 call saver2(lhed,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                       idist, TRACEHEADER)
                 dist = abs (float(idist))

                 IF (JJ .ge. nrst .and. JJ .le. nred .AND.
     1                        KK .ge. nst .and. KK .le. ned) THEN

c-------------------------
c  preserve dead tr flag
              	     call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,
     1                           istatic, TRACEHEADER)

                   IF(istatic .ne. 30000) THEN
 
                      iend = iend0
c-----
c       read header to extract start time, ihdr
c-----
              	      call saver2(lhed,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,
     1                            ihdr, TRACEHEADER)
                      ihdr = ihdr / nsi + 1

                      if (astart) then
                         ist = ihdr
                      else
                         ist  = ist0
                      endif

                      if (velval .ne. 0.0) then
                         reverse = .false.
                         call nmo  (xtr, vel, otrace, dist, nsamp, dt,
     1                              work, reverse)
                      else
                         call vmov (xtr, 1, work, 1, nsamp)
                      endif
                     
                      lpr  = ihdr - ps
                      if (lpr .le. 0) lpr = 1
                      lpf  = ps + pe
                      lf   = lpr + lpf
                      
                      iend = ist + nsampo - 1
c-----
                      if (iend .gt. nsamp) iend = nsamp
 
                      nsampk     = iend - ist + 1
 
                      if (nsampk .le. lf) then
                         write(LERR,*)'Design window time LT filter'
                         write(LERR,*)'length -- FATAL'
                         write(LERR,*)'Increase window start velocity'
                         write(LERR,*)'-v1[], and/or decrease end windw'
                         write(LERR,*)'vel -v2[] & re-run'
                         write(LER ,*)'Design window time LT filter'
                         write(LER ,*)'length -- FATAL'
                         write(LER ,*)'Increase window start velocity'
                         write(LER ,*)'-v1[], and/or decrease end windw'
                         write(LER ,*)'vel -v2[] & re-run'
                         go to 999
                      endif


                      call dotpr (work(ist),1,work(ist),1,xdot,nsampk)
                      if ( xdot .ne. 0.0 ) then

                           if (.not. first) then
                              call wgt (lpf, cost, bart, weight)
                           endif
c++++++++++++++++++++
c  time invariant option
                           call predik (nsampk,work(ist),lpr,lpf,pf,
     1                                  ase,prew,wtrace,weight)
                           lf = lpr + lpf
c++++++++++++++++++++
                           first = .true.
                      endif

c--------------------
c apply only within 
c design window, or
                      call vclr (otrace, 1, nsamp)

                      if (gate) then
                         call fold(lf,pf,nsampk,work(ist),nfold,otrace)
                         call vmov(otrace,1,work(ist),1,nsampk)
c over whole trace
                      else
                         call fold(lf,pf,nsamp,work,nfold,otrace)
                         call vmov(otrace,1,work,1,nsamp)
                      endif
c--------------------

 
                      if(verbos) then
                        write(LERR,*)'Record= ',jj,' Trace= ',kk,
     1                               ' Window start sample= ',ist,
     2                               ' end time (samps)= ',iend
                      endif

                      if (velval .ne. 0.0) then
                         reverse = .true.
                         call nmo  (work, vel, xtr, dist, nsamp, dt,
     1                              otrace, reverse)
                      else
                         call vmov (work, 1, otrace, 1, nsamp)
                      endif
                     
                      call vmov (otrace, 1, lhed(ITHWP1), 1, nsamp)

                   ENDIF

                 ENDIF

                 call wrtape(luout,lhed,obytes)

 
   99        CONTINUE


             KK = KK + 1
             if (kk .eq. ntrc) then
                 kk = 1
                 jj = jj + 1
             endif

      ENDDO

  999 continue

         call lbclos(luin)
         call lbclos(luout)

      END

c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for horpred: predictive'
        write(LER,*)'decon driven by header word horizon times'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)' '
        write(LER,*)'design window:'
        write(LER,*)'-s[ist]    -- start time                    (0 ms)'
        write(LER,*)'-e[iend]   -- end time                 (last samp)'
        write(LER,*)'-v[vel]    -- apply single value NMO          (no)'
        write(LER,*)' '
        write(LER,*)'prediction parameters:'
        write(LER,*)'-ps[ps]    -- prediction start time delay from hdr 
     1time (48)'
        write(LER,*)'-pe[pe]    -- prediction end time advance from hdr 
     1time (48)'
        write(LER,*)'-P[prew]   -- prewhitening                   (.01)'
        write(LER,*)' '
        write(LER,*)'trace/record limitation:'
        write(LER,*)'-ns[nst]   -- start process trc #       (first tr)'
        write(LER,*)'-ne[ned]   -- end process trc #          (last tr)'
        write(LER,*)'-rs[nrst]  -- start process rec #      (first rec)'
        write(LER,*)'-re[nred]  -- end process rec  #        (last rec)'
        write(LER,*)' '
        write(LER,*)'-C         -- cosine weighting of auto-corr'
        write(LER,*)'-B         -- bartlett weighting of auto-corr'
        write(LER,*)'           -- default is no weighting of auto-corr'
        write(LER,*)'-G         -- apply decon only within design windw'
        write(LER,*)'-S         -- auto-start design window to hdr time'
        write(LER,*)'-hw[hdrwrd]-- trc hdr word with start time (none)'
        write(LER,*)'Note: can have sum of const + dx/v + hdr time + ...
     1'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'     horpred -N[] -O[] -v[] -s[] -e[] -v[]'
        write(LER,*)'             -P[] -ps[] -pe[] -ns[] -ne[] -rs[]'
        write(LER,*)'             -re[] [ [-hw[]] -S -G -C -B -V]'
        write(LER,*)' '
 
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vtap  - C*100  velocity tape file
c       s   - I      start time
c       e   - I      stop time
c     nst   - I      start trace
c     ned   - I      stop trace
c    nrst   - I      start record
c    nred   - I      end record
c      pr   - R      prediction distance
c     vel   - R      velocity for design window
c      ol   - R      operator length
c    prew   - R      prewhitening
c   predict - L      output predictable part of data
c    gate   - L      apply only within the design window
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                 ps,pe,prew,verbos, gate,cost,bart,
     2                 hdrwrd,velval,astart)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), hdrwrd * 6
      integer    ist,iend,nst,ned,nrst,nred, argis
      integer    ps, pe
      real       prew
      logical    verbos, gate, cost, bart, astart

          call argstr ('-N', ntap ,' ',' ')
          call argstr ('-O', otap ,' ',' ')
          call argr4 ('-v', velval , 0.0 , 0.0 )
          call argi4 ('-s',  ist ,1,1) 
          call argi4 ('-e',  iend ,0,0) 
          call argi4 ('-ps', ps , 48 , 48 )
          call argi4 ('-pe', pe , 48 , 48 )
          call argr4 ('-P',  prew ,.01,.01)
          call argi4 ('-ns', nst ,0,0)
          call argi4 ('-ne', ned ,0,0)
          call argi4 ('-rs', nrst ,1,1)
          call argi4 ('-re', nred ,0,0)
          call argstr ('-hw', hdrwrd, 'WDepDP', 'WDepDP')

          if(ps .eq. 0.0 .AND. pe .eq. 0.) then
             write(LERR,*)'No prediction start/end times given -- FATAL'
             stop
          endif

          astart   = ( argis( '-S' ) .gt. 0 )
          gate     = ( argis( '-G' ) .gt. 0 )
          cost     = ( argis( '-C' ) .gt. 0 )
          bart     = ( argis( '-B' ) .gt. 0 )

          if (hdrwrd(1:1) .eq. ' ') then
              write(LERR,*)'Must enter header word mnemonic'
              write(LERR,*)'Use -hw[] cmd line arg & rerun'
              stop
          endif

          verbos   = ( argis( '-V' ) .gt. 0 )

      return
      end
