C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c horvel reads velspec semblance records, 2 velocity-time
c picks (which define a velocity fairway), and picks made from
c several horizons of a stacked section
c and puts it all together to automatically generate velocity
c functions (velocity tape), and
c writes the results to an output file

c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77

#include <f77/iounit.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     zhed( SZLNHD )
      real        head( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     iseg
      integer     irec, itrc, recmin, recmax
      integer     srcloc, recind, dphind, dstsgn

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
c     integer     static
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      real        times, data, pikout
      integer     recnum
      pointer     (wkrecnum, recnum(1))
      pointer     (wktimes , times (1))
      pointer     (wkdata  , data  (1))
      pointer     (wkpikout, pikout(1))

      real        vello(SZLNHD), velhi(SZLNHD ), velf(SZLNHD)
      real        velav(SZLNHD)
      real        tf(SZLNHD), tmp1(SZLNHD), tmp2(SZLNHD)
      real        vout(SZLNHD), velsem(SZLNHD)
      real        vlst(SZLNHD), vnxt(SZLNHD)
      real        vtr(SZLNHD)
      integer     irecz(SZLNHD), itrcz(SZLNHD), itz(SZLNHD)
      integer     nseg(SZLNHD)
      integer     mseg(SZLNHD)
      integer     kseg(SZLNHD)
      character   ntap * 256, otap * 256, name*6, stkpik * 256
      character   velpik * 256, qtap * 256, ptap * 256, ftap * 256
      character   vtap * 256
      character   gamkey * 5, depwrd * 6
      logical     verbos, query, heap, linear, num, first
      logical     QC, intrp, xsd, guide, vverbos
      logical     recpikv, recpiks, recpikp, repl, gamma
      integer     argis,lunstk,lunvel,lunflt
 
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
      equivalence ( itr(  1), lhed(1), head(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'HORVEL'/, first/.true./
      data zhed/SZLNHD*0/
      data gamma /.false./
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln (ntap,otap,stkpik,velpik,qtap,ptap,lunstk,lunvel,
     1             igate,next,linear,thr,log,nord,verbos,gamma,
     2             lupout,QC,intrp,repl,vst,vmax,dmul,lunflt,ftap,
     3             xsd,depwrd,vtap,vgate,guide,vverbos)

c-----
c     get logical unit numbers for input and output of seismic data

c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used

c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (qtap(1:1) .ne. ' ' .and. .not.QC)
     1    call getln(luqc, qtap,'w', 2)

c-----
c     read line header of velocity guide function tape
c     lbytes is the number of bytes actually read
c-----
      if ( guide ) then
         call getln(luvel, vtap,'r', 0)
         call rtape  ( luvel, itr, lvbytes)
         if(lvbytes .eq. 0) then
            write(LOT,*)'HORVEL: no header read from unit ',luvel
            write(LOT,*)'FATAL'
            stop
         endif
      endif

c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'HORVEL: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     save certain parameters

c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position

c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      call saver( itr, 'ILClIn',  vmin, LINHED)
      call saver( itr, 'CLClIn',  dvel, LINHED)
      call savew( itr, 'MinVel', ivmin, LINHED)
      call savew( itr, 'MaxVel', ivmax, LINHED)
      svel = vmin - dvel

      nvel = ntrc

      call saver(itr, 'Crew01', gamkey(1:1), LINHED)
      call saver(itr, 'Crew02', gamkey(2:2), LINHED)
      call saver(itr, 'Crew03', gamkey(3:3), LINHED)
      call saver(itr, 'Crew04', gamkey(4:4), LINHED)
      call saver(itr, 'Crew05', gamkey(5:5), LINHED)

c     if (gamkey .eq. 'Gamma') gamma = .true.

      if ( gamma ) then
         call saver(itr, 'T_Unit', iscl, LINHED)
         if (iscl .lt. 1) then
           write(LERR,*)' '
           write(LERR,*)'FATAL ERROR in horvel:'
           write(LERR,*)'Triggered gamma option but found zero scaler'
           write(LER ,*)' '
           write(LER ,*)'FATAL ERROR in horvel:'
           write(LER ,*)'Triggered gamma option but found zero scaler'
           stop 666
         endif
      else
         if (.not.guide .AND. (lunvel .eq. -999)) then
             write(LERR,*)'FATAL ERROR in horvel:'
             write(LERR,*)'Must enter pickfile containing 2 velocity'
             write(LERR,*)'pick segments defining semblance fairway'
             write(LER ,*)'FATAL ERROR in horvel:'
             write(LER ,*)'Must enter pickfile containing 2 velocity'
             write(LER ,*)'pick segments defining semblance fairway'
             call ccexit (666)
         elseif (guide .AND. (luvel .lt. 0)) then
             write(LERR,*)'FATAL ERROR in horvel:'
             write(LERR,*)'Unable to find guide velocity data set -v[]'
             write(LER ,*)'FATAL ERROR in horvel:'
             write(LER ,*)'Unable to find guide velocity data set -v[]'
             call ccexit (666)
         endif
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      if (depwrd(1:1) .ne. ' ')
     1call savelu(depwrd,ifmt_depwrd,l_depwrd,ln_depwrd,TRACEHEADER)


c------
c     hlhprt prints out the historical line header of length lbytes AND

c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 7, LERR)

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD


c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,stkpik,velpik,qtap,ptap,QC,
     2                  vmin,vmax,xsd,gamma,iscl,depwrd,
     3                  guide,vgate,vtap,luvel,vst,dvel)
c     end if

      igate = igate / 2
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      si = nsi
      dt = real (nsi) * unitsc

c--------------------------------------------------
c     BEGIN PROCESSING

c***************************************   read vel fairway
c   NOTE:  we can read in 2 sets of xsd picks defining a fairway
c   on the semblances ("guide" not true), or we can read a velocity
c   trace (stacking velocity) to use as a guide function.

      IF ( .not.guide ) THEN

c-----
c   find number of segments in velocity fairway pik file:
c   if there are 2 then get both segments and from time-vel
c   function build 2 velocity traces vello & velhi
c----

      num = .true.

      IF (.not. gamma) THEN

         call  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre,
     1                 nsmp,recpikv,irecz,itrcz,itz,num,lunvel,
     2                 unit1,dum1,unit3,off1,dum2,off3)

         if (nblk .ne. 2) then
            write(LERR,*)'Velocity fairway pick file does not contain'
            write(LERR,*)'required 2 pick segments (for low and high'
            write(LERR,*)'velocity limits)'
            stop
         endif


c----
c  get first function; create 1st vel trace
c----
         num = .false.
         iseg = 1
         call  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre,
     1                 nsmp,recpikv,irecz,itrcz,itz,num,lunvel,
     2                 unit1,unit2,unit3,off1,off2,off3)
         do  i = 1, nseg(1)
             velf(i) = itrcz(i)
             tf(i) = itz(i)
         enddo
         call vel (tf, velf, nsamp, si, nseg(1), tmp1)

c----
c  get second function; create 2nd vel trace
c----
         num = .false.
         iseg = 2
         call  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre,
     1                 nsmp,recpikv,irecz,itrcz,itz,num,lunvel,
     2                 unit1,unit2,unit3,off1,off2,off3)

         do  i = 1, nseg(2)
             velf(i) = itrcz(i)
             tf(i) = itz(i)
         enddo
         call vel (tf, velf, nsamp, si, nseg(2), tmp2)

         if (tmp1(1) .gt. tmp2(1)) then
            call vmov (tmp1, 1, velhi, 1, nsamp)
            call vmov (tmp2, 1, vello, 1, nsamp)
         elseif (tmp1(1) .lt. tmp2(1)) then
            call vmov (tmp1, 1, vello, 1, nsamp)
            call vmov (tmp2, 1, velhi, 1, nsamp)
         endif
   
         do  i = 2, nsamp
             if (velhi(i) .le. vello(i)) then
                write(LERR,*)'Fairway velocity functions cross -- FATAL'
                stop
             endif
         enddo
         do  i = 1, nsamp
             velav (i) = .5 * (vello(i) + velhi(i))
         enddo

      ELSE

         do  i = 1, nsamp
             vello (i) = 0.
             velhi (i) = 999999.
         enddo

      ENDIF

      if (verbos .AND. (.not.gamma) ) then
         write(LERR,*)'Low Velocity Fairway (every 10 samps)'
         write(LERR,*)(vello(ii),ii=1,nsamp,10)
         write(LERR,*)'High Velocity Fairway (every 10 samps)'
         write(LERR,*)(velhi(ii),ii=1,nsamp,10)
         write(LERR,*)' '
      endif
c----
c   velocity fairway all read in
c----

      ENDIF

      write(LERR,*)' '
      write(LERR,*)'Starting velocity  = ', svel
      write(LERR,*)'Velocity increment = ', dvel
      write(LERR,*)' '
c***************************************   end vel fairway section
      

c----
c   find # pick segments in stack pick file
c----
      heap = .true.
      num = .true.
      call  pikrd ( nhor, nseg, iunit, iseg,nsi,itrs,itre,
     1              nsmp,recpiks,irecz,itrcz,itz,num,lunstk,
     2              unit1,unit2,unit3,off1,off2,off3)

      ntrstk = itrs * itre       ! total number stk traces

      itempp = ntrstk * nhor
      itemp  = ntrstk * nhor *     SZSMPD

c-----
c  if using prev editted picks
c  need to get new pick file
c  header info
c----
c   find max number of picks in a segment if QC step
c   else just take the number of recs in semblance data set
c   as the number of velocity functions
c----
      if (QC) then
          num = .true.
          call  pikrd ( nhor, kseg, iunit, J,nsi,ntrstk1,itre,
     1                  nsmp,recpikp,irecz,itrcz,itz,num,lupout,
     2                  unit1,unit2,unit3,off1,off2,off3)
          maxpik = 0
          do  j = 1, nhor
              if (kseg(j) .ge. maxpik) maxpik = kseg(j)
          enddo
          item   = ntrstk * nhor * 3 * SZSMPD
          itemk  = ntrstk * nhor * 3 * SZSMPD
          if (intrp) then
             nrecdo = ntrstk
          else
             nrecdo = maxpik
          endif
      else
          item   = nsamp  * ntrc *     SZSMPD
          itemk  = nrec   * nhor * 3 * SZSMPD
          nrecdo = nrec
      endif


      call galloc (wkdata  , item, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkrecnum, itemp, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wktimes , itemp, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkpikout, itemk, errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemk,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemk,'  bytes'
         write(LERR,*)' '
      endif

      do  i = 1, itempp
          recnum (i) = -999
          times  (i) = -999.
      enddo

c----
c  interpolate each horizon from the 1st to the last trace in velspec
c  data set and put into array:

c        N = nrec
c        M = nhor

c        recnum( trc1, horz1)        times (trc1, horz1)
c        recnum( trc2, horz1)        times (trc2, horz1)
c        recnum( trc3, horz1)        times (trc3, horz1)
c              ...                       ...
c        recnum( trcN, horz1)        times (trcN, horz1)

c                             ...

c        recnum( trc1, horz2)        times (trc1, horz2)
c        recnum( trc2, horz2)        times (trc2, horz2)
c        recnum( trc3, horz2)        times (trc3, horz2)
c              ...                       ...
c        recnum( trcN, horz2)        times (trcN, horz2)

c                             ...

c        recnum( trc1, horz3)        times (trc1, horz3)
c        recnum( trc2, horz3)        times (trc2, horz3)
c        recnum( trc3, horz3)        times (trc3, horz3)
c              ...                       ...
c        recnum( trcN, horz3)        times (trcN, horz3)

c                             ...

c        recnum( trc1, horzM)        times (trc1, horzM)
c        recnum( trc2, horzM)        times (trc2, horzM)
c        recnum( trc3, horzM)        times (trc3, horzM)
c              ...                       ...
c        recnum( trcN, horzM)        times (trcN, horzM)
c----
        num = .false.
        DO  J = 1, nhor

            call  pikrd ( nhor, nseg, iunit, J,nsi,itrs,itre,
     1                    nsmp,recpiks,irecz,itrcz,itz,num,lunstk,
     2                    unit1,unit2,unit3,off1,off2,off3)
            call pikstf (j, nseg,mseg,itrcz,itz,recnum,times,ntrstk,
     1                   nhor,recmin,recmax,verbos,itrs,itre)

        ENDDO

        write(LERR,*)' '
        write(LERR,*)'Number traces in stack section          = ',ntrstk
        write(LERR,*)'Number horizons picked in stack section = ',nhor
        write(LERR,*)'Minimum record number in stack section  = ',recmin
        write(LERR,*)'Maximum record number in stack section  = ',recmax
        write(LERR,*)' '

c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)

      call savhlh(itr,lbytes,lbyout)
      call savew(itr, 'NumTrc',  1   , LINHED)
      call savew(itr, 'NumRec',ntrstk, LINHED)

c----------------------

c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )

      if (qtap(1:1) .ne. ' ' .and. .not.QC) then
         nqcsmp = nhor*ntrc
         nqcbyt = SZTRHD + nqcsmp * SZSMPD
         call savew(itr, 'SmpInt',    1  , LINHED)
         call savew(itr, 'NumRec',    1  , LINHED)
         call savew(itr, 'NumTrc', ntrstk, LINHED)
         call savew(itr, 'NumSmp', nqcsmp, LINHED)
         call wrtape ( luqc, itr, lbyout                 )
      endif

      if (QC) then
          call pikin (maxpik,nsmp,ntrstk,nhor,kseg,pikout,lupout,
     1                svel,dvel,nvel,nfunc,data,times,intrp)
      else
          call vclr (mseg, 1, SZLNHD)
      endif

c-----
c     read semblance gathers (and velocity guide trc if necessary),
c     find velocity function and write out vel trace
c-----

c-----
c     process desired trace records
c-----
      call savew2(zhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            30000  , TRACEHEADER)
      ir = 0
      it = 0

      DO   JJ = 1, nrecdo
 

c-----
c     if we're reading nmo velocities as a guide function read one
c     velocity trace per cdp gather and compute the hi/lo vel traces
c-----
            if ( guide ) then
                call rtape( luvel, itr, nbytes)
                if(nbytes .eq. 0) then
                   write(LERR,*)'End of file on input velocity:'
                   write(LERR,*)'  rec= ',jj,'  trace= ',kk
                   go to 999
                endif
                call vmov (itr(ITHWP1), 1, velf, 1, nsamp)
                do  i = 1, nsamp
                    dv = vgate * velf (i)
                    vello (i) = velf (i) - dv
                    velhi (i) = velf (i) + dv
                enddo

                if (vverbos) then
                do  i = 1, nsamp, nsamp/10
                write(LERR,*)'samp ',i,' vlo/vhi ',vello(i),velhi(i)
                enddo
                endif
            endif

            do    kk = 1, ntrc

                  nbytes = 0

                  if (.not. QC) then

                    call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       go to 999
                    endif
                    call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)
                    call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          itrc   , TRACEHEADER)
                    call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                          srcloc , TRACEHEADER)
                    call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                          recind , TRACEHEADER)
                    call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                          dphind , TRACEHEADER)
                    if (depwrd(1:1) .ne. ' ') then
                       call saver2(lhed,ifmt_depwrd,l_depwrd, ln_depwrd,
     1                             idepwrd, TRACEHEADER)
                    else
                       idepwrd = 999999
                    endif
                    call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          dstsgn , TRACEHEADER)
                    velsem(kk) = dstsgn
  
                    call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

                    istrc = (kk-1) * nsamp
                    call vmov (tri,1, data(istrc+1),1, nsamp)

                  elseif (QC .and. JJ .eq. 1 .and. KK .eq. 1) then

                    call rtape( luin, itr, nbytes)
                    call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)
                    call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          itrc   , TRACEHEADER)
                    call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                          srcloc , TRACEHEADER)
                    call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                          recind , TRACEHEADER)
                    call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                          dphind , TRACEHEADER)
                    call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          dstsgn , TRACEHEADER)


                  endif

            enddo

            IF (.not. QC) THEN
                call picker
     1                  (ntrc,nsamp,ntrstk,nhor,nrecdo,JJ,si,velsem,log,
     2                   vello,velhi,recnum,times,data,vnxt,nord,dvel,
     3                   next,thr,linear,igate,vtr,pikout,svel,mseg,
     4                   irec,velav,LH,verbos,vst,vmax,lunflt,xsd,nrec,
     5                   gamma,iscl,depwrd,idepwrd,first)
                if (LH .lt. 1) then
                    if (.not. repl) go to 100
                endif

            ELSE

                call pikvel
     1                  (JJ,irec,ntrstk,nhor,kseg,nsamp,si,vnxt,data,
     2                   verbos,vmin,vmax,lunflt,xsd,ntrc,nrec,
     3                   depwrd,idepwrd)
            ENDIF

            call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       1 , TRACEHEADER)
            IF (first) THEN

               call vmov (vnxt, 1, lhed(ITHWP1), 1, nsamp)
               do  jv = 1, irec

                   ir = ir + 1
                   call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         ir     , TRACEHEADER)
                   call wrtape (luout, itr, obytes)

                   if (.not.QC) then
                   if     (jv .lt. irec) then
                      it = it + 1
                      call savew2(zhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            it     , TRACEHEADER)
                      call savew2(zhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            1      , TRACEHEADER)
                      call wrtape (luqc, zhed, nqcbyt)
                   elseif (jv .eq. irec) then
                      call vmov   (vtr, 1, lhed(ITHWP1), 1, nqcsmp)
                      it = it + 1
                      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            it     , TRACEHEADER)
                      call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            1      , TRACEHEADER)
                      call wrtape (luqc, lhed, nqcbyt)
                   endif
                   endif

               enddo
               call vmov (vnxt, 1, vlst, 1, nsamp)
               first = .false.
               ireclst = irec

            ELSE

               ireccur = irec
               nrr = ireccur - ireclst + 1
               drr = nrr
               do  j = 2, nrr
                   scl = float(j) / drr
                   do  ii = 1, nsamp
                       vout (ii) = vlst(ii) + (vnxt(ii) - vlst(ii))*scl
                   enddo
                   ir = ir + 1
                   call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         ir     , TRACEHEADER)
                   call vmov (vout, 1, lhed(ITHWP1), 1, nsamp)
                   call wrtape (luout, itr, obytes)

                   if (.not.QC) then
                   if (ir .lt. irec) then
                      it = it + 1
                      call savew2(zhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            it     , TRACEHEADER)
                      call savew2(zhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            1      , TRACEHEADER)
                      call wrtape (luqc, zhed, nqcbyt)
                   elseif (ir .eq. irec) then
                      call vmov   (vtr, 1, lhed(ITHWP1), 1, nqcsmp)
                      it = it + 1
                      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            it     , TRACEHEADER)
                      call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            1      , TRACEHEADER)
                      call wrtape (luqc, lhed, nqcbyt)
                   elseif (ir .gt. irec) then
                      it = it + 1
                      call savew2(zhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            it     , TRACEHEADER)
                      call savew2(zhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            1      , TRACEHEADER)
                      call wrtape (luqc, zhed, nqcbyt)
                   endif
                   endif
               enddo
               call vmov (vnxt, 1, vlst, 1, nsamp)
               ireclst = ireccur

            ENDIF

100         CONTINUE

      ENDDO

      if (ir .lt. ntrstk) then
         do  j = ir+1, ntrstk
             call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   j      , TRACEHEADER)
             call vmov (vlst, 1, lhed(ITHWP1), 1, nsamp)
             call wrtape (luout, itr, obytes)
             if (.not.QC) then
             it = it + 1
             call savew2(zhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                   it     , TRACEHEADER)
             call savew2(zhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   1      , TRACEHEADER)
             call wrtape (luqc, zhed, nqcbyt)
             endif
         enddo
      endif

  999 continue

      if (.not. QC)
     1   call pikwrt (ntrstk, nqcsmp, nrec, nhor, mseg, pikout, lupout,
     2                verbos)

c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if (qtap(1:1) .ne. ' ' .and. .not.QC) call lbclos ( luqc)

            write(LERR,*)'end of horvel, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'horvel shifts seismic records based on interpolated rec/time'
        write(LER,*)
     :'pairs or interpolated picks from an xsd pick file'
        write(LER,*)
     :'see manual pages for details ( online by typing uman horvel )'
        write(LER,*)' '
        write(LER,*)
     :'execute horvel by typing horvel and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)  : input semblance data file name'
        write(LER,*)
     :' -O [otap]    (stdout) : output velocity tape file name'
        write(LER,*)
     :' -F [ftap]    (no file): opt. output velocity flat file'
        write(LER,*)
     :' -P [stkpik]  (none)   : picks of stacked reflector horizons'
        write(LER,*)
     :' -v [velpik]  (opt)   : picks defining velocity fairway, or...'
        write(LER,*)
     :' -guide  use -v[] velocity tape as guide fctn for each gather'
        write(LER,*)
     :' -vg [vgate]  (opt)   : velocity gate centered on guide function'
        write(LER,*)
     :' -Q [qtap]    (no qc)  : QC semblance/horizon data set'
        write(LER,*)
     :' -q [ptap]    (no qc)  : QC semblance pick file'
        write(LER,*)
     :' -E  use editted semblance QC picks to generate velocity tape'
        write(LER,*)
     :' -I  turn off interpolation between QC picks'
        write(LER,*) ' '
        write(LER,*)
     :' -g [igate]     (8)    : number samples in semblance time gate'
        write(LER,*)
     :' -s [nord]      (5)    : order of semblance smoothing'
        write(LER,*)
     :' -p [next]      (3)    : number of semblance peaks to test'
        write(LER,*)
     :' -l [log]   (no log)   : send semblance curves for this rec'
        write(LER,*)
     :'                       : to stderr (plot file with xgraph)'
        write(LER,*)
     :' -t [thr]       (.1)   : semblance threshold'
        write(LER,*)
     :' -w [depwrd]  (no word): headr word content written to flat file'
        write(LER,*)
     :' -vs [vmin]  (ignore)  : peg 0-time velocity'
        write(LER,*)
     :' -ve [vmax]  (ignore)  : peg trace end time velocity'
        write(LER,*) ' '
        write(LER,*)
     :' -gamma  input semblances are gamma-T rather than X-T'
        write(LER,*)
     :' -X  output optional velocity file as xsd pik file, else'
        write(LER,*)
     :'     file will be in flat file format: time velocity rec'
c       write(LER,*)
c    :' -L  do not remove linear trend from const time semblance profile
c    :s'
        write(LER,*)
     :' -R  use fairway average velocity for no-pick records'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   horvel -N[] -O[] -F[] -P[] -v[] [-Q[] -q[] -E -I] -g[]'
        write(LER,*)
     :'                 -s[] -p[] -l[] [ -w[] -t[] -vs[] -ve[] ]'
        write(LER,*)
     :'                  [ -gamma -X -R -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,stkpik,velpik,qtap,ptap,lunstk,lunvel,
     1                  igate,next,linear,thr,log,nord,verbos,gamma,
     2                  lupout,QC,intrp,repl,vst,vmax,dmul,lunflt,ftap,
     3                  xsd,depwrd,vtap,vgate,guide,vverbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character   ntap*(*), otap*(*), stkpik*(*), velpik*(*)
      character   qtap*(*), ptap*(*), ftap * 256, depwrd * 6
      character   vtap*(*)
      logical     verbos, linear, QC, intrp, repl, xsd, gamma
      logical     guide, vverbos
      integer     argis, lunstk, lunvel, lupout, nord, igate, lunflt
 
c     lunstk = 27
c     lunvel = 28
c     lupout = 29
c     lunflt = 30

      call alloclun (lunstk)
      call alloclun (lunvel)
      call alloclun (lupout)
      call alloclun (lunflt)
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.

c     For example program prgm might be invoked in the following way:

c     prgm  -Nxyz -Oabc

c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"

c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-F', ftap, ' ', ' ' )
            call argstr( '-G', vtap, ' ', ' ' )
            call argstr( '-P', stkpik, ' ', ' ' )
            guide     =   (argis('-guide') .gt. 0)
            call argr4 ( '-vg', vgate, 10., 10.)
            vgate = vgate / 100.
            if ( guide ) then
               call argstr( '-v', vtap, ' ', ' ' )
            else
               call argstr( '-v', velpik, ' ', ' ' )
            endif
            call argstr( '-Q', qtap  , ' ', ' ' )
            call argstr( '-q', ptap  , ' ', ' ' )

            call argi4 ( '-s', nord, 5, 5)
            call argi4 ( '-l', log, 0, 0)
            call argi4 ( '-p', next, 3, 3)
            call argi4 ( '-g', igate, 8, 8)
            call argr4 ( '-t', thr, 0.1, 0.1)
            call argr4 ( '-vs', vst, 0.0, 0.0)
            call argr4 ( '-ve', vmax, 0.0, 0.0)
            call argr4 ( '-d', dmul, 1.0, 1.0)
            call argstr( '-w', depwrd  , ' ', ' ' )

            QC     =   (argis('-E') .gt. 0)

            IF (stkpik(1:1) .eq. ' ') THEN

               write(LERR,*)'Must enter picks of reflectors from stcked'
               write(LERR,*)'section using  -P[]  cmd line arg'
               stop

            ENDIF

            IF (.not.guide .AND. (velpik(1:1) .eq. ' ')) THEN

               write(LERR,*)'WARNING:'
               write(LERR,*)'Must enter pickfile containing 2 velocity'
               write(LERR,*)'pick segments defining semblance fairway'
               write(LERR,*)'Assuming gamma-type input'
               lunvel = -999

            ENDIF

            open (unit=lunstk,file=stkpik,status='old',iostat=ierr)

            if (ierr .ne. 0) then
               write(LERR,*)'Could not open stkpik file ',stkpik
               write(LERR,*)'Check existence'
               stop
            endif

            if (.not. guide) then
               open (unit=lunvel,file=velpik,status='old',iostat=ierr)
   
               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open velpik file ',velpik
                  write(LERR,*)'Check existence'
                  stop
               endif
            endif

            if (QC) then
               open (unit=lupout,file=ptap,status='old',iostat=ierr)
            else
               if (ptap(1:1) .ne. ' ') then
                  open (unit=lupout,file=ptap,status='unknown',
     1                 iostat=ierr)
               else
                  lupout = -1
               endif
            endif

            if (ierr .ne. 0) then
               write(LERR,*)'Could not open QC pick file ',ptap
               write(LERR,*)'Check existence'
               stop
            endif

            if (ftap(1:1) .ne. ' ') then
               open (unit=lunflt, file=ftap, status='unknown',
     1                 iostat=ierr)
               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open velocity flat file ',
     1                          ftap
                  write(LERR,*)'Check existence'
                  stop
               endif
            else
               lunflt = -1
            endif


            xsd     =   (argis('-X') .gt. 0)
            repl    =   (argis('-R') .gt. 0)
            linear  =   (argis('-L') .gt. 0)
            intrp   =   (argis('-I') .le. 0)
            gamma   =   (argis('-gamma') .gt. 0)
            vverbos =   (argis('-VV') .gt. 0)
            verbos  =   (argis('-V') .gt. 0)

            if ( QC ) depwrd = '      '

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,stkpik,velpik,qtap,ptap,QC,
     2                  vmin,vmax,xsd,gamma,iscl,depwrd,
     3                  guide,vgate,vtap,luvel,vst,dvel)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, iform, iscl, luvel
      character   ntap*(*), otap*(*), stkpik*(*), velpik*(*)
      character   qtap*(*), ptap*(*), vtap*(*), depwrd * 6
      real        vgate
      logical     QC, xsd, gamma, guide
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name    =  ', ntap
            write(LERR,*) ' output data set name   =  ', otap
            write(LERR,*) ' stack horizon picks    =  ',stkpik
            if (guide) then
            write(LERR,*) ' velocity guide data set =  ',vtap
            write(LERR,*) ' velocity read unit#     =  ',luvel
            write(LERR,*) ' velocity gate (fraction)=  ',vgate
            else
            write(LERR,*) ' velocity fairway picks  =  ',velpik
            endif
            write(LERR,*) ' QC data set   =  ',qtap
            write(LERR,*) ' QC pick file  =  ',ptap
            write(LERR,*) ' QC pick file  =  ',ptap
            if (depwrd(1:1) .ne. ' ')
     1      write(LERR,*) ' Writing values from header word ',depwrd,
     2                    ' into flat file'
            if (QC)
     1      write(LERR,*) ' Using editted QC semblance picks to generate
     2 velocities'
            write(LERR,*) ' Minimum velocity of semb scan = ',vmin
            write(LERR,*) ' Velocity increment semb scan  = ',dvel
            if (vst .ne. 0.0)
     1      write(LERR,*) ' Minimum velocity at time zero = ',vst
            if (vmax .ne. 0.0)
     1      write(LERR,*) ' Maximum velocity at trace end = ',vmax
            write(LERR,*) ' Optional output velocity file is xsd? ',xsd
            if (gamma) then
            write(LERR,*)' Using gamma option:'
            write(LERR,*)' with scale factor      =  ', iscl
            write(LER ,*)' '
            write(LER ,*)' Using gamma option:'
            write(LER ,*)' with scale factor      =  ', iscl
            write(LER ,*)' '
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
