C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c  pick peaks (or troughs)
c----

	subroutine peak (rdata,nsamp,iflag,vp,ip,np)

#include <f77/lhdrsz.h>

	real      vp(SZLNHD), rdata(SZLNHD)
	integer   ip(SZLNHD)

	j = 0
        do  i = 1, nsamp
            vp (i) = 0.
        enddo

	do 100 i = 2,nsamp-1

c----
c   search for all peaks
c   vp = vector of peak values
c   ip = vector of peak positions (in original data)
c----
	if (iflag .eq. 0 ) then
		if (rdata  (i-1) .lt. rdata  (i)
     :		.and. rdata  (i) .gt. rdata  (i+1)) then
			j = j + 1
			vp(j) = rdata(i)
			ip(j) = i
		endif
c----
c   search for all troughs
c----
	else
		if (rdata  (i-1) .gt. rdata  (i)
     :			.and. rdata  (i) .lt. rdata  (i+1)) then
			j = j + 1
			vp(j) = rdata(i)
			ip(j) = i
		elseif (rdata  (i-1) .ge. rdata  (i)
     :                  .and. rdata  (i) .lt. rdata  (i+1)) then
                         j = j + 1
                         vp(j) = rdata(i)
                         ip(j) = i
	        elseif (rdata  (i-1) .gt. rdata  (i)
     :                  .and. rdata  (i) .le. rdata  (i+1)) then
                        j = j + 1
                        vp(j) = rdata(i)
                        ip(j) = i
		endif
	endif
100	continue
	np = j
	return
	end

c----
c   fit parabola to 3 points
c----
      SUBROUTINE PARAB(C1,C2,C3,X,Y)

	x = 0.0
	y = c2
        A  =0.5*(C1+C3-2.*C2)
        B = 0.5*(C3-C1)
        C = C2
        IF(A .EQ. 0.0 ) return
	  X = -B/(2.*A)
          Y = A * X**2 + B * X + C
	if ( abs(x) .gt. 1 ) then
		x = 0.0
		y = c2
	endif
      RETURN
      END
