C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pikwrt (nrec,nsamp,nvel,nhor,nseg,pikout,lupout,
     1                   verbos)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real      pikout (nvel,nhor,3)
      integer   nseg(*)
      real      unit1,unit2,unit3,off1,off2,off3
      integer   icolor, ntrc
      logical   verbos

      character Units*5, Offset*6, Count*5, Segment*10, picks*8
      character Name*35

      data Units/'Units'/, Offset/'Offset'/, Count/'Count'/
      data Segment/'Segment = '/, picks/'picks = '/
      data Name/'Name    NO_PICK_NAME_HERE  color = '/
      data unit1/1.0/, unit2/1.0/, unit3/1.0/
      data off1/0.0/, off2/0.0/, off3/0.0/
      data icolor/0/, ntrc/1/

      
      if (lupout .lt. 0) return

      maxpik = 0
      nhoro  = nhor
      DO  j = 1, nhor
          if (nseg(j) .lt. 2) then
             nhoro = nhoro - 1
          endif
      ENDDO

c     write(0,*)'nhor,nhoro= ',nhor,nhoro
c     write(0,*)'nvel= ',nvel,nrec,nhor,nhoro

      DO  j = 1, nhoro

          lseg = 0
          do  ir = 1, nrec

              rr = pikout (ir, j, 1)
              tr = pikout (ir, j, 2)
              vr = pikout (ir, j, 3)
c     write(0,*)'ir, j, rr, tr= ',ir, j, rr, tr
              if (rr.ne.0.0 .AND. tr.ne.0.0 .AND. vr.ne.0.0) then
                 lseg = lseg + 1
              endif
          enddo
          nseg (j) = lseg
          if (nseg(j) .lt. 2) then
               nhoro = nhoro - 1
             nseg (j) = 0
          endif
c     write(0,*)'seg= ',j,nseg(j)
      ENDDO

      DO  j = 1, nhor
          if (nseg(j) .lt. 2) then
             nseg (j) = 0
          endif
          if (nseg(j) .gt. maxpik) maxpik = nseg(j)
      ENDDO
c     write(0,*)'nseg,maxpik= ',nseg(1),maxpik


      write(lupout,101) Units,unit1,unit2,unit3,ntrc,nrec,nsamp,
     1                  Offset,off1,off2,off3,Count,nhoro,maxpik
      
101   format (a5,3f13.6,3i6,1x,a6,3f13.6,1x,a5,2i6)

      DO  j = 1, nhor

          IF (nseg(j) .ne. 0) THEN

             write(lupout,102) Segment,j,Name,icolor,picks,nseg(j)
102          format (a10,1x,i4,1x,a35,1x,i4,1x,a8,1x,i4)

             do  ir = 1, nrec

                 rr = pikout (ir, j, 1)
                 tr = pikout (ir, j, 2)
                 vr = pikout (ir, j, 3)
c     write(0,*)'J= ',j,nseg(j),' ir= ',ir,rr,tr,vr

                 if (rr.ne.0.0 .AND. tr.ne.0.0 .AND. vr.ne.0.0) then
                     write(lupout,103) rr, tr, vr
103                  format(f12.6,2f13.6)
                 endif
             enddo

             icolor = icolor + 1

          ENDIF

      ENDDO

      return
      end
