C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getw(wavelet,fwgt,worka,workb,twgt,
     1                nfft,minw,maxw,f1,f2,f3,f4,tw,dt,ndiv,ttaper,
     2                dtmsec,lerr)
c
      real wavelet(minw:maxw,0:ndiv)
      real twgt(minw:maxw)
      real worka(nfft),workb(nfft)
      real fwgt(0:nfft/2-1)
c
      df=1./(nfft*dt)
      nf=nfft/2
C_______________________________________________________________________
C     calculate spike centered in the center.
C_______________________________________________________________________
      call vclr(worka,1,nfft)
      worka(nfft/2)=1.
C_______________________________________________________________________
C     forward transform t-->omega               
C_______________________________________________________________________
      call rfft(worka,nfft,+1)
      call rfftsc(worka,nfft,+2,1)
C_______________________________________________________________________
C     generate taper in frequency domain.
C     generate taper in time domain.      
C_______________________________________________________________________
      call gttapr(fwgt,f1,f2,f3,f4,df,0,nf-1)
      write(lerr,'(a12,f12.6)') 'df',df,'f1',f1,'f2',f2,'f3',f3,'f4',f4
      write(lerr,*) 'wavelet '
      write(lerr,'(a12,2a12)') 'k','f','fwgt'
      write(lerr,'(i12,2f12.6)') (k,k*df,fwgt(k),k=0,nf-1)
      t1=-tw/2.       
      t4=+tw/2.      
      t2=t1+ttaper
      t3=t4-ttaper
      call gttapr(twgt,t1,t2,t3,t4,dtmsec,minw,maxw)
c___________________________________________________________________
c     loop over sample divisions.         
c___________________________________________________________________
      do 80000 jdiv=0,ndiv
c___________________________________________________________________
c      form time shifted impulse response.
c___________________________________________________________________
       dtfrac=jdiv*dt/ndiv
       call getspec(worka,workb,fwgt,dtfrac,df,nf)
c___________________________________________________________________
c      transform from omega --> t 
c___________________________________________________________________
       call rfft(workb,nfft,-1)
c___________________________________________________________________
c      shift to left.                               
c___________________________________________________________________
       do 60000 isamp=minw,maxw
        wavelet(isamp,jdiv)=workb(nfft/2+isamp)*twgt(isamp)
60000  continue
80000 continue
      write(lerr,'(2a12)') 'isamp','wavelet'
      write(lerr,'(i12,f12.6)') (isamp,wavelet(isamp,0),
     1                             isamp=minw,maxw)
c		
      return	
      end
