C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ichsub(u,hbegin,nsamp,
     1                  zhorizon,undefined,ntrace,irec,
     2                  ztemp,nsmooth,extrapleft,extrapright,
     3                  segname,segnum,segcolor,npicks,
     4                  record,trace,sample,
     5                  wavelet,minw,maxw,mask,spike,
     6                  xwgt,twgt,umask,ndiv,adiv,nxtaper,
     7                  maxpicks,nsegments,lerr,verbose,
     8                  mult_by_color)
c
      integer       hbegin
      real          u(hbegin:nsamp,ntrace)
      real          umask(nsamp,ntrace)
      real          ztemp(1-nsmooth/2:ntrace+nsmooth/2)                 
      real          zhorizon(ntrace)                 
      character*(*) segname(nsegments)
      integer       segnum(nsegments)
      integer       segcolor(nsegments)
      integer       npicks(nsegments)
      real          record(maxpicks,nsegments)
      real          trace(maxpicks,nsegments)
      real          sample(maxpicks,nsegments)
      real          wavelet(minw:maxw,0:ndiv)
      real          twgt(minw:maxw)
      real          xwgt(ntrace)    
      integer       firstpick,lastpick
c
      logical extrapleft,extrapright
      logical mask,mult_by_color
      logical       spike,verbose
c
      if(mask) then
         call vclr(umask,1,nsamp*ntrace)
      else
         do 10000 itrace=1,ntrace
          call vclr(u(1,itrace),1,nsamp)
10000    continue
      endif
c_____________________________________________________________________
c     loop over segments. see if any fall on current record.
c_____________________________________________________________________
      do 50000 iseg=1,nsegments
       if(nint(record(1,iseg)) .eq. irec) then
          call vfill(undefined,zhorizon(1),1,ntrace)
          do 20000 ipick=1,npicks(iseg)
           itrace=nint(trace(ipick,iseg))
           itrace=min(itrace,ntrace)
           itrace=max(itrace,1)
           zhorizon(itrace)=sample(ipick,iseg)
20000     continue
c_____________________________________________________________________
c         interpolate to obtain one pick per trace.       
c_____________________________________________________________________
          call interph(zhorizon(1),1,ntrace,           
     1                 undefined,extrapleft,extrapright)
c_____________________________________________________________________
c         if picks exist within the smoothing window, smooth them.
c_____________________________________________________________________
          call vmov(zhorizon(1),1,ztemp(1),1,ntrace)
          do 22000 k=1,nsmooth/2
           ztemp(1-k)=ztemp(1)
           ztemp(ntrace+k)=ztemp(ntrace)
22000     continue
          do 30000 itrace=1,ntrace                         
           if(ztemp(itrace) .ne. undefined) then           
              sum=ztemp(itrace)
              ncount=1
c
              do 28001 k=+1,+nsmooth/2               
               if(ztemp(itrace+k) .eq. undefined .or.  
     1            ztemp(itrace-k) .eq. undefined) then
                  go to 28002
               else
                  sum=sum+ztemp(itrace+k)+ztemp(itrace-k)
                  ncount=ncount+2
               endif 
28001         continue
28002         continue                   
c
28004         zhorizon(itrace)=sum/ncount 
           endif
30000     continue
c_____________________________________________________________________
c         find the first and last pick of this segment.       
c_____________________________________________________________________
          do 30500 itrace=1,ntrace
           if(zhorizon(itrace) .ne. undefined) then
               firstpick=itrace
               go to 30501
           endif
30500     continue
30501     continue
c
          do 30600 itrace=ntrace,1,-1
           if(zhorizon(itrace) .ne. undefined) then
               lastpick=itrace
               go to 30601
           endif
30600     continue
30601     continue
c_____________________________________________________________________
c         calculate xwgt.
c_____________________________________________________________________
          x1=firstpick 
          x2=firstpick+nxtaper
          x3=lastpick-nxtaper
          x4=lastpick
          dtrace=1. 
          call gttapr(xwgt,x1,x2,x3,x4,dtrace,1,ntrace)
c         
          if(verbose) then
c_____________________________________________________________________
c             write out smoothed, interpolated picks at each trace
c_____________________________________________________________________
              write(lerr,*) 'segment = ',iseg  
              write(lerr,'(2a12)') 'itrace','zhorizon'
              write(lerr,'(i12,f12.3)') (itrace,zhorizon(itrace),
     1                     itrace=firstpick,lastpick)
          endif
          ksamp = 0
          write(0,*) 'mult_by_color,segcolor(iseg) ',
     1             mult_by_color,segcolor(iseg) 
          do 40000 itrace=firstpick,lastpick  
           if(zhorizon(itrace) .ne. undefined) then
            jsamp=zhorizon(itrace)
            jdiv=nint((zhorizon(itrace)-jsamp)*adiv)
            if (.not. spike ) then
             if(mask) then
c_____________________________________________________________________
c             form a mask over the data.                      
c_____________________________________________________________________
              do 31000 isamp=max(1,jsamp+minw),min(nsamp,jsamp+maxw)
               umask(isamp,itrace)=
     1          max(umask(isamp,itrace),twgt(isamp-jsamp))*xwgt(itrace)
31000         continue
             elseif(mult_by_color) then 
c_____________________________________________________________________
c             convolve with the wavelet and multiply by the color!
c_____________________________________________________________________
                do isamp=max(1,jsamp+minw),min(nsamp,jsamp+maxw)
                 u(isamp,itrace)=u(isamp,itrace)
     1           +wavelet(isamp-jsamp,jdiv)*xwgt(itrace)*segcolor(iseg)
                end do
             else 
c_____________________________________________________________________
c             convolve with the wavelet.                      
c_____________________________________________________________________
              do 32000 isamp=max(1,jsamp+minw),min(nsamp,jsamp+maxw)
               u(isamp,itrace)=
     1          u(isamp,itrace)+wavelet(isamp-jsamp,jdiv)*xwgt(itrace)
32000         continue
             endif
            else
               if (ksamp .eq. 0) ksamp = jsamp
               inc = 1
               if (ksamp .gt. jsamp) inc = -1
               do isamp = ksamp, jsamp, inc
                u(isamp,itrace) = xwgt(itrace)
               enddo
               ksamp = jsamp
            endif
           endif
40000     continue
       endif
50000 continue
c
      if(mask) then
c_____________________________________________________________________
c        apply mask to the data.                      
c_____________________________________________________________________
         do 70000 itrace=1,ntrace
          do 60000 isamp=1,nsamp
           u(isamp,itrace)=umask(isamp,itrace)*u(isamp,itrace)
60000     continue
70000    continue
      endif
c
      return
      end
