/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <sys/param.h>

#include "globalE.h"
#include "ikp_defines.h"
#include "ikp_externs.h"

#include "prcrun.bitmap"
#include "prcstop.bitmap"
#include "ikp_icon.bitmap"
#include "copyCursor.xbc"
#include "copyCursorMask.xbcm"
#include "globalE.h"

/* #ifdef _hpux */
extern char *getwd(char *);
/* #endif */

extern void init_file_grn();
extern void menubar(Widget);
extern void ikp_callback_event();
extern void ikp_filer_box();
extern void prompt_box();
extern void get_xdefaults(char *);

extern void redisplayCB(Widget,XtPointer,XmDrawingAreaCallbackStruct *);
extern void netrunCB(Widget,XtPointer,XtPointer);
extern void prclibCB(Widget,XtPointer,XmListCallbackStruct *);
extern void prclibcrCB(Widget,XtPointer,XmListCallbackStruct *);
extern void prclibcr_textCB(Widget,XtPointer,XtPointer);

extern Library *current_lib;

void init_cursors();
void manpageCB(Widget ,XtPointer ,XtPointer);

char xui_path[1024];
Widget scroll_window=NULL;
Widget menu_bar=NULL;
Widget message_window=NULL;
Widget module_list=NULL;

static Widget main_window=NULL;
static Widget library_list=NULL;
char man_path[1024];

/* Cursor stuff */
static Cursor ccursor, lccursor, chcursor, klcursor;
static Cursor mvcursor, watchcursor, selcursor,cpcursor;
static Pixmap xvcursor_pm;

static Widget draw_area=NULL;

void init_windows()
{
  int screen, rootwin;
  Visual *vis;
  XVisualInfo visinfo;
  char *vendor;
  void init_canvas();
  
  screen= DefaultScreen(display);
  vis= DefaultVisual(display, screen);
  rootwin= DefaultRootWindow(display);
  vendor= ServerVendor(display);
  
  switch (DefaultDepth(display, screen)) {
  case 1:
    if (XMatchVisualInfo(display, screen, 1, StaticGray, &visinfo) == 0)
      ikp_err("Cannot access StaticGray visual on this display.", FATAL);
    visual= visinfo.visual;
    cmap= DefaultColormap(display, screen);
    break;
  case 8:
    switch (vis->class) {
      
    case StaticColor:
      
      /* OpenWindows 1.0 falls in this class */
      visual= vis;
      cmap= DefaultColormap(display, screen);
      break;
      
    case PseudoColor:
      
      /* MIT server -- use default PseudoColor visual */
      if ((vendor != (char *) NULL) && !strncmp(vendor, "MIT", 3)) {
	visual= vis;
	cmap= DefaultColormap(display, screen);
      }
      
      /* non-MIT server, assume OpenWindows 2.0 (dangerous
	 assumption!) -- try to get StaticColor visual so that
	 we interfere as little as possible with other
	 applications and get a pre-loaded colormap */
      /*
       * OpenWindows has PseudoColor - use it! - j.m.wade 11/15/92
       *
       *			else if (XMatchVisualInfo(display, screen, 8, StaticColor, &visinfo) != 0) {
       *				visual= visinfo.visual;
       *				cmap= XCreateColormap(display, rootwin, visual, AllocNone);
       *			}
       */
      
      /* if all else fails, use PseudoColor */
      else if (XMatchVisualInfo(display, screen, DefaultDepth(display, screen), PseudoColor, &visinfo) != 0) {
	visual= visinfo.visual;
	cmap= DefaultColormap(display, screen);
      }
      /*
       *  I added this when I took out the OpenWindows hook above - j.m.wade 11/15/92
       */
      /* if PseudoColor unavailable, try StaticColor */
      else if (XMatchVisualInfo(display, screen, 8, StaticColor, &visinfo) != 0) {
	visual= visinfo.visual;
	cmap= XCreateColormap(display, rootwin, visual, AllocNone);
      }
      else
	ikp_err("Cannot access StaticColor or PseudoColor visual on this display.", FATAL);
			break;
      
    default:
      ikp_err("Unknown visual class on this display.", FATAL);
    }
    break;
  }
  
  get_xdefaults(progname);

/* I now just set MANPATH in the startup script and execute the man 
   command as a child of xcat with the -man option. - joe m. wade 3/29/95 

  if (getenv("IKPMANPATH")==NULL) {
    ikp_err("Please set the environment variable IKPMANPATH.", NONFATAL);
    strcpy(man_path,"");
  } else {
    strcpy(man_path,getenv("IKPMANPATH"));
  }
*/

  if (getenv("XUI_PATH")==NULL) {
    fprintf(stderr,"Please set the environment variable XUI_PATH.\n\n");
    exit(1);
  } else {
                                /* Get path of the pattern files. */
    strcpy(xui_path,getenv("XUI_PATH"));
  }
  
  /* small size font */
  if ((small_font= XLoadQueryFont(display, SMALL_FONT)) == NULL) {
    (void) fprintf(stderr, "%s: display %s doesn't know font %s\n", progname, DisplayString(display), SMALL_FONT);
    exit(1);
  }
  small_fontht= small_font->max_bounds.ascent+small_font->max_bounds.descent;
  small_charwd= XTextWidth(small_font, "X", strlen("X"));
  (void) strcpy(small_fontnm, SMALL_FONT);

  init_canvas();
  
  XtRealizeWidget(top_level);

  init_gc();
  init_cursors();

  init_file_grn();

  return;
}

void init_canvas()
{
  Widget work_area;
  Widget label;
  Widget pulldown;
  Widget button;
  Widget paned_window;
  Widget form;
  Pixmap icon_pixmap;
  int screen;
  Library *l;
  Module *mdl;

  screen= DefaultScreen(display);

  icon_pixmap = XCreateBitmapFromData(display,
				      DefaultRootWindow(display),
				      (char *) ikp_icon_bits,
				      ikp_icon_width,ikp_icon_height);
  XtVaSetValues(top_level,
	       XtNiconPixmap,icon_pixmap,
	       NULL);

  main_window=XmCreateMainWindowVa(top_level,"main",
				   XmNshowSeparator,True,
                                   (char *)0);

  menubar(main_window);

  work_area=XmCreateFormVa(main_window,"form",
                           NULL);

  button=XmCreatePushButtonVa(work_area,"Man Page",
                              XmNleftAttachment,XmATTACH_FORM,
                              XmNleftOffset,10,
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNbottomOffset,10,
                              XmNactivateCallback,CBl(manpageCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(work_area,"Module by Name",
                              XmNleftAttachment,XmATTACH_FORM,
                              XmNleftOffset,10,
                              XmNbottomAttachment,XmATTACH_WIDGET,
                              XmNbottomWidget,button,
                              XmNactivateCallback,CBl(prclibcr_textCB,0),
                              NULL);

  paned_window=XmCreatePanedWindowVa(work_area,"paned",
                                     XmNtopAttachment,XmATTACH_FORM,
                                     XmNtopOffset,10,
                                     XmNleftAttachment,XmATTACH_FORM,
                                     XmNleftOffset,10,
                                     XmNbottomAttachment,XmATTACH_WIDGET,
                                     XmNbottomWidget,button,
                                     XmNbottomOffset,10,
                                     NULL);
  
  form=XmCreateFormVa(paned_window,"form",
                      NULL);
 
  label=XmCreateLabelVa(form,"Library List",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
                        NULL);

  library_list=XmCreateScrolledListVa(form,"library_list",
				      XmNscrollingPolicy,XmAUTOMATIC,
                                      XmNlistSizePolicy,XmCONSTANT,
                                      XmNscrollBarDisplayPolicy,XmSTATIC,
                                      XmNvisibleItemCount,15,
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget,label,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNleftAttachment,XmATTACH_FORM,
                                      XmNbottomAttachment,XmATTACH_FORM,
                                      XmNbottomOffset,10,
                                      XmNdefaultActionCallback,
                                      CBl(prclibCB,0),
                                      NULL);
 
  if (libs!=NULL)
    for (l= libs; l != (Library *) NULL; l= l->lib_next) {
      XmListAddItem(library_list,XMstr(l->lib_name),0);
    }


  form=XmCreateFormVa(paned_window,"form",
                      NULL);
 
  label=XmCreateLabelVa(form,"Module List",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
                        NULL);
 
  module_list=XmCreateScrolledListVa(form,"module_list",
				     XmNscrollingPolicy,XmAUTOMATIC,
                                     XmNlistSizePolicy,XmCONSTANT,
                                     XmNscrollBarDisplayPolicy,XmSTATIC,
                                     XmNvisibleItemCount,12,
                                     XmNtopAttachment,XmATTACH_WIDGET,
                                     XmNtopWidget,label,
                                     XmNrightAttachment,XmATTACH_FORM,
                                     XmNleftAttachment,XmATTACH_FORM,
                                     XmNbottomAttachment,XmATTACH_FORM,
                                     XmNdefaultActionCallback,
                                     CBl(prclibcrCB,0),
                                     NULL);
 
  scroll_window=XmCreateScrolledWindowVa(work_area,"scroll",
					 XmNwidth,512,
					 XmNheight,512,
					 XmNtopAttachment,XmATTACH_FORM,
					 XmNbottomAttachment,XmATTACH_FORM,
					 XmNleftAttachment,XmATTACH_WIDGET,
					 XmNleftWidget,paned_window,
					 XmNleftOffset,10,
					 XmNrightAttachment,XmATTACH_FORM,
					 XmNscrollingPolicy,XmAUTOMATIC,
					 NULL);
  
  draw_area=XmCreateDrawingAreaVa(scroll_window,"draw",
				  XmNwidth, NET_WIDTH,
				  XmNheight, NET_HEIGHT,
				  XmNexposeCallback,CBl(redisplayCB,0),
				  NULL);


  XtAddEventHandler(draw_area,
		    ButtonPressMask|ButtonReleaseMask|PointerMotionMask, 
		    False,ikp_callback_event, (caddr_t)0);
  
  message_area(main_window);

  ikp_filer_box();
  prompt_box();
  confirm_box();

  XtVaSetValues(main_window,
		XmNworkWindow,work_area,
/*                XmNmessageWindow,message_window, */
                XmNmenuBar,menu_bar,
                XmNshowSeparator,True,
                NULL);
}


init_gc()
{
  XGCValues gcv;
  GC gc;
  XImage image;

  top_window = XtWindow(top_level);
  net_cpm = XtWindow(draw_area);
  
  gcv.function= GXcopy;
  gcv.font= reg_font->fid;
  gcv.foreground= fg_pixel;
  gcv.background= bg_pixel;
  gcv.plane_mask= fg_pixel | bg_pixel;

  net_gc= XCreateGC(display, net_cpm, (GCFunction | GCFont | GCForeground | GCBackground | GCPlaneMask), &gcv);
  
  gcv.function= GXinvert;
  gcv.font= reg_font->fid;
  gcv.plane_mask= fg_pixel ^ bg_pixel;
  net_igc= XCreateGC(display, net_cpm, (GCFunction | GCFont | GCForeground | GCBackground | GCPlaneMask), &gcv);
  
  gcv.function= GXxor;
  gcv.foreground= fg_pixel ^ bg_pixel;
  net_xgc= XCreateGC(display, net_cpm, (GCFunction | GCFont | GCForeground | GCPlaneMask), &gcv);
  
  gcv.font= small_font->fid;
  net_sfxgc= XCreateGC(display, net_cpm, (GCFunction | GCFont | GCForeground | GCPlaneMask), &gcv);

  gcv.function= GXcopy;
  gcv.font= reg_font->fid;
  gcv.foreground= bg_pixel;
  gcv.background= fg_pixel;
  gcv.plane_mask= fg_pixel | bg_pixel;
  net_cgc= XCreateGC(display, net_cpm, (GCFunction | GCFont | GCForeground | GCBackground | GCPlaneMask), &gcv);
  
  /* GC for highlighting running processes */
  prcrun_pm= XCreatePixmap(display, DefaultRootWindow(display), prcrun_width, prcrun_height, 1);

  gcv.foreground= fg_pixel;
  gcv.background= bg_pixel;
  gc= XCreateGC(display, prcrun_pm, GCForeground | GCBackground, &gcv);
  image.height= prcrun_height;
  image.width= prcrun_width;
  image.xoffset= 0;
  image.format= XYBitmap;
  image.data=(char *) prcrun_bits;
  image.byte_order= LSBFirst;
  image.bitmap_unit= 8;
  image.bitmap_bit_order= LSBFirst;
  image.bitmap_pad= 8;
  image.bytes_per_line= (prcrun_width+7)>>3;
  image.depth= 1;
  XPutImage(display, prcrun_pm, gc, &image, 0, 0, 0, 0, prcrun_width, prcrun_height);
  XFreeGC(display, gc);
  gcv.foreground= fg_pixel;
  gcv.background= bg_pixel;
  gcv.function= GXxor;
  gcv.stipple= prcrun_pm;
  gcv.fill_style= FillStippled;
  net_rpgc= XCreateGC(display, net_cpm, (GCForeground | GCBackground | GCFunction | GCStipple | GCFillStyle), &gcv);

  /* GC for highlighting stopped processes */
  prcstop_pm= XCreatePixmap(display, DefaultRootWindow(display), prcstop_width, prcstop_height, 1);
  gcv.foreground= fg_pixel;
  gcv.background= bg_pixel;
  gc= XCreateGC(display, prcstop_pm, GCForeground | GCBackground, &gcv);
  image.height= prcstop_height;
  image.width= prcstop_width;
  image.xoffset= 0;
  image.format= XYBitmap;
  image.data=(char *) prcstop_bits;
  image.byte_order= LSBFirst;
  image.bitmap_unit= 8;
  image.bitmap_bit_order= LSBFirst;
  image.bitmap_pad= 8;
  image.bytes_per_line= (prcstop_width+7)>>3;
  image.depth= 1;
  XPutImage(display, prcstop_pm, gc, &image, 0, 0, 0, 0, prcstop_width, prcstop_height);
  XFreeGC(display, gc);
  gcv.foreground= fg_pixel;
  gcv.background= bg_pixel;
  gcv.function= GXxor;
  gcv.stipple= prcstop_pm;
  gcv.fill_style= FillStippled;
  net_spgc= XCreateGC(display, net_cpm, (GCForeground | GCBackground | GCFunction | GCStipple | GCFillStyle), &gcv);

  /* canvas input mask */
  XSelectInput(display, net_cpm, ExposureMask | ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
  
  return;
}

char *get_wkdir(char *dir)
{
  char *c, *d;
  
/*
  if (getwd(dir) == (char *) NULL) {
*/
  if (getcwd(dir,MAXPATHLEN+2) == (char *) NULL) {
    ikp_err("Getwd error.", NONFATAL);
    return((char *) NULL);
  }
  if (!strncmp(dir, AUTOMOUNT_PREFIX, strlen(AUTOMOUNT_PREFIX))) {
    for (c= dir+strlen(AUTOMOUNT_PREFIX), d= dir; *c != '\0'; c++, d++)
      *d= *c;
    *d= *c;
  }
  return(dir);
}

void init_cursors()
{
  Pixmap pixmap_mask,pixmap_source;
  static XColor fg,bg;
  
  fg.pixel=1;
  fg.red=0;
  fg.green=0;
  fg.blue=0;
  bg.pixel=0;
  bg.red=65535;
  bg.green=65535;
  bg.blue=65535;
  
  ccursor  = XCreateFontCursor(display, XC_left_ptr);
  lccursor = XCreateFontCursor(display, XC_top_left_corner);
  chcursor = XCreateFontCursor(display, XC_crosshair);
  klcursor = XCreateFontCursor(display, XC_pirate);
  mvcursor = XCreateFontCursor(display, XC_fleur);
  watchcursor = XCreateFontCursor(display, XC_watch);
  selcursor = XCreateFontCursor(display, XC_hand2);
  pixmap_mask=XCreateBitmapFromData(display,XtWindow(top_level),
				    (char *)copyCursorMask_bits,
				    copyCursorMask_width,
				    copyCursorMask_height);
  pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
				      (char *)copyCursor_bits,
				      copyCursor_width,
				      copyCursor_height);
  cpcursor=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,
				copyCursor_x_hot,copyCursor_y_hot);
}

Cursor get_cursor(int i)
{
  switch (i) {
  case LXC_CCURSOR:
    return (ccursor);
  case LXC_LCCURSOR:
    return (lccursor);
  case LXC_CHCURSOR:
    return (chcursor);
  case LXC_KLCURSOR:
    return (klcursor);
  case LXC_MVCURSOR:
    return (mvcursor);
  case LXC_WATCHCURSOR:
    return (watchcursor);
  case LXC_SELCURSOR:
    return (selcursor);
  case LXC_CPCURSOR:
    return (cpcursor);
  default:
    printf("Error -- undefined cursor from get_cursor\n");
    break;
  }
}

void manpageCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data)
{
  Module *current_module;
  int *module_item;
  int library_count=0,module_count,count;


/* I now just set MANPATH in the startup script and execute the man 
   command as a child of xcat with the -man option. - joe m. wade 3/29/95 

  if (strlen(man_path)==0) {
    ikp_err("Please set the environment variable IKPMANPATH.", NONFATAL);
    return;
  }
*/

  if (current_lib==NULL)
    current_lib=libs;

  if (XmListGetSelectedPos(module_list,&module_item,&module_count)==False)
    return;

  current_module=current_lib->lib_modules;

  for (count=1; count<*(module_item); count++) {
    current_module=current_module->mdl_next;
  }
/* - added the -man option for xcat; now just do a man on the module.
						- 3/27/95 - j.m.wade
  sprintf(buf1,"xcat -noscroll %s%s.help &",
	  man_path,current_module->mdl_prog);
*/
/* modified to use "usp man" for machine portability - modified 3/38/97 - jmw */
  sprintf(buf1,"xcat -C Ikp -man -noscroll -e usp man %s &",
	  current_module->mdl_prog);
  system(buf1);

  free((char *)module_item);
  return;
}

/*
  Find the cursor location.
*/
void locate_cursor(int *x,int *y)
{
  Window root,child;
  int root_x=0,root_y=0,win_x,win_y;
  unsigned int keys_buttons;
 
  XQueryPointer(display,top_window,&root,&child,
		&root_x,&root_y,&win_x,&win_y,&keys_buttons);
 
  if (root_x>50) 
    root_x-=50; 
  else 
    root_x=0;
  if (root_y>50) 
    root_y-=50; 
  else 
    root_y=0;
 
  *x=root_x;
  *y=root_y;
 
  return;
}
