/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <signal.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"


/*
   Create a module. If this routine is called while
   reading a library file, p will be NULL. If it is
   called while reading a net configuration file,
   l will be NULL. (Exactly one of l and p will
   always be NULL.)
*/
Module *mdl_create(Library *l,Process *p,char *name)
{
  Module *m, *n;
  char *c;
  
  if ((l == (Library *) NULL) && (p == (Process *) NULL)) {
    ikp_err("Null library and process.", NONFATAL);
    return((Module *) NULL);
  }
  if ((l != (Library *) NULL) && (p != (Process *) NULL)) {
    ikp_err("Non-null library and process.", NONFATAL);
    return((Module *) NULL);
  }
  if (name == (char *) NULL) {
    ikp_err("Null module name.", NONFATAL);
    return((Module *) NULL);
  }
  if (strlen(name) == 0) {
    ikp_err("Null module name.", NONFATAL);
    return((Module *) NULL);
  }
  
  if ((m= (Module *) calloc(1, sizeof(Module))) == (Module *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  m->mdl_library= (caddr_t) l;
  m->mdl_process= (caddr_t) p;
  m->mdl_prog= (char *) NULL;
  if ((m->mdl_label= calloc((unsigned) (strlen(name)+1), sizeof(char *))) == (char *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  (void) strcpy(m->mdl_label, name);
  m->mdl_path= (char *) NULL;
  m->mdl_dir= (char *) NULL;
  m->mdl_helpfile= (char *) NULL;
  m->mdl_input= (Mdlio *) NULL;
  m->mdl_output= (Mdlio *) NULL;
  m->mdl_diag= (Mdlio *) NULL;
  m->mdl_nitems= 0;
  m->mdl_commlen= 0;
  m->mdl_items= (Mdlitem *) NULL;
  m->mdl_twin= None;
  m->mdl_next= (Module *) NULL;
  
  if (l != (Library *) NULL) {

    /* link into module list */
    if (l->lib_modules == (Module *) NULL)
      l->lib_modules= m;
    else {
      for (n= l->lib_modules; n->mdl_next != (Module *) NULL; n= n->mdl_next);
      n->mdl_next= m;
    }
  } else 
    if (p != (Process *) NULL)
      p->prc_module= m;
  
  return(m);
}

int mdl_free(Module *m)
{
  Mdlio *mio, *nio;
  Mdlitem *mi, *ni;
  
  if (m->mdl_prog != (char *) NULL)
    cfree(m->mdl_prog);
  if (m->mdl_label != (char *) NULL)
    cfree(m->mdl_label);
  if (m->mdl_path != (char *) NULL)
    cfree(m->mdl_path);
  if (m->mdl_dir != (char *) NULL)
    cfree(m->mdl_dir);
  if (m->mdl_helpfile != (char *) NULL)
    cfree(m->mdl_helpfile);
  
  for (mio= m->mdl_input; mio != (Mdlio *) NULL; mio= nio) {
    nio= mio->mdlio_next;
    cfree(mio);
  }
  for (mio= m->mdl_output; mio != (Mdlio *) NULL; mio= nio) {
    nio= mio->mdlio_next;
    cfree(mio);
  }
  for (mio= m->mdl_diag; mio != (Mdlio *) NULL; mio= nio) {
    nio= mio->mdlio_next;
    cfree(mio);
  }
  
  cfree((char *) m);
  
  return(IKP_SUCCESS);
}

int mdl_addio(Module *m,int fd,int type)
{
  Mdlio *mi, *ni;
  
  for (mi= m->mdl_input; mi != (Mdlio *) NULL; mi= mi->mdlio_next) {
    if (mi->mdlio_fd == fd) {
      ikp_err("Duplicate module input connector.", NONFATAL);
      return(IKP_FAILURE);
    }
  }
  for (mi= m->mdl_output; mi != (Mdlio *) NULL; mi= mi->mdlio_next) {
    if (mi->mdlio_fd == fd) {
      ikp_err("Duplicate module output connector.", NONFATAL);
      return(IKP_FAILURE);
    }
  }
  for (mi= m->mdl_diag; mi != (Mdlio *) NULL; mi= mi->mdlio_next) {
    if (mi->mdlio_fd == fd) {
      ikp_err("Duplicate module diagnostic connector.", NONFATAL);
      return(IKP_FAILURE);
    }
  }
  
  if ((mi= (Mdlio *) calloc(1, sizeof(Mdlio))) == (Mdlio *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  mi->mdlio_fd= fd;
  
  switch (type) {
  case MDLIO_INPUT:
    if (m->mdl_input == (Mdlio *) NULL)
      m->mdl_input= mi;
    else {
      for (ni= m->mdl_input; ni->mdlio_next != (Mdlio *) NULL; ni= ni->mdlio_next);
      ni->mdlio_next= mi;
    }
    break;
  case MDLIO_OUTPUT:
    if (m->mdl_output == (Mdlio *) NULL)
      m->mdl_output= mi;
    else {
      for (ni= m->mdl_output; ni->mdlio_next != (Mdlio *) NULL; ni= ni->mdlio_next);
      ni->mdlio_next= mi;
    }
    break;
  case MDLIO_DIAG:
    if (m->mdl_diag == (Mdlio *) NULL)
      m->mdl_diag= mi;
    else {
      for (ni= m->mdl_diag; ni->mdlio_next != (Mdlio *) NULL; ni= ni->mdlio_next);
      ni->mdlio_next= mi;
		}
    break;
  default:
    break;
  }
  mi->mdlio_next= (Mdlio *) NULL;
  return(IKP_SUCCESS);
}

Module *mdl_copy(Module *m)
{
  Module *new;
  Mdlio **newio, *mio;
  Mdlitem **newi, *mi;
  
  if (m == (Module *) NULL) {
    ikp_err("Null module.", FATAL);
    return((Module *) NULL);
  }
  
  if ((new= (Module *) calloc(1, sizeof(Module))) == (Module *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  new->mdl_library= m->mdl_library;
  new->mdl_process= (caddr_t) NULL;
  
  /* program */
  if (m->mdl_prog != (char *) NULL) {
    if ((new->mdl_prog= calloc((unsigned) (strlen(m->mdl_prog)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->mdl_prog, m->mdl_prog);
  }
  else
    new->mdl_prog= (char *) NULL;
  
  /* label */
  if ((new->mdl_label= calloc((unsigned) (strlen(m->mdl_label)+1), sizeof(char *))) == (char *) NULL)
    ikp_err("Memory allocation error.", FATAL);
  (void) strcpy(new->mdl_label, m->mdl_label);
  
  /* path prefix */
  if (m->mdl_path != (char *) NULL) {
    if ((new->mdl_path= calloc((unsigned) (strlen(m->mdl_path)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->mdl_path, m->mdl_path);
  }
  else
    new->mdl_path= (char *) NULL;
  
  /* working directory */
  if (m->mdl_dir != (char *) NULL) {
    if ((new->mdl_dir= calloc((unsigned) (strlen(m->mdl_dir)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->mdl_dir, m->mdl_dir);
  }
  else
    new->mdl_dir= (char *) NULL;
  
  /* helpfile */
  if (m->mdl_helpfile != (char *) NULL) {
    if ((new->mdl_helpfile= calloc((unsigned) (strlen(m->mdl_helpfile)+1), sizeof(char))) == (char *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (void) strcpy(new->mdl_helpfile, m->mdl_helpfile);
  }
  else
    new->mdl_helpfile= (char *) NULL;
  
  /* input connectors */
  newio= &(new->mdl_input);
  for (mio= m->mdl_input; mio != (Mdlio *) NULL; mio= mio->mdlio_next) {
    if ((*newio= (Mdlio *) calloc(1, sizeof(Mdlio))) == (Mdlio *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (*newio)->mdlio_fd= mio->mdlio_fd;
    newio= &((*newio)->mdlio_next);
  }
  *newio= (Mdlio *) NULL;
  
  /* output connectors */
  newio= &(new->mdl_output);
  for (mio= m->mdl_output; mio != (Mdlio *) NULL; mio= mio->mdlio_next) {
    if ((*newio= (Mdlio *) calloc(1, sizeof(Mdlio))) == (Mdlio *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (*newio)->mdlio_fd= mio->mdlio_fd;
    newio= &((*newio)->mdlio_next);
  }
  *newio= (Mdlio *) NULL;
  
  /* diagnostic connectors */
  newio= &(new->mdl_diag);
  for (mio= m->mdl_diag; mio != (Mdlio *) NULL; mio= mio->mdlio_next) {
    if ((*newio= (Mdlio *) calloc(1, sizeof(Mdlio))) == (Mdlio *) NULL)
      ikp_err("Memory allocation error.", FATAL);
    (*newio)->mdlio_fd= mio->mdlio_fd;
    newio= &((*newio)->mdlio_next);
  }
  *newio= (Mdlio *) NULL;
  
  new->mdl_commlen= m->mdl_commlen;
  new->mdl_nitems= m->mdl_nitems;
  new->mdl_twin= None;
  
  newi= &(new->mdl_items);

  *newi= (Mdlitem *) NULL;
  
  return(new);
}

