/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

Net *net_sel;
static Net *nt_wr;
static Net *nt_dst;

extern void netrun();
extern Cursor get_cursor();
extern void net_highlight(Net *);
extern void prc_erase(Process *);
extern void net_draw(Net *);

void netrdCB(Widget,XtPointer,XmFileSelectionBoxCallbackStruct *);
void net_cancelrdCB(Widget,XtPointer,XtPointer);

void netwrCB(Widget,XtPointer,XmFileSelectionBoxCallbackStruct *);
void net_appendCB(Widget,XtPointer,XmFileSelectionBoxCallbackStruct *);
void net_cancelwrCB(Widget,XtPointer,XtPointer);
void netdestroy_okCB(Widget w,XtPointer client_data,XtPointer call_data);
void netdestroy_cancelCB(Widget w,XtPointer client_data,XtPointer call_data);

static int net_x,net_y;

netsel_select(XEvent *event,int run_flag)
{
  Net *nt;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((nt= (Net *) p->prc_net) == (Net *) NULL) {
    ikp_err("Selected process not bound to any net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  curr_net= nt;
  net_op= MAIN_MENU;

  if (run_flag)
    netrun();

  return;
}

void net_nameCB(Widget w,
		XtPointer client_data,
		XmSelectionBoxCallbackStruct *call_data)
{
  char *str;

  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);

  fprintf(stderr,"Name of net %s\n",str);

  if (curr_net->name!=NULL)
    free(curr_net->name);
  curr_net->name=strdup(str);
  
  return;
}


netname_select(XEvent *event)
{
  Net *nt;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((nt= (Net *) p->prc_net) == (Net *) NULL) {
    ikp_err("Selected process not bound to any net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  curr_net= nt;
  net_op= MAIN_MENU;

  if (nt->name==NULL)
    strcpy(buf1,"");
  else
    strcpy(buf1,nt->name);
  XtVaSetValues(prompt,
		XmNselectionLabelString,XMstr("Net Name:"),
		XmNtextString,XMstr(buf1),
		XmNokCallback,CBl(net_nameCB,0),
		XmNcancelCallback,CBl(NULL,0),
		NULL);
  XtManageChild(prompt);
  return;
}


netdst_select(XEvent *event)
{
  Net *nt;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y, val,root_x,root_y;
  boolean net_editopen();
  void net_highlight();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((nt= (Net *) p->prc_net) == (Net *) NULL) {
    ikp_err("Selected process not bound to any net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (nt == run_net) {
    ikp_err("Cannot destroy a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (net_editopen(nt)) {
    ikp_err("Selected net is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  net_highlight(nt);
  nt_dst=nt;
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
                XmNdefaultPosition,False,
                XmNdialogTitle,XMstr("Destroy Net"),
                XmNmessageString,
                XMstr("Do you want to destroy this net?"),
                XmNokCallback,CBl(netdestroy_okCB,0),
                XmNcancelCallback,CBl(netdestroy_cancelCB,0),
                XmNx,root_x,
                XmNy,root_y,
                NULL);
 
  XtManageChild(confirm);
}


void netdestroy_okCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  Process *p,*p_next;
  
  if (curr_net == nt_dst)
    curr_net= (Net *) NULL;
  net_highlight(nt_dst);

/*  for (p= nt_dst->net_prclist; p != (Process *) NULL; p= p->prc_next) { */
  p_next=nt_dst->net_prclist;
  while (p_next!=NULL) {
    p=p_next;
    p_next=p->prc_next;
    prc_erase(p);
    if (p->prc_net != (caddr_t) NULL)
      prc_unlink(p);
    prc_free(p, PRC_FREENET);
  }

  redisplayCB(NULL,1,NULL);

  net_op= MAIN_MENU;
  return;
}
    
void netdestroy_cancelCB(Widget w,
			 XtPointer client_data,
			 XtPointer call_data)
{
  net_highlight(nt_dst);
  
  net_op= MAIN_MENU;
  return;
}

netrd_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  net_x= evt->x;
  net_y= evt->y;
  if (net_x < NET_MARGIN)
    net_x= NET_MARGIN;
  if (net_y < NET_MARGIN)
    net_y= NET_MARGIN;

  
  message_update("Open net");
 
  XtVaSetValues(file,
		XmNokCallback,CBl(netrdCB,0),
		XmNcancelCallback,CBl(net_cancelrdCB),
		XmNdialogTitle,XMstr("Open Net"),
		NULL);

  XtManageChild(file);
}


void netrdCB(Widget w,
	     XtPointer client_data,
	     XmFileSelectionBoxCallbackStruct *call_data)
{ 
  char *filename;
 
                                  /* Set if a filename was entered. */
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&filename);

  if (filename==NULL) {
    ikp_err("Empty filename.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  net_read(net_x,net_y, filename);

  net_op= MAIN_MENU;
  return;
}

void net_cancelrdCB(Widget w,
		    XtPointer client_data,
		    XtPointer call_data)
{ 
  net_op= MAIN_MENU;
  return;
}


netwr_select(XEvent *event)
{
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  boolean net_editopen();
  void net_highlight();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((nt_wr= (Net *) p->prc_net) == (Net *) NULL) {
    ikp_err("Selected process not bound to any net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (nt_wr == run_net) {
    ikp_err("Cannot write a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (net_editopen(nt_wr)) {
    ikp_err("Selected net is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  net_highlight(nt_wr);

  
  message_update("Write net");
 
 
  XtVaSetValues(file,
		XmNokCallback,CBl(netwrCB,0),
		XmNcancelCallback,CBl(net_cancelwrCB),
		XmNdialogTitle,XMstr("Save Net"),
		NULL);

  XtManageChild(file);
}



void netwrCB(Widget w,
	     XtPointer client_data,
	     XmFileSelectionBoxCallbackStruct *call_data)
{ 
  char *filename;
 
                                  /* Set if a filename was entered. */
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&filename);

  if (filename==NULL) {
    ikp_err("Empty filename.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  net_write(nt_wr, filename,0);

  
  net_highlight(nt_wr);
  
  net_op= MAIN_MENU;
  return;
}


netappend_select(XEvent *event)
{
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  boolean net_editopen();
  void net_highlight();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((nt_wr= (Net *) p->prc_net) == (Net *) NULL) {
    ikp_err("Selected process not bound to any net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (nt_wr == run_net) {
    ikp_err("Cannot write a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (net_editopen(nt_wr)) {
    ikp_err("Selected net is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  net_highlight(nt_wr);

  
  message_update("Write net");
 
 
  XtVaSetValues(file,
		XmNokCallback,CBl(net_appendCB,0),
		XmNcancelCallback,CBl(net_cancelwrCB),
		XmNdialogTitle,XMstr("Save Append Net"),
		NULL);

  XtManageChild(file);
}

void net_appendCB(Widget w,
		XtPointer client_data,
		XmFileSelectionBoxCallbackStruct *call_data)
{ 
  char *filename;
 
                                  /* Set if a filename was entered. */
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&filename);

  if (filename==NULL) {
    ikp_err("Empty filename.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  net_write(nt_wr, filename,1);

  
  net_highlight(nt_wr);
  
  net_op= MAIN_MENU;
  return;
}

void net_cancelwrCB(Widget w,
		    XtPointer client_data,
		    XtPointer call_data)
{ 
  net_highlight(nt_wr);
  
  net_op= MAIN_MENU;
  return;
}


netcp_select(XEvent *event)
{
  Net *nt;
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  Net *net_copy();
  boolean net_editopen();
  void net_highlight();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  x= evt->x;
  y= evt->y;
  
  if (net_sel == (Net *) NULL) {
    if ((p= prc_locate(x, y)) == (Process *) NULL) {
      ikp_err("No net selected.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    if ((net_sel= (Net *) p->prc_net) == (Net *) NULL) {
      ikp_err("Selected process not bound to any net.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    if (net_editopen(net_sel)) {
      ikp_err("Selected net is being edited.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    XDefineCursor(display,top_window,
		  get_cursor( LXC_LCCURSOR));
    net_highlight(net_sel);
    return;
  }
  
  
  if (x < NET_MARGIN)
    x= NET_MARGIN;
  if (y < NET_MARGIN)
    y= NET_MARGIN;
  if ((nt= net_copy(net_sel, x, y)) != (Net *) NULL) {
    net_draw(nt);
    curr_net= nt;
  }
  
  XDefineCursor(display,top_window,
		get_cursor( LXC_CCURSOR));
  net_highlight(net_sel);
  net_op= MAIN_MENU;
  return;
}
