C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c does some simple indexing and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer * 2 itr  ( SZLNHD )
      real        head ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      integer     nmod, ist1, ist2, idwrd1, idwrd2, ist3
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     stacor, iwrd1, iwrd2
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 256, otap * 256, name*5
      character   hdrwrd1 * 6, hdrwrd2 * 6, hdrwrd3 * 6
      logical     verbos, query, rnum1, rnum2, twod
      integer     argis
 
c-----
c    we access the header values which can be short or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'INDEX'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,ist1,ist2,idwrd1,idwrd2,
     1             nmod, hdrwrd1, hdrwrd2, verbos, rnum1, rnum2,
     2             twod,hdrwrd3,ist3)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'INDEX: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if (rnum1 .or. rnum2) then

      call savelu(hdrwrd1,ifmt_hdrwrd1,l_hdrwrd1,ln_hdrwrd1,TRACEHEADER)
      call savelu(hdrwrd2,ifmt_hdrwrd2,l_hdrwrd2,ln_hdrwrd2,TRACEHEADER)

      endif

      if (hdrwrd3(1:1) .ne. ' ') then
      call savelu(hdrwrd3,ifmt_hdrwrd3,l_hdrwrd3,ln_hdrwrd3,TRACEHEADER)
      endif
c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 5, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if (nmod .eq. 0) nmod = jtr
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nmod, hdrwrd1, hdrwrd2, ntap, otap,
     2                  ist1, ist2, idwrd1, idwrd2, rnum1, rnum2,
     3                  twod,hdrwrd3,ist3)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      ic = 0
      iwrd1 = ist1
      iwrd2 = ist2 - idwrd2
      DO  JJ = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            DO  KK = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  ic = ic + 1
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        idi    , TRACEHEADER)
                  call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        igi    , TRACEHEADER)
                  call saver2(lhed,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                        isi    , TRACEHEADER)

                  if (hdrwrd3(1:1) .ne. ' ') then
                     call savew2(lhed,ifmt_hdrwrd3,l_hdrwrd3,
     1                           ln_hdrwrd3, ist3  , TRACEHEADER)
                  endif

                  if (twod) then

                     ipri = idi - igi
                     isrc = 10 * isi
                     call savew2(lhed,ifmt_PrRcNm,l_PrRcNm,
     1                           ln_PrRcNm, ipri  , TRACEHEADER)
                     call savew2(lhed,ifmt_SrcLoc,l_SrcLoc,
     1                           ln_SrcLoc, isrc  , TRACEHEADER)

                  endif

                  iwrd2 = iwrd2 + idwrd2

                  if (rnum1 .or. rnum2) then
                     call savew2(lhed,ifmt_hdrwrd1,l_hdrwrd1,
     1                           ln_hdrwrd1, iwrd1  , TRACEHEADER)
                     call savew2(lhed,ifmt_hdrwrd2,l_hdrwrd2,
     1                           ln_hdrwrd2, iwrd2  , TRACEHEADER)
                  endif

                  if     (rnum1) then
                         call savew2(lhed,ifmt_RecNum,l_RecNum,
     1                               ln_RecNum, iwrd1 , TRACEHEADER)
                         call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum, iwrd2 , TRACEHEADER)
                         call savew2(lhed,ifmt_PrTrNm,l_PrTrNm,
     1                               ln_PrTrNm, iwrd2 , TRACEHEADER)
                  elseif (rnum2) then
                         call savew2(lhed,ifmt_RecNum,l_RecNum,
     1                               ln_RecNum, iwrd2 , TRACEHEADER)
                         call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum, iwrd1 , TRACEHEADER)
                         call savew2(lhed,ifmt_PrTrNm,l_PrTrNm,
     1                               ln_PrTrNm, iwrd1 , TRACEHEADER)
                  endif

                  IF (ic .eq. nmod) THEN
                      iwrd1 = iwrd1 + idwrd1
                      iwrd2 = ist2 - idwrd2
                      ic = 0
                  ENDIF

                  call wrtape (luout, itr, obytes)

            ENDDO
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
      ENDDO
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of index, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of index, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'index does simple indexing on user specified trace hdr words'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute index by typing index and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -Hw1[wd1]    (default = passed)   : hdr word 1'
        write(LER,*)
     :' -Hw2[wd2]    (default = passed)   : hdr word 2'
        write(LER,*)
     :' -Hw3[wd3]    (default = passed)   : hdr word 3'
        write(LER,*)
     :' -nr[nr]      (default = #trc/rec) : # traces in cycle'
        write(LER,*)
     :' -s1[s1]      (default = 1)        : start index for hdr wrd 1'
        write(LER,*)
     :' -s2[s2]      (default = 1)        : start index for hdr wrd 2'
        write(LER,*)
     :' -s3[s3]      (default = 0)        : constant inserted in Hw3'
        write(LER,*)
     :' -i1[i1]      (default = 1)        : index increment for wrd 1'
        write(LER,*)
     :' -i2[i2]      (default = 1)        : index increment for wrd 2'
        write(LER,*) ' '
        write(LER,*)
     :' -R1    RecNum numbered using Hw1; TrcNum with Hw2, or'
        write(LER,*)
     :' -R2    RecNum numbered using Hw2; TrcNum with Hw1, or'
        write(LER,*)
     :'        RecNum & TrcNum unchanged'
        write(LER,*)
     :' -twod  2D permanent rec numbering set ( PRI = DI - GI )'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   index -N[] -O[] -Hw1[] -Hw2[] -Hw3[] -s1[] -s2[] -s3[]'
        write(LER,*)
     :'                -i1[] -i2[] [ [ -R1 -R2 ] -twod -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,ist1,ist2,idwrd1,idwrd2,
     1                  nmod, hdrwrd1, hdrwrd2, verbos, rnum1, rnum2,
     2                  twod,hdrwrd3,ist3)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      character   hdrwrd1 * 6, hdrwrd2 * 6, hdrwrd3 * 6
      integer     ns, ne, irs, ire, nmod, ist1,ist2,idwrd1,idwrd2
      integer     ist3
      logical     verbos, rnum1, rnum2, twod
      integer     argis
 
      verbos = .false.
      rnum1  = .false.
      rnum2  = .false.
      twod   = .false.
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program index might be invoked in the following way:
 
c     index  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into index and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-Hw1', hdrwrd1, ' ', ' ' )
            call argstr( '-Hw2', hdrwrd2, ' ', ' ' )
            call argstr( '-Hw3', hdrwrd3, ' ', ' ' )
            call argi4 ( '-nr', nmod ,   0  ,  0    )
            call argi4 ( '-s1', ist1 ,   1  ,  1    )
            call argi4 ( '-s2', ist2 ,   1  ,  1    )
            call argi4 ( '-s3', ist3 ,   0  ,  0    )
            call argi4 ( '-i1', idwrd1 ,   1  ,  1    )
            call argi4 ( '-i2', idwrd2 ,   1  ,  1    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            rnum1  =   (argis('-R1') .gt. 0)
            rnum2  =   (argis('-R2') .gt. 0)
            twod   =   (argis('-twod') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
            IF (rnum1 .or. rnum2) THEN
               if (hdrwrd1(1:1) .eq. ' ') then
                  write(LER,*)'Error in index:'
                  write(LER,*)'Must specify hdr word 1 using -Hw1[]'
                  stop
               endif
               if (hdrwrd2(1:1) .eq. ' ') then
                  write(LER,*)'Error in index:'
                  write(LER,*)'Must specify hdr word 2 using -Hw2[]'
                  stop
               endif
            ENDIF
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nmod, hdrwrd1, hdrwrd2, ntap,otap,
     2                  ist1, ist2, idwrd1, idwrd2, rnum1, rnum2,
     3                  twod,hdrwrd3,ist3)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, nmod
      integer     ist1, ist2, idwrd1, idwrd2, ist3
      character   ntap*(*), otap*(*)
      character   hdrwrd1 * 6, hdrwrd2 * 6, hdrwrd3 * 6
      logical     rnum1, rnum2, twod
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace  =  ', nsamp
            write(LERR,*) ' sample interval     =  ', nsi
            write(LERR,*) ' traces per record   =  ', ntrc
            write(LERR,*) ' records per line    =  ', nrec
            write(LERR,*) ' format of data      =  ', iform
            if (hdrwrd1(1:1) .ne. ' ')
     1      write(LERR,*) ' Header word 1       =  ', hdrwrd1
            if (hdrwrd2(1:1) .ne. ' ')
     1      write(LERR,*) ' Header word 2       =  ', hdrwrd2
            if (hdrwrd3(1:1) .ne. ' ') then
            write(LERR,*) ' Header word 3       =  ', hdrwrd3
            write(LERR,*) ' Constant Hw3 value  =  ', ist3
            endif
            write(LERR,*) ' Number trcs in cycle=  ',nmod
            write(LERR,*) ' Start wrd 1         =  ', ist1
            write(LERR,*) ' Start wrd 2         =  ', ist2
            if (rnum1)
     1      write(LERR,*) ' RecNum numbered using Hw1; TrcNum with Hw2'
            if (rnum2)
     1      write(LERR,*) ' RecNum numbered using Hw2; TrcNum with Hw1'
            if (rnum1 .or. rnum2) then
            write(LERR,*) ' Increment wrd 1     =  ', idwrd1
            write(LERR,*) ' Increment wrd 2     =  ', idwrd2
            endif
            if (twod)
     1      write(LERR,*) ' Compute 2D PRI ( PRI = DI - GI )'
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
