C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  to replace data in a disk file
C
C**********************************************************************C
C
C insert READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and replaces a specified record on the output disk file
C with the input record
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis
      REAL        xtr ( 10*SZSMPM ),work(10*SZSMPM)
      CHARACTER   NAME * 6,  ntap * 256, otap * 256
#include <f77/pid.h>
      logical verbos,rnum,query
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )

      DATA     NAME /'INSERT'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, rnum /.false./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,nrst,nred,verbos)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'r+', -1)

      if (luin .eq. 0) then
          call sislgbuf( luin, 'on' )
      else
          call sislgbuf( luin, 'off' )
      endif

      if (luout .lt. 0) then
         write(LERR,*)'Output cannot be a pipe -- FATAL HEART ATTACK'
         stop
      endif

      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'INSERT: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif
#include <f77/saveh.h>
      ntrci  = ntrc
      nreci  = nrec
      nsampi = nsamp

      CALL RTAPE  ( LUOUT, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'INSERT: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif
#include <f77/saveh.h>
      ntrco  = ntrc
      nreco  = nrec
      nsampo = nsamp

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if (nsampi .ne. nsampo) then
         write(LERR,*)'FATAL HEART ATTACK in insert:'
         write(LERR,*)'input # samps ',nsampi,' different from output'
         write(LERR,*)'number samps ',nsampo
         stop
      endif
      if(ntrci .ne. ntrco) then
         write(LERR,*)'FATAL HEART ATTACK in insert:'
         write(LERR,*)'input # traces ',ntrci,' different from output'
         write(LERR,*)'number traces ',ntrco
         stop
      endif


c---------------------------------------
c  check key values for reasonableness
c---------------------------------------

      if (nrst .eq. 0) nrst = 1
      if (nred .eq. 0) nred = nreco
      nrecc = nred - nrst + 1


C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C

      dt = real (nsi) * unitsc

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsampi
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrci
        write(LERR,*) ' Input Records/Line  =  ', nreci
        write(LERR,*) ' Output Samples/Trc  =  ', nsampo
        write(LERR,*) ' Input traces/rec    =  ', ntrco
        write(LERR,*) ' Input Records/Line  =  ', nreco
        write(LERR,*) ' Format of Data      =  ', iform
        write(LERR,*) ' Start record        =  ', nrst
        write(LERR,*) ' End record          =  ', nred
        write(LERR,*) ' Number input recs   =  ', nrecc
c     endif


C**********************************************************************C
C     select portion of data set & write out
C**********************************************************************C

c------------------------------------------
c  skip to just before desired record
c------------------------------------------
      call skipt(luout,ntrc*(nrst-1),idummy)

      DO 100 JJ = 1, nrecc


             DO 99 KK = 1, ntrc
 
                   nbytes = 0
                   CALL RTAPE  ( LUIN , ITR, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         irec, TRACEHEADER)
                   call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         itrc, TRACEHEADER)

                   if(verbos) then
                      write(LERR,*)'JJ= ',jj,' kk= ',kk,
     1                             '  Output Record ',irec,
     2                             ' Trace ',itrc
                   endif

                   call wrtape(luout,itr,nbytes)

   99        CONTINUE


  100 CONTINUE

  700 continue

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for insert: replace records'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      insert -N[] -O[] -rs[] -re[] -V'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,nrst,nred,verbos)
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     nrst  - I         start record
c     nred  - I         end record
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      integer   argis,nrst,nred
      logical   verbos

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)
           verbos = ( argis( '-V' ) .gt. 0 )

c-----
      return
      end

