C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE INSTFR
C
C**********************************************************************C
C
C INSTFR READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and computes instantaneous frequency and polarity
C
C SUBROUTINE CALLS: RTAPE, WRTAPE, HLH, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer   itr (SZLNHD)
      integer   luin, luout1, luout2, lbytes, nbytes,obytes
      real      tri (SZLNHD)
      real      trifrq(SZLNHD), tripol(SZLNHD)
      integer   nsamp, nsi, ntrc, nrec, iform
      character name * 6
#include <f77/pid.h>
      integer   ns, ne, rs, re
      integer   static
      character ntap*512, otap1*512, otap2*512
      logical   verbos
      logical   query, IKP
      integer   argis, ordfft, pipe
 
c     equivalence ( itr(129), tri (1) )
      data name /'INSTFR'/, nbytes / 0 /, lbytes / 0 /
      data verbos/.true./
      data pipe/3/
c-----
c      read program parameters from command line
c-----
      query = (argis('-?') .gt. 0)
      if(query) then
            call help()
            stop
      endif
c-----
c      open printout file
c-----
#include <f77/open.h>
c-----
c      parse command line arguments
c-----
      call gcmdln(ns,ne,rs,re,ntap,otap1,otap2,verbos,fl,fh)

c-----
c      get logical unit numbers for input
c-----
      IKP = .false.
      if(in_ikp() .eq. 1) IKP = .true.

      call getln(luin  , ntap , 'r',  0)
      call getln(luout1, otap1, 'w',  1)
      if (IKP) then
         luout2 = -1
         call sisfdfit (luout2, pipe)
      else
         call getln(luout2, otap2, 'w', -1)
      endif

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape (luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'INSTFR: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif

      call hlhprt(itr, lbytes, name, 6, LERR)
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----
c      ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
c-----
c     initialize headers of output files
c-----
      if (mod(nsamp,2) .ne. 0) then
         nsamp = nsamp - 1
      endif
      call savew( itr, 'NumSmp', nsamp, LINHED)
      obytes = SZTRHD + nsamp * SZSMPD

c-----
c       get power of two
c       set up number of points for FFT
      nu = ordfft (nsamp)
      npts = 2 ** nu
c------

      nrecc = re - rs + 1
      call savew( itr, 'NumRec', nrec , LINHED)
      jtr = ne - ns + 1
      call savew( itr, 'NumTrc', ntrc , LINHED)
      call savhlh( itr, lbytes, lbyout)
      call wrtape(luout1, itr, lbyout)
      if(luout2 .gt. 0)then
            call wrtape(luout2, itr, lbyout)
      endif
c-----
c      verbose output of all pertinent information before
c      processing begins
c-----
      if(verbos )then
            call verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,
     1           otap1,otap2,luin,luout1,luout2,ns,ne,rs,re,verbos)
      endif
c-----
c      BEGIN PROCESSING
c      read trace
c----
c-----
c     skip unwanted records
c-----
      call recskp(1,rs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      do 1000 jj = rs, re

            call trcskp(jj,1,ns-1,luin,ntrc,itr)

            do 1001 kk=ns,ne

                  nbytes = 0
                  call rtape(luin,itr,nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',i,'  trace= ',k
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)

                  if(static .ne. 30000)then
                        call filtit(tri,trifrq,tripol,nsamp,nsi,fl,fh,
     1                              npts,unitsc,SZSMPD)
                  else
                        call vclr(trifrq,1,nsamp)
                        call vclr(tripol,1,nsamp)
                  endif

                  if(luout1.gt.0)then
                       do 5110 i=1,nsamp
                             tri(i) = trifrq(i)
 5110                  continue
                       call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                       call wrtape(luout1, itr, obytes)
                  endif

                  if(luout2.gt.0)then
                       do 5220 i=1,nsamp
                             tri(i) = tripol(i)
 5220                  continue
                       call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                       call wrtape(luout2, itr, obytes)
                  endif

 1001       continue

            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 1000 continue
  999 continue

      call lbclos(luin)
      call lbclos(luout1)
      if(luout2.gt.0)call lbclos(luout2)
      stop
      end

        subroutine filtit(tri,trifrq,tripol,nsamp,nsi,fl,fh,
     1                              npts,unitsc,SZSMPD)
#include <f77/iounit.h>
        real    tri(*), trifrq(*), tripol(*)
        integer npts, ierr, ierrs, iabort, SZSMPD
        complex data
        real    freq
        real    slop
        pointer (wkdata, data(1))
        pointer (wkfreq, freq(1))
        pointer (wkslop, slop(1))
c       equivalence (freq(1),slop(1))
        iabort = 0
        ierrs = 0

        item = NPTS * SZSMPD
        call galloc (wkdata, 2*item, ierr, iabort)
        ierrs = ierrs + ierr
        call galloc (wkfreq, item, ierr, iabort)
        ierrs = ierrs + ierr
        call galloc (wkslop, item, ierr, iabort)
        ierrs = ierrs + ierr
        if (ierrs .ne. 0) then
           write(LER,*)'FATAL ERROR in instfr:'
           write(LER,*)'Failure to allocate memory - traces too long?'
           call ccexit (666)
        endif

        NPTS21 = NPTS/2 + 1
        do 2000 i=1,NPTS
                if(i.le.nsamp)then
                        data(i) = cmplx(tri(i),0.0)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 2000   continue
c-----
c      define dt
c-----

        dt = real (nsi) * unitsc

        call four(data,npts,-1,dt,df)
c-----
c       form spectra to get quadrature
c-----
        do 3000 i=1, npts
                if(i.lt.npts21)then
                        data(i) = 2.0*data(i)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 3000   continue
        call four(data,npts,+1,dt,df)
c-----
c       now real(data) is the original time series
c       and aimag(data) is the quadrature series
c-----
        do 4000 i=1,nsamp
                h = real(data(i))
                q = aimag(data(i))
                if(i.eq.1)then
                        dqdt = aimag(data(2)-data(1))/dt
                        dhdt = real (data(2)-data(1))/dt
                elseif(i.gt.1 .and. i.lt.nsamp)then
                        dqdt = aimag(data(i+1)-data(i-1))/(2.0*dt)
                        dhdt = real (data(i+1)-data(i-1))/(2.0*dt)
                elseif(i.eq.nsamp)then
                        dqdt = aimag(data(i) - data(i-1))/(dt)
                        dhdt = real (data(i) - data(i-1))/(dt)
                endif
                den = h*h + q*q
                if(den .gt. 1.e-10) then
                   freq(i) = (h*dqdt - q*dhdt)/(h*h + q*q)
                   freq(i) = abs(freq(i)/6.2831853)
                else
                   freq(i) = 0.
                endif
 4000   continue
c-----
c       compute envelope
c-----
        do 5000 i=1,nsamp
                data(i) = cmplx(cabs(data(i)),0.0)
 5000   continue
c-----
c       weighted average of frequency
c       use a NPOINT smoothing operator
c-----
        NPOINT = 10
        do 6000 i=1,nsamp
                sumn = 0.0
                sumd = 0.0
                jlow = i - NPOINT/2
                jup  = i + NPOINT/2
                if(jlow.lt.1)jlow = 1
                if(jup .gt.nsamp)jup=nsamp
                do 6001 j=jlow,jup
                        sumn = sumn + real(data(j))*freq(j)
                        sumd = sumd + real(data(j))
 6001           continue
                if (abs(sumd) .gt. 1.e-10) then
                   trifrq(i) = sumn/sumd
                else
                   trifrq(i) = 0.
                endif
                if(trifrq(i) .lt. fl)trifrq(i) = fl
                if(trifrq(i) .gt. fh)trifrq(i) = fh
 6000   continue
c-----
c       get polarity using original trace and amplitude
c-----
        do 7000 i=1,nsamp
                if(i.eq.1)then
                        slop(1)=real(data(2)-0.75*data(1)-0.25*data(3))
                elseif(i.eq.nsamp)then
                        slop(i)=real(0.75*data(nsamp)-data(nsamp-1)+
     1                          0.25*data(nsamp-2))
                else
                        slop(i) = real(data(i+1) - data(i-1))
                endif
 7000   continue
        do 7010 i=1,nsamp
                if(i.eq.1)then
                        tripol(i) = 0.0
                else
                        if(sign(1.0,slop(i-1)).ne.sign(1.0,slop(i)))then
                                tripol(i) = sign(1.0,tri(i))
                        else
                                tripol(i) = tripol(i-1)
                        endif
                endif
 7010   continue
                        
        call gfree (wkdata)
        call gfree (wkfreq)
        call gfree (wkslop)

        return
        end


      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     1'***************************************************************'
      write(LER,*)
      write(LER,*)
     1'Execute instfr by typing instfr with the following arguments'
      write(LER,*)
     1' -N [ntap]    (default stdin)   : Input data file name'
      write(LER,*)
     1' -OF [otap1]  (default stdout)  : output file for frequency '
      write(LER,*)
     1' -OP [otap2]  (optional)        : output file for polarity  '
      write(LER,*)
     1' -rs [ir],    (default=1)       : beginning record number'
      write(LER,*)
     1' -re [re],    (default=last)    : ending record number'
      write(LER,*)
     1' -ns [ns],    (default=1)       : beginning trace number'
      write(LER,*)
     1' -ne [ne],    (default=last)    : ending trace number'
      write(LER,*)
     1' -V                             : verbose output'
      write(LER,*)
     1' -fl [fl]     : Lower hard limit for output freqneucy '
      write(LER,*)
     1' -fh [fh]     : Upper hard limit for output frequency '
      write(LER,*)
     1'Usage: instfr -N[ntap] -OF[otap1] -OP[otap2]  -ns[] -ne[]'
      write(LER,*)
     1'              -rs[] -re[] -fl[] -fh[] -V '
      write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ns,ne,rs,re,ntap,otap1,otap2,verbos,fl,fh)
#include <f77/iounit.h>
      integer*4 ns, ne, rs, re
      character ntap*(*), otap1*(*), otap2*(*)
      integer argis
      logical verbos
            call argstr('-N', ntap, ' ', ' ' )
            call argstr('-OF', otap1, ' ', ' ')
            call argstr('-OP', otap2, ' ', ' ')
            call argi4 ('-ns' , ns, 0, 0)
            call argi4 ('-ne' , ne, 0, 0)
            call argi4 ('-rs',rs,1,1)
            call argi4 ('-re',re,0,0)
            call argr4( '-fl', fl, 10.0, 10.0 )
            call argr4( '-fh', fh, 40.0, 40.0 )
            verbos = ( argis ('-V') .gt. 0 )
      return
      end

      subroutine verbal(lbytes, nsamp, nsi, ntrc, nrec, iform, ntap,
     1 otap1, otap2, luin, luout1, luout2, ns, ne, rs, re, verbos)
c-----
c     verbose output of processing parameters
c
c     lbytes- I*4 number of bytes in line header
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*100     input file name
c     otap1 - C*100     instantaneous frequency output file name
c     otap2 - C*100     instantaneous polarity output file name
c     luin  - I*4 input file unit number
c     luout1- I*4 instantaneous frequency unit number
c     luout2- I*4 instantaneous polarity unit number
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     rs    - I*4 starting record
c     re    - I*4 ending record
c     verbos- L   verbose information
c-----
#include <f77/iounit.h>
      integer*4 lbytes, nsamp, nsi, ntrc, nrec, iform
      integer *4 luin, luout1, luout2
      character ntap*(*), otap1*(*), otap2*(*)
      integer*4 ns, ne, rs, re
      logical verbos
      integer*4 lenstr
            ln = lenstr(ntap)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of bytes in line header=',lbytes
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' luin               =  ', luin
            write(LERR,*) ' luout1             =  ', luout1
            write(LERR,*) ' luout2             =  ', luout2
            write(LERR,*) ' input data set name =  ', ntap(1:ln)
            write(LERR,*) ' ns (starting trace)    =  ',ns
            write(LERR,*) ' ne (ending trace  )    =  ',ne
            write(LERR,*) ' rs (starting record)   =  ',rs
            write(LERR,*) ' re (ending record)     =  ',re
            write(LERR,*) ' verbose output         =  ',verbos
            write(LERR,*)' '
      return
      end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end

