C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine filtinit(mutemin,mutemax,nt,dt,
     1                    f1,f2,f3,f4,df,nf,lerr,verbose, 
     2                    twgt,fwgt,fwgtr,fwgti)
C
      parameter(pi=3.14159265358)
      real      twgt(mutemin:mutemax)
      real      fwgt(0:nf-1),fwgtr(0:nf-1),fwgti(0:nf-1)
      complex   const,ci
      logical   verbose
      data      ci/(0.,1.)/
c_____________________________________________________________________
C     calculate mute tapers.       
c     t1,t2,t3 and t4 are measured in samples.
c_____________________________________________________________________
      t1=mutemin
      t2=mutemax
      t3=mutemax
      t4=mutemax
      call gttapr(twgt,t1,t2,t3,t4,1.,mutemin,mutemax)
c_____________________________________________________________________
c     calculate frequency tapers
c_____________________________________________________________________
      call gttapr(fwgt,f1,f2,f3,f4,df,0,nf-1)
c_____________________________________________________________________
c
c     calculate frequency filters based on 
c     Bleistein, Cohen and Hagin (1987) GEOPHYSiCS, eqn 63.
c
C     specifically, calculate sqrt(-i*omega)*f(omega)
c
c     where omega is the radial frequency
c     i is the sqrt(-1.)
c     f(omega) is the source wavelet or bandwidth.
C_______________________________________________________________________
      do 5000 ifreq=0,nf-1
       omega=2.*pi*ifreq*df
       const=sqrt(-ci*omega)
       fwgtr(ifreq)=real(const)*fwgt(ifreq)
       fwgti(ifreq)=aimag(const)*fwgt(ifreq)
5000  continue
      if(verbose) then
         write(lerr,'(5a12)') 'jf','freq','fwgt','fwgtr','fwgti'      
         write(lerr,'(i12,4e12.3)') (jf,jf*df,fwgt(jf),
     1                 fwgtr(jf),fwgti(jf),jf=1,nf-1)
         write(lerr,'(2a12)') 'jt','twt'      
         write(lerr,'(i12,f12.4)')
     1      (jt+nt-1,twgt(jt),jt=mutemin,mutemax)
      endif
c
      return
      end
