C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount(lupick,Npicks)

c
c ----- routine to count total number of picks -----
c       in pick file.  Expects xsd pick format
c

#include <f77/iounit.h>

      integer lupick,Npicks,nrec,ntrc,nsegs

      real rec_units,trc_units,samp_units

      character junk*1

c
c ----- initialize variables -----
c

      Npicks = 0
      nsegs = 1

c
c ----- read file header -----
c

      read(lupick,'(a1,4x,3f13.7,2x,2i7)',end=900)junk,rec_units,
     :     trc_units,samp_units,nrec,ntrc

      if(junk.ne."U")then
         write(LERR,*)' '
         write(LERR,*)' FATAL ........................'
         write(LERR,*)' Something fishy with pick file'
         write(LERR,*)' first line does not start with Units'
         write(LERR,*)' Fix this and rerun'
         write(LERR,*)' '
         stop
      endif

c
c ----- check first segment for format -----
c

      read(lupick,'(a1)',end=900)junk

      if(junk.ne."S")then
         write(LERR,*)' '
         write(LERR,*)' FATAL ........................'
         write(LERR,*)' Something fishy with pick file'
         write(LERR,*)' second line does not start with Segment'
         write(LERR,*)' Fix this and rerun'
         write(LERR,*)' '
         stop

      endif

c
c ----- determine number of picks -----
c

 10   read(lupick,'(a1)',end=910)junk
      
      if(junk.ne."S")then

         Npicks = Npicks + 1

      endif

      goto 10

 900  continue

      write(LERR,*)'FATAL .........'
      write(LERR,*)'No entries found in pick file'
      stop

 910  continue

      write(LERR,*)' '
      write(LERR,*)'EOF on pick file after ',Npicks,' picks'
      write(LERR,*)' '

      return
      end
