C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPick(lupick,record,trace,pick,Npicks)

c
c ----- genereic pick reader for xsd pick files -----
c       returns arrays of record,trace and pick 
c       each with Npicks entries.
c 

#include <f77/iounit.h>

      integer lupick,Npicks
      integer nsegs,index(5000,1),nelem,pointer

      real record(*),trace(*),pick(*)
      real rec_units,trc_units,samp_units

      character junk*1

c
c ----- initialize counters -----
c
      
      Npicks = 1
      nelem = 0
      nsegs = 1
      pointer = 0

c
c ----- rewind pickfile -----
c

      rewind lupick

c
c ----- read file header -----
c

      read(lupick,'(a1,4x,3f13.7)')junk,rec_units,trc_units,samp_units

c 
c ----- read segment header -----
c

      read(lupick,'(a1)',end=900)junk

c
c ----- read first segment -----
c

 1    read(lupick,'(a1)',end=20)junk

      if(junk.ne.'S') then

         nelem = nelem + 1
         goto 1

      else

         index(nsegs,1) = nelem

         write(LERR,*) ' segment number : ', nsegs 
         write(LERR,*) ' number of elements : ', nelem 

c
c -----	advance segment register and reset element counter -----
c

         nsegs = nsegs + 1
  
         nelem = 0

c
c ----- start next segment -----
c

         goto 1

      endif

c
c ----- have reached end of pick file -----
c	assign number of elements for last segment
c

 20   index(nsegs,1) = nelem
      
      write(LERR,*) ' segment number : ', nsegs 
      write(LERR,*) ' number of elements : ', nelem 

c
c -----	now know total number of segments -----
c       and number of elements in each
c
	
      rewind lupick

c	
c ----- read and load each segment -----
c	

      read(lupick,'(a1)') ajunk

c	
c ----- SEGMENT LOOP -----
c	

      DO i = 1,nsegs

c
c		
c ----- read past segment header -----
c

         read(lupick,'(a1)') ajunk

c		
c ----- ELEMENT LOOP -----
c

         do 30 j = 1,index(i,1)

            read(lupick,*,end=900)record(Npicks),trace(Npicks),
     :           pick(Npicks)

c
c ----- guard against reverse and duplicate entries -----
c

            if(j.gt.1)then

               if(record(Npicks).le.record(Npicks-1).and.trace(Npicks)
     :              .le.trace(Npicks-1))then

              write(LERR,*)'WARNING: Duplicate or reverse order picks '
              write(LERR,*)'         in pick file.  Picks involved are:'
              write(LERR,*)' '
              write(LERR,*)'Record = ',record(Npicks-1),' Trace = ',
     :             trace(Npicks-1)
              write(LERR,*)'Record = ',record(Npicks),' Trace = ',
     :             trace(Npicks)
              write(LERR,*)' '
              write(LERR,*)'Last pick has been dropped.'
              write(LERR,*)' '
           
              goto 30

               endif

            endif

c
c ----- advance the array element counter -----
c

            Npicks = Npicks + 1

 30      continue

      ENDDO

 900  continue

      return
      end
 
