C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ------------------------------- killtr ---------------------------
c
c Aug/95 - increased capability of previous options to be able to handle
c          arbitrary indexing schemes.  The one in this routine was meant
c          for sequential data and did not allow for generality: Garossino
c
c June/95 - added option to associate kill file parameters with a given
c           header index or pair of header indices: Garossino
C
C killtr READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and kills the specified trace, putting zeros, and if desired
C putting 30000 in the static header.  Traces to be killed may be 
c specified on the command line or in an attached kill file.

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard usp variables

      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, irs, ire, ns, ne
      integer     luin, lbytes, nbytes, obytes
      integer     argis

      real        tri(SZLNHD)

      character   name*6, ntap*255, otap*255, kfile*255

      logical verbos

c declare program dependant variables using dynamic memory allocation

      integer     errcd1, errcd2, errcd3, abort
      integer     column1, column2, NumEntries

      real        record, trace, pick

      pointer (wkcolumn1, column1(2000000))
      pointer (wkcolumn2, column2(2000000))
      pointer (wkadr_record, record(2000000))
      pointer (wkadr_trace, trace(2000000))
      pointer (wkadr_pick, pick(2000000))

c declare program dependant static variables

      integer DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer RecNum, ifmt_RecNum, l_RecNum, ln_RecNum
      integer TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer HdrWrd1, ifmt_HdrWrd1, l_HdrWrd1, ln_HdrWrd1
      integer HdrWrd2, ifmt_HdrWrd2, l_HdrWrd2, ln_HdrWrd2

      integer  lupick, j, JJ, KK, ic

      real  dismin, dismax

      character   card*80, Wrd1*6, Wrd2*6

      logical dead, pickfile, traces, records, inv, killflag

c initialize variables

      data name /'KILLTR'/
      data luin /1/
      data lbytes /0/
      data nbytes /0/
      data lupick /27/
      data abort /1/
      pickfile = .false.
      killflag = .false.

C get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help()
          stop
      endif

C open printout file

#include <f77/open.h>

C get command line parameters

      call cmdln ( ntap, otap, kfile, ns, ne, irs, ire, dead, pickfile, 
     :     lupick, traces, dismin, dismax, records, inv, Wrd1, Wrd2, 
     :     verbos )

C open I/O data sets & assign logical units

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

C read input line header; save certain parameters; adjust output
C line header; update historical line header

      lbytes=0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'KILLTR: no header read on ',ntap,' unit= ',luin
         write(LERR,*)'Check existence of file & rerun'
         write(LERR,*)'FATAL'
         stop
      endif

      call hlhprt ( itr , lbytes, name, 6, LERR )
 
#include <f77/saveh.h>

      if ( nsamp .gt. SZLNHD ) nsamp = SZLNHD

c define formats, pointers and lengths for header entries used in routine

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c define trace header reference indices if requested

      if ( Wrd1 .ne. ' ' )
     :     call savelu(Wrd1,ifmt_HdrWrd1,l_HdrWrd1,ln_HdrWrd1,
     :     TRACEHEADER)
      if ( Wrd2 .ne. ' ' )
     :     call savelu(Wrd2,ifmt_HdrWrd2,l_HdrWrd2,ln_HdrWrd2,
     :     TRACEHEADER)

c define number of output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c echo pertinent information to printout file

      call verbal ( ntap, otap, kfile, nsamp, nsi, ntrc, nrec, iform, 
     :     dead, pickfile, traces, dismin, dismax, records, inv, Wrd1, 
     :     Wrd2, ns, ne, irs, ire, verbos )

c read attached kill file if present

      IF ( kfile(1:1) .ne. ' ') then

c count the number of lines in the attached control kill file

         if ( .not. pickfile ) then
            NumEntries = 0
            do while (1 .eq. 1)
               read (lupick, '(a80)', end = 11) card
               NumEntries = NumEntries + 1
            enddo

 11         rewind lupick
         endif

c dynamic memory allocation of arrays to contain kill file information.  The
c arrays being allocated are a function of the type of kill file being attached.
c if an XSD pickfile is used things are just a little different.

         if ( .not. pickfile .AND. 
     :        .not. traces .AND. 
     :        .not. records ) then

c here we have a flat file containing two entries per line.  It is
c expected that the first entry pertains to record and the second
c to trace.

            call galloc (wkcolumn1, NumEntries * SZSMPD, errcd1, abort)
            call galloc (wkcolumn2, NumEntries * SZSMPD, errcd2, abort)

            if ( errcd1 .ne. 0 .or.
     :           errcd2 .ne. 0 ) then
               write(LERR ,*)' '
               write(LERR ,*)' Unable to allocate memory:'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*)' '
               write(LER ,*)' KILLTR: Unable to allocate memory:'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)' Allocating memory:'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
            endif

c read the control file, since neither record nor trace have been flagged we
c can assume that there will be two indices present in the control file.  If the
c user has intentionally set the first index to a hard zero then set traces 
c to be true.

            do j = 1, NumEntries
               read (lupick, *, end=2) column1(j), column2(j)
            enddo

 2          continue

            if ( column1(1) .eq. 0 ) traces = .true.

         elseif ( .not. pickfile .AND. traces ) then

c since traces has been flagged we can load up hard zeroes in column1[] while
c reading the trace entries into column2[]

            call galloc (wkcolumn1, NumEntries * SZSMPD, errcd1, abort )
            call galloc (wkcolumn2, NumEntries * SZSMPD, errcd2, abort )

            if ( errcd1 .ne. 0 .or.
     :           errcd2 .ne. 0 ) then
               write(LERR ,*)' '
               write(LERR ,*)' Unable to allocate memory:'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*)' '
               write(LER ,*)' KILLTR: Unable to allocate memory:'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)' Allocating memory:'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
            endif

            do j = 1, NumEntries
               read (lupick, *, end=3) column2(j)
               column1(j) = 0
            enddo

 3          continue

         elseif ( .not. pickfile .AND. records ) then

c since records has been flagged we can load up column1[] while assigning
c hard zeroes to column2[]

            call galloc (wkcolumn1, NumEntries * SZSMPD, errcd1, abort )
            call galloc (wkcolumn2, NumEntries * SZSMPD, errcd2, abort )

            if ( errcd1 .ne. 0 .or.
     :           errcd2 .ne. 0 ) then
               write(LERR ,*)' '
               write(LERR ,*)' Unable to allocate memory:'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LERR ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*)' '
               write(LER ,*)' KILLTR: Unable to allocate memory:'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               write(LER ,*) NumEntries * SZSMPD,'  bytes'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)' Allocating memory:'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
               write(LERR,*) NumEntries * SZSMPD,'  bytes'
            endif

c read in record number to be killed 

            do j = 1, NumEntries
               read (lupick, *, end=4) column1(j)
               column2(j) = 0
            enddo

 4          continue

         elseif ( pickfile ) then
            
            call PickCount( lupick, NumEntries )
            
c allocate pick memory

            call galloc( wkadr_record, NumEntries * SZSMPD, errcd1, 
     :           abort )
            call galloc( wkadr_trace, NumEntries * SZSMPD, errcd2, 
     :           abort )
            call galloc( wkadr_pick, NumEntries * SZSMPD, errcd3, 
     :           abort )

            if ( errcd1 .ne. 0 .or. 
     :           errcd2 .ne. 0 .or.
     :           errcd3 .ne. 0 ) then
               write(LERR,*)' '
               write(LERR,*)' Unable to allocate memory:'
               write(LERR,*) 3 * NumEntries * SZSMPD,'  bytes'
               write(LERR,*)' '
               write(LER,*)' '
               write(LER,*)' KILLTR: Unable to allocate memory:'
               write(LER,*) 3 * NumEntries * SZSMPD,'  bytes'
               write(LER,*)' '
               stop
            else
               write(LERR,*)' '
               write(LERR,*)' Allocating memory:'
               write(LERR,*) 3 * NumEntries * SZSMPD,'  bytes'
               write(LERR,*)' '
            endif

c read picks

            call ReadPick( lupick, record, trace, pick, NumEntries) 

         endif
      ENDIF 

c update historical line header & write out output header

      call savhlh ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )
 
      if ( verbos ) then
         write(LERR,*)' '
         write(LERR,*)' Statistics on Kills '
         write(LERR,*)' ------------------- '
         write(LERR,*)' '
      endif

      ic = 1
      DO JJ = 1, nrec
         DO KK = 1, ntrc

c read a trace and load time series to tri() array.
            
            nbytes = 0
            call rtape  ( luin , itr, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

c read required header information from trace header
            
            call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn, DstSgn, 
     :           TRACEHEADER)
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum, RecNum, 
     :           TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum, TrcNum, 
     :           TRACEHEADER)

c read data specific header information if requested by the user

            if ( Wrd1 .ne. ' ' ) call saver2(itr,ifmt_HdrWrd1,l_HdrWrd1, 
     :           ln_HdrWrd1, HdrWrd1, TRACEHEADER)
            if ( Wrd2 .ne. ' ' ) call saver2(itr,ifmt_HdrWrd2,l_HdrWrd2, 
     :           ln_HdrWrd2, HdrWrd2, TRACEHEADER)


            IF ( Wrd1 .ne. ' ' .or. Wrd2 .ne. ' ' ) then

c ------------------------------------------------------------------------------
c HEADER MNEMONIC INDEXING OPTION
c ------------------------------------------------------------------------------

               IF ( kfile(1:1) .eq. ' ') THEN

c ------------------------------------------------------------------------------
c COMMAND LINE CONTROL... we are NOT USING A KILL FILE.  The kill parameters are 
c coming from the command line.  Check if trace qualifies then kill or 
c invert as requested
c using HdrWrd1 [for record index] and HdrWrd2 [for trace index] logic
c in this case the irs, ire, ns, ne parameters actually refer to the information
c contained in the associated header location NOT the sequential record, trace
c numbering
c ------------------------------------------------------------------------------
               
                  IF ( irs .ne. 0 .AND. 
     :                 ire .eq. 0 .AND. 
     :                 ns .ne. 0  .AND. 
     :                 ne .eq. 0 ) THEN

c kill or invert a single trace in a single record [-ns -rs defined]
                  
                     if ( HdrWrd2 .eq. ns .and. HdrWrd1 .eq. irs ) then
                     
                        if (verbos)
     1                       write(LERR,*)' Rec = ',HdrWrd1,' Trc = ',
     2                       HdrWrd2,' Killed or Polarity Reversed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                  
                  ELSEIF (irs .eq. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .ne. 0  .AND.
     :                    ne .eq. 0 ) THEN

c kill or invert a given trace in every record based on trace number
c [-ns defined]
                  
                     if(HdrWrd2 .eq. ns) then
                        if (verbos ) write(LERR,*)' Rec = ',HdrWrd1,
     :                       ' Trc = ',HdrWrd2,'  Killed or Polarity Rev
     :ersed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF( irs .ne. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .eq. 0  .AND.
     :                    ne .eq. 0 ) THEN

c kill or invert all traces of a given record number [-rs defined]
                  
                     if(HdrWrd1 .eq. irs) then
                        if ( verbos ) write(LERR,*)' Rec = ',HdrWrd1,
     1                       ' Trc = ',HdrWrd2,'  Killed or Polarity Rev
     :ersed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                  
                  ELSEIF ( irs .ne. 0 .AND. 
     :                    ire .ne. 0 .AND. 
     :                    ns .eq. 0 .AND.
     :                    ne .eq. 0 ) THEN

c kill or invert a contiguous set of  records, [-rs -re defined] 
c the range of records and traces may be given in increasing or decreasing

                     if ( ire .ge. irs ) then
                        if( HdrWrd1 .ge. irs .AND. HdrWrd1 .le. ire) 
     :                       then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     else
                        if( HdrWrd1 .ge. ire .AND. HdrWrd1 .le. irs) 
     :                       then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or polarity
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     endif
                  
                  ELSEIF ( irs .ne. 0 .AND. 
     :                    ire .ne. 0 .AND. 
     :                    ns .ne. 0 .AND.
     :                    ne .ne. 0 ) THEN
                     
c kill or invert a contiguous set of  traces within a 
c contiguous set of  records.  [ -rs -re -ns -ne]
                  

                     if ( ire .ge. irs .and. ne .ge. ns ) then
                        if( HdrWrd1 .ge. irs .AND. 
     :                       HdrWrd1 .le. ire .AND.
     :                       HdrWrd2 .ge. ns  .AND. 
     :                       HdrWrd2 .le. ne ) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or polarity
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                  elseif ( ire .ge. irs .and. ne .lt. ns ) then
                        if( HdrWrd1 .ge. irs .AND. 
     :                       HdrWrd1 .le. ire .AND.
     :                       HdrWrd2 .ge. ne  .AND. 
     :                       HdrWrd2 .le. ns ) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                  elseif ( ire .lt. irs .and. ne .ge. ns ) then
                        if( HdrWrd1 .ge. ire .AND. 
     :                       HdrWrd1 .le. irs .AND.
     :                       HdrWrd2 .ge. ns  .AND. 
     :                       HdrWrd2 .le. ne ) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                  elseif ( ire .lt. irs .and. ne .lt. ns ) then
                        if( HdrWrd1 .ge. ire .AND. 
     :                       HdrWrd1 .le. irs .AND.
     :                       HdrWrd2 .ge. ne  .AND. 
     :                       HdrWrd2 .le. ns ) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                  endif

                  ELSEIF ( irs .eq. 0 .AND. 
     :                    ire .eq .0 .AND. 
     :                    ns .ne. 0 .AND.
     :                    ne .ne. 0 ) THEN

c kill or invert a contiguous set of  traces within all
c records of the dataset.  
                  
                     if ( ne .ge. ns ) then
                        if(HdrWrd2 .ge. ns .AND. HdrWrd2 .le. ne) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     else
                        if(HdrWrd2 .ge. ne .AND. HdrWrd2 .le. ns) then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     endif
                  
                  ELSEIF ( irs. ne. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .gt. 0 .AND.
     :                    ne .gt. 0 ) THEN
                     
c kill or invert a contiguous set of traces within a single record only

                     if ( ne .ge. ns ) then
                        if( HdrWrd2 .ge. ns .AND. HdrWrd2 .le. ne .AND.
     1                       HdrWrd1 .eq. irs)  then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     else
                        if( HdrWrd2 .ge. ne .AND. HdrWrd2 .le. ns .AND.
     1                       HdrWrd1 .eq. irs)  then
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     endif
                  
                  ENDIF
               
               ELSE
               
c  -------------------------------------------------------------------------
c  KILL FILE CONTROL ... could be either a flat file with one or two columns
c                        described or an XSD pickfile.  Flatfile logic first
c                        followed by XSD pickfile logic.
c  -------------------------------------------------------------------------
               
                  if ( .not. pickfile .AND. 
     :                 .not. traces .AND. 
     :                 .not. records ) then

c must search entire control file for every trace read in.  There is
c no reason to assume that the index being referenced is in any particular
c order.  It may decrement, increment or be random or repeating.
                  

                     call KillCheck(HdrWrd1, HdrWrd2, NumEntries, 
     :                    column1, column2, killflag)

                     if (killflag) then

c kill or invert selected  traces of selected  records                     
                     
                        if ( verbos) write(LERR,*)' Rec = ',HdrWrd1,
     :                       ' Trc = ',HdrWrd2,'  Killed or Polarity rev
     :ersed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                  
                  elseif ( .not. pickfile .AND. traces ) then

c kill or invert selected traces for every record
                  
                     do mm = 1, NumEntries

                        if ( HdrWrd2 .eq. column2(mm) ) then
                    
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     enddo
                  
                  elseif ( .not. pickfile .AND. records ) then

c kill or invert all records specified in killfile

                     do mm = 1, NumEntries
                  
                        if (HdrWrd1 .eq. column1(mm)) then
                     
                           if (verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                          ' Trc = ',HdrWrd2,'  Killed or Polarity 
     :Reversed'
                        
                           if (inv) then
                              do  ii = 1, nsamp
                                 tri (ii) = -tri (ii)
                              enddo
                           else
                              call vclr (tri,1,nsamp)
                              if( dead ) 
     1                             call savew2(itr,ifmt_StaCor,l_StaCor,
     2                             ln_StaCor, 30000, TRACEHEADER)
                           endif
                        endif
                     enddo
                  
                  elseif ( pickfile ) then

c kill or invert selected  records and traces as defined in 
c the attached XSD pickfile. 
                  
                     call XsdKillCheck(HdrWrd1, HdrWrd2, NumEntries, 
     :                    record, trace, killflag)

                     if ( killflag ) then
                     
                        if ( verbos) write(LERR,*)' Rec = ',HdrWrd1,
     1                       ' Trc= ',HdrWrd2,'  Killed or Polarity Reve
     :rsed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                  endif
               ENDIF

            ELSE

c using sequential record and trace logic [normal default killtr mode]
c Here the user has NOT specified Wrd1 or Wrd2 on the command line.

               IF ( kfile(1:1) .eq. ' ') THEN

c ------------------------------------------------------------------------------
c SEQUENTIAL RECORD AND TRACE INDEXING OPTION [the default]
c COMMAND LINE CONTROL... we are NOT USING A KILL FILE.  The kill parameters are 
c coming from the command line.  Check if trace qualifies then kill or 
c invert as requested
c ------------------------------------------------------------------------------
               
                  IF ( irs .ne. 0 .AND. 
     :                 ire .eq. 0 .AND. 
     :                 ns .ne. 0  .AND. 
     :                 ne .eq. 0 ) THEN

c kill or invert a single sequential trace in a single sequential record
                  
                     if ( KK .eq. ns .and. JJ .eq. irs ) then
                     
                        if (verbos)
     1                       write(LERR,*)' Rec = ',JJ,' Trc = ',
     2                       KK,' Killed or Polarity Reversed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF (irs .eq. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .ne. 0  .AND.
     :                    ne .eq. 0 ) THEN
                     
c kill or invert a given trace in every record based on sequential trace number
                  
                     if(KK .eq. ns) then
                        if (verbos ) write(LERR,*)' Rec = ',JJ,
     1                       ' Trc = ',KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF( irs .ne. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .eq. 0  .AND.
     :                    ne .eq. 0 ) THEN
                     
c kill or invert all traces of a given sequential record number
                  
                     if(JJ .eq. irs) then
                        if ( verbos ) write(LERR,*)' Rec = ',JJ,
     1                       ' Trc = ',KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF ( irs .ne. 0 .AND. 
     :                    ire .ne. 0 .AND. 
     :                    ns .eq. 0 .AND.
     :                    ne .eq. 0 ) THEN
                     
c POLICEMAN: in sequential mode this logic does not support irs > ire

                     if ( irs .gt. ire ) then
                        write(LERR,*)' '
                        write(LERR,*)'When using sequential indexing '
                        write(LERR,*)'the start record must be less'
                        write(LERR,*)'than or equal to the end record'
                        write(LERR,*)'FATAL '
                        write(LER,*)' '
                   write(LER,*)'KILLTR: When using sequential indexing '
                   write(LER,*)'        the start record must be less'
                   write(LER,*)'        than or equal to the end record'
                   write(LER,*)'FATAL '
                        goto 999
                     endif

c kill or invert a contiguous set of sequential records
                  
                     if( JJ .ge. irs .AND. JJ .le. ire) then
                        if (verbos) write(LERR,*)' Rec = ',JJ,
     1                       ' Trc = ',KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF ( irs .ne. 0 .AND. 
     :                    ire .ne. 0 .AND. 
     :                    ns .ne. 0 .AND.
     :                    ne .ne. 0 ) THEN

c kill or invert a contiguous set of sequential traces within a 
c contiguous set of sequential records
                  
                     if ( irs .gt. ire ) then
                        write(LERR,*)' '
                        write(LERR,*)'When using sequential indexing '
                        write(LERR,*)'the start record must be less'
                        write(LERR,*)'than or equal to the end record'
                        write(LERR,*)'FATAL '
                        write(LER,*)' '
                   write(LER,*)'KILLTR: When using sequential indexing '
                   write(LER,*)'        the start record must be less'
                   write(LER,*)'        than or equal to the end record'
                   write(LER,*)'FATAL '
                        goto 999
                     endif

                     if ( ns .gt. ne ) then
                        write(LERR,*)' '
                        write(LERR,*)'When using sequential indexing '
                        write(LERR,*)'the start trace must be less'
                        write(LERR,*)'than or equal to the end trace'
                        write(LERR,*)'FATAL '
                        write(LER,*)' '
                   write(LER,*)'KILLTR: When using sequential indexing '
                   write(LER,*)'        the start trace must be less'
                   write(LER,*)'        than or equal to the end trace'
                   write(LER,*)'FATAL '
                        goto 999
                     endif

                     if(JJ .ge. irs .AND. JJ .le. ire .AND.
     1                    KK .ge. ns  .AND. KK .le. ne       ) then
                        if (verbos) write(LERR,*)' Rec = ',JJ,' Trc = ',
     1                       KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF ( irs .eq. 0 .AND. 
     :                    ire .eq .0 .AND. 
     :                    ns .ne. 0 .AND.
     :                    ne .ne. 0 ) THEN
                     
c kill or invert a contiguous set of sequential traces within all
c records of the dataset
                  
                     if ( ns .gt. ne ) then
                        write(LERR,*)' '
                        write(LERR,*)'When using sequential indexing '
                        write(LERR,*)'the start trace must be less'
                        write(LERR,*)'than or equal to the end trace'
                        write(LERR,*)'FATAL '
                        write(LER,*)' '
                   write(LER,*)'KILLTR: When using sequential indexing '
                   write(LER,*)'        the start trace must be less'
                   write(LER,*)'        than or equal to the end trace'
                   write(LER,*)'FATAL '
                        goto 999
                     endif

                     if(KK .ge. ns .AND. KK .le. ne) then
                        if (verbos) write(LERR,*)' Rec = ',JJ,' Trc = ',
     1                       KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ELSEIF ( irs. ne. 0 .AND. 
     :                    ire .eq. 0 .AND. 
     :                    ns .gt. 0 .AND.
     :                    ne .gt. 0 ) THEN
                     
c kill or invert a contiguous set of traces within a single record only
                  
                     if ( ns .gt. ne ) then
                        write(LERR,*)' '
                        write(LERR,*)'When using sequential indexing '
                        write(LERR,*)'the start trace must be less'
                        write(LERR,*)'than or equal to the end trace'
                        write(LERR,*)'FATAL '
                        write(LER,*)' '
                   write(LER,*)'KILLTR: When using sequential indexing '
                   write(LER,*)'        the start trace must be less'
                   write(LER,*)'        than or equal to the end trace'
                   write(LER,*)'FATAL '
                        goto 999
                     endif

                     if(KK .ge. ns .AND. KK .le. ne .AND.
     1                    JJ .eq. irs)  then
                        if (verbos) write(LERR,*)' Rec = ',JJ,' Trc = ',
     1                       KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                     endif
                     
                  ENDIF
               
               ELSE
               
c  -------------------------------------------------------------------------
c  KILL FILE CONTROL ... could be either a flat file with one or two columns
c                        described or an XSD pickfile.  Flatfile logic first
c                        followed by XSD pickfile logic.
c  -------------------------------------------------------------------------
               
                  if ( .not. pickfile .AND. 
     :                 .not. traces .AND. 
     :                 .not. records ) then
                     
                     if (JJ .eq. column1(ic) .AND. KK .eq. column2(ic)) 
     :                    then

c kill or invert selected sequential traces of selected sequential records                     
                     
                        if ( verbos) write(LERR,*)' Rec = ',JJ,
     :                       ' Trc = ',KK,' Killed or Polarity Reversed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                        ic = ic + 1
                        
                     endif
                     
                  elseif ( .not. pickfile .AND. traces ) then
                     
c kill or invert selected sequential traces of all records
                     
                     if (KK .eq. 1) ic = 1
                     if (KK .eq. column2(ic)) then
                        
                        if (verbos) write(LERR,*)' Rec = ',JJ,' Trc = ',
     1                       KK,' Killed or Polarity Reversed'
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                        ic = ic + 1
                        
                     endif
                  
                  elseif ( .not. pickfile .AND. records ) then

c kill or invert selected sequential records
                  
                     if (JJ .eq. column1(ic)) then
                     
                        if (verbos) write(LERR,*)' Rec = ',JJ,' Trc = ',
     1                       KK,' Killed or Polarity Reversed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                        if (KK .eq. ntrc) ic = ic + 1
                        
                     endif
                     
                     
                  elseif ( pickfile ) then

c kill or invert selected sequential records and traces as defined in 
c the attached XSD pickfile
                     
                     if ( JJ .eq. record(ic) .and. 
     :                    KK .eq. trace(ic) ) then
                        
                        if ( verbos) write(LERR,*)' Rec = ',JJ,' Trc= ',
     1                       KK,' Killed or Polarity Reversed'
                        
                        if (inv) then
                           do  ii = 1, nsamp
                              tri (ii) = -tri (ii)
                           enddo
                        else
                           call vclr (tri,1,nsamp)
                           if( dead ) 
     1                          call savew2(itr,ifmt_StaCor,l_StaCor,
     2                          ln_StaCor, 30000, TRACEHEADER)
                        endif
                        ic = ic + 1
                        
                     endif
                  endif
               ENDIF
            ENDIF
            
c kill or invert traces whose signed trace distance falls inside the 
c selected range regardless of indexing scheme requested [header or sequential]

            if ( DstSgn .gt. dismin .AND. 
     :           DstSgn .lt. dismax) then

               if ( verbos ) write(LERR,*)' Rec = ',JJ,' Trc= ',
     1                    KK,' Killed or Polarity Reversed'

               if (inv) then
                  do  ii = 1, nsamp
                     tri (ii) = -tri (ii)
                  enddo
               else
                  call vclr (tri, 1, nsamp)
                  if( dead ) 
     1                 call savew2(itr,ifmt_StaCor,l_StaCor,
     2                 ln_StaCor, 30000, TRACEHEADER)
               endif
            endif
            
            call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )
            call wrtape ( luout, itr, obytes )

         ENDDO
      ENDDO

c Normal Termination, close open files and exit

      call lbclos(luin)
      call lbclos(luout)
      if ( kfile(1:1) .ne. ' ') close(lupick)
      
      write(LERR,*)' '
      write(LERR,*)' Normal Termination'
      write(LER,*)'killtr:  Normal Termination'
      stop

 999  continue

c Abnormal Termination, close any open files and exit

      call lbclos(luin)
      call lbclos(luout)
      if ( kfile(1:1) .ne. ' ') close(lupick)
      
      write(LERR,*)' '
      write(LERR,*)' Abnormal Termination'
      write(LER,*)'killtr:  Abnormal Termination'
      stop

      END

