C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c 
c

c     Program Changes:

c      - original written: October 13, 1999

c     Program Description:

c      - read las format data, convert a user defined column to usp format

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsampo, nsi, ntrc, nrec
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, argis

      character   ntap*255, otap*255, name*7

      logical     verbos

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    las_data

      pointer ( mem_las_data, las_data(1))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer column, LinesInHeader

c Initialize variables

      data abort/0/
      data name/"LAS2USP"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ist, iend, nsi, column, name, 
     :     LinesInHeader, verbos )

c open input and output files

      if ( ntap .ne. ' ' ) then
         call alloclun(luin)
         length = lenth(ntap)
         open(unit=luin, file=ntap(1:length), status='old', 
     :        iostat=ierr )
         if ( ierr .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'LAS2USP: Could not open input file ',
     :           ntap(1:length)
            write(LERR,*)'       Check existance and rerun '
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'LAS2USP: Could not open input file ',
     :           ntap(1:length)
            write(LER,*)'       Check existance and rerun '
            write(LER,*)'FATAL'
            stop
         endif
      else
            write(LERR,*)' '
            write(LERR,*)'LAS2USP: Input file cannot be a pipe'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'LAS2USP: Input file cannot be a pipe'
            write(LER,*)'FATAL'
            stop
      endif

      call getln(luout, otap,'w', 1)

c  form output USP line header based on input information

      ist = ist / nsi + 1
      if ( ist .eq. 0 ) ist = 1
      iend = iend / nsi + 1
      if ( iend .le. ist ) then
         write(LERR,*)' '
         write(LERR,*)' you need to specify a time window for'
         write(LERR,*)' trace generation.  Enter -s[] AND -e[]'
         write(LERR,*)' values on the command line and try again.'
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'LAS2USP: '
         write(LER,*)' you need to specify a time window for'
         write(LER,*)' trace generation.  Enter -s[] AND -e[]'
         write(LER,*)' values on the command line and try again.'
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop
      else
         nsampo = iend - ist + 1
         ntrc = 1
         nrec = 1
         obytes = SZTRHD + SZSMPD * nsampo
      endif

c create an output line header

      
      call savew(itr, 'NumSmp', nsampo, LINHED)
      call savew(itr, 'SmpInt', nsi  , LINHED)
      call savew(itr, 'NumTrc', ntrc , LINHED)
      call savew(itr, 'NumRec', nrec , LINHED)
      call savew(itr, 'Format', 3, LINHED)
      lbytes = HSTOFF
      nbytes = 2 * SZHFWD

      call savew( itr, 'HlhEnt',  0   , LINHED)
      call savew( itr, 'HlhByt', nbytes , LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsampo, nsi, ntrc, nrec, ist, 
     :     iend, LinesInHeader, column, verbos)

c dynamic memory allocation:  

      TraceSize = nsampo 
      call galloc (mem_las_data, TraceSize * SZSMPD, errcd1, 
     :     abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( las_data, 1, TraceSize )

c READ input LAS data

      call ReadLas( las_data, nsampo, luin, LinesInHeader, column )

c Output USP trace

c store required trace header information

      call savew2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     nrec, TRACEHEADER )

      call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     ntrc, TRACEHEADER) 

      call vmov ( las_data, 1, itr(ITHWP1), 1, nsampo )

c write output data

      call wrtape (luout, itr, obytes)
 
c close data files 

      close ( luin )
      call lbclos ( luout )
      write(LERR,*)'las2usp: Normal Termination'
      write(LER,*)'las2usp: Normal Termination'
      stop

 999  continue

      close ( luin )
      call lbclos ( luout )
      write(LERR,*)'las2usp: ABNORMAL Termination'
      write(LER,*)'las2usp: ABNORMAL Termination'
      stop
      end
