C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C**********************************************************************C
C
C     PROGRAM MODULE linespec (lins in data set lable)
C d. bjerstedt
C September 17, 1991.
C     Program does maximum entropy spectral analysis of traces
C      on input tape and send results to X-Y graphable files.
C     Program will also optionally output a Welch FFT analysis to a
C      file with the same name as the X-Y file but with .FFT appended.
C Additional trace number checks and check for zero trace added
C March 10, 1992  d.r.b
C Amplitude spectral root and logarithmic scaling added
C March 11, 1992  d.r.b
C Added trace output option April 14, 1992.
C
C Spectral analysis routines are from Numerical Recipies.
C
C**********************************************************************C
C
C From USP manual by Don Wagoner, 10-31-90, pages 1 and 2.
C SZDTHD bytes in trace header on disk   (256)
C SZTRHD bytes in trace header in pipes  (256)
C LNTRHD samples in trace header         (128)
C SZDVHD size of vanl analysis header on disk in bytes    (2112)
C SZVAHD  "                           in pipe             (2112)
C SZSAMP bytes in floating pt sample   (4)
C SZSMPM max number of trace samples   (8000)
C SZLNHD line file size = (SZTRHD + SZSAMP*MAXSMP)/2      (8320)
C SZSPRD size of spread in channels      (500)
C SZSMPD bytes per sample in pipe   (4)
C HSTOFF count of byte at which hlh starts    (1004)
C SZHFWD bytes in 1/2 word           (2)
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
                                                                         
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
                                                                         
c
      INTEGER  itr1 ( SZLNHD )
      INTEGER  itr2 ( SZLNHD )
cmam  INTEGER * 2 itr1 ( SZLNHD )
cmam  INTEGER * 2 itr2 ( SZLNHD )
      INTEGER     luin1, luout
      REAL        tri1 ( SZSMPM ), wk1( SZSMPM ), wk2( SZSMPM )
      REAL        tri2 ( SZSMPM )
      REAL        p( SZSMPM*2 )
      REAL        w1( SZSMPM*4 ), w2( SZSMPM*2 )
      real        cof( SZSMPM ), wkm( SZSMPM )
      CHARACTER   NAME * 4, ntap1 * 100, graphfile * 100, otap * 100
      CHARACTER   fftoutput * 106
      logical     fft, log, verbos, query
      logical     overlap, str, noprint, print
      integer     argis
      integer     irs,ire,its,ite,mpfl,mpfh
      integer     lbytes1,lbyted1
      integer     specsamp
 
      EQUIVALENCE ( itr1(ITHWP1), tri1(1) )
      EQUIVALENCE ( itr2(ITHWP1), tri2(1) )
cmam  EQUIVALENCE ( itr1(129), tri1(1) )
cmam  EQUIVALENCE ( itr2(129), tri2(1) )
      DATA NAME / 'LINS' /
C
C
c     write(LER,*)
c    :'Starting linespec.'
C
C open report files.
c     write(LER,*) 'Opening report.file                             '
cmam  open(35,file='li.rep.file',form='formatted')
cmam  write(35,10)
cmam   10 format('Report for linespec program:')
C
                                                                         
C#include <f77/pid.h>
                                                                         
                                                                         
c     write(LER,*) 'Checking if help needed.                        '
C
C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
cmam  close(35)
          call help()
          stop
      endif
#include <f77/open.h>
c
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
c
c     write(LER,*) 'Calling cmdln.                                  '
      call cmdln(ntap1,otap,graphfile,irs,ire,its,ite,iti,numc,
     :nfreq, mpfl, mpfh, mseg, fft, ipows, log, str, noprint, verbos)
C
      print=.true.
      if(noprint) then
       print=.false.
       write(LERR,*) 'No X-Y grapfh file will be output.'
cmam   write(35,*) 'No X-Y grapfh file will be output.'
      endif
C
      if(mpfl.lt.0) mpfl=0
       if(print) write(LERR,*)
     :		'Print file lowf ', mpfl, ' highf ', mpfh
cmam   if(print) write(35,*) 'Print file lowf ', mpfl, ' highf ', mpfh
C
      if(iti.lt.1) iti=1
      if (verbos) 
     :	write(LERR,9000) nfreq,numc,irs,ire,its,ite,SZSMPM,SZLNHD
cmam  write(35,9000) nfreq,numc,irs,ire,its,ite,SZSMPM,SZLNHD
 9000 format('After cmdln, nfreq,numc,irs,ire,its,ite,SZSMPM,SZLNHD: ',
     :/,8i8)
      if(str) write(LERR,*) 'Spectral output trace file name is: ',
     :		otap
cmam  if(str) write(35,*) 'Spectral output trace file name is: ', otap
c
C**********************************************************************C
C     verbos printout
C**********************************************************************C
cmam     if ( verbos ) then
             write(LERR,*) 'Values read from command line.'
             write(LERR,*) 'Input data   =  ', ntap1
             write(LERR,*) 'Output data  =  ', graphfile
             write(LERR,*) 'Number Coeff =  ', numc
             write(LERR,*) 'Number Freq  =  ', nfreq
             write(LERR,*) 'mseg         =  ', mseg
             write(LERR,*) 'Start record =  ', irs
             write(LERR,*) 'End record   =  ', ire
             write(LERR,*) 'Start trace  =  ', its
             write(LERR,*) 'End trace    =  ', ite
             write(LERR,*) 'Trace inc.   =  ', iti
cmam     end if

C Open FFT file if specified.
      if( fft ) then
C First prefix pspec. to the graph output file using write and read to
C  fixit.file . (A good string facility would be nice.)
      open(39,file='fixit.file',form='formatted')
      write(39,448) graphfile
  448 format('pspec.',a100)
      rewind(39)
      read(39,*) fftoutput
      write(LERR,447) fftoutput
cmam  write(35,447) fftoutput
      if( verbos ) write(LER, 447) fftoutput
  447 format('Fourier power spectrum output file name is: ',a40)
      open(38,file=fftoutput,form='formatted')
      close(39)
      open(9,file='FFTdataspace',form='formatted')
      endif
C
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      if(verbos) write(LERR,*) 'Getting logical unit # for input.  '
      call getln( luin1, ntap1, 'r', 0)
      if(str) call getln( luout, otap , 'w', 0)
C
C Read line header for input data set and save parameters.
      lbytes1 = 0
      if(verbos) write(LERR,*) 'Reading input header.             '
      CALL RTAPE4( luin1, itr1, lbytes1, lbyted1 )
C lbytes is number of bytes read in first record of tape image (header size).
C lbyted is number of bytes header takes on disk in computer being used.
      if(verbos) write(LERR,9074) lbytes1,lbyted1
cmam  write(35,9074) lbytes1,lbyted1
 9074 format('Header read done; lbytes(tape), lbyted(disk) are: ',2i7)
c
      if(lbytes1 .eq. 0) then
         write(LERR,*)'linespec: zero bytes in header on unit ',ntap1
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
C
C Open coefficient output files.
      open(36,file='coeff.file',form='formatted')
C
C Open graph output files.
      if(print) open(34,file=graphfile,form='formatted')
c
C Get input data set parameters.
      if(verbos) write(LER,*) 'Doing saver stuff.               '
      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)
      call saver(itr1, 'Format', iform , LINHED)
      call saver(itr1, 'GrpInt', dx    , LINHED)
c
      if(verbos) write(LERR,9339) ntrc,nsamp,nrec,nsi
cmam  write(35,9339) ntrc,nsamp,nrec,nsi
 9339 format('After saver ntrc,nsamp,nrec,nsi are: ',4i6)
C
cmam     if (verbos) then
             write(LERR,*)
             write(LERR,*) 'Values from Lineheader of input 1:'
             write(LERR,*) 'No. of Records         =  ',nrec
             write(LERR,*) 'No. of Traces per Record =',ntrc
             write(LERR,*) 'No. of Samples per Trace =',nsamp
             write(LERR,*) 'Sample interval          =',nsi
             write(LERR,*) 'Format                   =',iform
cmam     end if
C
      if(nsi.le.0) nsi=1
      if(mpfh.le.0) mpfh=int(500.0/float(nsi))
      if(mpfh.lt.mpfl) mpfl=0
c
C Fix last record and trace if defaulted in command line.
C
C Default ire=0 indicates user wants ire to be last record # of input.
      if(ire.eq.0) ire=nrec
C Default ite=0 indicates user wants ite to be last trace # of input.
      if(ite.eq.0) ite=ntrc
      if((its.gt.ite).or.(its.lt.1)) its=1
C
c This (mrec) is number of records to process and output.
      mrec=ire-irs+1
C
      if(str) then
C Copy input line header to output.
        do 13 ih=1,SZLNHD,1
        itr2(ih)=itr1(ih)
   13   continue
C
C Change line header for output.
C HLHprt changes header by adding NAME, incrementing 3rd argument
C (lbytes1) by length (argument 4) of the string and reports this to
C logical unit given in last argument.
C Note we now have lbytes1=lbytes1+4 (when NAME has length 4 bytes).
        CALL HLHprt( itr2, lbytes1, NAME, 4, LERR)
        if(verbos) write(LERR,9075) NAME,lbytes1
cmam    write(30,9075) NAME,lbytes1
 9075 format('HLHprt done. NAME is: ',a10,' New lbytes(disk) is :',i7)
C
C Save command line in line header ( ihop=1 ).
C savhlh concatenates command line input into line header and returns
C  new size of line header as last argument.
        call savhlh( itr2, lbytes1, lbytnew )
C
        nsamp2=1*nfreq
        ntrc2=(ite-its+1)/iti
        nrec2=mrec
        call savew(itr2, 'NumSmp', nsamp2, LINHED)
        call savew(itr2, 'NumTrc', ntrc2 , LINHED)
        call savew(itr2, 'NumRec', nrec2 , LINHED)
C
        call WRTAPE(luout, itr2, lbytnew )
C
        if(verbos) write(LERR,*) 
     :	'Wrote spectral traces output line header.'
cmam    write(35,*) 'Wrote spectral traces output line header.'
        lbytout=SZTRHD+nsamp2*SZSMPD
        if(verbos) write(LERR,*) 
     :	'bytes in output spectral traces = ', lbytout
cmam    write(35,*) 'bytes in output spectral traces = ', lbytout
      endif
C
      nsample=nsamp
      ntrace=ntrc
C
C Set up variables to be used in power spectrum part.
      if( fft ) then
C Set overlap true as we have pre recorded data.
        overlap=.true.
C
C Find the nearest even power of 2 greater than or equal to the value
C of m input. FFT requires even power of 2 samples.
        if(mseg.lt.8) mseg=8
        mtest=nsamp/mseg
        if(mtest.lt.8)  mseg=nsamp/8
C Number of samples in each subsegment will now be at least 8 and
C  there will be at least 8 subsegments ie at least 4 windows for
C  FFT analysis. Variance will be reduced by at least 4*9/11.
C
C Make sure of an even power of 2 for number of samples in sub segment.
        call evenpow2(mseg, nn)
        if(verbos) write(LERR,7375) mseg,nn
cmam  write(35,7375) mseg,nn
cmam    if( verbos ) write(LER,7375) mseg,nn
 7375 format('Samples in sub segment input: ',i5,' Value used is: ',i5)
        m=nn
C
C Will pass only data needed (ie specsamp samples).
        specsamp=m*(nsamp/m)
        k=specsamp/(4*m)
        if(overlap) then
           write(LERR,9449) k
cmam   write(35,9449) k
 9449 format('overlap is .true. k if overlap is .false. is: ',i7)
           k=((specsamp/m)-1)/2
        endif
        write(LERR,7376) k, specsamp
cmam  write(35,7376) k, specsamp
 7376 format('Number of windows is: ',i5,' Total samples analysed: ',i8)
      endif
C
      if(nsi.lt.1) then
        nsi=1
C Prevents divide by zero if nsi bad in header.
        write(LERR,9125)
cmam  write(35,9125)
        write(LER,9125)
 9125 format('***** Warning: Sample interval changed to 1 .')
      endif
C
C Nyquist frequency of data trace is fnyq.
      fnyq=500.0/float(nsi)
      write(LERR,9120) nsi, fnyq
cmam  write(35,9120) nsi, fnyq
 9120 format('Sample int, Nyquist freq are: ',i5,f10.2)
C
C Make sure at least 2 frequencies calculated to avoid divide by zero
C  when df is calculated.
      if(nfreq.lt.2) nfreq=2
      fstart=0.0
      fend=0.5
C
C Valid fdt for routine evlmem is -0.5 to +0.5 .
C We use range 0.0 to +0.5 corresponding to 0.0 Hz to +ve Nyquist.
      df=(fend-fstart)/float(nfreq-1)
C
      fmpfl=float(mpfl)
      fmpfh=float(mpfh)
C
C**********************************************************************C
C
C     READ TRACES IN, PERFORM ANALYSIS AND WRITE TO GRAPH FILE.
C
C**********************************************************************C
c
      if(verbos) write(LERR,*) 'Begin record reading.             '
C Skip to start record
        call recskp(1,irs-1,luin1,ntrc,itr1)
C
        DO 200 JJ = 1, mrec, 1
C
      if(verbos) write(LERR,3350) jj
cmam  write(35,3350) jj
 3350 format('Working ordinal record number: ',i5)
C
C Skip to 1 trace before first desired trace (number its).
            if(its.gt.1)  call trcskp(JJ,1,its-1,luin1,ntrc,itr1)
                                                                         
            DO 198 KK = its,ntrc,iti
C Read left over traces if   increment goes over end of record.
       if(KK.gt.ntrc) then
         call trcskp(JJ,1,ntrc,luin1,ntrc,itr1)
       endif
C Test do loop boundary in case compiler does not test this way.
             if(KK.le.ntrc) then
C On subsequent iterations, skip to 1 tr before next desired trace.
       if((KK.gt.its).and.(iti.gt.1))  call trcskp(JJ,1,KK-1,luin1,
     : ntrc,itr1)
C
C Read trace from input 1.
               nbytes = 0
               CALL RTAPE  ( luin1, itr1, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input 1:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
C
      if(str) then
C Zero output trace array.
      do 14 kz=1,nfreq,1
      tri2(kz)=0.0
   14 continue
C
C Copy trace header.
      do 15 ks=1,LNTRHD,1
      itr2(ks)=itr1(ks)
   15 continue
      endif
                                                                         
C Check for zero trace.
      isit=0
      do 909 iszer=1,nsamp,1
      if(tri1(iszer).ne.0.0) isit=1
  909 continue
C
C Warn and write zero trace if  necessary.
      if(isit.eq.0) then
         if(str) CALL WRTAPE  ( luout, itr2, lbytout )
cmam     write(35,*) 'Zero trace found. No analysis.'
         write(LERR,*) 'Zero trace found. No analysis.'
      endif
C
      if((kk.le.ite).and.(isit.eq.1)) then
C Perform analysis.
      call memcof(tri1,nsamp,numc,pm,cof,wk1,wk2,wkm)
C
C Do output.
C Put blank line in graphics files to separate results.
      write(36,410)
      if(print) write(34,410)
      if( fft ) write(38,410)
  410 format('    ')
C
C Report:
      do 400 iout=1,numc,1
C  to graphable coefficient file.
      write(36,420) iout, cof(iout)
      if(verbos) write(LERR,420) iout, cof(iout)
  420 format(i10,f15.4)
C  Put out 1st coef to report file as a check.
      if(iout.eq.1) write(LERR,440) iout, cof(iout)
cmam  if(iout.eq.1) write(35,440) iout, cof(iout)
  440 format('First coefficient ',i10,' is : ',f15.4)
  400 continue
C
C Produce spectra.
C
      do 4400 iout=1,nfreq,1
      fdt=fstart+df*float(iout-1)
      value=evlmem(fdt,cof,numc,pm)
C
c Convert natural frequency (range -0.5 to +0.5) to Hz.
C Factor of 2 used as range of fdt (-0.5 to +0.5) is from -Nyquist
C  to +Nyquist.
      f=fdt*2.0*fnyq
C
C Output to graphable spectrum file.
      if(value.gt.0.0) then
      if(ipows.gt.0) value=value**(1.0/float(ipows))
      endif
      if(log) value=log10(value+0.1)
      if((f.ge.fmpfl).and.(f.le.fmpfh)) then
         if(print) write(34,4420) f, value
      endif
      tri2(iout)=value
 4420 format(2f15.4)
 4400 continue
C
      if(str) CALL WRTAPE  ( luout, itr2, lbytout )
C
C Do Welch FFT power spectra and output if specified.
      if( fft ) then
C
C Calculate power spectrum via Welch (see Childers) method.
C
C Put data out to data space used by power spectrum routine spctrm.
      rewind(9)
      do 553 jout=1,specsamp,1
      write(9,8361) tri1(jout)
 8361 format(f15.7)
  553 continue
      rewind(9)
C
      mpass=m
      call spctrm(p,mpass,k,overlap,w1,w2)
C On return, p(j) will be an array of m elements containing the
C  power spectrom between 0.0 Hz and Nyquist frequency. The frequency
C  for index j is (j-1)/(2*m) Hz.
C
C Write (via loop) amplitude spectra
      do 539 kloop=1,m,1
C Calculate current frequency. This is correct as 2 sub segments with
C  total of 2*m samples are analysed in each FFT.
      fis=fnyq*float(kloop-1)/float(m)
      value=p(kloop)
      if(value.gt.0.0) then
      if(ipows.gt.0) value=p(kloop)**(1.0/float(ipows))
      endif
      if(log) value=log10(p(kloop)+0.1)
      write(38,4420) fis, value
  539 continue
                                                                         
      endif
C End Welsh FFT part.
C
cmam  write(35,9004) kk
      if(verbos) write(LERR,9004) kk
 9004 format(' Finished for trace: ',i5)
C
      endif
      endif
C end trace_number less than or = to ntrc if then.
C
  198 CONTINUE
C End trace loop.
C
C Force skip to last trace this record.
      if(ite.lt.ntrc)  call trcskp(JJ,1,ntrc,luin1,ntrc,itr1)
C
  200 continue
C End record loop.
C
  999 continue
C Branch point for null trace.
c
      if(print) write(LERR,460) graphfile
cmam  if(print) write(35,460) graphfile
C
      call lbclos ( luin1 )
      if(str) call lbclos ( luout )
C
      if(verbos) write(LERR,*) 'Closing logical units.             '
      if(print) close(34)
cmam  close(35)
      close(36)
      close(37)
      if( fft ) then
       close(38)
       close(9)
      endif
      if(print) write(LER,460) graphfile
      if(print) write(LERR,460) graphfile
  460 format('See file ',a50,/,'for X-Y spectra results.')
      write(LER,*) 'Program linespec finished.                    '
C
      stop
      END

c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine help
                                                                         
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
         write(LER,*)
         write(LER,*)
     :'Program linespec: MEM (Maximum Entropy Method) spectra with'
         write(LER,*)
     :'                   an optional Welch FFT spectral analysis.'
         write(LER,*)
     :'                   Optional output of MEM spectra as traces.'
         write(LER,*)
         write(LER,*)
     :'SUGGESTION: For best results, input job constant GASP data.'
         write(LER,*)
         write(LER,*)
     :'Run this program by typing: linespec and following arguments'
         write(LER,*)
         write(LER,*)
     :' -N [ntap1]     (no default)         : Input data file name'
         write(LER,*)
     :' -O [ntap1]     (spectraces)         : Output spectral traces'
         write(LER,*)
     :'                                       data set name.'
         write(LER,*)
     :' -S [str]       (flag)               : Create spectral traces.'
         write(LER,*)
     :' -G [graphfile] (default graph.out)  : Output X-Y graph file.'
         write(LER,*)
     :' -rs [irs]      (default 1)          : First rec # to use.'
         write(LER,*)
     :' -re [ire]      (default last rec)   : Last rec # to use.'
         write(LER,*)
     :' -ts [its]      (default 1)          : First trace # to analyse'
         write(LER,*)
     :' -te [ite]      (default last trace) : Last trace # to analyse.'
         write(LER,*)
     :' -ti [iti]      (default 1)          : Trace analysis increment.'
         write(LER,*)
     :' -M [numc]      (default 64)     : Order of MEM approximation.'
         write(LER,*)
     :' -F [nfreq]     (default 1001)   : Desired number of frequencies'
         write(LER,*)
     :'                   to occur between 0.0 and Nyquist (inclusive).'
         write(LER,*)
     :'                   Note: used only for Maximum Entropy spectra.'
         write(LER,*)
         write(LER,*)
     :' -fft  This optional flag will produce an additional graph file'
         write(LER,*)
     :'         containing a Welch FFT power spectrum. The name of this'
         write(LER,*)
     :'         file is pspec.graphfile (graphfile input with -G).'
         write(LER,*)
     :' -root [ipows]     (default 0)    : If not 0, takes ipow root of'
         write(LER,*)
     :'                                    spectral amplitude values.'
         write(LER,*)
     :'                                    Must be integer.'
         write(LER,*)
     :' -log  This optional flag will produce logarithmic scaling of'
         write(LER,*)
     :'        amplitudes in output spectra (applied after root if any'
         write(LER,*)
     :'        taken). Note 0.1 added to amplitude before log taken.'
         write(LER,*)
         write(LER,*)
     :' -m[mseg]   (default 128) : Half the number of samples in each '
         write(LER,*)
     :'                 Welch FFT window. Should be integer power of 2.'
         write(LER,*)
     :'                  (mseg is also the number of FFT frequecies you'
         write(LER,*)
     :'                  get between 0.0 Hz and the Nyquist frequency.)'
         write(LER,*)
     :' -gfl[mpfl]      (default 0)   : Lowest frequency, graph file.'
         write(LER,*)
     :' -gfh[mpfh]  (default Nyquist) : Highest frequency, graph file.'
         write(LER,*)
         write(LER,*)
     :' -V       This optional flag will cause verbos screen reporting.'
         write(LER,*)
     :' -nop     This optional flag prevents MEM X-Y graph file output.'
         write(LER,*)
         write(LER,*)
     :'Usage: linespec -N[ntap1] -O[otap] -S '
         write(LER,*)
     :'  -G[graphfile] -rs[start_rec_#] -re[end_rec_#] '
         write(LER,*)
     :'  -ts[start_trace_#] -te[end_tr_#] -ti[trace_inc] '
         write(LER,*)
     :' -M[number_of_MEM_coefficients] -F[#_of_MEM_frequencies] -fft '
         write(LER,*)
     :' -m[samples_in_half_FFT_window] -log -root[integer] -V -nop'
         write(LER,*)
     :' -gfl[graph_lowest_frequency] -gfh[graph_highest_frequency] '
         write(LER,*)
         write(LER,*)
     :' NOTE: It is risky not to job constant scale the input data (use'
         write(LER,*)
     :'  USP GASP job constant defaults parameters). Otherwise, numer-'
         write(LER,*)
     :'  ical exceptions will often occur and produce bad output files.'
         write(LER,*)
         write(LER,*)
     :'***************************************************************'
c
      return
      end
c
c-----
c     get command arguments
c
c     ntap1      - C*100  input  file name.
c     otap       - C*100  output file name (spectral traces).
c     graphfile  - C*100  X-Y graph file output name.
C     str        - L      output traces (spectra) 0r not.
C     verbos     - L      verbose output or not.
C     fft        - L      fft output file or not.
C     log        - L      logarithmic (base 10) amplitude scale or not
C     ipows      - I      integer root for amplitude scaling
C     irs        - I      first record to process.
C     ire        - I      last record to process.
C     its        - I      first trace to analyse.
C     ite        - I      last trace to analyse.
C     numc       - I      desired order of MEM approximation.
C     mseg       - I      desired number of samples in sub segment.
C     nfreq      - I      desired number of frequencies.
C     mpfl        -I      lowest frequency permitted in print file.
C     mpfh        -I      highest frequency permitted in print file.
c-----
      subroutine cmdln(ntap1,otap,graphfile,irs,ire,its,ite,iti,numc,
     :nfreq, mpfl, mpfh, mseg, fft, ipows, log, str, noprint, verbos)
                                                                         
#include <f77/iounit.h>
                                                                         
      character   ntap1*(*), otap*(*), graphfile*(*)
      integer     argis
      integer     irs, ire, its, ite, iti, numc, nfreq, mseg,ipows
      integer     mpfl, mpfh
      logical     verbos, fft, log, str, noprint
c
         call argstr ( '-N', ntap1, ' ', ' ' )
         call argstr ( '-O', otap , ' ', ' ')
cmam     call argstr ( '-O', otap , 'spectraces', 'spectraces')
         call argstr ( '-G', graphfile, 'graph.out', 'graph.out' )
         call argi4  ( '-rs', irs  , 1, 1 )
         call argi4  ( '-re', ire  , 0, 0 )
C Note program must make ire=last rec if default used.
         call argi4  ( '-gfl', mpfl  , 0, 0 )
         call argi4  ( '-gfh', mpfh  , 0, 0 )
C Note program must make mpfh=Nyquist if default used.
         call argi4  ( '-ts', its  , 1, 1 )
         call argi4  ( '-te', ite  , 0, 0 )
         call argi4  ( '-ti', iti  , 1, 1 )
         call argi4  ( '-root', ipows, 0, 0 )
C Note program must make ite=last trace if default used.
         call argi4  ( '-M' , numc  , 64, 64 )
         call argi4  ( '-m' , mseg  , 128,   128 )
         call argi4  ( '-F' , nfreq , 1001, 1001 )
C
         verbos = ( argis ( '-V' ) .gt. 0 )
         fft    = ( argis ( '-fft' ) .gt. 0 )
         log    = ( argis ( '-log' ) .gt. 0 )
         str    = ( argis ( '-S' ) .gt. 0 )
         noprint= ( argis ( '-nop' ) .gt. 0 )
c
      return
      end
C
C --------------------------------------------------------------------
      subroutine evenpow2(nsample, nn)
      integer nsample, nn
C FFT routines in general require an even power of 2 for number of
C  samples. Routine finds nn, the nearest even power of 2 greater than
C  or equal to nsample.
      ipow2=ifix(log(float(nsample))/log(2.0))
      i2samp=2**ipow2
      i4samp=i2samp
      if(i2samp.lt.nsample) i4samp=2*i2samp
C     write(30,9090) i4samp
 9090 format('Nearest (greater than or equal) even power of 2 is:',i6)
      nn=i4samp
      return
      end
C
C -------------------------------------------------------------------
C
      SUBROUTINE MEMCOF(DATA,N,M,PM,COF,WK1,WK2,WKM)                            
                                                                         
#include <f77/iounit.h>
                                                                         
      DIMENSION DATA(N),COF(M),WK1(N),WK2(N),WKM(M)                             
      P=0.                                                                      
      DO 11 J=1,N                                                               
        P=P+DATA(J)**2                                                          
11    CONTINUE                                                                  
      PM=P/N                                                                    
      WK1(1)=DATA(1)                                                            
      WK2(N-1)=DATA(N)                                                          
      DO 12 J=2,N-1                                                             
        WK1(J)=DATA(J)                                                          
        WK2(J-1)=DATA(J)                                                        
12    CONTINUE                                                                  
      DO 17 K=1,M                                                               
        PNEUM=0.                                                                
        DENOM=0.                                                                
        DO 13 J=1,N-K                                                           
          PNEUM=PNEUM+WK1(J)*WK2(J)                                             
          DENOM=DENOM+WK1(J)**2+WK2(J)**2                                       
13      CONTINUE                                                                
        COF(K)=2.*PNEUM/DENOM                                                   
        PM=PM*(1.-COF(K)**2)                                                    
        IF(K.NE.1)THEN                                                          
          DO 14 I=1,K-1                                                         
            COF(I)=WKM(I)-COF(K)*WKM(K-I)                                       
14        CONTINUE                                                              
        ENDIF                                                                   
        IF(K.EQ.M)RETURN                                                        
        DO 15 I=1,K                                                             
          WKM(I)=COF(I)                                                         
15      CONTINUE                                                                
        DO 16 J=1,N-K-1                                                         
          WK1(J)=WK1(J)-WKM(K)*WK2(J)                                           
          WK2(J)=WK2(J+1)-WKM(K)*WK1(J+1)                                       
16      CONTINUE                                                                
17    CONTINUE                                                                  
c     PAUSE 'PROBLEM: Should never get here! Subroutine memcof.'
      write(LER,*) 'PROBLEM: Should never get here! Subroutine memcof.'
      write(LERR,*)'PROBLEM: Should never get here! Subroutine memcof.'
      END                                                                       
C
C ----------------------------------------------------------------
      FUNCTION EVLMEM(FDT,COF,M,PM)                                             
      DIMENSION COF(M)                                                          
      DOUBLE PRECISION WR,WI,WPR,WPI,WTEMP,THETA
      THETA=6.28318530717959D0*FDT                                              
      WPR=DCOS(THETA)                                                           
      WPI=DSIN(THETA)                                                           
      WR=1.D0                                                                   
      WI=0.D0                                                                   
      SUMR=1.                                                                   
      SUMI=0.                                                                   
      DO 11 I=1,M                                                               
        WTEMP=WR                                                                
        WR=WR*WPR-WI*WPI                                                        
        WI=WI*WPR+WTEMP*WPI                                                     
        SUMR=SUMR-COF(I)*SNGL(WR)                                               
        SUMI=SUMI-COF(I)*SNGL(WI)                                               
11    CONTINUE                                                                  
      EVLMEM=PM/(SUMR**2+SUMI**2)                                               
      RETURN                                                                    
      END                                                                       
C
C ----------------------------------------------------------------
      SUBROUTINE FOUR1(DATA,NN,ISIGN)                                           
      DOUBLE PRECISION WR,WI,WPR,WPI,WTEMP,THETA
      DIMENSION DATA(*)                                                         
      N=2*NN                                                                    
      J=1                                                                       
      DO 11 I=1,N,2                                                             
        IF(J.GT.I)THEN                                                          
          TEMPR=DATA(J)                                                         
          TEMPI=DATA(J+1)                                                       
          DATA(J)=DATA(I)                                                       
          DATA(J+1)=DATA(I+1)                                                   
          DATA(I)=TEMPR                                                         
          DATA(I+1)=TEMPI                                                       
        ENDIF                                                                   
        M=N/2                                                                   
1       IF ((M.GE.2).AND.(J.GT.M)) THEN                                         
          J=J-M                                                                 
          M=M/2                                                                 
        GO TO 1                                                                 
        ENDIF                                                                   
        J=J+M                                                                   
11    CONTINUE                                                                  
      MMAX=2                                                                    
2     IF (N.GT.MMAX) THEN                                                       
        ISTEP=2*MMAX                                                            
        THETA=6.28318530717959D0/(ISIGN*MMAX)                                   
        WPR=-2.D0*DSIN(0.5D0*THETA)**2                                          
        WPI=DSIN(THETA)                                                         
        WR=1.D0                                                                 
        WI=0.D0                                                                 
        DO 13 M=1,MMAX,2                                                        
          DO 12 I=M,N,ISTEP                                                     
            J=I+MMAX                                                            
            TEMPR=SNGL(WR)*DATA(J)-SNGL(WI)*DATA(J+1)                           
            TEMPI=SNGL(WR)*DATA(J+1)+SNGL(WI)*DATA(J)                           
            DATA(J)=DATA(I)-TEMPR                                               
            DATA(J+1)=DATA(I+1)-TEMPI                                           
            DATA(I)=DATA(I)+TEMPR                                               
            DATA(I+1)=DATA(I+1)+TEMPI                                           
12        CONTINUE                                                              
          WTEMP=WR                                                              
          WR=WR*WPR-WI*WPI+WR                                                   
          WI=WI*WPR+WTEMP*WPI+WI                                                
13      CONTINUE                                                                
        MMAX=ISTEP                                                              
      GO TO 2                                                                   
      ENDIF                                                                     
      RETURN                                                                    
      END                                                                       
C
C ---------------------------------------------------------------------
      SUBROUTINE SPCTRM(P,M,K,OVRLAP,W1,W2)                                     
      LOGICAL OVRLAP                                                            
      DIMENSION P(M),W1(*),W2(M)                                                
      WINDOW(J)=(1.-ABS(((J-1)-FACM)*FACP))                                     
C     WINDOW(J)=1.                                                              
C     WINDOW(J)=(1.-(((J-1)-FACM)*FACP)**2)                                     
      MM=M+M                                                                    
      M4=MM+MM                                                                  
      M44=M4+4                                                                  
      M43=M4+3                                                                  
      DEN=0.                                                                    
      FACM=M-0.5                                                                
      FACP=1./(M+0.5)                                                           
      SUMW=0.                                                                   
      DO 11 J=1,MM                                                              
        SUMW=SUMW+WINDOW(J)**2                                                  
11    CONTINUE                                                                  
      DO 12 J=1,M                                                               
        P(J)=0.                                                                 
12    CONTINUE                                                                  
      IF(OVRLAP)THEN                                                            
        READ (9,*) (W2(J),J=1,M)                                                
      ENDIF                                                                     
      DO 18 KK=1,K                                                              
        DO 15 JOFF=-1,0,1                                                       
          IF (OVRLAP) THEN                                                      
            DO 13 J=1,M                                                         
              W1(JOFF+J+J)=W2(J)                                                
13          CONTINUE                                                            
            READ (9,*) (W2(J),J=1,M)                                            
            JOFFN=JOFF+MM                                                       
            DO 14 J=1,M                                                         
              W1(JOFFN+J+J)=W2(J)                                               
14          CONTINUE                                                            
          ELSE                                                                  
            READ (9,*) (W1(J),J=JOFF+2,M4,2)                                    
          ENDIF                                                                 
15      CONTINUE                                                                
        DO 16 J=1,MM                                                            
          J2=J+J                                                                
          W=WINDOW(J)                                                           
          W1(J2)=W1(J2)*W                                                       
          W1(J2-1)=W1(J2-1)*W                                                   
16      CONTINUE                                                                
        CALL FOUR1(W1,MM,1)                                                     
        P(1)=P(1)+W1(1)**2+W1(2)**2                                             
        DO 17 J=2,M                                                             
          J2=J+J                                                                
          P(J)=P(J)+W1(J2)**2+W1(J2-1)**2                                       
     *        +W1(M44-J2)**2+W1(M43-J2)**2                                      
17      CONTINUE                                                                
        DEN=DEN+SUMW                                                            
18    CONTINUE                                                                  
      DEN=M4*DEN                                                                
      DO 19 J=1,M                                                               
        P(J)=P(J)/DEN                                                           
19    CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       
C
