C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CROSS(A,LA,B,LB,C,NCOUNT,LEAD,LAG)                     WEL35750
                                                                        WEL35760
C     THIS SUBROUTINE WILL CROSS CORRELATE TWO INPUT ARRAYS OF DIFFERINGWEL35770
C     ELEMENT COUNT BY USING AN INPUT LEAD OR LAG.  A LAG, HERE, IS     WEL35780
C     DEFINED AS THE AMOUNT OF NEGATIVE SHIFT (THE SHIFTED ARRAY IS     WEL35790
C     MOVED FORWARD IN TIME) STARTING FROM A ZERO SHIFT POSITION        WEL35800
C     (IE A LAG OF 1 ==> A ZERO SHIFT).  A LEAD IS DEFINED AS A POSITIVEWEL35810
C     SHIFT (THE SHIFTED ARRAY IS MOVED BACKWARD IN TIME) {A LEAD OF 1  WEL35820
C     IS A ZERO SHIFT ALSO}.  LEAD CANNOT BE .GT. LB.  OUTPUT IS AN     WEL35830
C     ARRAY OF INDIVIDUAL CORRELATIONS HAVING AN ELEMENT COUNT OF       WEL35840
C     (LEAD + LAG - 1) EXCEPT WHERE LEAD=0.                             WEL35850
                                                                        WEL35860
C***********************************************************************WEL35870
C*                      GLOSSARY OF VARIABLES                          *WEL35880
C*                                                                     *WEL35890
C* A     -- (I) STATIC INPUT ARRAY                                     *WEL35900
C* LA    -- (I) NUMBER OF ELEMENTS IN "A"                              *WEL35910
C* B     -- (I) SHIFTED INPUT ARRAY                                    *WEL35920
C* LB    -- (I) NUMBER OF ELEMENTS IN "B"                              *WEL35930
C* C     -- (O) OUTPUT ARRAY CONTAINING (LEAD+LAG) CORRELATIONS        *WEL35940
C* NCOUNT-- (O) NUMBER OF ELEMENTS IN "C"                              *WEL35950
C* LEAD  -- (I) AMT OF POSITIVE SHIFT NO GREATER THAN LB               *WEL35960
C* LAG   -- (I) AMT OF NEGATIVE SHIFT WITH A LAG NO GREATER THAN LA    *WEL35970
C***********************************************************************WEL35980
                                                                        WEL35990
      REAL*4 A(*),B(*),C(*)                                             WEL36000
      INTEGER*4 LA,LB,LEAD,LAG,NCOUNT
      LOGICAL CHLEAD                                                    WEL36020
                                                                        WEL36030
C     VALIDATE LEAD                                                     WEL36040
C     ******************************************************************WEL36050
      IF(LEAD.EQ.0)THEN                                                 WEL36060
        CHLEAD=.TRUE.                                                   WEL36070
        LEAD=1                                                          WEL36080
      ELSE                                                              WEL36090
        CHLEAD=.FALSE.                                                  WEL36100
      ENDIF                                                             WEL36110
                                                                        WEL36120
C     CROSS CORRELATE USING THE LEAD                                    WEL36130
C     ******************************************************************WEL36140
      DO 1 J=1,LEAD                                                     WEL36150
        CALL DOTPR(B(LEAD-J+1),1,A,1,C(J),MIN0(LB-LEAD+J,LA))           WEL36160
 1    CONTINUE                                                          WEL36170
                                                                        WEL36180
C     CROSS CORRELATE USING THE LAG                                     WEL36190
C     ******************************************************************WEL36200
      DO 2 J=2,LAG                                                      WEL36210
        CALL DOTPR(A(J),1,B,1,C(J+LEAD-1),MIN0(LB,LA-J+1))              WEL36220
 2    CONTINUE                                                          WEL36230
                                                                        WEL36240
C     CALCULATE THE OUTPUT ELEMENT COUNT                                WEL36250
C     ******************************************************************WEL36260
      IF(LAG.GT.0)THEN                                                  WEL36270
        NCOUNT=(LEAD+LAG)-1                                             WEL36280
      ELSE                                                              WEL36290
        NCOUNT=LEAD                                                     WEL36300
      ENDIF                                                             WEL36310
                                                                        WEL36320
C     RETURN LEAD TO ORIGINAL VALUE IF NEEDED                           WEL36330
C     ******************************************************************WEL36340
      IF(CHLEAD)LEAD=0                                                  WEL36350
                                                                        WEL36360
      RETURN                                                            WEL36370
      END                                                               WEL36380
