C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     program module llxy
c
c**********************************************************************c
c
c llxy reads seismic trace data from an input file,
c converts lat-lon to xy via table lookup, and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD ),imat(3000,2)
      integer     nsamp, nsi, ntrc, nrec, iform,  nbyte
      integer     luin , luout, lbytes, nbytes, lbyout,lbyte
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      real        tri ( SZLNHD )
      character   ntap * 256, otap * 256, name*4,mfile*256
      logical     query, dir
      integer     argis

c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'LLXY'/

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

      call gcmdln(ntap,otap,ns,ne,irs,ire,mfile,dir)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      open (unit=30,file=mfile,form = 'formatted')
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'DAVC: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      call hlhprt (itr, lbytes, name, 4, LERR)
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
      do 2020 i = 1,9999
      	READ (30,'(20x,i5,20x,i8,i8)',end=2030) 
     :		isrc, ieast, inorth
	imat(isrc,1) = ieast/10
	imat(isrc,2) = inorth/10
2020  continue
2030  continue
c-----
c     BEGIN PROCESSING
c     read trace, do agc, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
            do 1001 kk=ns,ne
                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call saver2(itr,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                        ishot , TRACEHEADER)
                  call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        igi   , TRACEHEADER)
                  call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        isi10 , TRACEHEADER)
c  fix si, gi, and di to match shot station coordinate system
		  isiold = isi10/10
		  igiold = igi
		  isi = ishot
		  if (dir ) then
		  	igi = ishot - ( igiold -isiold)
		  else
			igi = ishot + ( igiold -isiold)
		  endif
		  idi = isi + igi
		  isi10 = isi*10
		  isx = imat(ishot,2)
		  isy = imat(ishot,1)
                  iry = imat(igi,1)
                  irx = imat(igi,2)
                  call savew2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                        isx   , TRACEHEADER)
                  call savew2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                        isy   , TRACEHEADER)
                  call savew2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                        irx   , TRACEHEADER)
                  call savew2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                        iry   , TRACEHEADER)
                  call savew2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        isi10 , TRACEHEADER)
                  call savew2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        igi   , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        idi   , TRACEHEADER)
                  call wrtape( luout, itr, nbyte)
 1001             continue
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000       continue
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
         write(LER,*)
     :' PROGRAM TO ADD x,y coordinates to trace headers from table'
         write(LER,*)
     :' llxy searches for consistency between Shot station and SrcLoc'
         write(LER,*)
     :' and forces the source indices and gi"s to conform'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -L [otap]    (no default)      : lat/lon file from data base'
        write(LER,*)
     :'	using format (20x,i5,20x,i8,i8) for shotpt, E & N coords'
        write(LER,*)
     :' -R  ( default=no): SrcSta reverse order; ri"s ascending'
       write(LER,*)
     :' -ns[ns]      (default = first)         : start trace number'
       write(LER,*)
     :' -ne[ne]      (default = last)         : end trace number'
       write(LER,*)
     :' -rs[irs]      (default = first)         : start record number'
       write(LER,*)
     :' -re[ire]      (default = last)         : end record number'
         write(LER,*)
     :'usage:   llxy -N[ntap] -O[otap] -L[mfile]  ',
     :' -ns[ns] -ne[ne] -rs[irs] -re[ire] -R'
         write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,mfile,dir)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     mfile  - c*120    input flat file with lats and long's
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), mfile*(*)
      integer * 4 ns, ne, irs, ire
      logical    verbos, dir
      integer    argis

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-L', mfile, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            verbos = ( argis( '-V' ) .gt. 0 )
            dir    = ( argis( '-R' ) .gt. 0 )

      return
      end

