C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  pickrd (lupik, ntot, lines, sp, shift,
     1                    trc1, sht1, trc2, sht2,padval)

#include <f77/iounit.h>

      real       sp (*), shift (*)
      integer    lupik, lines, ntot, ist(100), ied(100)
      real       x, y, trc1, sht1, trc2, sht2
      character  line*30, flag*1
      logical    on

      dtrc = trc2 - trc1
      itrc = dtrc
      dsht = sht2 - sht1

      lines = 1
      ic = 0
      id = 0
      il = 0
      iseg = 0
c      iseg = 1

      on = .false.

1     continue

      read (lupik, 100, end=1000) line, spi, x, y, shifti, flag
100   format (a30, f10.2, 2f12.2, f12.3, 3x, a1)
          sp (lines) = spi
          shift (lines) = shifti

          if     (shifti .eq. padval .AND.      on) then
                 on = .false.
                 ied(iseg) = lines - itrc
          elseif (shifti .ne. padval .AND. .not.on) then
                 on = .true.
                 iseg = iseg + 1
                 ist(iseg) = lines
          elseif (shifti .ne. padval) then
                 on = .true.
          elseif (shifti .eq. padval .AND. .not.on) then
                 id = id + 1
11               continue
          endif

          ic = ic + 1
          lines = lines + itrc
          go to 1
1000  continue

      if (ied(iseg) .eq. 0) ied(iseg) = lines

          write(LERR,*)' '
          write(LERR,*)'Total picks will be= ',lines
          write(LERR,*)'Total lines in pick file= ',ic
          write(LERR,*)'Total number padded picks= ',id
          write(LERR,*)'Number segments= ',iseg
          write(LERR,*)' '
          ic = lines - 1

      DO  19  J = 1, iseg 

          write(LERR,*)'Live pick segment= ',J,' from ',ist(J),' to ',
     1                  ied(J)

          do  15  is = ist(J), ied(J), itrc

             if (shift(is-itrc) .eq. padval) then
                 tmism = shift(is)
             else
                 tmism = shift(is-itrc)
             endif

             if (shift(is) .eq. padval) then
                 tmisp = tmism
             else
                 tmisp = shift(is)
             endif
c
c ---- this is a test loop installed by pgag who ass-u-mes -----
c      that if you are between picks with pick values of
c      padval that you should put a pick value of padval
c      here.  Hopefully this will do that
c

             if(shift(is-itrc).eq.padval.and.shift(is).eq.padval)then
                tmism = padval
                tmisp = padval
             endif
             

             dshft = (tmisp - tmism)/abs(dtrc)
             dshot = (sp(is) - sp(is-itrc))/abs(dtrc)
             do  10  i = 2, itrc
                 shift (is-itrc+i-1) = tmism + 
     1                                    dshft*(i-1)
                 sp (is-itrc+i-1)    = sp (is-itrc) +
     1                                    dshot*(i-1)

10           continue

15        continue

          is = is - itrc
          ii = 0
          do  16  i = is+1, ied(J)+itrc-1
              ii = ii + 1
              shift (i) = tmisp
              sp (i)    = sp (is) + ii*dshot
16        continue

19    CONTINUE

          write(LERR,*)ic
          write(LERR,*)' '

          if (lines .eq. 0) then
             write(LERR,*)' '
             write(LERR,*)'FATAL HEART ATTACK in program lmpicks:'
             write(LERR,*)'No picks could be read from pick file'
             stop 911
          endif
          if (ic .lt. ntot) then
             write(LERR,*)'WARNING:  fewer picks (',ic,') then input'
             write(LERR,*)'traces on data set (',ntot,')'
             write(LERR,*)'Will duplicate last pick value'
             write(LERR,*)'last SP= ',sp (ic),' dsht= ',dshot
             do  20  i = ic+1, ntot
                 shift (i) = shift (ic)
                 sp (i)    = sp (ic) + 2 * (i - ic ) * dshot
20           continue
          elseif (ic .gt. ntot) then
             write(LERR,*)'WARNING: more picks (',ic,') then input'
             write(LERR,*)'traces on data set (',ntot,')'
             write(LERR,*)'Will truncate picks'
          endif
          write(LERR,*)' '
          write(LERR,*)'pick file reads ended after ',ic,' picks'
          do  50 i = 1, ntot
              if (sp(i) .ne. 0.) then
                 splast = sp(i)
                 ii = 0
              endif
              if (shift(i) .eq. 0. .AND. sp(i) .eq. 0.) then
                 write(LERR,*)'Fixing picks/shifts for line= ',i
                 ii = ii + 1
                 sp(i) = splast + ii*dshot
                 shift(i) = padval
              endif
              write(LERR,*)'pick= ',i,' SP= ',sp(i),'  shift= ',shift(i)
50        continue
          write(LERR,*)' '

          return

      end
