C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine test(cmdforward,cmdbackward,ps,file_in1,file_in2,
     1                file_temp,file_temp2,lerr,lmin,verbose)

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      integer       lerr,lmin
      character*256 file_in1,file_in2,file_temp,file_temp2
      character*700 cmdforward,cmdbackward
      logical       verbose
      real*8        ps

c     Declaration for local variables
      character*512 string
      integer       lengstring
      parameter     (lengstring=512)
      integer       ld_in1,ld_in2,ld_temp2
      integer       ld_cmdforward,ld_cmdbackward,ld_temp,lnst
      real*8        val
c-----------------------------------------------------------------------



c-----------------------------------------------------------------------
c     Define the length of the different file name used
c-----------------------------------------------------------------------
      ld_in1 = lnst(file_in1)
      ld_in2 = lnst(file_in2)
      ld_temp = lnst(file_temp)
      ld_temp2 = lnst(file_temp2)
      ld_cmdforward = lnst(cmdforward)
      ld_cmdbackward = lnst(cmdbackward)


c-----------------------------------------------------------------------
c     Define the command line
c-----------------------------------------------------------------------
      string = 'vmult -N1'//file_in1(1:ld_in1)
     1            //' -N2'//file_in2(1:ld_in2)
     2            //' -O'//file_temp(1:ld_temp)


c-----------------------------------------------------------------------
c     Call system
c-----------------------------------------------------------------------
      call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c     Define the command line
c-----------------------------------------------------------------------
      string = 'lnorm -N'//file_temp(1:ld_temp)
     1            //' -O'//file_temp2(1:ld_temp2)//' -exp1.'


c-----------------------------------------------------------------------
c     Call system
c-----------------------------------------------------------------------
      call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c     Read value in outputfile
c-----------------------------------------------------------------------
      string = file_temp2(1:ld_temp2)
      open(10,file=string,form='formatted')
      read(10,*) val
      close(10)


c-----------------------------------------------------------------------
c     Write result
c-----------------------------------------------------------------------
      write(lerr,*) ' '
      write(lerr,*) 'To verify that: ',
     1              cmdbackward(1:ld_cmdbackward)//' -Ndata -Omodel'
      write(lerr,*) 'is the adjoint of: ',
     1              cmdforward(1:ld_cmdforward)//' -Nmodel -Odata'
      write(lerr,*) 'the two following value should be identical:' 
      write(lerr,*) ps
      write(lerr,*) -val
      write(lerr,*) 'If it is not the case, the convergence of the'
     1             //' conjugate'
      write(lerr,*) 'gradient algorithm is not obvious at all'
      write(lerr,*) ' '

      write(lmin,*) ' '
      write(lmin,*) 'To verify that: ',
     1              cmdbackward(1:ld_cmdbackward)//' -Ndata -Omodel'
      write(lmin,*) 'is the adjoint of: ',
     1              cmdforward(1:ld_cmdforward)//' -Nmodel -Odata'
      write(lmin,*) 'the two following value should be identical:' 
      write(lmin,*) ps
      write(lmin,*) -val
      write(lmin,*) 'If it is not the case, the convergence of the'
     1             //' conjugate'
      write(lmin,*) 'gradient algorithm is not obvious at all'
      write(lmin,*) ' '



      return
      end
