C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                       
C     PROGRAM NAME: MAIP  ( MARINE LINE INDEXING PROGRAM )              
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C          PROGRAM MAIP WAS DESIGNED TO INDEX A MARINE LINE WITH        
C          AS LITTLE CARD INPUT AS POSSIBLE, BUT AT THE SAME TIME       
C          TO BE EXTREMELY FLEXIBLE.  A MARINE LINE CAN BE INDEXED,     
C          CAN RECEIVE FIELD HISTORY, WATER DEPTHS, CABLE DEPTHS,       
C          TRACE STATICS, OR TRACE DISTANCES.                           
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                             02/28/86   J. VINSON                      
C                             CORRECTED CDP CALCULATION TO USE          
C                             ACTUAL SOURCE POSITION RATHER THAN        
C                             SOURCE LABELING POSITION                  
C                             07/08/86   E. JOHNSON                     
C                             ADDED ERROR MESSAGES, ADDED SHOT          
C                             POINTS / MILE IN HEADER.                  
C                             01/08/87   J. VINSON                      
C                             SET STATIC TYPE (HW 75) IN LH TO 2        
C                             USE TR HW 125 AS DEAD TRACE FLAG ONLY     
C                             SET JOB CONSTANT STATIC IN TR HW 15       
C                             SET INIT CORR IN TR HW 7 AND 8            
C                             SET RECP CORR IN TR HW 10 AND 11          
C                             MISC. BUG FIXES - SEE ITEM 86147          
C                             10/13/87   J. VINSON                      
C                             BUG FIX RE CHECK ON NEGATIVE SHOT POINTS  
c
c  September, 2000: pushed array size for traces to 8192 from 1024 for
c                   Bill Felinski.  I know ...a quick fix...but that is 
c                   all I had time for and it worked....
c  Garossino
C                                                                       
C                                                                       
C***********************************************************************

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
C                                                                       
	character*7 crew
	character*8 TJOBID
C                                                                       
      REAL     DIST(8192), WDEPTH(12000), JCSTAT, DSTNCE(2,5000),
     *            BEGIN(8192), FINISH(8192), INCR, RBUF ( 1500 ),
     *            CHARGE, DINKY, SMALL, CONV
C                                                                       
      INTEGER  IHEAD(2 * SZLNHD), RIPSRC, luout, IBLANK,
     *            FCDP, SPNUM1, SPINC, DIERR(50), GIERR(50), luin,
     *            SPSET, ASSIGN, BOUNDS(3,5000), HDRLEN, WATVEL,
     *            MAXWD, MINWD, IREC, MULT, N22, N23, N25, N4,
     *            IDISKC, IDISKW
      character*80 KARD
	integer spbiasfl,spbas,isp1
C

      character   ntap*100, otap*100, cardin*100
	integer	ibuf(2 * SZLNHD),ibflag,metric,imutf
	character * 2 stype
	integer		it0
C                                                                       
      character * 4 MAIP, grpst, name
      character * 1 TITLE(66)
      logical     CONVEN, INDEX, WTRCRD, FELDCD, DSTCRD
	logical     MOOVUP, HISTGR, CBLCRD, MAIP1
	integer argis
C
C added flag (saveperm) to not override PrRcNm and PrTrNm 
C    3/18/97 - jev
C
      logical saveperm
C                                                                       
	equivalence (ibuf(1), rbuf(1), ihead(1))
C                                                                       
      DATA  TITLE/19*' ','M','A','R','I','N','E',' ','L','I','N','E',
     *                   ' ','I','N','D','E','X','I','N','G',' ','P',
     *                   'R','O','G','R','A','M',19*' '/,
     *      DINKY/0.0/, N4/4/, MAIP/'MAIP'/, CHARGE/0.5/, IREC/0/,
     *      MULT/1/, N22/22/, N23/23/, N25/25/, STYPE/' 1'/,
     *      SMALL/99999.0/, MAXWD/-32768/, MAIP1/.FALSE./,
     *      IBLANK/0/, WDEPTH/12000*-99999.99/, CONV /3.280/,
     *      MINWD/2147483647/, METRIC / 0 /, name/'MAIP'/,
     *      IDISKC/13/, IDISKW/11/, imutf/ 1 /, it0/0/
C
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH

cc       check for help flag

      if ( (argis ('-?').gt.0) .or. 
     :	   (argis('-h').gt.0) .or. 
     :	   (argis('-help').gt.0) ) then 
         call help1()
         stop
      endif

C--                                                                     
C---- open printout file
C--                                                                     
#include <f77/open.h>

C--                                                                     
C---- SET INITIAL CONDITIONS...                                         
C--                                                                     
	lcount = 0
      IREADR = 99
      IPRNTR = LERR
      WTRCRD = .FALSE.                                                  
      FELDCD = .FALSE.                                                  
      INDEX  = .TRUE.                                                   
      CONVEN = .FALSE.                                                  
      DSTCRD = .FALSE.                                                  
      MOOVUP = .FALSE.                                                  
      CBLCRD = .FALSE.                                                  
      HISTGR = .TRUE.                                                   
	call move (0, DIERR, 0, 50*SZSMPD)
	call move (0, GIERR, 0, 50*SZSMPD)
C--                                                                     
C---- PRINT BANNER PAGE AND OPEN TAPES...                               
C--                                                                     
      CALL GAMOCO ( TITLE, 1, IPRNTR )                                  
      call argstr ('-N', ntap, ' ', ' ')
      call argstr ('-O', otap, ' ', ' ')
      call argstr ('-C',cardin, ' ', ' ')
C
C added saveperm flag to save permanent rec indec and trc index from 
c       input data set
C
      saveperm = .false.
      saveperm = (argis('-saveperm') .gt. 0)
C
C *------------------------------------------------------------------* C
C *  If ntap specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntap.ne.' ')then
        call getln (luin , ntap, 'r', 0)
      else
        luin = 0
      endif
       if (luin .lt. 0) then
         write (LERR,*) 'Could not open input ',ntap
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If otap specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otap.ne.' ')then
        call getln (luout, otap, 'w', 1)
      else
        luout = 1
      endif



      open (unit = IDISKC, form = 'formatted',
     1      status = 'scratch', access = 'sequential')
      open (unit = IDISKW, form = 'formatted',
     1      status = 'scratch', access = 'sequential')

      if (cardin(1:1) .ne. ' ') then
         open (unit=99, file= cardin, status='old',
     1         form='formatted',access='sequential')
      else
         write(LERR,*)'No card input file name given -- FATAL'
         write(LERR,*)'Use -C[] on command line to input file name'
         stop 911
      endif

C--                                                                     
C---- READ LINE HEADER..                                                
C--                                                                     
      HDRLEN = 0                                                        
      CALL RTAPE ( luin, IHEAD, HDRLEN )                                
      IF ( HDRLEN .NE. 0 ) GO TO 200                                    
C                                                                       
      WRITE(IPRNTR,100)                                                 
  100 FORMAT (/,13X,'** M0000 ** ERROR DETECTED BY PROGRAM MAIN:',      
     *        /,25X,'AN END-OF-FILE WAS ENCOUNTERED ATTEMPTING TO',     
     *        /,25X,'READ THE INPUT DATA SET LINE HEADER.  VERIFY',     
     *        /,25X,'THE INPUT DATA SET NAME AND IN THE CASE OF',       
     *        /,25X,'MULTI-VOLUME DATA SETS, VERIFY THE ORDER IN',      
     *        /,25X,'WHICH THE VOLUMES WERE CATALOGED.',/)              
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
C---- UPDATE HISTORY...                                                 
C--                                                                     
  200 continue
      call savelu('NumTrc',ifmtnt,l_NumTrc,lengnt,LINHED)
      call savelu('NumRec',ifmtnr,l_NumRec,lengnr,LINHED)
      call savelu('JobNum',ifmtjn,l_JobNum,lengjn,LINHED)
      call savelu('SpBiFl',ifmsbf,l_SpBiFl,lensbf,LINHED)
      call savelu('SPBias',ifmspb,l_SPBias,lenspb,LINHED)
      call savelu('FrstSP',ifm1sp,l_FrstSP,len1sp,LINHED)
      call savelu('DpN1SP',ifmdn1,l_DpN1SP,lendn1,LINHED)
      call savelu('NmDpIn',ifmndi,l_NmDpIn,lenndi,LINHED)
      call savelu('WatVel',ifmtwv,l_WatVel,lengwv,LINHED)
      call savelu('GrpInt',ifmtgi,l_GrpInt,lenggi,LINHED)
      call savelu('OpGrFl',ifmogf,l_OpGrFl,lenogf,LINHED)
      call savelu('SrtTyp',ifmtst,l_SrtTyp,lengst,LINHED)
      call savelu('CDPFld',ifmfld,l_CDPFld,lenfld,LINHED)
      call savelu('OrNTRC',ifmont,l_OrNTRC,lenont,LINHED)
      call savelu('OrNREC',ifmonr,l_OrNREC,lenonr,LINHED)
      call savelu('NmSpMi',ifmnsm,l_NmSpMi,lennsm,LINHED)
      call savelu('UnitFl',ifmtuf,l_UnitFl,lenguf,LINHED)
      call savelu('StWdFl',ifmswf,l_StWdFl,lenswf,LINHED)
      call savelu('DptInt',ifmdpi,l_DptInt,lendpi,LINHED)
      call savelu('PltDir',ifmtpd,l_PltDir,lengpd,LINHED)
      call savelu('MutFlg',ifmtmf,l_MutFlg,lengmf,LINHED)
      call savelu('TmMsFS',ifmtm1,l_TmMsFS,lentm1,LINHED)
      call savelu('CrwNam',ifmtcn,l_CrwNam,lengcn,LINHED)
      call saver(ihead, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(ihead, 'UnitSc', unitsc, LINHED)
      endif


      CALL HLHprt ( IHEAD, HDRLEN, MAIP, N4, LERR )
cc    CALL MOVE   ( 1, TJOBID, IHEAD(11), 8 )                           
        call saver2(ihead,ifmtjn,l_JobNum,lengjn,TJOBID,LINHED)
        call saver2(ihead,ifmtnt,l_NumTrc,lengnt,NTRACE,LINHED)
        call saver2(ihead,ifmtnr,l_NumRec,lengnr,nrec,LINHED)
C--                                                                     
C---- GO READ CARD(S)                                                   
C--                                                                     
  300 CALL RDCARD ( KARD, ITYPE, HDRLEN, IFOLD, IBTWN, IPLOT,           
     *      METRIC, IHEAD, WDEPTH, MINWD, MAXWD, MAIP1, NTRACE )        
      IF ( ITYPE .LE. 0 ) GO TO 400                                     
      IF ( ITYPE .LT. 6 ) GO TO 300                                     
C--                                                                     
C---- CHECK INPUT THEN SEE IF INDEXING...                               
C--                                                                     
  400 CALL ERRCHK ( IHEAD, MAIP1 )
      IF ( WTRCRD ) CALL WSTUFF ( WDEPTH )                              
c---------------------------
c  if index is true then we will index the data
c  else we attempt to read previous indexing
c---------------------------
      IF ( INDEX ) GO TO 500                                            
C--                                                                     
C---- ANYTHING SPECIAL FOR HLH ??                                       
C--                                                                     
      IF ( FELDCD )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE FIELD HISTORY',N23,
     *                  LERR)
      IF ( WTRCRD )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE WATER DEPTHS',N22,
     *                  LERR)
      IF ( DSTCRD )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE TRACE DISTANCES',N25,
     *                  LERR)
C--                                                                     
C---- WERE WATR CARDS INPUT ???                                         
C--                                                                     
      IF ( .NOT. WTRCRD ) GO TO 900                                     
C--                                                                     
C---- IF NO INDEXING AND WATER DEPTHS ARE                               
C---- TO BE INPUT, WE NEED SOME INFO TO                                 
C---- PROPERLY ASSIGN A WATER DEPTH                                     
C---- ABOVE A DEPTH POINT....                                           
C--                                                                     
        call saver2(ibuf,ifmsbf,l_SpBiFl,lensbf,spbiasfl,LINHED)
        call saver2(ibuf,ifmspb,l_SPBias,lenspb,spbas,LINHED)
        call saver2(ibuf,ifm1sp,l_FrstSP,len1sp,isp1,LINHED)
C
      CALL GETSP ( spbiasfl, spbas, isp1, IFSORC )
      FSORC = IFSORC                                                    
C     FSORC = IBUF(72)                                                  
c     FCDP  = IBUF(73)                                                  
c     INCR  = IBUF(74)                                                  
        call saver2(ibuf,ifmdn1,l_DpN1SP,lendn1,FCDP,LINHED)
        call saver2(ibuf,ifmndi,l_NmDpIn,lenndi,INCR,LINHED)
      GO TO 900                                                         
C--                                                                     
C---- SET SOURCE INFORMATION...                                         
C--                                                                     
  500 SLINT  = GIINT / 10.0                                             
C--                                                                     
C---- HOW FAR BETWEEN LABELED SOURCES ???                               
C--                                                                     
      SPLINT = SRCINT * FLOAT( RIPSRC )                                 
      IF ( METRIC .EQ. 0 ) GO TO 550                                    
         SPLIN2 = SPLINT * CONV                                         
         SPMILE = 5280.0 / SPLIN2                                       
         GO TO 575                                                      
  550 SPMILE = 5280.0 / SPLINT                                          
                                                                        
C--                                                                     
C---- SET POSITION OF SOURCE BEFORE INITIAL MOVEUP...                   
C---- WE WANT THE MOST NEGATIVE TRACE TO FALL EXACTLY                   
C---- ON THE FIRST GI FOR THE FIRST SOURCE POINT..                      
C---- TRACE DISTANCE WILL DECIDE WHETHER OR NOT SOURCE                  
C---- LOCATION INDEX OF 1ST SOURCE WILL BE ON A GI CENTER               
C---- I.E. ON THE GROUP AS OPPOSED TO BETWEEN GROUP SHOOTING            
C--                                                                     
C---- DETERMINE HOW FAR TO FIRST SOURCE POINT                           
C---- GET HELP TO LOCATE GROUP 1...                                     
C--                                                                     
  575 DO 700 I = 1,NTRACE                                               
         IF ( CONVEN ) GO TO 600                                        
         MULT = -1                                                      
         IF ( DIST(I) .LT. DINKY ) DINKY = DIST(I)                      
         IF ( DIST(I) .LT. SMALL ) SMALL = DIST(I)                      
         GO TO 700                                                      
  600    IF ( DIST(I) .GT. DINKY ) DINKY = DIST(I)                      
  700    CONTINUE                                                       
C--                                                                     
C---- IF PUSHING A SPREAD, GET SMALLEST                                 
C---- TRACE DISTANCE TO REPOSITION ORIGIN FOR 108...                    
C--                                                                     
      IF ( SMALL .LE. 0.0                                               
     *           .OR. DINKY .LT. 0.0 ) SMALL = 0.0                      
C--                                                                     
C---- IF MOVEUP CARDS INPUT, USE THE FIRST MOVEUP                       
C---- ( IF FIRST MOVEUP IS NOT BLANK, -99999.99 )                       
C---- TO POSITION THINGS SO FIRST TRACE                                 
C---- LANDS ON A GROUP CENTER...                                        
C--                                                                     
      ALIGN  = SRCINT                                                   
      IF ( ( MOOVUP )                                                   
     *       .AND. DSTNCE(1,1) .NE. -99999.99 ) ALIGN = DSTNCE(1,1)     
      SOURCE = ( MULT * DINKY ) + GIINT - ALIGN + OFFSET                
C--                                                                     
C---- IF PUSHING A SPREAD, MAKE SURE                                    
C---- FIRST TRACE LANDS ON A GROUP                                      
C---- CENTER.  SOURCE CAN GO ANYWHERE...                                
C--                                                                     
      IF ( DINKY .EQ. 0.0 ) then
      	SOURCE = SOURCE + ( ALIGN - SMALL )
	endif
C--                                                                     
C---- SET SOME STUFF IN LINE HEADER                                     
C---- THAT SORT AND PLOT NEED...                                        
C--                                                                     
      RDREGS = SOURCE + ALIGN                                           
C--                                                                     
C---- IF SHOT ON GROUP, RDREGS WILL                                     
C---- BE ZERO.  PUSHING SPREAD ONLY...                                  
C--                                                                     
      IF ( RDREGS .EQ. 0 ) RDREGS = RDREGS + ALIGN                      
      FSTSRC = RDREGS                                                   
C--                                                                     
C---- GET BUCKET LIMIT FOR DI SLOP PER LABELED SOURCE POINT             
C---- WHAT FRACTION OF SPLINT DOES A DI HAVE TO FALL IN...              
C--                                                                     
      DIOVRL = DIINT / SPLINT * 0.5                                     
C--                                                                     
C---- DOES WATER VELOCITY NEED TO BE DEFAULTED ???                      
C--                                                                     
      IF ( .NOT. INDEX ) GO TO 900                                      
         IF ( WATVEL .EQ. 0                                             
     *            .AND. METRIC .EQ. 0 ) WATVEL = 4850                   
         IF ( WATVEL .EQ. 0                                             
     *            .AND. METRIC .EQ. 1 ) WATVEL = 1480                   
        call savew2(ibuf,ifmtwv,l_WatVel,lengwv,WATVEL,LINHED)
C--                                                                     
C---- GET THE GROUP INTERVAL IN PROPER                                  
C---- FRAME OF MIND...                                                  
C--                                                                     
      IGIINT = RECINT + 0.5                                             
	write(grpst,799) IGIINT
  799   format(i4)
        call savew2(ibuf,ifmtgi,l_GrpInt,lenggi,grpst,LINHED)
C--                                                                     
C---- STUFF ALL KINDS OF CRAP IN LINE HEADER....                        
C--                                                                     
        call savew2(ibuf,ifmogf,l_OpGrFl,lenogf,IBTWN,LINHED)
        call savew2(ibuf,ifmtst,l_SrtTyp,lengst,stype,LINHED)
      IF ( IFOLD .NE. 0 ) THEN
        call savew2(ibuf,ifmfld,l_CDPFld,lenfld,IFOLD,LINHED)
      ENDIF
        call savew2(ibuf,ifmont,l_OrNTRC,lenont,ntrc,LINHED)
        call savew2(ibuf,ifmonr,l_OrNREC,lenonr,nrec,LINHED)
        call savew2(rbuf,ifmnsm,l_NmSpMi,lennsm,SPMILE,LINHED)
	intval = METRIC
        call savew2(ibuf,ifmtuf,l_UnitFl,lenguf,intval,LINHED)
      IBUF72  = SPSET ( RDREGS, SPLINT, DIOVRL, TRUESP, FSTSRC )
        call savew2(ibuf,ifm1sp,l_FrstSP,len1sp,IBUF72,LINHED)
      IBUF73  = ASSIGN ( RDREGS, DIINT, 0, DUMMY )
        call savew2(ibuf,ifmdn1,l_DpN1SP,lendn1,IBUF73,LINHED)
      IBUF74  = SPLINT / ( DIINT * SPINC ) * 100.
        call savew2(ibuf,ifmndi,l_NmDpIn,lenndi,IBUF74,LINHED)
        call savew2(ibuf,ifmswf,l_StWdFl,lenswf,2,LINHED)
      IBUF76  = DIINT + 0.5
        call savew2(ibuf,ifmdpi,l_DptInt,lendpi,IBUF76,LINHED)
        call savew2(ibuf,ifmtpd,l_PltDir,lengpd,IPLOT,LINHED)
        call savew2(ibuf,ifmtmf,l_MutFlg,lengmf,imutf,LINHED)
        call savew2(ibuf,ifmtm1,l_TmMsFS,lentm1,it0,LINHED)
      IF ( it0 .EQ. 0) THEN
        call savew2(ibuf,ifmogf,l_OpGrFl,lenogf,it0,LINHED)
      ENDIF
C--                                                                     
C---- CALL SOURCE POINT BIASING ROUTINE...                              
C--                                                                     
        call saver2(ibuf,ifmsbf,l_SpBiFl,lensbf,spbiasfl,LINHED)
        call saver2(ibuf,ifmspb,l_SPBias,lenspb,spbas,LINHED)
        call saver2(ibuf,ifm1sp,l_FrstSP,len1sp,isp1,LINHED)
      CALL SBIAS ( spbiasfl, spbas, isp1, SPNUM1 )
      IBFLAG = spbiasfl
C                                                                       
900   continue
      call savhlh(ihead,hdrlen,lbyout)
        call saver2(ihead,ifmtcn,l_CrwNam,lengcn,crew,LINHED)
      call wrtape(luout,ihead,lbyout)       
C--                                                                     
C---- IF WATER DEPTHS ARE TO BE INPUT,                                  
C---- GO INTERPOLATE AND PRINT THEM FIRST....                           
C--                                                                     
      IF ( WTRCRD ) CALL DSPLAY ( WDEPTH, MINWD, MAXWD, 1 )             
C                                                                       
      IF ( .NOT. INDEX ) CALL UTILTY ( IREC, KARD, IHEAD, MINWD, MAXWD,
     *                                 NTRACE, FSORC, WDEPTH )          
C                                                                       
      IF ( INDEX ) then                                                 
           CALL INDX ( IREC, SLINT, SPLINT, SOURCE, FSTSRC, DIOVRL,     
     *                 TRUESP, DIERR, GIERR, MULT, IHEAD,
     *                 WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG, saveperm) 
	endif
C                                                                       
      IF  ( ( INDEX )                                                   
     *        .AND. ( HISTGR ) ) CALL HISTGM ( GIERR, 1 )               
      IF  ( ( INDEX )                                                   
     *        .AND. ( HISTGR ) ) CALL HISTGM ( DIERR, 6 )               
C--                                                                     
C---- DO MY ACCOUNTING...                                               
C--                                                                     
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 0 )                                                 
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE INDX ( IREC, SLINT, SPLINT, SOURC1, FSTSRC, DIOVRL,    
     *                  TRUESP, DIERR, GIERR, MULT, IBUF,
     *                  WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG, saveperm)
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: INDX                                             
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE INDX DOES THE STUFFING OF TRACE HEADER VALUES      
C         AND IS ONLY CALLED WHEN INDEXING IS TO BE PERFORMED.          
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                             02/28/86   J. VINSON                      
C                             CORRECTED CDP CALCULATION TO USE          
C                             ACTUAL SOURCE POSITION RATHER THAN        
C                             SOURCE LABELING POSITION                  
C                                                                       
C     PARAMETERS PASSED:                                                
C         IREC   - NUMBER OF RECORDS PROCESSED                          
C         SLINT  - SOURCE LOCATION INDEX INTERVAL                       
C         SPLINT - INTERVAL AT WHICH SOURCES ARE LABELED ABOVE CDP'S    
C         SOURC1 - SOURCE LOCATION IN DISTANCE                          
C         FSTSRC - FIRST SOURCE ON LINE                                 
C         DIOVRL - SLOP FOR LABELING SP OVER CDP                        
C         TRUESP - WHAT SOURCE POINT IS ABOVE ANY CDP                   
C         DIERR  - ERROR IN CDP ASSIGNMENTS                             
C         GIERR  - ERROR IN GI ASSIGNMENTS                              
C         MULT   - MULTIPLIER FOR TRACE DISTANCE MAGNITUDES             
C         IBUF   - TRACE BUFFER                                         
C         WDEPTH - WATER DEPTH ARRAY                                    
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    
C         NTRACE - NUMBER OF TRACES PER RECORD                          
C         IBFLAG - SOURCE POINT BIASING FLAG                            
C                                                                       
C***********************************************************************
#include <save_defs.h>
#include <f77/sisdef.h>
C                                                                       
	character*8 TJOBID
      REAL    * 4 DIST(8192), WDEPTH(12000), JCSTAT, DSTNCE(2,5000),    
     *            BEGIN(8192), FINISH(8192), INIT                       
C                                                                       
      INTEGER * 4 RECORD, SRCLOC, SRCNUM, SPSET, luout, SPINC, SPNUM1,
     *            DIERR(50), GIERR(50), ASSIGN, BOUNDS(3,5000), VALUE,  
     *            RIPSRC, FCDP, WATVEL, DIBSP
      integer     assign4
	integer ASSIG1
	integer kval, lval
      character*80  KARD
	integer SPSET1
      integer srcloc4
C                                                                       
      INTEGER  IBUF(*), IBFLAG
	real lcdp(2), lshot(2), lrecv(2), ldiint(2)
	integer ldi(2), ltr
C                                                                       
      logical   CONVEN, INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, FIRST,
     *            START, END, HISTGR, CBLCRD
      logical   saveperm
c
C                                                                       
      DATA FIRST/.TRUE./, START/.FALSE./, END/.FALSE./,                 
     *     IPNTR/1/, BLANK/-99999.99/, IBOTOM/-99999/, ISTART/-9999/,   
     *     IEND/-9999/                                                  
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
	save ltr,ldi,lcdp,lshot,lrecv,ldiint

c__________________________________________________________________
c     look up hardware specific trace header indices.
c     these indices will be the same for all output records.
c__________________________________________________________________
cmam.....short int
      call savelu('RecNum',ifmtrn,l_RecNum,lengrn,TRCHED)
      call savelu('TrcNum',ifmttn,l_TrcNum,lengtn,TRCHED)
      call savelu('SrcLoc',ifmtsl,l_SrcLoc,lengsl,TRCHED)
      call savelu('RecInd',ifmtri,l_RecInd,lengri,TRCHED)
      call savelu('SoPtNm',ifmtsp,l_SoPtNm,lengsp,TRCHED)
      call savelu('RcStAp',ifmrsa,l_RcStAp,lenrsa,TRCHED)
      call savelu('RcStUn',ifmrsu,l_RcStUn,lenrsu,TRCHED)
cmam.....short int
      call savelu('DphInd',ifmtdi,l_DphInd,lengdi,TRCHED)
      call savelu('DstSgn',ifmtds,l_DstSgn,lengds,TRCHED)
      call savelu('DstUsg',ifmtdu,l_DstUsg,lengdu,TRCHED)
      call savelu('StaCor',ifmtsc,l_StaCor,lengsc,TRCHED)
cmam.....long int
      call savelu('SGRDat',ifmsgr,l_SGRDat,lensgr,TRCHED)
cmam.....short int
      call savelu('WDepDP',ifmtwd,l_WDepDp,lengwd,TRCHED)
      call savelu('ToTmAU',ifmttu,l_ToTmAU,lenttu,TRCHED)
      call savelu('ShtDep',ifmtsd,l_ShtDep,lengsd,TRCHED)
      call savelu('CabDep',ifmtcd,l_CabDep,lengcd,TRCHED)
      call savelu('PREPIn',ifmtpi,l_PREPIn,lengpi,TRCHED)
      call savelu('InStUn',ifminu,l_InStUn,leninu,TRCHED)
      call savelu('PREPRc',ifmtpr,l_PREPRc,lengpr,TRCHED)
      call savelu('ToStUn',ifmtsu,l_ToStUn,lentsu,TRCHED)

      if (.not. saveperm) then
        call savelu('PrRcNm',ifmprn,l_PrRcNm,lenprn,TRCHED)
        call savelu('PrTrNm',ifmptn,l_PrTrNm,lenptn,TRCHED)
      endif
C--                                                                     
C---- START PROCESSING TAPE....                                         
C--                                                                     
      ICNT = 0                                                          
      LASTRI = 0                                                        
  100 ILABEL = 0                                                        
  200 ISTAT  = 0                                                        
      JSTAT  = 0                                                        
      INIT   = 0.                                                       
      RECEP  = 0.                                                       
      TOTAL  = 0.                                                       
      LENGTH = 0                                                        
      CALL RTAPE ( luin, IBUF, LENGTH )                                 
      IF ( LENGTH .EQ. 0 ) GO TO 1200                                   
C                                                                       
	call saver2(ibuf,ifmtrn,l_RecNum,lengrn,krec,TRCHED)
	call saver2(ibuf,ifmttn,l_TrcNum,lengtn,ktrc,TRCHED)
	if(ktrc .ne. 1) go to 250
	if(krec .ne. LASTRI) go to 240
      WRITE (IPRNTR,230) krec                                           
  230 FORMAT(/13X,'** M0202 ** WARNING FROM SUBROUTINE INDX:'           
     *      ,/25X,'DUPLICATE RECORD NUMBER ', I6,' FOUND.',             
     *       /25X,'PROCESSING CONTINUES.',/)                            
  240 LASTRI = krec                                                     
  250 CONTINUE                                                          
C                                                                       
      IF ( .NOT. MOOVUP ) GO TO 400                                     
C--                                                                     
C---- WE HAVE MOVE UP CARDS...PANIC !!!!                                
C---- START SETTING FLAGS...                                            
C--                                                                     
C---- HAVE WE PASSED THE END RECORD ???                                 
C--                                                                     
      IF ( ( .NOT. END )                                                
     *       .OR. krec .EQ. BOUNDS(2,IPNTR) ) GO TO 300                 
      START = .FALSE.                                                   
      END   = .FALSE.                                                   
C--                                                                     
C---- BUMP POINTER TO NEXT STARTING RECORD...                           
C---- IF ZERO, THAT WILL MEAN NO MORE TO WRITE OUT...                   
C--                                                                     
      ICNT   = 0                                                        
      SOURC1 = SOURCE                                                   
      IPNTR = IPNTR + 1                                                 
      IF ( BOUNDS(1,IPNTR) .EQ. 0 ) GO TO 1200                          
C--                                                                     
C---- WE HAVE REACHED THE FIRST RECORD YET ???                          
C--                                                                     
  300 IF ( krec .EQ. BOUNDS(1,IPNTR) ) START = .TRUE.                   
      IF ( .NOT. START ) GO TO 100                                      
C--                                                                     
C---- DO THIS STUFF FOR TRACE 1 OF EVERY RECORD...                      
C--                                                                     
  400    IF ( ktrc .GT. 1 ) GO TO 600                                   
C                                                                       
            RECORD = krec                                               
            CALL DSTUPD ( RECORD, KARD, NTRACE )                        
C                                                                       
            IF ( ( CBLCRD )                                             
     *             .AND. RECORD .GT. IEND )                             
     *                  CALL CDEPTH ( ISTART, IEND, NTRACE )            
C--                                                                     
C---- HOW FAR IS THIS SOURCE AFTER MOVEUP ???                           
C--                                                                     
            IF ( ( .NOT. MOOVUP )                                       
     *             .OR. ( ( MOOVUP ) .AND.                              
     *                  DSTNCE(1,IPNTR) .EQ. BLANK ) )                  
     *                        SOURCE = SOURC1 + SRCINT * (ICNT + 1)     
C    *                        SOURCE = SOURCE + SRCINT                  
C--                                                                     
C---- IS THERE A SOURCE MOVEUP ON THE MOOV CARD ???                     
C---- -99999.99 SIGNIFIES A BLANK ENTRY AS OPPOSED TO A ZERO ENTRY...   
C--                                                                     
            IF ( (  MOOVUP    )                                         
     *              .AND. DSTNCE(1,IPNTR) .NE. BLANK )                  
     *         SOURCE = SOURC1 + DSTNCE(1,IPNTR) * (ICNT + 1)           
C                                                                       
C           IF ( (  MOOVUP    )                                         
C    *              .AND. DSTNCE(1,IPNTR) .NE. BLANK )                  
C    *                  SOURCE = SOURCE + DSTNCE(1,IPNTR)               
C--                                                                     
C---- IF THEY SPECIFIED A SHOT POINT TO TIE                             
C---- TO, LET'S COMPUTE WHERE THE SHOT SHOULD BE...                     
C--                                                                     
            IF ( ( .NOT. MOOVUP )                                       
     *             .OR. BOUNDS(3,IPNTR) .LE. 0                          
     *                .OR. RECORD .NE. BOUNDS(1,IPNTR) ) GO TO 500      
               NUMSP  = ( BOUNDS(3,IPNTR) - SPNUM1 )  / SPINC
            RNUMSP = FLOAT(( BOUNDS(3,IPNTR) - SPNUM1 )) / FLOAT(SPINC)
               SOURCE = FSTSRC + ( ABS(RNUMSP) * SPLINT )
C              SOURCE = FSTSRC + ( IABS(NUMSP) * SPLINT )
               SOURC1 = SOURCE                                          
               ICNT   = ICNT - 1                                        
C--                                                                     
C---- BACK UP FROM ANTENNA IF NECESSARY...                              
C--                                                                     
  500       SHOT  = SOURCE - OFFSET                                     
C--                                                                     
C---- DETERMINE SOURCE LOCATION INDEX (109)                             
C--                                                                     
            SRCLOC = ASSIGN ( SHOT, SLINT, 0, DUMMY )                   
            srcloc4= assign4( shot, slint, 0, dummy )                   
            IF ( SRCLOC .NE. -1 ) GO TO 550                             
            WRITE(IPRNTR,525) RECORD                                    
  525       FORMAT(/13X,'** M0200 ** ERROR DETECTED BY SUBROUTINE INDX:'
     *            ,/25X,'THE COMPUTED SOURCE LOCATION INDEX FOR',       
     *             /25X,'RECORD ',I5,' IS LESS THAN ONE.  VERIFY',      
     *             /25X,'ALL PROCESSING PARAMETERS ARE CORRECT.',/)     
            CALL LBCLOS ( luin )
            CALL LBCLOS ( luout )
            CALL CCEXIT ( 100 )                                         
C--                                                                     
  550       IF ( FIRST ) FSTSRC = SOURCE                                
                 FIRST = .FALSE.                                        
cc	write out heading for trace related values
	write(IPRNTR,560)
  560 format(//,1x,'Tr#  ',
     *'   CDP   ','  SHOT  ',' RECEIV ','DIINT ','  DI  ',1x,
     *'   CDP   ','  SHOT  ',' RECEIV ','DIINT ','  DI  ',/)
  570 format(1x,i3,2x,3f8.1,f6.1,i5,3x,3f8.1,f6.1,i5)
C--                                                                     
C---- WHAT IS THE SOURCE NUMBER FOR THIS RECORD ???                     
C--                                                                     
C---- TRUESP IS ACTUAL SOURCE EVEN BETWEEN LABELED SOURCES...           
C--                                                                     
            SRCNUM = SPSET ( SOURCE, SPLINT, DIOVRL, TRUESP, FSTSRC )   
            if (BOUNDS(3,IPNTR) .GT. 0) then
               if (RECORD .EQ. BOUNDS(1,IPNTR))
     *          SRCNUM = BOUNDS(3,IPNTR)
               if ((SRCNUM .EQ. 0) .AND. (SPINC .EQ. 2))
     *          SRCNUM = TRUESP
            endif
C--                                                                     
C---- RECALL SRCLOC IS A FACTOR OF 10 BIGGER...                         
C--                                                                     
600     continue
	call savew2(ibuf,ifmtsl,l_SrcLoc,lengsl,srcloc,TRCHED)
	call savew2(ibuf,ifmsgr,l_SGRDat,lensgr,srcloc4,TRCHED)
C--                                                                     
C---- SET TRACE DISTANCE...                                             
C--                                                                     
         SDIST     = DIST( ktrc )                                       
	kval = sdist + SIGN(0.5, sdist)
	call savew2(ibuf,ifmtds,l_DstSgn,lengds,kval,TRCHED)
	kval = iabs(kval)
	call savew2(ibuf,ifmtdu,l_DstUsg,lengdu,kval,TRCHED)
C--                                                                     
C---- DETERMINE WHERE RECEIVER IS LOCATED..                             
C--                                                                     
         RECEIV    = SHOT - ( MULT * SDIST )                            
         kval = ASSIGN ( RECEIV, GIINT, 1, GIERR )                      
	call savew2(ibuf,ifmtri,l_RecInd,lengri,kval,TRCHED)
C                                                                       
         IF ( kval .NE. -1 ) GO TO 650                                  
         WRITE(IPRNTR,625) RECORD, ktrc                                 
  625    FORMAT (/13X,'** M0201 ** ERROR DETECTED BY SUBROUTINE INDX:', 
     *           /25X,'THE COMPUTED GROUP INDEX FOR RECORD ',I5,        
     *           /25X,'TRACE ',I4,' WAS LESS THAN ONE.  VERIFY',        
     *           /25X,'THAT THE GROUP INTERVAL AND TRACE DISTANCES',    
     *           /25X,'ARE CORRECT.',/)                                 
         CALL LBCLOS ( luin )
         CALL LBCLOS ( luout )
         CALL CCEXIT ( 100 )                                            
C--                                                                     
C---- WHAT IS THE CDP ??                                                
C----             CDP IS CALCULATED FROM SHOT (ACTUAL SOURCE POSITION)  
C----             RATHER THAN SOURCE (SOURCE LABELING POSITION)         
C--                                                                     
C 650    CDP       = ( SOURCE + RECEIV ) * 0.5                          
  650    CDP       = ( SHOT + RECEIV ) * 0.5                            
         kval = ASSIG1 ( CDP, DIINT, 1, DIERR )                         
	call savew2(ibuf,ifmtdi,l_DphInd,lengdi,kval,TRCHED)
cc	save values, write out values
	lcount = lcount + 1
	if(lcount .gt.2) then
	   write(IPRNTR,570)ltr,(lcdp(i),lshot(i),lrecv(i),
     *		ldiint(i),ldi(i),i=1,2)
	   lcount = 1
	   ltr = ktrc
	endif
	if(ktrc .EQ. 1) ltr = 1
	lcdp(lcount) = CDP
	lshot(lcount) = SHOT
	lrecv(lcount) = RECEIV
	ldiint(lcount) = DIINT
	ldi(lcount) = kval
	
 9999    FORMAT(' CDP = ', E12.5,' SHOT = ', E12.5,' RECEIV = ', E12.5, 
     *          ' DIINT = ', E12.5,' DI = ', I10)                       
         DIBSP     = SPSET1( CDP, SPLINT, DIOVRL, TRUESP, FSTSRC )      
C--                                                                     
C---- GET SOURCE POINT LABELS TO                                        
C---- ASSIGN VALUES...                                                  
C--                                                                     
         IF ( WTRCRD ) then                                             
                 kval = VALUE ( TRUESP, WDEPTH, MINWD, MAXWD,           
     *                               SPINC )                            
	        call savew2(ibuf,ifmtwd,l_WDepDp,lengwd,kval,TRCHED)
	endif
        if (.not. saveperm) then
	  call savew2(ibuf,ifmprn,l_PrRcNm,lenprn,krec,TRCHED)
	  call savew2(ibuf,ifmptn,l_PrTrNm,lenptn,ktrc,TRCHED)
        endif
C                                                                       
              IF ( DIBSP .EQ. 0 ) GO TO 700                             
                 IF ((ILABEL .GT. DIBSP .AND. SPINC .GT. 0 .AND.        
     *                ILABEL .NE. 0 ) .OR.                              
     *               (ILABEL .LT. DIBSP .AND. SPINC .LT. 0 .AND.        
     *                ILABEL .NE. 0 ))  GO TO 700                       
                   ILABEL = DIBSP                                       
	       call saver2(ibuf,ifmtdi,l_DphInd,lengdi,iwhere,TRCHED)
                   IF ( WTRCRD ) then
	       call saver2(ibuf,ifmtwd,l_WDepDp,lengwd,ibotom,TRCHED)
                   endif
C                                                                       
C ***         IBUF(125) WILL BE DEAD TRACE FLAG ONLY                    
C ***         JOB-CONSTANT STATIC WILL BE STORED IN                     
C ***         IBUF(16) - TIMING ADJUSTMENT                              
C                                                                       
700      continue
	 call saver2(ibuf,ifmtsc,l_StaCor,lengsc,kval,TRCHED)
	 if(kval .ge. 30000
     *                  .OR. JCSTAT .EQ. 0. ) GO TO 800                 
                   TOTAL   = JCSTAT * 4                                 
	 call saver2(ibuf,ifmttu,l_ToTmAU,lenttu,lval,TRCHED)
    	 lval = lval + ( TOTAL + SIGN(0.5, TOTAL) )
	 call savew2(ibuf,ifmttu,l_ToTmAU,lenttu,lval,TRCHED)
                   GO TO 1100                                           
C                                                                       
  800         IF ( .NOT. CBLCRD ) GO TO 1100                            
C--                                                                     
C---- IEND = 99999 MEANS NO MORE CABL CARDS;                            
C---- HENCE, NO MORE SPATIAL INTERPOLATION...                           
C---- IF NOT 99999, SPATIALLY INTERPOLATE...                            
C--                                                                     
                 IF ( IEND .EQ. 99999                                   
     *                     .OR. RECORD .LE. ISTART                      
     *                            .OR. RECORD .GT. IEND ) GO TO 900     
                    ISPAN    = IEND - ISTART                            
		    DIFF = FINISH(ktrc) - BEGIN(ktrc)
                    STEP     = DIFF / FLOAT(ISPAN)                      
                    RECEP    = (( FLOAT( RECORD - ISTART ) * STEP )     
     *                          + BEGIN(ktrc))                          
                 GO TO 1000                                             
C                                                                       
  900               RECEP    = BEGIN( ktrc )                            
 1000               INIT     = DSTNCE(2,IPNTR)                          
	 kval = init+0.5
	 call savew2(ibuf,ifmtsd,l_ShtDep,lengsd,kval,TRCHED)
	 kval = recep+0.5
	 call savew2(ibuf,ifmtcd,l_CabDep,lengcd,kval,TRCHED)
	 call saver2(ibuf,ifmtsc,l_StaCor,lengsc,kval,TRCHED)
C                                                                       
                 IF ( kval .GE. 30000 ) GO TO 1100                      
                    INIT     = INIT  / FLOAT(WATVEL)                    
                    RECEP    = RECEP / FLOAT(WATVEL)                    
                    TOTAL    = INIT + RECEP                             
C--                                                                     
C---- CONVERT TO 1/4 MS...                                              
C--                                                                     
C-- INITIATION STATIC...                                                
                 INIT      = INIT * 4 * 1000.                           
                   ISTAT   = INIT + SIGN ( 0.5, INIT )                  
C                                                                       
C-- RECEPTION STATIC...                                                 
                 RECEP     = RECEP * 4 * 1000.                          
                   JSTAT   = RECEP + SIGN ( 0.5, RECEP )                
C--                                                                     
C---- STORE IN TRACE HEADER...                                          
C--                                                                     
	 call saver2(ibuf,ifmtpi,l_PREPIn,lengpi,kval,TRCHED)
	kval = kval + istat
	 call savew2(ibuf,ifmtpi,l_PREPIn,lengpi,kval,TRCHED)
	 call saver2(ibuf,ifminu,l_InStUn,leninu,kval,TRCHED)
	kval = kval + istat
	 call savew2(ibuf,ifminu,l_InStUn,leninu,kval,TRCHED)
	 call saver2(ibuf,ifmtpr,l_PREPRc,lengpr,kval,TRCHED)
	kval = kval + jstat
	 call savew2(ibuf,ifmtpr,l_PREPRc,lengpr,kval,TRCHED)
	 call saver2(ibuf,ifmrsu,l_RcStUn,lenrsu,kval,TRCHED)
	kval = kval + jstat
	 call savew2(ibuf,ifmrsu,l_RcStUn,lenrsu,kval,TRCHED)
	 call saver2(ibuf,ifmtsu,l_ToStUn,lentsu,kval,TRCHED)
	kval = kval + istat + jstat
	 call savew2(ibuf,ifmtsu,l_ToStUn,lentsu,kval,TRCHED)
C--                                                                     
C---- STUFF BIASED SOURCE POINTS...                                     
C--                                                                     
 1100 continue

      call spbias ( ibflag, ibuf, DIBSP, SRCNUM )
C--                                                                     
C---- WRITE IT OUT AND DO IT AGAIN...                                   
C--                                                                     
         CALL WRTAPE ( luout, IBUF, LENGTH )
            IF ( ( MOOVUP ) .AND.                                       
     *             krec .EQ. BOUNDS(2,IPNTR) ) END = .TRUE.             
C--                                                                     
C---- KEEP TRACK OF WHAT WE PROCESS...                                  
C--                                                                     
         IF ( ktrc .LT. NTRACE ) GO TO 200                              
C                                                                       
cc	 write out values if any are ready
	if(lcount .gt.0) then
	   write(IPRNTR,570)ltr,(lcdp(i),lshot(i),lrecv(i),
     *		ldiint(i),ldi(i),i=1,lcount)
	   lcount = 0
	endif
         CALL WRTOUT ( RECORD, ILABEL, IWHERE, IBOTOM )                 
         IREC = IREC + 1                                                
         ICNT = ICNT + 1                                                
         GO TO 100                                                      
C                                                                       
 1200 RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      INTEGER FUNCTION ASSIGN ( PLACE, DELTA, MODE, INTERR )            
C***********************************************************************
C                                                                       
C     FUNCTION NAME: ASSIGN                                             
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         FUNCTION ASSIGN WILL ASSIGN AN INDEX VALUE BASED ON           
C         A DISTANCE PASSED AND A BUCKET SIZE.                          
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         PLACE  - DISTANCE FROM ORIGIN TO BE LABELED                   
C         DELTA  - LABELING INTERVAL                                    
C         MODE   - FLAG TO SEE IF WE'RE ACCUMULATING ERROR              
C         INTERR - ERROR COUNTER                                        
C                                                                       
C***********************************************************************
C                                                                       
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             
C--                                                                     
C---- SET 'BUCKET' ASSIGNMENT                                           
C--                                                                     
      DELTA2 = DELTA * 0.5                                              
      ASSIGN = ( PLACE + DELTA2 ) / DELTA                               
C--                                                                     
C---- MAKE SURE INDEX STAYS UNDER 32768..                               
C--                                                                     
         IF ( ASSIGN .GT. 32767 ) ASSIGN = 32767                        
C--                                                                     
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               
C--                                                                     
         IF ( ASSIGN .GE. 1 ) GO TO 100                                 
              ASSIGN = -1                                               
              RETURN                                                    
C--                                                                     
C--------------------------------------------------------------         
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       
C--                                                                     
  100 IF ( MODE .LT. 1 ) RETURN                                         
         DIFFER = ( PLACE - DELTA * ASSIGN ) / DELTA * 50.0             
         ERROR = 26 + DIFFER                                            
         IF (ERROR .LT.  1) ERROR = 1                                   
         IF (ERROR .GT. 50) ERROR = 50                                  
         INTERR(ERROR) = INTERR(ERROR) + 1                              
         RETURN                                                         
      END                                                               
      INTEGER FUNCTION ASSIGN4( PLACE, DELTA, MODE, INTERR )            
C                                                                       
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             
C--                                                                     
C---- SET 'BUCKET' ASSIGNMENT                                           
C--                                                                     
      DELTA2 = DELTA * 0.5                                              
      ASSIGN4= ( PLACE + DELTA2 ) / DELTA                               
C--                                                                     
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               
C--                                                                     
         IF ( ASSIGN4 .GE. 1 ) GO TO 100  
              ASSIGN4 = -1 
              RETURN                                                    
C--                                                                     
C--------------------------------------------------------------         
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       
C--                                                                     
  100 IF ( MODE .LT. 1 ) RETURN                                         
         DIFFER = ( PLACE - DELTA * ASSIGN4) / DELTA * 50.0             
         ERROR = 26 + DIFFER                                            
         IF (ERROR .LT.  1) ERROR = 1                                   
         IF (ERROR .GT. 50) ERROR = 50                                  
         INTERR(ERROR) = INTERR(ERROR) + 1                              
         RETURN                                                         
      END                                      
C                                                                       
C                                                                       
      INTEGER FUNCTION VALUE ( REAL, WDEPTH, MINWD, MAXWD, SPINC )      
C***********************************************************************
C                                                                       
C     FUNCTION NAME: VALUE                                              
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         FUNCTION VALUE WILL COMPUTE WATER DEPTHS FOR TRACE INPUT.     
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         REAL   - TRUE SOURCE POINT                                    
C         WDEPTH - WATER DEPTH ARRAY                                    
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    
C         SPINC  - SOURCE POINT INCREMENT                               
C                                                                       
C***********************************************************************
C                                                                       
      REAL    * 4 WDEPTH(12000)                                         
C                                                                       
      INTEGER * 4 SPINC                                                 
C                                                                       
      IREEL  = REAL                                                     
      DIFFER = REAL - IREEL                                             
      IF ( SPINC .LT. 0                                                 
     *           .AND. DIFFER .NE. 0. ) IREEL = IREEL + 1               
C--                                                                     
C---- SEE IF IN BOUNDS....                                              
C--                                                                     
      IF ( IREEL .LT. MINWD ) IREEL = MINWD                             
      IF ( IREEL .GT. MAXWD ) IREEL = MAXWD                             
C--                                                                     
C---- ARE WE BETWEEN TWO SOURCE POINTS ???                              
C---- OR ARE WE AT THE OUTER LIMIT ???                                  
C--                                                                     
      IPNT1  = IREEL - ( MINWD - 1 )                                    
      VALUE1 = WDEPTH(IPNT1)                                            
      IF ( SPINC .GT. 0                                                 
     *           .AND. ( DIFFER .EQ. 0.                                 
     *                .OR. (IREEL + 1) .GT. MAXWD ) )                   
     *                       IREEL = IREEL - 1                          
      IF ( SPINC .LT. 0                                                 
     *           .AND. ( DIFFER .EQ. 0.                                 
     *                .OR. (IREEL - 1) .LT. MINWD ) )                   
     *                       IREEL = IREEL + 1                          
      IPNT2  = IREEL - ( MINWD - 1 )                                    
      IPNT2  = IPNT2 + ISIGN ( 1, SPINC )                               
      VALUE2 = WDEPTH( IPNT2 )                                          
C--                                                                     
C---- SEE HOW IN BETWEEN IT IS...                                       
C--                                                                     
      WDIFF  = VALUE2 - VALUE1                                          
      XDIFF  = DIFFER                                                   
      IF ( SPINC .LT. 0 ) XDIFF = 1. - DIFFER                           
      ISLOPE = ( WDIFF * XDIFF ) + SIGN ( 0.5, WDIFF )                  
      VALUE  = VALUE1 + ISLOPE                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE HISTGM ( ERROR, NMBR )                                 
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: HISTGM                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE HISTGM DISPLAYS ERROR HISTOGRAMS WHICH ILLUSTRATE  
C         HOW WELL INDEX ASSIGNMENTS FELL INTO ASSIGNMENT BUCKETS.      
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         ERROR  - GI OR DI ERROR IN ASSIGNMENTS                        
C         NMBR   - POINTER FOR HISTOGRAM TITLE                          
C                                                                       
C***********************************************************************
C                                                                       
      INTEGER * 4 ERROR(50)                                             
C                                                                       
      character * 1 TITLE(39), STRING(90), NDECS(10)
C                                                                       
      DATA TITLE/'=','=','=','=','>',7*' ','I','N','D','E','X',         
     *           ' ','E','R','R','O','R',' ','H','I','S','T','O',       
     *           'G','R','A','M',' ','<','=','=','=','='/,              
     *     STRING /90*'*'/, NDECS/'G','R','O','U','P',                  
     *     'D','E','P','T','H'/, MIDDLE/26/                             
C                                                                       
      COMMON /LUNIT/ IREADR, IPRNTR, IDISKW, IDISKC

C--                                                                     
C---- DISPLAY THE TITLE FIRST                                           
C--                                                                     
      CALL MOVE ( 1, TITLE(7), NDECS(NMBR), 5 )                         
      WRITE(IPRNTR,100) TITLE                                           
  100 FORMAT ('1',47X,39A1,/,54X,'---------------------------',/,       
     *        5X,'ERROR',4X,'COUNT',5X,'%',/,5X,'-----',4X,'-----',     
     *        3X,'-----')                                               
C--                                                                     
C---- FIND MAX MAGNITUDE                                                
C--                                                                     
      PERCNT   = 0.                                                     
      MAX      = 0                                                      
      ITOTAL   = 0                                                      
      DO 200 I = 1,50                                                   
         IF ( ERROR(I) .LT.   0) ERROR(I) = -ERROR(I)                   
         IF ( ERROR(I) .GT. MAX) MAX = ERROR(I)                         
         ITOTAL = ITOTAL + ERROR(I)                                     
  200 CONTINUE                                                          
C--                                                                     
C---- COMPUTE NORMALIZATION COEFFICIENT                                 
C--                                                                     
      RNORML = 80.0 / FLOAT( MAX )                                      
C--                                                                     
C---- SCALE EACH ELEMENT AND PLOT HISTOGRAM                             
C--                                                                     
      DO 800 I = 1,50                                                   
         IVAL = ERROR(I) * RNORML + 1                                   
         PERCNT = ( FLOAT( ERROR(I) ) / FLOAT( ITOTAL ) ) * 100.        
         IF ( I .GT. 1 ) GO TO 400                                      
            WRITE (IPRNTR,300) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)   
  300       FORMAT (/,5X,'-0.50',2X,I7,3X,F5.1,3X,'+',90A1)             
            GO TO 800                                                   
  400    IF ( I .NE. MIDDLE ) GO TO 600                                 
            WRITE (IPRNTR,500) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)   
  500       FORMAT (5X,' 0.00',2X,I7,3X,F5.1,3X,'+',90A1)               
            GO TO 800                                                   
  600    WRITE (IPRNTR,700) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)      
  700    FORMAT (12X,I7,3X,F5.1,3X,'I',90A1)                            
  800    CONTINUE                                                       
C                                                                       
      WRITE (IPRNTR,900) ITOTAL                                         
  900 FORMAT (5X,'+0.50',2X,'      0',3X,'  0.0',3X,'+*',/,12X,         
     *        '-------',/,4X,'TOTAL = ',I7)                             
C--                                                                     
C---- GET OUTTA HERE !!!!                                               
C--                                                                     
      IF ( NMBR .EQ. 6 ) WRITE(IPRNTR,1000)                             
 1000 FORMAT ('1')                                                      
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE RDCARD ( KARD, ITYPE, HDRLEN, IFOLD, IBTWN, IPLOT,     
     *           METRIC, IHEAD, WDEPTH, MINWD, MAXWD, MAIP1, NTRACE )   
C********************************************************************** 
C                                                                       
C     SUBROUTINE NAME: READCD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE RDCARD READS INPUT CARDS AND SENDS THEM TO         
C         APPROPRIATE DECODING ROUTINES.                                
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C         ITYPE  - POINTER FOR CARD OPTION ARRAY                        
C         HDRLEN - LINE HEADER LENGTH                                   
C         IFOLD  - FOLD OF LINE                                         
C         IBTWN  - SOURCE LOCATION FLAG                                 
C         IPLOT  - PLOT DIRECTION FLAG                                  
C         LHEAD  - LINE HEADER ARRAY (LOGICAL)                          
C         WDEPTH - WATER DEPTH ARRAY                                    
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    
C         MAIP1  - FLAG TO SEE IF 1MAIP CARD INPUT                      
C         NTRACE - NUMBER OF TRACES PER RECORD                          
C                                                                       
C***********************************************************************
C                                                                       
	character*8 TJOBID
C                                                                       
      REAL    * 4 WDEPTH(12000), DIST(8192), DSTNCE(2,5000),            
     *            JCSTAT, BEGIN(8192), FINISH(8192)                     
C                                                                       
      INTEGER  CHOICE(6), IHEAD(*), CC1,
     *            BOUNDS(3,5000), HDRLEN, RIPSRC, luout,
     *            RECORD, SPNUM1, SPINC
      CHARACTER*1 PKARD(35)
	character*80 KARD
C                                                                       
      INTEGER  METRIC
cmam  INTEGER * 2 METRIC                                                
C                                                                       
      LOGICAL     INDEX, WTRCRD, INPUT, FELDCD, DSTCRD, CONVEN,
     *            MOOVUP, HISTGR, CBLCRD, REREAD, MAIP1
C                                                                       
      DATA CHOICE /'MAIP','FLDH','WATR','CABL','MOOV','DSTN'/,          
     *     INPUT/.FALSE./, REREAD/.FALSE./                              
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C--                                                                     
C---- READ CARD...                                                      
C--                                                                     
	if(REREAD) then
	   read(KARD,102) CC1, KARDID, (PKARD(J),J=1,35)
  102 format(I1,A4,5X,35A1)
	else
      READ(IREADR,100,END=1100) KARD, CC1, KARDID,                      
     *                         (PKARD(J),J=1,35)                        
  100 FORMAT (A80,T1,I1,A4,5X,35A1)                                     
	endif

      REREAD = .FALSE.                                                  
      IF ( .NOT. INPUT ) CALL WRCARD ( KARD, 2, IPRNTR )                
      INPUT = .TRUE.                                                    
C                                                                       
      DO 200 I = 1,6                                                    
         ITYPE = I                                                      
         IF ( KARDID .EQ. CHOICE(I) ) GO TO 300                         
  200    CONTINUE                                                       
C--                                                                     
C---- CALL APPROPRIATE READING ROUTINE..                                
C---- IF A DIST CARD, READ LATER...                                     
C--                                                                     
  300 GOTO (500,600,700,800,1200,1300), ITYPE                           
C                                                                       
      CALL WRCARD ( KARD, 3, IPRNTR )                                   
      WRITE(IPRNTR,400)                                                 
  400 FORMAT (/13X,'** M0500 ** ERROR DETECTED IN SUBROUTINE READCD:',  
     *        /25X,'THE PRECEDING CARD IS AN INVALID INPUT CARD TO',    
     *        /25X,'PROGRAM MAIP.  VERIFY CARD INPUT AND RESUBMIT.',/)  
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
  500 CALL MODECD ( KARD, CC1, METRIC, IPLOT, IBTWN, IFOLD, IHEAD,      
     *              MAIP1 )                                             
      RETURN                                                            
C--                                                                     
C---- READ FIELD HISTORY CARDS...                                       
C--                                                                     
  600 CALL FLDHCD ( KARD, HDRLEN, CC1, PKARD, IHEAD )
      FELDCD = .TRUE.                                                   
      RETURN                                                            
C--                                                                     
C---- READ WATER DEPTH CARDS...                                         
C--                                                                     
  700 CALL WATRCD ( KARD, WDEPTH, MINWD, MAXWD )                        
      WTRCRD = .TRUE.                                                   
      RETURN                                                            
C--                                                                     
C---- READ CABLE DEPTH CARDS...                                         
C--                                                                     
  800 IF ( .NOT. CBLCRD ) GO TO 1000                                    
      CALL WRCARD ( KARD, 3, IPRNTR )                                   
      WRITE(IPRNTR,900)                                                 
  900 FORMAT (/,13X,'** M0501 ** ERROR DETECTED IN SUBROUTINE RDCARD:', 
     *        /,25X,'IF CABLE DEPTH (NCABL) CARDS ARE INPUT, THEY MUST',
     *        /,25X,'ALL BE INPUT SIMULTANEOUSLY IN A GROUP.  VERIFY',  
     *        /,25X,'THIS CONDITION AND RESUBMIT.',/)                   
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
 1000 CALL CABLCD ( KARD, TJOBID, KARDID, NTRACE )                      
      CBLCRD = .TRUE.                                                   
C--                                                                     
C---- BECAUSE OF THE WAY CABLCD WORKS,                                  
C---- WE HAVE THE NEXT DATA CARD IN MEMORY.                             
C---- WE WILL NEED TO CALL STRING TO REREAD                             
C---- IT BECAUSE OF THE WAY RDCARD WORKS...                             
C--                                                                     
      REREAD = .TRUE.                                                   
      RETURN                                                            
C                                                                       
 1100 ITYPE = 0                                                         
      GO TO 1500                                                        
C--                                                                     
C---- READ MOVEUP CARDS...                                              
C--                                                                     
 1200 CALL MOOVCD ( KARD )                                              
      MOOVUP = .TRUE.                                                   
      RETURN                                                            
C                                                                       
 1300 DSTCRD = .TRUE.                                                   
C--                                                                     
C---- SET GROUP INTERVAL INITIALLY                                      
C--                                                                     
      IF ( GIINT .GT. 0.0 ) GO TO 1400                                  
C--                                                                     
C---- DEFAULT THE GROUP INDEXING INTERVAL..                             
C--                                                                     
         FAKE = ABS (RECINT - SRCINT)                                   
         IF ( RECINT .LE. SRCINT                                        
     *               .AND. RECINT .LE. FAKE ) GIINT = RECINT            
         IF ( SRCINT .LE. RECINT                                        
     *               .AND. SRCINT .LE. FAKE ) GIINT = SRCINT            
         IF ( FAKE   .LE. RECINT                                        
     *               .AND. FAKE .LE. SRCINT ) GIINT = FAKE              
         IF ( FAKE .EQ. 0. ) GIINT = RECINT                             
C--                                                                     
C---- DO WE NEED TO DEFAULT DI INTERVAL ???                             
C--                                                                     
 1400 IF ( DIINT .GT. 0.0 ) GO TO 1500                                  
C                                                                       
           DIINT = GIINT                                                
           IF ( ( RECINT * 0.5 ) .LT. GIINT ) DIINT = RECINT * 0.5      
C                                                                       
 1500 CALL PRNTEM ( METRIC, IPLOT, IBTWN, IFOLD )                       
C--                                                                     
C---- READ DISTANCE CARDS, IF INPUT....                                 
C--                                                                     
      IF ( DSTCRD ) CALL DISTRD ( RECORD, KARD, NTRACE )                
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE MODECD ( KARD, CC1, METRIC, IPLOT, IBTWN, IFOLD,       
     *                    IHEAD, MAIP1 )                                
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: MODECD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R.WILSON AND E. ANDES                                     
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE MODECD READS IN JOB CONSTANT INFORMATION           
C         FROM 1MAIP, 2MAIP, AND 3MAIP CARDS (IF INPUT).                
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C         CC1    - VALUE IN CC 1                                        
C         METRIC - METRIC FLAG                                          
C         IPLOT  - PLOT DIRECTION                                       
C         IBTWN  - SOURCE LOCATION FLAG                                 
C         IFOLD  - FOLD OF LINE                                         
C         LHEAD  - LINE HEADER ARRAY (LOGICAL)                          
C         MAIP1  - FLAG TO SEE IF 1MAIP CARD INPUT                      
C                                                                       
C***********************************************************************
C                                                                       
#include <save_defs.h>
#include <f77/sisdef.h>
      character  * 8 TJOBID, CJOBID, BLANK8
        character*6 CREW
        character*8 DATE, pcheck
        character*8 LINUM
        character*10 pname
        character*4 direct
C                                                                       
      REAL    * 4 JCSTAT, DIST(8192), DSTNCE(2,5000),                   
     *            BEGIN(8192), FINISH(8192)                             
C                                                                       
      INTEGER   IHEAD(*), CC1, RIPSRC, SPNUM1, SPINC,
     *            BOUNDS(3,5000), WATVEL, FCDP, luout
C                                                                       
      INTEGER METRIC
cmam  INTEGER * 2 METRIC                                                
C                                                                       
	character*80 KARD
      character * 1 CJOB(8)
      LOGICAL   MAIP1, MAIP2, MAIP3, CONVEN,
     *              INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP,
     *              HISTGR, CBLCRD
C                                                                       
C                                                                       
      EQUIVALENCE ( CJOB(1), CJOBID )                                   

      DATA MAIP2/.FALSE./, MAIP3/.FALSE./, BLANK4/'    '/,              
     *     BLANK8/'        '/, PNAME/'          '/
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C--                                                                     
C---- PRINT WHAT WE GOT....                                             
C--                                                                     
      CALL WRCARD ( KARD, 3, IPRNTR )                                   
      CALL MOVE ( 2, CJOB, 0, 8 )                                       
C--                                                                     
C---- GO TO APPROPRIATE CARD READ...                                    
C--                                                                     
      GO TO (200,800,1100), CC1                                         
C                                                                       
      WRITE(IPRNTR,100)                                                 
  100 FORMAT (/13X,'** M0600 ** ERROR DETECTED IN SUBROUTINE MODECD:',  
     *        /25X,'THE PRECEDING MAIP CARD HAS AN INVALID ENTRY',      
     *        /25X,'IN CC 1.  VALID ENTRIES FOR MAIP CARDS ARE ',       
     *             '1, 2, OR 3.',/)                                     
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
  200 IF ( .NOT. MAIP1 ) GO TO 400                                      
C                                                                       
      WRITE(IPRNTR,300) CC1, CC1                                        
  300 FORMAT (/,13X,'** M0601  ** ERROR DETECTED IN SUBROUTINE MODECD:',
     *        /,25X,'THE MAXIMUM NUMBER OF ',I1,'MAIP CARDS ALLOWED',   
     *        /,25X,'PER PROGRAM EXECUTION IS ONE.  LIMIT THE NUMBER',  
     *        /,25X,'OF ',I1,'MAIP CARDS TO ONE AND RESUBMIT.',/)       
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
  400 MAIP1 = .TRUE.                                                    
      READ(KARD,500) CARDID, MODE, INDECS, METRIC, IPLOT, IHIST,        
     *             RECINT, SRCINT, SPNUM1, SPINC,                       
     *             RIPSRC, (CJOB(I),I=2,8)                              
  500 FORMAT (1X,A4,5I1,2F10.0,I5,2X,I3,3X,I2,23X,7A1)                  
C--                                                                     
C---- CHECK FOR NEGATIVE SOURCE POINT ID                                
C--                                                                     
      IF ( SPNUM1 .GE. 0 ) GO TO 575                                    
         WRITE(IPRNTR,550)                                              
  550 FORMAT (/,13X,'** M0602 ** ERROR DETECTED IN SUBROUTINE MODECD:', 
     *        /,25X,'FIRST RECORD SOURCE ID IS INVALID ON 1MAIP CARD',  
     *        /,25X,'ID MUST BE GREATER THAN ZERO.  CORRECT AND',       
     *        /,25X,'RESUBMIT.',/)                                      
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
C---- CHECK JOB NUMBER                                                  
C--                                                                     
  575 continue

      IF ( CJOBID .EQ. TJOBID ) GO TO 700                               
C                                                                       
      WRITE(IPRNTR,600) CC1, CC1, (CJOB(I),I=1,8), TJOBID               
  600 FORMAT (/,13X,'** M0603 ** WARNING IN SUBROUTINE MODECD:',        
     *        /,25X,'JOB IDENTIFICATION NUMBER OF THE ',I1,'MAIP CARD', 
     *        /,25X,'(CC 69-75), DOES NOT MATCH THE JOB',               
     *        /,25X,'IDENTIFICATION NUMBER ON THE INPUT TAPE.',         
     *        /,25X,I1,'MAIP CARD: ',8A1,                               
     *        /,25X,  'INPUT TAPE: ', A8,/)                             
C--                                                                     
C---- SET PARMS FOR FUTURE CHECKING....                                 
C--                                                                     
  700 IF ( MODE .NE. 1 ) MODE   = 0                                     
      IF ( MODE .NE. 1 ) CONVEN = .TRUE.                                
C--                                                                     
C---- SET SOME DEFAULTS....                                             
C--                                                                     
      IF ( SPNUM1 .LE. 0 ) SPNUM1 = 1                                   
      IF ( SPINC  .EQ. 0 ) SPINC  = 1                                   
      IF ( RIPSRC .LE. 0 ) RIPSRC = 1                                   
      IF ( IPLOT  .NE. 1 ) IPLOT  = 0                                   
      IF ( METRIC .NE. 1 ) METRIC = 0                                   
      IF ( INDECS .NE. 0 ) INDEX  = .FALSE.                             
      IF ( IHIST  .EQ. 1 ) HISTGR = .FALSE.                             
      RETURN                                                            
C--                                                                     
C-- THE 2MAIP CARD IS OPTIONAL..                                        
C-- ONLY ONE IS ALLOWED...                                              
C--                                                                     
  800 IF ( .NOT. MAIP2 ) GO TO 900                                      
C                                                                       
cmam  write(0,*)'More than 1 1MAIP card -- FATAL'
      WRITE(IPRNTR,300) CC1, CC1                                        
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
  900 MAIP2 = .TRUE.                                                    
      READ(KARD,1000) IFOLD, GIINT, DIINT, OFFSET, JCSTAT,              
     *             IBTWN, (CJOB(I),I=2,8), WATVEL                       
 1000 FORMAT (6X,I4,4F10.0,14X,I1,3X,7A1,1X,I4)                         
C                                                                       
      IF ( IBTWN  .NE. 1 ) IBTWN  = 0                                   
C--                                                                     
C---- CHECK JOB NUMBER                                                  
C--                                                                     
      IF ( CJOBID .EQ. TJOBID ) RETURN                                  
C                                                                       
      WRITE(IPRNTR,600) CC1, CC1, (CJOB(I),I=1,8), TJOBID               
	return
c     CALL LBCLOS ( luin )
c     CALL LBCLOS ( luout )
c     CALL CCEXIT ( 100 )                                               
C--                                                                     
C-- THE 3MAIP CARD IS OPTIONAL..                                        
C-- ONLY ONE IS ALLOWED...                                              
C--                                                                     
 1100 IF ( .NOT. MAIP3 ) GO TO 1200                                     
C                                                                       
      WRITE(IPRNTR,300) CC1, CC1                                        
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
 1200 MAIP3 = .TRUE.                                                    
c     CALL STRING ( KARD, 80 )                                          
c     READ(99,1300) CREW, (PNAME(J),J=1,10),                            
      READ(KARD,1300) CREW, PNAME,
     *              DATE, LINUM(2:8), DIRECT, PCHECK
 1300 FORMAT (    14X,A6,      A10,
     *             2X,A8, 3X,A7, 1X,A4, T23,A8 )
C--                                                                     
C---- STUFF GOOD INFO IF INPUT...                                       
	call savelu('CrwNam',ifmtcn,l_CrwNam,lengcn,LINHED)
	call savelu('PrcDat',ifmtpd,l_PrcDat,lengpd,LINHED)
	call savelu('OACLin',ifmtol,l_OACLin,lengol,LINHED)
	call savelu('LinDir',ifmtld,l_LinDir,lengld,LINHED)
	call savelu('PrcNam',ifmtpn,l_PrcNam,lengpn,LINHED)
C--                                                                     
        if(crew .ne. '      ') 
     *      call savew2(ihead,ifmtcn,l_CrwNam,lengcn,crew,LINHED)
        if(date .ne. '        ') 
     *      call savew2(ihead,ifmtpd,l_PrcDat,lengpd,date,LINHED)
        if(linum(2:8) .ne.'       ') then
                linum(1:1) = ' '
           call savew2(ihead,ifmtol,l_OACLin,lengol,linum,LINHED)
        endif
        if(direct .ne. '    ')
     *      call savew2(ihead,ifmtld,l_LinDir,lengld,direct,LINHED)
        if(pname .ne. '          ')
     *      call savew2(ihead,ifmtpn,l_PrcNam,lengpn,pname,LINHED)
C                                                                       
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE FLDHCD ( KARD, HDRLEN, CC1, PKARD, IHEAD )
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: FLDHCD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE FLDHCD INSERTS FIELD HISTORY INTO THE              
C         LINE HEADER.                                                  
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C         HDRLEN - LENGTH OF LINE HEADER                                
C         CC1    - VALUE IN CC 1                                        
C         PKARD  - PORTION OF CARD IMAGE (CC 11-45)                     
C                                                                       
C***********************************************************************
C                                                                       
      REAL    * 4 DIST(8192), DSTNCE(2,5000),                           
     *            BEGIN(8192), FINISH(8192)                             
C                                                                       
      INTEGER   IHEAD( *), CC1, HDRLEN,
     *            BOUNDS(3,5000), LENG2
      CHARACTER*1 PKARD(35)
	character*80 KARD
C                                                                       
      LOGICAL     DELFLD                                                
C                                                                       
      DATA  DELFLD/.TRUE./                                              
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C--                                                                     
C---- DISPLAY CARD...                                                   
      CALL WRCARD ( KARD, 3, IPRNTR )                                   
C--                                                                     
C---- FIRST TIME THROUGH DELETE..                                       
      IF ( DELFLD ) CALL DEFLDH ( IHEAD, HDRLEN, IHEAD )                
      DELFLD = .FALSE.                                                  
C                                                                       
      IF ( CC1 .NE. 1 ) WRITE(IPRNTR,100) CC1                           
  100 FORMAT (/13X,'** M0700 ** WARNING FROM SUBROUTINE FLDHCD:',       
     *        /25X,'THE CARD NUMBER IDENTIFIER (CC 1) IS INCORRECT.',   
     *        /25X,'THE CARD CONTAINS A ',I1,' BUT IT SHOULD HAVE',     
     *        /25X,'BEEN A 1.  VERIFY CARD INPUT IS CORRECT.',/)        
C                                                                       
      I = LENG2 ( PKARD, 35 )
      IF ( I .LT. 1 ) I = 1                                             
      CALL INFLDH ( IHEAD, HDRLEN, PKARD, I, IHEAD )                    
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE WATRCD ( KARD, WDEPTH, MINWD, MAXWD )                  
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: WATRCD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE WATRCD READS IN SOURCE POINT ORIENTED WATER        
C         DEPTHS AND STORES THEM.                                       
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C         WDEPTH - WATER DEPTH ARRAY                                    
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    
C                                                                       
C***********************************************************************
C                                                                       
      character * 8 TJOBID, CJOBID
C                                                                       
      REAL    * 4 DIST(8192), WDEPTH(12000), DEEP(4), DSTNCE(2,5000),   
     *            BEGIN(8192), FINISH(8192)                             
C                                                                       
      INTEGER  SPOINT(4), BOUNDS(3,5000),
     *            luout, SPNUM1, SPINC, RIPSRC
C                                                                       
      character * 1 CJOB(8)
	character*80 KARD
	integer*4 iminwd, imaxwd
	save iminwd, imaxwd
C                                                                       
      EQUIVALENCE ( CJOB(1), CJOBID )                                   
C                                                                       
      DATA  NCARDS/0/
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH

C--                                                                     
C---- DISPLAY CARD...                                                   
C--                                                                     
      CALL WRCARD ( KARD, 3, IPRNTR )                                   
C--                                                                     
C---- READ CARD...                                                      
C--                                                                     
      CALL MOVE ( 2, CJOB, 0, 8 )                                       
      READ(KARD,100) NCHECK, (SPOINT(I),I=1,4),                         
     *                 (CJOB(J),J=2,8)
  100 FORMAT (I1,4X,4(I5,10X),T69,7A1)
      write(IPRNTR,100) NCHECK, (SPOINT(I),I=1,4),
     *                 (CJOB(J),J=2,8)
C                                                                       
      NCARDS = NCARDS + 1                                               
C                                                                       
      IF ( NCHECK .NE. 1 ) WRITE(IPRNTR,200) NCHECK                     
  200 FORMAT (/13X,'** M0800 ** WARNING FROM SUBROUTINE WATRCD:',       
     *        /25X,'THE CARD NUMBER IDENTIFIER (CC 1) IS INCORRECT.',   
     *        /25X,'THE CARD CONTAINS A ',I1,' BUT IT SHOULD HAVE',     
     *        /25X,'BEEN A 1.  VERIFY CARD INPUT IS CORRECT.',/)        
C                                                                       
      IF ( NCARDS .LE. 3000 ) GO TO 400                                 
C                                                                       
      WRITE(IPRNTR,300)                                                 
  300 FORMAT (/13X,'** M0801 ** ERROR DETECTED IN SUBROUTINE WATRCD:',  
     *        /25X,'PROGRAM MAIP WILL ACCEPT A MAXIMUM OF 3000 1WATR',  
     *        /25X,'CARDS PER PROGRAM EXECUTION.  THIS MAXIMUM HAS',    
     *        /25X,'BEEN EXCEEDED.  REDUCE THE NUMBER OF 1WATR CARDS',  
     *        /25X,'AND RESUBMIT.',/)                                   
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
C---- CHECK JOB NUMBER                                                  
C--                                                                     
  400 continue

      IF ( CJOBID .NE. TJOBID )                                         
     *            WRITE(IPRNTR,500) (CJOB(I),I=1,8), TJOBID             
  500 FORMAT (/,13X,'** M0802 ** WARNING FROM SUBROUTINE WATRCD:',      
     *        /,25X,'JOB IDENTIFICATION NUMBER OF THE 1WATR CARD',      
     *        /,25X,'(CC 69-75), DOES NOT MATCH THE JOB',               
     *        /,25X,'IDENTIFICATION NUMBER ON THE INPUT TAPE.',         
     *        /,25X,'1WATR CARD: ',8A1,                                 
     *        /,25X,'INPUT TAPE: ', A8,/)                               
C--                                                                     
C---- TRAP MIN AND MAX WATER DEPTH....                                  
C--                                                                     
      DO 600 J = 1,4                                                    
         IF (   SPOINT(J) .LE. 0   ) GO TO 600                          
         IF ( SPOINT(J) .LT. MINWD ) MINWD = SPOINT(J)                  
         IF ( SPOINT(J) .GT. MAXWD ) MAXWD = SPOINT(J)                  
  600 CONTINUE                                                          
	iminwd = MINWD
	imaxwd = MAXWD
C                                                                       
      WRITE(IDISKW,700) KARD                                            
  700 FORMAT(A80)                                                       
C                                                                       
      RETURN                                                            
C--                                                                     
C---- WSTUFF PUTS WATER DEPTHS IN TABLE...                              
C--                                                                     
      ENTRY WSTUFF ( WDEPTH )                                           
C                                                                       
            ENDFILE IDISKW                                              
            REWIND  IDISKW                                              
C--                                                                     
C---- READ CARD FROM DISK...                                            
C--                                                                     
c 800 CALL MOVE ( 2, CJOB, 0, 8 )                                       
  800 continue
      READ(IDISKW,900,END=1100) (SPOINT(I),DEEP(I),I=1,4)               
  900 FORMAT (5X,4(I5,F10.0))                                           
C--                                                                     
C---- STUFF WATER DEPTHS INTO BUFFER....                                
C--                                                                     
      DO 1000 K = 1,4                                                   
         IF ( SPOINT(K) .LE. 0 ) GO TO 1000                             
         WDEPTH( SPOINT(K) - (iminwd - 1 ) ) = DEEP(K)                  
c        WDEPTH( SPOINT(K) - (MINWD - 1 ) ) = DEEP(K)                   
 1000 CONTINUE                                                          
      GO TO 800                                                         
C                                                                       
 1100 RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE CABLCD ( KARD, TJOBID, KARDID, NTRACE )                
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: CABLCD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE CABLCD READS CABLE DEPTH CARDS AND WRITES THEM     
C         TO DISK FOR LATER ACCESS.                                     
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C         TJOBID - JOB NUMBER FROM TAPE                                 
C         KARDID - CC 2-5                                               
C         NTRACE - NUMBER OF TRACES PER RECORD                          
C                                                                       
C***********************************************************************
C                                                                       
      character * 8 TJOBID, CJOBID
C                                                                       
      INTEGER * 4  CC1                                                  
C                                                                       
      character * 1 CJOB(8)
	character*80 KARD
C                                                                       
      EQUIVALENCE ( CJOB(1), CJOBID )                                   
C                                                                       
      DATA NCABL/'CABL'/
C                                                                       
      COMMON /LUNIT/ IREADR, IPRNTR, IDISKW, IDISKC

C--                                                                     
C---- IS CARD KOSHER ???                                                
C--                                                                     
  100 IF ( KARDID .EQ. NCABL ) GO TO 200                                
C                                                                       
         ENDFILE IDISKC                                                 
         REWIND  IDISKC                                                 
         GO TO 700                                                      
C                                                                       
  200 CALL WRCARD ( KARD, 3, IPRNTR )                                   
C--                                                                     
C---- REREAD CARD....                                                   
C--                                                                     
      CALL MOVE ( 2, CJOB, 0, 8 )                                       
c     CALL STRING ( KARD, 80 )                                          
c     READ(99,300) CC1, (CJOB(K),K=2,8)                                 
      READ(KARD,300) CC1, (CJOB(K),K=2,8)                               
  300 FORMAT (I1,T69,7A1)                                               
C--                                                                     
C---- RIGHT JOB NUMBER ???                                              
C--                                                                     
c     call stoflt(CJOB,CJOBID)

      IF ( CJOBID .NE. TJOBID )                                         
     *            WRITE(IPRNTR,400) CC1, CC1, (CJOB(I),I=1,8), TJOBID   
  400 FORMAT (/,13X,'** M0900 ** WARNING FROM SUBROUTINE CABLCD:',      
     *        /,25X,'JOB IDENTIFICATION NUMBER OF THE ',I1,'CABL CARD', 
     *        /,25X,'(CC 69-75), DOES NOT MATCH THE JOB',               
     *        /,25X,'IDENTIFICATION NUMBER ON THE INPUT TAPE.',         
     *        /,25X, I1,'CABL CARD: ',8A1,                              
     *        /,25X,'INPUT TAPE: ', A8,/)                               
C--                                                                     
C---- WRITE IT OUT AND READ ANOTHER...                                  
C--                                                                     
      WRITE (IDISKC,500) KARD                                           
  500 FORMAT(A80)                                                       
      READ(IREADR,600) KARDID, KARD                                     
  600 FORMAT (1X,A4,T1,A80)                                             
      GO TO 100                                                         
C                                                                       
  700 RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE MOOVCD ( KARD )                                        
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: MOOVCD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE MOOVCD READS IN RECORD VARIABLE SOURCE MOVEUPS.    
C         THE MOVEUP VALUE ENTERED WILL OVERRIDE THE SOURCE INTERVAL    
C         ENTERED ON THE 1MAIP CARD FOR THE RECORD BOUNDARIES GIVEN     
C         ON THE 1MOOV CARD(S).                                         
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         KARD   - CARD IMAGE                                           
C                                                                       
C***********************************************************************
C                                                                       
#include <f77/lhdrsz.h>
      REAL    * 4 DIST(8192), DSTNCE(2,5000), BEGIN(8192), FINISH(8192) 
C                                                                       
      INTEGER BOUNDS(3,5000), CC1, luout
	character*80 KARD
C                                                                       
cmam ... 052093 ... potential error on cray.........
	character*4 IPOOP, IBLANK
	data iblank/'    '/
      DATA IPOINT/1/,  BLANK/-99999.99/
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
	save
C                                                                       
      IF ( IPOINT .NE. 1 ) GO TO 100                                    
           CALL MOVE ( 0, DSTNCE, 0., 10000*SZSMPD )                    
           CALL MOVE ( 0, BOUNDS, 0 , 15000*SZSMPD )                    
C--                                                                     
C---- DISPLAY CARD...                                                   
C--                                                                     
  100 CALL WRCARD ( KARD, 3, IPRNTR )                                   
C                                                                       
      READ(KARD  ,200) CC1, BOUNDS(1,IPOINT), BOUNDS(2,IPOINT),         
     *                 BOUNDS(3,IPOINT),DSTNCE(1,IPOINT),               
     *                 DSTNCE(2,IPOINT), IPOOP
  200 FORMAT (I1,4X,3I5,2F10.0,T27,A4)
C                                                                       
      IF ( CC1 .NE. 1 ) WRITE(IPRNTR,300) CC1                           
  300 FORMAT (/13X,'** M1000 ** WARNING FROM SUBROUTINE MOOVCD:',       
     *        /25X,'THE CARD NUMBER IDENTIFIER (CC 1) IS INCORRECT.',   
     *        /25X,'THE CARD CONTAINS A ',I1,' BUT IT SHOULD HAVE',     
     *        /25X,'BEEN A 1.  VERIFY CARD INPUT IS CORRECT.',/)        
C                                                                       
      IF ( IPOINT .LE. 5000 ) GO TO 500                                 
C                                                                       
      WRITE(IPRNTR,400)                                                 
  400 FORMAT (/13X,'** M1001 ** ERROR DETECTED IN SUBROUTINE MOOVCD:',  
     *        /25X,'PROGRAM MAIP WILL ACCEPT A MAXIMUM OF 5000 MOOV',   
     *        /25X,'CARDS PER PROGRAM EXECUTION.  THIS MAXIMUM HAS',    
     *        /25X,'BEEN EXCEEDED.  REDUCE THE NUMBER OF MOOV CARDS',   
     *        /25X,'AND RESUBMIT.',/)                                   
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
  500 IF ( BOUNDS(1,IPOINT) .NE. 0                                      
     *             .AND. BOUNDS(2,IPOINT) .NE. 0 ) GO TO 700            
      WRITE(IPRNTR,600)                                                 
  600 FORMAT (/13X,'** M1002 ** ERROR DETECTED IN SUBROUTINE MOOVCD:',  
     *        /25X,'THE FIRST (CC 6-10) AND LAST (CC 11-15) RECORD',    
     *        /25X,'ENTRIES CAN NOT BE LEFT BLANK OR 0.  VERIFY',       
     *        /25X,'CARD INPUT AND RESUBMIT.',/)                        
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C                                                                       
  700 IF ( BOUNDS(3,IPOINT) .GE. 0 ) GO TO 900                          
      WRITE(IPRNTR,800)                                                 
  800 FORMAT (/13X,'** M1003 ** WARNING FROM SUBROUTINE MOOVCD:',       
     *        /25X,'THE FIRST RECORD SOURCE ID ON 1MOOV CARD IS LESS',  
     *        /25X,'THAN ZERO.  PARAMETER WILL NOT BE USED.'/)          
  900 IF ( IPOOP .EQ. IBLANK ) DSTNCE(1,IPOINT) = BLANK                 
C                                                                       
      IPOINT = IPOINT + 1                                               
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      INTEGER FUNCTION SPSET ( SOURCE, DELTA, LIMIT, TRUESP, FRSTSP )   
C***********************************************************************
C                                                                       
C     FUNCTION NAME: SPSET                                              
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         FUNCTION SPSET ASSIGNS HALF WORD 108.                         
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         SOURCE - DISTANCE FROM ORIGIN                                 
C         DELTA  - LABELING INTERVAL                                    
C         LIMIT  - AMOUNT OF SLOP FOR LABELING                          
C         TRUESP - FLOATING POINT SOURCE POINT AT ANY LOCATION          
C         FRSTSP - LOCATION OF FIRST SOURCE ON LINE                     
C                                                                       
C***********************************************************************
C                                                                       
      character * 8 TJOBID
C
      REAL * 4 SOURCE, LIMIT, ERROR   
C                                                                       
      INTEGER * 4 SPNUM1, SPINC, RIPSRC, ASSIGN                         
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/ luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
C--                                                                     
C---- COMPUTE DISTANCE FROM FIRST SOURCE POINT AND BIAS BY ONE          
C---- SOURCE POINT LABELING INTERVAL.                                   
C--                                                                     
      ADJUST = SOURCE - FRSTSP + DELTA                                  
C--                                                                     
C---- GET SOURCE POINT OVER THIS DI...                                  
C--                                                                     
      SPSET = ASSIGN ( ADJUST, DELTA, 0, DUMMY ) 
C--                                                                     
C---- IS IT VALID ???                                                   
C--                                                                     
      IF ( SPSET .GT. 0 ) GO TO 100                                     
           SPSET  = 0                                                   
           TRUESP = SPNUM1                                              
           RETURN                                                       
C--                                                                     
C-- COMPUTE REAL ERROR IN SOURCE POINT LABEL INDEX ASSIGNMENT           
C--                                                                     
  100 ERROR = ADJUST / DELTA - FLOAT(SPSET)                             
C--                                                                     
C---- COMPUTE AND RETURN SOURCE POINT LABEL                             
C---- ASSOCIATED WITH THIS POSITION...                                  
C---- DETERMINE REAL SOURCE POINT LABELING                              
C---- INDEX TOO, EVEN BETWEEN TWO LABELED SOURCE POINTS....             
C--                                                                     
      SPSET  = SPNUM1 + ( SPSET - 1 ) * SPINC
      TRUESP = SPSET + ( ERROR * FLOAT( SPINC ) )                       
C--                                                                     
C---- IF POSITION IS BEFORE FIRST SOURCE LABEL POSTION, RETURN          
C---- ZERO FOR A LABEL AND FIRST SOURCE POINT AS TRUESP                 
C---- ALSO NEED TO ADD AN INCREMENT OF SOURCE POINT LABEL IF            
C---- NOT A POSITIVE NUMBER...                                          
C--                                                                     
C     IF ( ABS(ERROR) .LT. LIMIT ) GO TO 150                            
      IF (( ABS(ERROR) .LT.   LIMIT ) .OR.                              
     *    (     ERROR  .EQ.   LIMIT   .AND. SPINC .GT. 0) .OR.          
     *    (     ERROR  .EQ. -(LIMIT)  .AND. SPINC .LT. 0) )             
     * GO TO 150                                                        
C                                                                       
      SPSET = 0                                                         
      IF ( TRUESP .LT. SPNUM1                                           
     *            .AND. SPINC .GT. 0 ) TRUESP = SPNUM1                  
      IF ( TRUESP .GT. SPNUM1                                           
     *            .AND. SPINC .LT. 0 ) TRUESP = SPNUM1                  
      RETURN                                                            
C                                                                       
  150 IF (SPSET .GT. 0) RETURN                                          
C                                                                       
      WRITE(IPRNTR,200) SPSET                                           
  200 FORMAT (/13X,'** M1100 ** ERROR DETECTED IN FUNCTION SPSET:',     
     *        /25X,'SOURCE POINT NUMBER ',I5,' IS LESS THAN OR',        
     *        /25X,'EQAUL TO ZERO. REENTER SOURCE ID AND SOURCE',       
     *        /25X,'POINT INCREMENT ON 1MAIP CARD.',/)                  
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE DSTUPD ( RECORD, KARD, NTRACE)                         
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: DSTUPD                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE DSTUPD CHECKS TO SEE IF THE CURRENT SET OF         
C         TRACE DISTANCES ARE VALID.  IF THEY ARE NOT, IT WILL          
C         READ IN ANOTHER SET OF DISTANCES.                             
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         RECORD - CURRENT RECORD NUMBER                                
C                                                                       
C***********************************************************************
C                                                                       
#include <f77/lhdrsz.h>
      character * 8 TJOBID, CJOBID
C                                                                       
      REAL    * 4 CDIST(4), DIST(8192), DSTNCE(2,5000),                 
     *            BEGIN(8192), FINISH(8192)                             
C                                                                       
      INTEGER * 4 TRASE(4), RECORD, BYTES, CC1, ONECHK,                 
     *            BOUNDS(3,5000), luout,
     *            SPNUM1, SPINC, RIPSRC
C                                                                       
	character*80 KARD
      CHARACTER*1 CJOB(8)
      LOGICAL     HDRFLG, RDFLAG, CONVEN, FIRST, INDEX,
     *            WTRCRD, FELDCD, DSTCRD, MOOVUP, HISTGR, CBLCRD
      LOGICAL     LRIFLG,
     *            DCHECK 
	INTEGER*4 MRI
	SAVE MRI, LRIFLG
C                                                                       
      EQUIVALENCE ( CJOB(1), CJOBID )                                   
C                                                                       
      DATA NDSTN /'DSTN'/, LASTRI/-9999/, BLANK/-99999.99/
      DATA LRIFLG /.FALSE./, DCHECK /.TRUE./
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C--                                                                     
C-- IF WE HAVE DISTANCES FOR THIS RECORD, LEAVE...                      
C--                                                                     
      MRI = 0                                                           
C                                                                       
  100 IF ( RECORD .LE. LASTRI ) RETURN                                  
      GO TO 200                                                         
C--                                                                     
C-- IF READING NEXT SET OF TRACE DISTANCES,                             
C-- RESET SOME STUFF..                                                  
C--                                                                     
C---- THIS IS FOR VERY FIRST DSTN CARD ONLY....                         
      ENTRY DISTRD ( RECORD, KARD, NTRACE )                             
      FIRST  = .TRUE.                                                   
C--                                                                     
C---- HDRFLG IS TO INDICATE FIRST DSTN CARD OF A SET...                 
C---- RDFLAG INDICATES A DISTANCE HAS BEEN READ FOR THE LAST TRACE      
C---- OF A RECORD....                                                   
C--                                                                     
  200 HDRFLG = .FALSE.                                                  
      RDFLAG = .TRUE.                                                   
      ONECHK = 0                                                        
      CALL MOVE ( 2, CJOB, 0, 8 )                                       
C--                                                                     
C---- READ A CARD...                                                    
C--                                                                     
c     IF ( FIRST ) CALL STRING ( KARD, 80 )                             
C                                                                       
  300 if(FIRST) then
	read(KARD,402,END=2000) CC1,KARDID,(TRASE(I),CDIST(I),I=1,4),
     *	    (CJOB(K),K=2,8), LRI
  402 FORMAT (I1,A4,4(1X,I4,F10.0),3X,7A1,I5)                           
      else
      READ(IREADR,400,END=2000) CC1, KARDID, (TRASE(I),CDIST(I),I=1,4), 
     *                          (CJOB(K),K=2,8), LRI, KARD              
  400 FORMAT (I1,A4,4(1X,I4,F10.0),3X,7A1,I5,T1,A80)                    
      endif
C--                                                                     
C---- CHECK PARAMETERS ON DISTANCE CARDS...                             
C--                                                                     
      IF ( LRI .EQ. 0 ) LRI = 99999                                     
                                                                        
      IF ( MRI .EQ. 0 ) MRI = LRI                                       
      IF ( TRASE(1) .NE. 1 .AND. LRI .NE. MRI ) GO TO 2200              
                                                                        
      IF ( LRI .NE. MRI .AND. .NOT. LRIFLG ) GO TO 2200                 
      IF ( MRI .NE. LRI ) LRIFLG = .FALSE.                              
      IF ( MRI .NE. LRI ) MRI = LRI                                     
                                                                        
C--                                                                     
C---- SET UP TRACE DISTANCE BUFFER FOR INTERPOLATION...                 
C--                                                                     
      IF ( HDRFLG ) GO TO 500                                           
      BYTES = ( NTRACE * SZSMPD ) - SZSMPD                              
      DIST(1) = BLANK                                                   
	call vfill(BLANK, DIST, 1, NTRACE)
C--                                                                     
C---- WAS LAST RECORD BLANK ???                                         
C--                                                                     
  500 continue
      IF ( CJOBID .EQ. TJOBID ) GO TO 700                               
C                                                                       
      IF ( .NOT. HDRFLG ) CALL WRCARD ( KARD, 1, IPRNTR )               
      IF     ( HDRFLG )   CALL WRCARD ( KARD, 3, IPRNTR )               
      WRITE(IPRNTR,600) CC1, CC1, (CJOB(I),I=1,8), TJOBID               
  600 FORMAT (/,13X,'** M1200 ** WARNING FROM SUBROUTINE DSTUPD:',      
     *        /,25X,'JOB IDENTIFICATION NUMBER OF THE ',I1,'DSTN CARD', 
     *        /,25X,'(CC 69-75), DOES NOT MATCH THE JOB',               
     *        /,25X,'IDENTIFICATION NUMBER ON THE INPUT TAPE.',         
     *        /,25X, I1,'DSTN CARD: ',8A1,                              
     *        /,25X,'INPUT TAPE: ', A8,/)                               
C                                                                       
  700 FIRST = .FALSE.                                                   
C--                                                                     
C---- IF THIS IS FIRST DSTN CARD, GRAB SOME STUFF..                     
C--                                                                     
      IF ( HDRFLG ) GO TO 800                                           
           HDRFLG = .TRUE.                                              
C--                                                                     
C---- PRINT IT OUT...                                                   
C--                                                                     
         CALL WRCARD ( KARD, 1, IPRNTR )                                
         LASTRI = LRI                                                   
         GO TO 900                                                      
C--                                                                     
C-- SHOW THEM THE CARD... MAKE SURE ITS OK...                           
C--                                                                     
  800 CALL WRCARD ( KARD, 3, IPRNTR )                                   
  900 IF ( KARDID .EQ. NDSTN ) GO TO 1100                               
      WRITE (IPRNTR,1000)                                               
 1000 FORMAT (/,13X,'** M1201 ** ERROR DETECTED IN SUBROUTINE DSTUPD:', 
     *        /,25X,'THE PRECEDING CARD IS INVALID INPUT TO PROGRAM',   
     *        /,25X,'MAIP.  VERIFY CARD INPUT AND RESUBMIT.',/)         
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
C---- CHECK CARD SEQUENCE COUNTER, CC1 ....                             
C--                                                                     
 1100 ONECHK = ONECHK + 1                                               
      IF ( CC1 .NE. ONECHK ) WRITE(IPRNTR,1200) CC1, ONECHK             
 1200 FORMAT (/,13X,'** M1202 ** WARNING FROM SUBROUTINE DSTUPD:',      
     *        /,25X,'THE CARD SEQUENCE NUMBER (CC 1) IS INCORRECT.',    
     *        /,25X,'THE DSTN CARD CONTAINS A ',I1,' BUT IT SHOULD',    
     *        /,25X,'HAVE BEEN A ',I1,'.  VERIFY CARD INPUT IS',        
     *        /,25X,'CORRECT.',/)                                       
C                                                                       
      IF ( ONECHK .EQ. 9 ) ONECHK = 0                                   
C--                                                                     
C---- GET TRACE DISTANCE (IF VALID) AND STASH THEM IN DISTANCE ARRAY.   
C---- WHEN TRACE 'N' IS READ, SET FLAG TO NOT READ CARDS...             
C--                                                                     
      DO 1300 I = 1,4                                                   
         IF ( TRASE(I) .EQ. NTRACE ) RDFLAG = .FALSE.                   
         IF ( .NOT. RDFLAG .AND. DCHECK ) GO TO 2200                    
            DCHECK = .FALSE.                                            
         IF ( ( TRASE(I) .LT. 1 )                                       
     *            .OR. ( TRASE(I) .GT. NTRACE ) ) GO TO 1300            
         IF ( TRASE (I) .NE. TRASE (I-1) ) GO TO 1250                   
      WRITE (IPRNTR,1225)                                               
 1225 FORMAT (//,13X,'** M1203 ** ERROR IN SUBROUTINE DSTUPD:',         
     *         /,25X,'TRACE NUMBERS ENTERED ON THE DSTN CARDS ARE',     
     *         /,25X,'INVALID.  YOU MUST BEGIN WITH THE FIRST TRACE',   
     *         /,25X,'OF THE RECORD AND END WITH THE LAST.  CORRECT',   
     *         /,25X,'PARAMETER AND RESUBMIT.',/)                       
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
                                                                        
 1250    DIST( TRASE(I) ) = CDIST(I)                                    
 1300 CONTINUE                                                          
C                                                                       
      IF ( RDFLAG ) GO TO 300                                           
C--                                                                     
C---- INTERPOLATE BETWEEN KNOWN DISTANCES....                           
C--   TO POSSIBLE SPLIT SPREAD OR OFF END CONDITIONS...                 
C--   THEN GO CHECK IF THIS FUNCTION IS OK.                             
C--                                                                     
      CALL INTERP ( DIST, 1, NTRACE )                                   
      LRIFLG = .TRUE.                                                   
C--                                                                     
C---- PRINT THEM OUT....                                                
C--                                                                     
      NROWS = ( NTRACE + 9 ) / 10                                       
      IPNT1 = 1                                                         
      IPNT2 = 10                                                        
      WRITE (IPRNTR,1400) LASTRI                                        
 1400 FORMAT (///3X,'TRACE',19X,'**** THE FOLLOWING ARE TRACE ',        
     *               'DISTANCES TO BE USED THROUGH RECORD ',I5,' ****', 
     *          /3X,'-----')                                            
      DO 1600 L = 1,NROWS                                               
         IF ( IPNT2 .GT. NTRACE ) IPNT2 = NTRACE                        
         WRITE (IPRNTR,1500) IPNT1, (DIST(M),M=IPNT1,IPNT2)             
 1500    FORMAT (4X,I4,10F12.1)                                         
         IPNT1 = IPNT1 + 10                                             
         IPNT2 = IPNT2 + 10                                             
 1600 CONTINUE                                                          
      WRITE(IPRNTR,1700)                                                
 1700 FORMAT(///)                                                       
C--                                                                     
C---- CHECK FOR SPLIT SPREAD...                                         
C--                                                                     
      IF ( CONVEN ) GO TO 100                                           
      DO 1800 I = 2,NTRACE                                              
            IF ( DIST( I - 1 ) .LT. DIST(I) ) GO TO 1900                
               DIST( I - 1 ) = -DIST( I - 1 )                           
 1800 CONTINUE                                                          
         DIST( NTRACE ) = -DIST( NTRACE )                               
 1900 GO TO 100                                                         
C--                                                                     
C---- REPORT END OF DATASET....                                         
C--                                                                     
 2000 IF ( .NOT. LRIFLG ) GO TO 2200                                    
      WRITE (IPRNTR,2100)                                               
 2100 FORMAT (//,13X,'** M1204 ** WARNING FROM SUBROUTINE DSTUPD:',     
     *         /,25X,'END OF FILE ENCOUNTERED ON INPUT CARD DATASET.'   
     *         /,25X,'THE LAST SET OF TRACE DISTANCES WILL BE USED',    
     *         /,25X,'TO THE END OF THE DATASET.',/)                    
      LASTRI = 99999                                                    
      RETURN                                                            
 2200 WRITE (IPRNTR,1225)                                               
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT (100)                                                 
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE CDEPTH ( ISTART, IEND, NTRACE )                        
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: CDEPTH                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE CDEPTH CHECKS TO SEE IF THE CURRENT SET OF         
C         CABLE DEPTHS ARE VALID.  IF THEY ARE NOT, IT WILL             
C         READ IN ANOTHER SET OF DEPTHS.                                
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         ISTART - STARTING RECORD BOUNDARY                             
C         IEND   - ENDING RECORD BOUNDARY                               
C         NTRACE - NUMBER OF TRACES PER RECORD                          
C                                                                       
C***********************************************************************
C                                                                       
#include <f77/lhdrsz.h>
      REAL    * 4 UNDER(4), DIST(8192), DSTNCE(2,5000),                 
     *            BEGIN(8192), FINISH(8192)                             
C                                                                       
      INTEGER * 4 TNUMB(4), CC1,                                        
     *            BOUNDS(3,5000), ENDRI, luout
C                                                                       
      LOGICAL     FCARD, LDEPTH, FSET, TCHECK                           
      LOGICAL     KRIFLG
C                                                                       
      DATA  ENDRI/-9999/, BLANK/-99999.99/, FSET/.TRUE./
      DATA  TCHECK/.TRUE./, KRIFLG / .FALSE. /
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C                                                                       
      LENGTH = NTRACE * SZSMPD                                          
      MRI = 0                                                           
C--                                                                     
C---- FCARD IS TO INDICATE FIRST CABL CARD OF A SET...                  
C---- LDEPTH INDICATES A DEPTH HAS BEEN READ FOR THE LAST TRACE         
C---- OF A RECORD....MOVE ENDING FUNCTION TO BEGINNING IF NEEDED...     
C--                                                                     
      IF ( FSET ) GO TO 100                                             
      CALL MOVE ( 1, BEGIN, FINISH, LENGTH )                            
      ISTART = IEND                                                     
C                                                                       
  100 FCARD  = .FALSE.                                                  
      LDEPTH = .TRUE.                                                   
C--                                                                     
C---- READ A CARD...                                                    
C--                                                                     
  200 READ(IDISKC,300,END=1000) CC1, KARDID, (TNUMB(I),UNDER(I),I=1,4), 
     *                          KRI                                     
  300 FORMAT (I1,A4,4(1X,I4,F10.0),10X,I5)                              
C                                                                       
      IF ( KRI .EQ. 0 ) KRI = 99999                                     
      IF ( TNUMB(1) .NE. 1 .AND. KRI .NE. MRI ) GO TO 1150              
C--                                                                     
C---- CHECK FOR LAST TRACE BEFORE NEW RECORD BEGINS...                  
C--                                                                     
      IF ( MRI .EQ. 0 ) MRI = KRI                                       
C                                                                       
      IF ( KRI .NE. MRI .AND. .NOT. KRIFLG ) GO TO 1150                 
C                                                                       
      IF ( MRI .NE. KRI ) KRIFLG = .FALSE.                              
      IF ( MRI .NE. KRI ) MRI = KRI                                     
C--                                                                     
C---- SET UP CABLE DEPTH BUFFER FOR INTERPOLATION...                    
C--                                                                     
      IF ( FCARD ) GO TO 400                                            
         NBYTES    = LENGTH - SZSMPD                                    
         FINISH(1) = BLANK                                              
         CALL MOVE ( 1, FINISH(2), FINISH(1), NBYTES )                  
C--                                                                     
C---- WAS LAST RECORD BLANK ???                                         
C--                                                                     
  400 IF ( ( FSET )                                                     
     *       .OR. KRI .NE. 0 ) GO TO 600                                
      WRITE (IPRNTR,500)                                                
  500 FORMAT (//,13X,'** M1300 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',
     *         /,25X,'IF MULTIPLE SETS OF NCABL CARDS ARE INPUT TO',    
     *         /,25X,'FACILITATE SPATIAL INTERPOLATION OF CABLE',       
     *         /,25X,'DEPTHS, A BLANK, ZERO, OR 99999 FOR THE RECORD',  
     *         /,25X,'NUMBER, (CC 76-80 NCABL), IS INVALID.  PLEASE',   
     *         /,25X,'VERIFY ALL RECORDS ARE VALID NON-ZERO',           
     *         /,25X,'NUMBERS AND RESUBMIT.',/)                         
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
C--                                                                     
C---- IF THIS IS FIRST CABL CARD, SET SOME STUFF..                      
C--                                                                     
  600 IF ( FCARD ) GO TO 700                                            
           FCARD = .TRUE.                                               
           ENDRI = KRI                                                  
C                                                                       
  700 DO 800 I = 1,4                                                    
         IF ( TNUMB(I) .EQ. NTRACE ) LDEPTH = .FALSE.                   
                                                                        
         IF ( .NOT. LDEPTH .AND. TCHECK ) GO TO 1100                    
            TCHECK = .FALSE.                                            
                                                                        
         IF ( ( TNUMB(I) .LT. 1 )                                       
     *            .OR. ( TNUMB(I) .GT. NTRACE ) ) GO TO 800             
         IF ( TNUMB (I) .NE. TNUMB (I-1) ) GO TO 750                    
            WRITE(IPRNTR,775) TNUMB(I), TNUMB(I-1)                      
  775 FORMAT (//,13X,'** M1350 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',
     *         /,25X,'FOR SPATIAL INTERPOLATION OF CABLE DEPTHS',       
     *         /,25X,'A MINIMUM DISTANCE OF TWO TRACES IS REQUIRED.',   
     *         /,25X,I6,' AND ',I6,' ARE NOT VALID.  CORRECT AND',      
     *         /,25X,'RESUBMIT.',/)                                     
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
  750    FINISH( TNUMB(I) ) = UNDER(I)                                  
  800 CONTINUE                                                          
C                                                                       
      IF ( LDEPTH ) GO TO 200                                           
C--                                                                     
C---- INTERPOLATE BETWEEN KNOWN DEPTHS....                              
C--                                                                     
      CALL INTERP ( FINISH, 1, NTRACE )                                 
      KRIFLG = .TRUE.                                                   
C--                                                                     
C---- NEXT BLOCK OF CODE DONE FIRST AFTER FIRST                         
C---- SET OF NCABL CARDS ONLY...                                        
C--                                                                     
      IF ( .NOT. FSET ) GO TO 900                                       
         CALL MOVE ( 1, BEGIN, FINISH, LENGTH )                         
         FSET = .FALSE.                                                 
         ISTART = ENDRI                                                 
         GO TO 100                                                      
C                                                                       
  900 IEND = ENDRI                                                      
      RETURN                                                            
C                                                                       
 1000 IF ( KRIFLG ) GO TO 1010                                          
         WRITE ( IPRNTR, 1200 )                                         
         CALL LBCLOS ( luin )
         CALL LBCLOS ( luout )
         CALL CCEXIT (0)                                                
C                                                                       
 1010 IEND = 99999                                                      
      RETURN                                                            
 1100    WRITE( IPRNTR, 1200 )  NTRACE                                  
 1150    WRITE( IPRNTR, 1200 )                                          
 1200 FORMAT (//,13X,'** M1325 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',
     *         /,25X,'FOR SPATIAL INTERPOLATION OF CABLE DEPTHS',       
     *         /,25X,'BEGIN WITH THE FIRST TRACE OF THE RECORD',        
     *         /,25X,'AND END WITH THE LAST TRACE OF THE RECORD FOR',   
     *         /,25X,'EACH SET OF CABLE CARDS.  ',I6,' IS NOT A ',      
     *         /,25X,'VALID BEGINNING POINT.  CORRECT PARAMETERS AND',  
     *         /,25X,'RESUBMIT.',/)                                     
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE INTERP ( ARRAY, IFIRST, ILAST )                        
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: INTERP                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE INTERP WILL INTERPOLATE AN ARRAY GIVEN THE         
C         FIRST AND LAST ELEMENT LOCATIONS.  BLANK ENTRIES ARE          
C         FLAGGED WITH A -99999.99 IN THEM.                             
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         ARRAY  - ARRAY TO BE INTERPOLATED                             
C         IFIRST - STARTING POSITION FOR INTERPOLATION                  
C         ILAST  - ENDING POSITION FOR INTERPOLATION                    
C                                                                       
C***********************************************************************
C                                                                       
      REAL  ARRAY(*)
C                                                                       
      DATA BLANK/-99999.99/                                             
C--                                                                     
C---- SET STARTING POSITION...                                          
C--                                                                     
      I1 = IFIRST                                                       
  100 I1 = I1 + 1                                                       
      ICOUNT = 0                                                        
C--                                                                     
C---- FIND NUMBER OF BLANKS                                             
C---- BETWEEN VALID ENTRIES...                                          
C--                                                                     
      DO 200 I = I1, ILAST                                              
         IF ( ARRAY(I) .NE. BLANK ) GO TO 300                           
         ICOUNT = ICOUNT + 1                                            
         IF ( I .EQ. ILAST ) RETURN                                     
  200 CONTINUE                                                          
C                                                                       
  300 continue
      IF ( ICOUNT .EQ. 0 ) GO TO 500                                    
C--                                                                     
C---- DETERMINE INTERPOLATION INCREMENT....                             
C--                                                                     
      SLOPE = ( ARRAY(I) - ARRAY(I1-1) ) / ( ICOUNT + 1 )               
      I2    = I - 1                                                     
C                                                                       
      DO 400 J = I1, I2                                                 
         ARRAY(J) = ARRAY(J-1) + SLOPE                                  
  400 CONTINUE                                                          
C                                                                       
  500 continue
      IF ( I1 .NE. ILAST ) GO TO 100                                    
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE UTILTY ( IREC, KARD, IBUF, MINWD, MAXWD, NTRACE,       
     *                    FSORC, WDEPTH )                               
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: UTILTY                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE UTILTY PERFORMS TASKS NOT ASSOCIATED WITH          
C         THE INDEXING PORTION OF MAIP.  IT WILL INPUT TRACE            
C         DISTANCES AND WATER DEPTHS IF NEEDED.  THIS ROUTINE           
C         IS DESIGNED FOR USE WITH SECONDARY RUNS TO CORRECT            
C         OR CHANGE INFORMATION ON TAPE.                                
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         IREC   - NUMBER OF RECORDS PROCESSED                          
C         KARD   - CARD IMAGE                                           
C         IBUF   - TRACE BUFFER                                         
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    
C         NTRACE - NUMBER OF TRACES PER RECORD                          
C         FSORC  - FIRST SOURCE POINT ON LINE FROM LINE HEADER          
C                                                                       
C***********************************************************************
C                                                                       
#include <f77/sisdef.h>
#include <save_defs.h>
      REAL    * 4 WDEPTH(12000), DIST(8192), DSTNCE(2,5000),            
     *            BEGIN(8192), FINISH(8192), INCR                       
C                                                                       
      INTEGER * 4 luout, FCDP,  RECORD, BOUNDS(3,5000),
     *            WATVEL
	character*80 KARD
C                                                                       
      INTEGER IBUF(*)
C                                                                       
      LOGICAL     WTRCRD, FELDCD, INDEX, DSTCRD, MOOVUP, CONVEN,        
     *            HISTGR, CBLCRD                                        
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C--                                                                     
      KRI = -99999                                                      
      LASTRI = 0                                                        
	call savelu('RecNum',ifmtrn,l_RecNum,lengrn,TRCHED)
	call savelu('TrcNum',ifmttn,l_TrcNum,lengtn,TRCHED)
	call savelu('StaCor',ifmtsc,l_StaCor,lengsc,TRCHED)
	call savelu('DstSgn',ifmtds,l_DstSgn,lengds,TRCHED)
	call savelu('DstUsg',ifmtdu,l_DstUsg,lengdu,TRCHED)
	call savelu('DphInd',ifmtdi,l_DphInd,lengdi,TRCHED)
C--                                                                     
C---- READ A TRACE....                                                  
C--                                                                     
  100 LENGTH = 0                                                        
      CALL RTAPE ( luin, IBUF, LENGTH )                                 
      IF ( LENGTH .EQ. 0 ) GO TO 700                                    
C                                                                       
	call saver2(ibuf,ifmtrn,l_RecNum,lengrn,krec,TRCHED)
	call saver2(ibuf,ifmttn,l_TrcNum,lengtn,ktrc,TRCHED)
      IF (ktrc .NE. 1) GO TO 150                                        
      IF (krec .NE. LASTRI) GO TO 140                                   
      WRITE (IPRNTR,130) krec                                           
  130 FORMAT(/13X,'** M0302 ** WARNING FROM SUBROUTINE UTILTY:'         
     *      ,/25X,'DUPLICATE RECORD NUMBER ', I6,' FOUND.',             
     *       /25X,'PROCESSING CONTINUES.',/)                            
  140 LASTRI = krec                                                     
  150 CONTINUE                                                          
C--                                                                     
C---- ARE TRACE DISTANCES TO BE INPUT ??                                
C--                                                                     
      IF ( .NOT. DSTCRD ) GO TO 300                                     
C--                                                                     
C---- IF TRACE ONE, SEE IF DISTANCES STILL GOOD....                     
C--                                                                     
            IF ( ktrc      .GT. 1 ) GO TO 200                           
            RECORD = krec                                               
            CALL DSTUPD ( RECORD, KARD, NTRACE)                         
C--                                                                     
C---- IS TRACE DEAD ??  WE HAVE TO CHECK FOR                            
C---- DEAD TRACE NOW INSTEAD OF BEFORE TO ENSURE                        
C---- WE GET A CURRENT SET OF TRACE DISTANCES                           
C---- IN CASE TRACE 1 IS DEAD....                                       
C--                                                                     
  200	call saver2(ibuf,ifmtsc,l_StaCor,lengsc,kval,TRCHED)
		if(kval .ge. 30000) go to 600
            SDIST     = DIST( ktrc      )                               
            lval      = SDIST + SIGN ( 0.5, SDIST )                     
	call savew2(ibuf,ifmtds,l_DstSgn,lengds,lval,TRCHED)
		if(lval .lt. 0) lval = -lval
	call savew2(ibuf,ifmtdu,l_DstUsg,lengdu,lval,TRCHED)
C--                                                                     
C---- ARE WE ASSIGNING WATER DEPTHS ???                                 
C--                                                                     
  300	call saver2(ibuf,ifmtsc,l_StaCor,lengsc,mval,TRCHED)
      IF ( ( .NOT. WTRCRD )                                             
     *           .OR. mval      .GE. 30000 ) GO TO 600                  
C                                                                       
      IREEL = 0                                                         
C--                                                                     
C---- HOW MANY CDP'S ARE WE FROM THE                                    
C---- FIRST LABELED SOURCE POINT ???                                    
C--                                                                     
	call saver2(ibuf,ifmtdi,l_DphInd,lengdi,locat,TRCHED)
      IMANY  = LOCAT - FCDP                                             
C--                                                                     
C---- IF WE ARE BEFORE FIRST SOURCE, LEAVE...                           
C--                                                                     
      IF ( IMANY .GE. 0  ) GO TO 400                                    
C                                                                       
      IREEL = FSORC                                                     
      IF (IREEL .LT. MINWD) IREEL = MINWD                               
      IF (IREEL .GT. MAXWD) IREEL = MAXWD                               
      REEL  = IREEL                                                     
      GO TO 500                                                         
C--                                                                     
C---- IF NOT, FIGURE WHAT SOURCE                                        
C---- POINT WE'RE ON NOW....                                            
C--                                                                     
  400 REEL  = FLOAT( IMANY ) / ( INCR / 100. ) + FSORC                  
      IREEL = REEL                                                      
C--                                                                     
C---- ARE WE OUT OF BOUNDS ???                                          
C--                                                                     
      IF ( IREEL .LE. MAXWD ) GO TO 450                                 
C                                                                       
      IREEL = MAXWD                                                     
      REEL  = IREEL                                                     
      GO TO 500                                                         
C                                                                       
  450 IF ( IREEL .GE. MINWD ) GO TO 500                                 
C                                                                       
      IREEL = MINWD                                                     
      REEL  = IREEL                                                     
C--                                                                     
C---- SEE IF WE'RE BETWEEN TWO GIVEN WATER DEPTHS....                   
C--                                                                     
  500 DIFFER = REEL - IREEL                                             
      IF ( INCR .LT. 0.                                                 
     *          .AND. DIFFER .NE. 0. ) IREEL = IREEL + 1                
      IPNT1  = IREEL - ( MINWD - 1 )                                    
      DEPTH1 = WDEPTH( IPNT1 )                                          
      IF ( INCR .GT. 0.                                                 
     *          .AND. ( DIFFER .EQ. 0.                                  
     *                .OR. (IREEL + 1) .GT. MAXWD ) )                   
     *                       IREEL = IREEL - 1                          
      IF ( INCR .LT. 0.                                                 
     *          .AND. ( DIFFER .EQ. 0.                                  
     *                .OR. (IREEL - 1) .LT. MINWD ) )                   
     *                       IREEL = IREEL + 1                          
      IPNT2  = IREEL - ( MINWD - 1 )                                    
      IPNT2  = IPNT2 + SIGN ( 1., INCR )                                
      DEPTH2 = WDEPTH( IPNT2 )                                          
C--                                                                     
C---- FIGURE DIFFERENCE BETWEEN TWO DEPTHS....                          
C--                                                                     
      WDIFF  = DEPTH2 - DEPTH1                                          
C--                                                                     
C---- MULTIPLY THIS DIFFERENCE BY                                       
C---- THE FRACTIONAL AMOUNT BETWEEN THE TWO SOURCES....                 
C--                                                                     
      XDIFF = DIFFER                                                    
      IF ( INCR .LT. 0. ) XDIFF = 1. - DIFFER                           
      ISLOPE = ( WDIFF * XDIFF ) + SIGN ( 0.5, WDIFF )                  
C--                                                                     
C---- ADD THIS AMOUNT TO PREVIOUS DEPTH...                              
C--                                                                     
      IBUF(97) = DEPTH1 + ISLOPE                                        
C                                                                       
  600 CALL WRTAPE ( luout, IBUF, LENGTH )
      IF ( KRI .EQ. krec      ) GO TO 100                               
      KRI = krec                                                        
      CALL RIPRNT ( KRI, IPRNTR )                                       
      IREC = IREC + 1                                                   
      GO TO 100                                                         
C                                                                       
  700 CALL RICLR ( IPRNTR )                                             
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE PRNTEM ( METRIC, IPLOT, IBTWN, IFOLD )                 
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: PRNTEM                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE PRNTEM DISPLAYS PROCESSING PARAMETERS.             
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         METRIC - METRIC FLAG                                          
C         IPLOT  - PLOT DIRECTION FLAG                                  
C         IBTWN  - SOURCE LOCATION                                      
C         IFOLD  - FOLD OF LINE                                         
C                                                                       
C***********************************************************************
C                                                                       
      character * 8 TJOBID
      REAL    * 4 JCSTAT                                                
C                                                                       
      INTEGER * 4 SPNUM1, SPINC, RIPSRC                                 
C                                                                       
      INTEGER METRIC
cmam  INTEGER * 2 METRIC                                                
C                                                                       
      CHARACTER*1 IFHIST, IWATOR, IDIST, Y, MOOV

      LOGICAL     WTRCRD, FELDCD, INDEX, DSTCRD,
     *            MOOVUP, CONVEN, HISTGR, CBLCRD
C                                                                       
      DATA IFHIST/'N'/, IWATOR/'N'/, IINDEX/0/, IDIST/'N'/, MOOV/'N'/,  
     *     IHIST/0/, Y/'Y'/                                             
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
C                                                                       
      IF (       FELDCD ) IFHIST = 'Y'
      IF (       WTRCRD ) IWATOR = 'Y'
      IF ( .NOT. INDEX  ) IINDEX = 1                                    
      IF ( .NOT. HISTGR ) IHIST  = 1                                    
      IF (       DSTCRD ) IDIST  = 'Y'
      IF (       MOOVUP ) MOOV   = 'Y'
C                                                                       
      WRITE(IPRNTR,100)                                                 
  100 FORMAT(////29X,'***** PROCESSING PARAMETERS FOR PROGRAM MAIP ',   
     *            'AFTER DEFAULTS *****',/)                             
C--                                                                     
      WRITE(IPRNTR,200) RECINT, SPNUM1, SRCINT, SPINC, GIINT, RIPSRC    
  200 FORMAT(/19X,'GROUP (RECEIVER) SPACING.....',F10.1,                
     *         9X,'FIRST RECORD SOURCE ID.......',I10,                  
     *      //19X,'SOURCE MOVEUP................',F10.1,                
     *         9X,'SOURCE POINT INCREMENT.......',I10,                  
     *      //19X,'GROUP INDEXING INTERVAL......',F10.1,                
     *         9X,'RECORD LABELING INTERVAL.....',I10 )                 
C--                                                                     
      WRITE(IPRNTR,300) DIINT, IFOLD, IPLOT, METRIC, IINDEX, IBTWN      
  300 FORMAT(/19X,'DEPTH POINT INDEXING INTERVAL',F10.1,                
     *         9X,'FOLD.........................',I10,                  
     *      //19X,'PLOT DIRECTION...............',I10,                  
     *         9X,'UNITS........................',I10,                  
     *       /22X,'0 = NORMAL                   ',                      
     *        19X,'0 = ENGLISH                  ',                      
     *       /22X,'1 = REVERSE                  ',                      
     *        19X,'1 = METRIC                   ',                      
     *      //19X,'INDEX DATA SET...............',I10,                  
     *         9X,'SHOT PLACEMENT...............',I10,                  
     *       /22X,'0 = YES                      ',                      
     *        19X,'0 = SHOT ON GROUPS           ',                      
     *       /22X,'1 = NO                       ',                      
     *        19X,'1 = SHOT BETWEEN GROUPS      ')                      
C--                                                                     
      WRITE(IPRNTR,400) IFHIST, IWATOR, OFFSET, IDIST,                  
     *                  JCSTAT, IHIST                                   
  400 FORMAT(/19X,'INPUT FIELD HISTORY..........',9X,A1,                
     *         9X,'INPUT WATER DEPTHS...........',9X,A1,                
     *       /22X,'N = NO                       ',                      
     *        19X,'N = NO                       ',                      
     *       /22X,'Y = YES                      ',                      
     *        19X,'Y = YES                      ',                      
     *      //19X,'SOURCE LABELING OFFSET.......',F10.1,                
     *         9X,'INPUT TRACE DISTANCES........',9X,A1,                
     *       /22X,'0 = SOURCE AT SHOT           ',                      
     *        19X,'N = NO                       ',                      
     *       /70X,'Y = YES                      ',                      
     *       /19X,'JOB CONSTANT STATIC..........',F10.1,                
     *       /67X,'DISPLAY ERROR HISTOGRAMS.....',I10   )               
C                                                                       
      WRITE(IPRNTR,500) MOOV, MODE                                      
  500 FORMAT( 19X,'INPUT SOURCE MOVEUP CARDS....',9X,A1,                
     *        12X,'0 = YES                      ',                      
     *       /22X,'N = NO                       ',                      
     *        19X,'1 = NO                       ',                      
     *       /22X,'Y = YES                      ',                      
     *       /67X,'SIGN CONVENTION..............',I10,// )              
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE ERRCHK ( IBUF, MAIP1 )
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: ERRCHK                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: E. ANDES                                                  
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE ERRCHK PERFORMS ERROR CHECKING ON INPUT DATA       
C         SET.                                                          
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         IBUF   - LINE HEADER (I*2)                                    
C         IHEAD  - LINE HEADER (I*4)                                    
C         MAIP1  - FLAG SET WHEN 1MAIP CARD IS READ                     
C                                                                       
C***********************************************************************
C                                                                       
#include <f77/sisdef.h>
#include <save_defs.h>
      character * 8 TJOBID
C                                                                       
      REAL    * 4 JCSTAT                                                
C                                                                       
      INTEGER   SPNUM1, SPINC, RIPSRC, luout
C                                                                       
	INTEGER IBUF(*)
C                                                                       
      LOGICAL     INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,        
     *            HISTGR, CBLCRD, MAIP1                                 
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
	integer IBUF33, IHEAD16, IHEAD13
c
	call savelu('Format',ifmtfm,l_Format,lengfm,LINHED)
	call savelu('NumSmp',ifmtns,l_NumSmp,lengns,LINHED)
	call savelu('NumTrc',ifmtnt,l_NumTrc,lengnt,LINHED)
	call saver2(ibuf,ifmtfm,l_Format,lengfm,ibuf33,LINHED)
	call saver2(ibuf,ifmtns,l_NumSmp,lengns,ihead16,LINHED)
	call saver2(ibuf,ifmtnt,l_NumTrc,lengnt,ihead13,LINHED)
C                                                                       
      IF ( IBUF33 .EQ. 1                                                
     *              .OR. IBUF33 .EQ. 3 ) GO TO 200                      
C                                                                       
      WRITE(IPRNTR,100)                                                 
  100 FORMAT (/,13X,'** M1700 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'THE FORMAT CODE READ FROM THE INPUT DATA SET',     
     *        /,25X,'LINE HEADER IS NOT A 1 OR A 3.  VERIFY THAT',      
     *        /,25X,'THE INPUT DATA SET HAS THE CORRECT FORMAT CODE',   
     *        /,25X,'AND RESUBMIT.',/)                                  
      GO TO 1700                                                        
C                                                                       
  200 IF ( ( IBUF33 .EQ. 1 .AND. IHEAD16 .LE. 12000)                    
     *           .OR. ( IBUF33 .EQ. 3 .AND. IHEAD16 .LE. 6000 ) )       
     *                GO TO 400                                         
C                                                                       
      WRITE(IPRNTR,300)                                                 
  300 FORMAT (/,13X,'** M1701 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'THE NUMBER OF SAMPLES PER TRACE AS FILED IN',      
     *        /,25X,'THE INPUT DATA SET LINE HEADER EXCEEDS THE ',      
     *        /,25X,'PROGRAM LIMIT.  PROGRAM MAIP ACCEPTS A MAXIMUM',   
     *        /,25X,'OF 6000 SAMPLES IF FORMAT 3, AND ACCEPTS A ',      
     *        /,25X,'MAXIMUM OF 12000 SAMPLES IF FORMAT 1.',/)          
      GO TO 1700                                                        
C                                                                       
  400 IF ( MAIP1 ) GO TO 600                                            
C                                                                       
      WRITE(IPRNTR,500)                                                 
  500 FORMAT (/,13X,'** M1702 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'A 1MAIP CARD WAS NOT READ AND IT IS REQUIRED.',    
     *        /,25X,'VERIFY CARD INPUT AND RESUBMIT.',/)                
      GO TO 1700                                                        
C                                                                       
  600 IF ( ( .NOT. INDEX )                                              
     *          .OR. GIINT .GT. 0 ) GO TO 800                           
C                                                                       
      WRITE(IPRNTR,700)                                                 
  700 FORMAT (/,13X,'** M1703 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING,',  
     *        /,25X,'BUT THE GROUP INTERVAL (CC 11-20 2MAIP) WAS',      
     *        /,25X,'NOT PROVIDED AND A SUITABLE DEFAULT COULD NOT',    
     *        /,25X,'BE DETERMINED.  VERIFY INPUT AND RESUBMIT.',/)     
      GO TO 1700                                                        
C                                                                       
  800 IF ( ( .NOT. INDEX )                                              
     *          .OR. SRCINT .GT. 0 ) GO TO 1000                         
C                                                                       
      WRITE(IPRNTR,900)                                                 
  900 FORMAT (/,13X,'** M1704 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING,',  
     *        /,25X,'BUT THE SOURCE INTERVAL (CC 21-30 1MAIP) WAS',     
     *        /,25X,'NOT PROVIDED AND A SUITABLE DEFAULT COULD NOT',    
     *        /,25X,'BE DETERMINED.  VERIFY INPUT AND RESUBMIT.',/)     
      GO TO 1700                                                        
C                                                                       
 1000 IF ( ( .NOT. INDEX )                                              
     *          .OR. ( DSTCRD ) ) GO TO 1200                            
C                                                                       
      WRITE(IPRNTR,1100)                                                
 1100 FORMAT (/,13X,'** M1705 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING',   
     *        /,25X,'(CC 7 1MAIP), BUT TRACE DISTANCES WERE NOT',       
     *        /,25X,'SUPPLIED ON NDSTN CARDS.  FOR INDEXING TO BE',     
     *        /,25X,'PERFORMED, TRACE DISTANCES MUST BE SUPPLIED.',     
     *        /,25X,'VERIFY CARD INPUT AND RESUBMIT.',/)                
      GO TO 1700                                                        
C                                                                       
 1200 IF ( ( .NOT. INDEX )                                              
     *          .OR. ( RECINT .NE. 0. ) ) GO TO 1400                    
C                                                                       
      WRITE(IPRNTR,1300)                                                
 1300 FORMAT (/,13X,'** M1706 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'IF INDEXING IS REQUESTED (CC 7 1MAIP), THE',       
     *        /,25X,'GROUP (RECEIVER) SPACING MUST BE INPUT.',          
     *        /,25X,'VERIFY CARD INPUT AND RESUBMIT.',/)                
      GO TO 1700                                                        
C                                                                       
 1400 IF ( IHEAD13 .LE. 8192 ) GO TO 1600                               
C                                                                       
      WRITE(IPRNTR,1500)                                                
 1500 FORMAT (/,13X,'** M1707 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 
     *        /,25X,'THE NUMBER OF TRACES PER RECORD AS FILED IN',      
     *        /,25X,'THE INPUT DATA SET LINE HEADER EXCEEDS THE ',      
     *        /,25X,'PROGRAM LIMIT.  PROGRAM MAIP ACCEPTS A MAXIMUM',   
     *        /,25X,'OF 8192 TRACES PER RECORD.',/)                     
      GO TO 1700                                                        
C                                                                       
 1600 RETURN                                                            
C                                                                       
 1700 CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE DSPLAY ( WDEPTH, MINWD, MAXWD )                        
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: DSPLAY                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: E. ANDES                                                  
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE DSPLAY DISPLAYS INFORMATION ABOUT WATER DEPTHS     
C         TO BE USED IN JOB.                                            
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         WDEPTH - WATER DEPTH ARRAY                                    
C         MINWD  - MIN SOURCE POINT/WATER DEPTH ARRAY                   
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH ARRAY                   
C                                                                       
C***********************************************************************
C                                                                       
      REAL    * 4 WDEPTH(12000)                                         
	character*8 TJOBID
	real*4 DIST(8192),DSTNCE(2,5000),BEGIN(8192),FINISH(8192)
	integer BOUNDS(3,5000)
	logical INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,
     *		HISTGR, CBLCRD
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C                                                                       
      IQUIT = MAXWD - ( MINWD - 1 )                                     
      CALL INTERP ( WDEPTH, 1, IQUIT )                                  
C                                                                       
      WRITE(IPRNTR,100)                                                 
  100 FORMAT(///2X,'SOURCE',28X,'**** THE FOLLOWING ARE SOURCE ',       
     *              'POINT ORIENTED WATER DEPTHS ****',                 
     *         /2X,'------')                                            
C                                                                       
      NROWS = ( ( MAXWD - MINWD ) + 10 ) / 10                           
      IPNT1 = MINWD                                                     
      I1    = 1                                                         
      I2    = 10                                                        
C                                                                       
      DO 300 I = 1,NROWS                                                
         IF ( I2 .GT. ( MAXWD - ( MINWD - 1 ) ) )                       
     *            I2 = MAXWD - ( MINWD - 1 )                            
         WRITE(IPRNTR,200) IPNT1, ( WDEPTH(M),M=I1,I2)                  
  200    FORMAT(3X,I5,10F12.1)                                          
         IPNT1 = IPNT1 + 10                                             
         I1    = I1 + 10                                                
         I2    = I2 + 10                                                
  300 CONTINUE                                                          
C                                                                       
      WRITE(IPRNTR,400)                                                 
  400 FORMAT(///)                                                       
      RETURN                                                            
      END                                                               
C                                                                       
C                                                                       
      SUBROUTINE WRTOUT ( RECORD, ILABEL, IWHERE, IBOTOM )              
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: WRTOUT                                           
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: E. ANDES                                                  
C                                                                       
C     DATE WRITTEN: 09/12/85                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         SUBROUTINE WRTOUT DISPLAYS INFORMATION FOR EACH OUTPUT        
C         RECORD.                                                       
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         RECORD - RECORD JUST PROCESSED                                
C         ILABEL - LAST LABELED SOURCE POINT FOR RECORD                 
C         IWHERE - CDP BELOW LAST SOURCE POINT                          
C         IBOTOM - WATER DEPTH FOR SOURCE POINT                         
C                                                                       
C***********************************************************************
C                                                                       
      INTEGER * 4 RECORD, OLDLBL                                        
	character*8 TJOBID
	real*4 DIST(8192),DSTNCE(2,5000),BEGIN(8192),FINISH(8192)
	integer BOUNDS(3,5000)
	logical INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,
     *		HISTGR, CBLCRD
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    
     *                HISTGR, CBLCRD                                    
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH
C                                                                       
      DATA OLDLBL/-9999/                                                
C                                                                       
      IF ( ( ILABEL .NE. OLDLBL )                                       
     *              .AND. ( ILABEL .NE. 0 )                             
     *                    .AND. ( IBOTOM .NE. -99999 ) )                
     *                      WRITE(IPRNTR,100) RECORD, ILABEL, IWHERE,   
     *                                        IBOTOM                    
  100 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.  SOURCE ',         
     *            'POINT ',I5,' IS ABOVE CDP ',I5,' IN ',I5,' UNITS ',  
     *            'OF WATER.')                                          
C                                                                       
      IF ( ( ILABEL .NE. OLDLBL )                                       
     *              .AND. ( ILABEL .NE. 0 )                             
     *                    .AND. ( IBOTOM .EQ. -99999 ) )                
     *                      WRITE(IPRNTR,200) RECORD, ILABEL, IWHERE    
  200 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.  SOURCE ',         
     *            'POINT ',I5,' IS ABOVE CDP ',I5,'.')                  
C                                                                       
      IF ( ( ILABEL .EQ. OLDLBL )                                       
     *              .OR. ( ILABEL .EQ. 0 ) )                            
     *                     WRITE(IPRNTR,300) RECORD                     
  300 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.')                  
C                                                                       
C---- SAVE SOURCE LABEL TO CHECK AGAINST                                
C---- NEXT LABEL.  IF THEY MATCH, DON'T                                 
C---- PRINT OUT SAME INFORMATION AGAIN.                                 
      OLDLBL = ILABEL                                                   
C                                                                       
      RETURN                                                            
      END                                                               
C----------------------------------------------------------------------C
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C
C----------------------------------------------------------------------C
C-- DEFLDH - DELETE FIELD HISTORY INFORMATION FROM SEISMIC LINE      --C
C--          HEADER.                                                 --C
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C
C----------------------------------------------------------------------C
      SUBROUTINE DEFLDH ( IHEAD , HDRLEN, HEADER )                      
      IMPLICIT   INTEGER*4 (A-Z)                                        
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	integer IHEAD(*)
      character*1  HEADER(*), HEX5A
      INTEGER  TOTAL, COUNT
#ifndef CRAYSYSTEM
	integer*2 length
#else
	integer length
#endif
	DATA HEX5A / '!' /

	FLDHIS = HLHOFF + 1
	POINT = HSTOFF + 1
	INFO = POINT + HLHINT
C--                                                                     
C--------------------------------------------------------------         
C-- MOVE HISTORICAL HEADER ENTRY COUNTER AND LENGTH INTO WORKSPACE      
C--                                                                     
	call saver(IHEAD , 'HlhEnt', COUNT, 0)
	call saver(IHEAD , 'HlhByt', TOTAL, 0)
C--                                                                     
C--------------------------------------------------------------         
C-- CHECK BOUNDARY CONDITION (NO HISTORICAL INFO...)                    
C--                                                                     
   10 IF (COUNT.LE.0) GOTO 20                                           
C--                                                                     
C--------------------------------------------------------------         
C-- OBTAIN LENGTH OF THIS ENTRY AND ADDRESS OF NEXT ENTRY               
C--                                                                     
         CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  
#ifndef CRAYSYSTEM
         NEXT = INFO + LENGTH                                           
#else
	LENGTH = (INT((LENGTH + 7) / 8) * 8)
	NEXT = INFO + LENGTH
#endif
C--                                                                     
C--------------------------------------------------------------         
C-- IF THIS ENTRY IS FLAGGED AS HISTORICAL, THEN DELETE THE ENTRY       
C--    ALSO UPDATE OVERALL LENGTH OF LINE HEADER                        
C--                                                                     
         IF (HEADER(INFO).NE.HEX5A) GOTO 20                             
            LENGTH = LENGTH + HLHINT                                    
            TOTAL = TOTAL - LENGTH                                      
            COUNT = COUNT - 1                                           
            HDRLEN = HDRLEN - LENGTH                                    
            LEN4 = TOTAL                                                
            CALL MOVE ( 4, HEADER(POINT), HEADER(NEXT), LEN4 )          
            GOTO 10                                                     
C--                                                                     
C--------------------------------------------------------------         
C-- UPDATE HEADER...                                                    
C--                                                                     
   20 call savew(IHEAD , 'HlhEnt', COUNT, 0)
      call savew(IHEAD , 'HlhByt', TOTAL, 0)

      RETURN                                                            
      END                                                               
C----------------------------------------------------------------------C
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C
C----------------------------------------------------------------------C
C-- INFLDH - INSERT FIELD HISTORY INFORMATION INTO SEISMIC LINE      --C
C--          HEADER.                                                 --C
C----------------------------------------------------------------------C
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C
C----------------------------------------------------------------------C
C-- CATALOGUED AND TESTED - 10/25/82 9:00 AM                         --C
C----------------------------------------------------------------------C
C-- ABSTRACT - INSERT ONE (1) LINE OF FIELD HISTORY INFORMATION INTO --C
C--            A SEISMIC LINE HEADER.  ENTRY IS PLACED AT END OF     --C
C--            "FIELD" INFORMATION IMMEDIATELY BEFORE "PROCESSING"   --C
C--            INFORMATION.  LENGTH OF OVERALL HEADER IS ALSO RESET. --C
C----------------------------------------------------------------------C
      SUBROUTINE INFLDH ( IHEAD , HDRLEN, FLD, FLDLEN, HEADER )         
      IMPLICIT   INTEGER*4 (A-Z)                                        
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	integer IHEAD(*)
      character*1  HEADER(*), HEX5A, FLD(*)
	integer kount,ktot
#ifndef CRAYSYSTEM
      INTEGER*2 WORKSP(2),LENGTH,TOTAL,COUNT
#else
      INTEGER WORKSP(2),LENGTH,TOTAL,COUNT
#endif
      EQUIVALENCE (WORKSP(1),COUNT),                                    
     $            (WORKSP(2),TOTAL)                                     
	DATA HEX5A / '!' /
	FLDHIS = HLHOFF + 1
	START = HSTOFF + 1
	iNFO = START + HLHINT
C--                                                                     
C--------------------------------------------------------------         
C-- MOVE ITEM COUNT AND LENGTH INTO WORKSPACE                           
C--                                                                     
	call saver(IHEAD , 'HlhEnt', KOUNT, 0)
	call saver(IHEAD , 'HlhByt', KTOT, 0)
	count = kount
	total = ktot

C--                                                                     
C--------------------------------------------------------------         
C-- INITIALIZE POINTERS...                                              
C--                                                                     
      POINT = START                                                     
      ENTRY = INFO                                                      
C--                                                                     
C--------------------------------------------------------------         
C-- IF THE HISTORY IS EMPTY, THEN DON'T BOTHER WITH A SEARCH            
C--                                                                     
      IF (COUNT.LE.0) GOTO 20                                           
C--                                                                     
C--------------------------------------------------------------         
C--     GET NEXT ITEM LENGTH...                                         
C--                                                                     
   10    CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  
#ifdef CRAYSYSTEM
	LENGTH = (INT((LENGTH + 7) / 8) * 8)
#endif
C--                                                                     
C--------------------------------------------------------------         
C-- IF THIS ENTRY IS A FIELD HISTORY ENTRY, THEN WE SKIP BY IT.         
C--    AND POINT TO THE NEXT ITEM                                       
C--                                                                     
         IF (HEADER(ENTRY).NE.HEX5A) GOTO 20                            
            POINT = ENTRY + LENGTH                                      
            ENTRY = POINT + HLHINT                                      
            GOTO 10                                                     
C--                                                                     
C--------------------------------------------------------------         
C-- COMPUTE LENGTH OF REMAINING HEADER INFO AND TARGET ADDRESS          
C--     THEN MOVE THE HEADER ON DOWN INTO POSTION TO MAKE ROOM          
C--     FOR THE NEW HISTORY ENTRY.                                      
C-- (PROVIDED THERE ACTUALLY IS SOMETHING TO BE MOVED)                  
C--                                                                     
   20 continue
	leng1 = FLDLEN + 1
#ifdef CRAYSYSTEM
	leng1 = (INT((leng1 + 7) / 8) * 8)
#endif
      MOVLEN = START + TOTAL - POINT                                    
      NEWLOC = POINT + leng1 + HLHINT                                   
      IF (MOVLEN.GT.0) then                                             
      	call move(4,HEADER(NEWLOC),HEADER(POINT),MOVLEN)
	endif
C--                                                                     
C--------------------------------------------------------------         
C-- FLAG THIS ENTRY AS HISTORY                                          
C--                                                                     
      HEADER(ENTRY) = HEX5A                                             
C--                                                                     
C--------------------------------------------------------------         
C-- MOVE THE ENTRY INTO POSITION (WE DON'T CARE HOW LONG IT IS)         
C--                                                                     
      ENTRY = ENTRY + 1                                                 
      CALL MOVE ( 1, HEADER(ENTRY), FLD, FLDLEN )                       
C--                                                                     
C--------------------------------------------------------------         
C-- SET THE LENGTH OF THE ENTRY...                                      
C--                                                                     
       LENGTH = FLDLEN + 1                                              
      CALL MOVE ( 1, HEADER(POINT), LENGTH, HLHINT)                     
C--                                                                     
C--------------------------------------------------------------         
C-- UPDATE ENTRY COUNT AND TOTAL BYTE LENGTH OF HISTORY HEADER          
C--    THEN GO HOME                                                     
C--                                                                     
      COUNT = COUNT + 1                                                 
      TOTAL = TOTAL + leng1  + HLHINT                                   
      HDRLEN = HDRLEN + leng1  + HLHINT                                 
	kount = count
	ktot = total
	call savew(IHEAD , 'HlhEnt', KOUNT, 0)
   	call savew(IHEAD , 'HlhByt', KTOT, 0)

      RETURN                                                            
      END                                                               
C----------------------------------------------------------------------C
C--     AMOCO PRODUCTION COMPANY - SEISMIC TRACE PROCESSING GROUP    --C
C--                  FOR USE WITH 'FLDHIS' ROUTINES...               --C
C----------------------------------------------------------------------C
C-- CHARACTER STRING LENGTH FUNCTION - RETURN NUMBER OF CHARACTERS   --C
C-- IN AN ARRAY, ZERO IF ARRAY IS ALL BLANK, ROUTINE ACTS AS A       --C
C-- 'TRIMMING' FUNCTION FOR CHARACTER STRING DATA                    --C
C----------------------------------------------------------------------C
C-- RUSSELL L. WILSON --- 09/05/83 --- 963 SOUTH TDC --- EXT.3783    --C
C----------------------------------------------------------------------C
      INTEGER FUNCTION  LENG2 (STRING,MAXLEN)
      character*1 BLANK,  STRING (*)
      INTEGER*4   MAXLEN
      DATA        BLANK   /' '/

      LENG2 = MAXLEN + 1
   10 LENG2 = LENG2 - 1
         IF (LENG2.LT.1) RETURN
         IF (STRING(LENG2).EQ.BLANK)  GOTO 10
      RETURN
      END


      subroutine getsp (biasflg, spmul, fstsp, ifsorc)

      integer       biasflg, spmul, fstsp, ifsorc

      if (biasflg .eq. 0) then
         ifsorc = fstsp
      else
         ifsorc = fstsp - spmul * 10000
      endif

      return
      end

      subroutine sbias (biasflg, spmul, fstsp, spnum)

      integer       biasflg, spmul, fstsp, spnum

      if (biasflg .eq. 0) then
         spnum = fstsp
      else
         spnum = fstsp + spmul * 10000
      endif

      return
      end

      subroutine spbias (biasflg, itr, dibsp, srcnum)
#include <f77/sisdef.h>
#include <save_defs.h>

      integer itr(*)
      integer      dibsp, srcnum
	integer biasflg

      call savelu('SrcPnt',ifmtsp,l_SrcPnt,lengsp,TRCHED)
      call savelu('SoPtNm',ifmspn,l_SoPtNm,lenspn,TRCHED)

        call savew2(itr,ifmtsp,l_SrcPnt,lengsp,dibsp,TRCHED)
        call savew2(itr,ifmspn,l_SoPtNm,lenspn,srcnum,TRCHED)

      return
      end

      subroutine help1
#include <f77/iounit.h>

          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM maip................Marine Line Indexing'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]      (no default)      : Input data file name'
         write(LER,*)
     :' -O [otap]      (no default)      : Output data file name'
         write(LER,*)
     :' -C [cardin]    (no default)      : Card data file name'
         write(LER,*)
     :'   the file cardin must contain these card images:'
	 write(LER,*)
     :'    1MAIP : required'
	 write(LER,*)
     :'    2MAIP : optional'
	 write(LER,*)
     :'    3MAIP : optional'
	 write(LER,*)
     :'    nCABL : optional'
	 write(LER,*)
     :'    1WATR : optional'
	 write(LER,*)
     :'    1MOOV : optional'
	 write(LER,*)
     :'    1FLDH : optional'
	 write(LER,*)
     :'    nDSTN : required when indexing (cc7,1MAIP card=blank or 0)'
         write(LER,*)
     :' -V [verbos]    (default=no)      : Verbose output '
       write(LER,*)
     :'Usage:  ',
     :' maip -N[ntap] -O[otap] -C[cardin]  -[V,B]'
       write(LER,*)
     :'***************************************************************'
      return
      end

      INTEGER FUNCTION ASSIG1 ( PLACE, DELTA, MODE, INTERR )            
C***********************************************************************
C                                                                       
C     FUNCTION NAME: ASSIGN                                             
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         FUNCTION ASSIGN WILL ASSIGN AN INDEX VALUE BASED ON           
C         A DISTANCE PASSED AND A BUCKET SIZE.                          
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         PLACE  - DISTANCE FROM ORIGIN TO BE LABELED                   
C         DELTA  - LABELING INTERVAL                                    
C         MODE   - FLAG TO SEE IF WE'RE ACCUMULATING ERROR              
C         INTERR - ERROR COUNTER                                        
C                                                                       
C***********************************************************************
C                                                                       
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             
C--                                                                     
C---- SET 'BUCKET' ASSIGNMENT                                           
C--                                                                     
      DELTA2 = DELTA * 0.5                                              
      ASSIG1 = ( PLACE + DELTA2 ) / DELTA                               
C--                                                                     
C---- MAKE SURE INDEX STAYS UNDER 32768..                               
C--                                                                     
         IF ( ASSIG1 .GT. 32767 ) ASSIG1 = 32767                        
C--                                                                     
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               
C--                                                                     
         IF ( ASSIG1 .GE. 1 ) GO TO 100                                 
              ASSIG1 = -1                                               
              RETURN                                                    
C--                                                                     
C--------------------------------------------------------------         
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       
C--                                                                     
  100 IF ( MODE .LT. 1 ) RETURN                                         
         DIFFER = ( PLACE - DELTA * ASSIG1 ) / DELTA * 50.0             
         ERROR = 26 + DIFFER                                            
         IF (ERROR .LT.  1) ERROR = 1                                   
         IF (ERROR .GT. 50) ERROR = 50                                  
         INTERR(ERROR) = INTERR(ERROR) + 1                              
         RETURN                                                         
      END                                                               
C                                                                       
      INTEGER FUNCTION SPSET1( SOURCE, DELTA, LIMIT, TRUESP, FRSTSP )   
C***********************************************************************
C                                                                       
C     FUNCTION NAME: SPSET                                              
C                                                                       
C     LANGUAGE: FORTRAN                                                 
C                                                                       
C     AUTHOR: R. WILSON AND E. ANDES                                    
C                                                                       
C     DATE WRITTEN: 01/13/86                                            
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY -                                
C                              TO BE MAINTAINED IN CONFIDENCE           
C                                                                       
C     ABSTRACT:                                                         
C         FUNCTION SPSET ASSIGNS HALF WORD 108.                         
C                                                                       
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        
C                             INITIAL RELEASE.                          
C                                                                       
C     PARAMETERS PASSED:                                                
C         SOURCE - DISTANCE FROM ORIGIN                                 
C         DELTA  - LABELING INTERVAL                                    
C         LIMIT  - AMOUNT OF SLOP FOR LABELING                          
C         TRUESP - FLOATING POINT SOURCE POINT AT ANY LOCATION          
C         FRSTSP - LOCATION OF FIRST SOURCE ON LINE                     
C                                                                       
C***********************************************************************
C                                                                       
      character * 8 TJOBID
      REAL    * 4 SOURCE, LIMIT, ERROR                                  
C                                                                       
      INTEGER * 4 SPNUM1, SPINC, RIPSRC, ASSIGN                         
C                                                                       
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/ luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       
C--                                                                     
C---- COMPUTE DISTANCE FROM FIRST SOURCE POINT AND BIAS BY ONE          
C---- SOURCE POINT LABELING INTERVAL.                                   
C--                                                                     
      ADJUST = SOURCE - FRSTSP + DELTA                                  
C--                                                                     
C---- GET SOURCE POINT OVER THIS DI...                                  
C--                                                                     
      SPSET1 = ASSIGN ( ADJUST, DELTA, 0, DUMMY )                       
C--                                                                     
C---- IS IT VALID ???                                                   
C--                                                                     
      IF ( SPSET1.GT. 0 ) GO TO 100                                     
           SPSET1 = 0                                                   
           TRUESP = SPNUM1                                              
           RETURN                                                       
C--                                                                     
C-- COMPUTE REAL ERROR IN SOURCE POINT LABEL INDEX ASSIGNMENT           
C--                                                                     
  100 ERROR = ADJUST / DELTA - FLOAT(SPSET1)                            
C--                                                                     
C---- COMPUTE AND RETURN SOURCE POINT LABEL                             
C---- ASSOCIATED WITH THIS POSITION...                                  
C---- DETERMINE REAL SOURCE POINT LABELING                              
C---- INDEX TOO, EVEN BETWEEN TWO LABELED SOURCE POINTS....             
C--                                                                     
      SPSET1 = SPNUM1 + ( SPSET1- 1 ) * SPINC                           
      TRUESP = SPSET1+ ( ERROR * FLOAT( SPINC ) )                       
C--                                                                     
C---- IF POSITION IS BEFORE FIRST SOURCE LABEL POSTION, RETURN          
C---- ZERO FOR A LABEL AND FIRST SOURCE POINT AS TRUESP                 
C---- ALSO NEED TO ADD AN INCREMENT OF SOURCE POINT LABEL IF            
C---- NOT A POSITIVE NUMBER...                                          
C--                                                                     
C     IF ( ABS(ERROR) .LT. LIMIT ) GO TO 150                            
      IF (( ABS(ERROR) .LT.   LIMIT ) .OR.                              
     *    (     ERROR  .EQ.   LIMIT   .AND. SPINC .GT. 0) .OR.          
     *    (     ERROR  .EQ. -(LIMIT)  .AND. SPINC .LT. 0) )             
     * GO TO 150                                                        
C                                                                       
      SPSET1 = 0                                                        
      IF ( TRUESP .LT. SPNUM1                                           
     *            .AND. SPINC .GT. 0 ) TRUESP = SPNUM1                  
      IF ( TRUESP .GT. SPNUM1                                           
     *            .AND. SPINC .LT. 0 ) TRUESP = SPNUM1                  
      RETURN                                                            
C                                                                       
  150 IF (SPSET1.GT. 0) RETURN                                          
C                                                                       
      WRITE(IPRNTR,200) SPSET1                                          
  200 FORMAT (/13X,'** M1100 ** ERROR DETECTED IN FUNCTION SPSET1:',    
     *        /25X,'SOURCE POINT NUMBER ',I5,' IS LESS THAN OR',        
     *        /25X,'EQAUL TO ZERO. REENTER SOURCE ID AND SOURCE',       
     *        /25X,'POINT INCREMENT ON 1MAIP CARD.',/)                  
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               
      END                                                               

