C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mdian2 (y, nt, xmed, idec)

#include <f77/lhdrsz.h>

c   routine to compute median of an array y of nt numbers sampled every
c   idec samples

c   method is an iterative one that does not require sorting the data

      parameter (big=1.e-30, afac=1.5, amp=1.5)
      real       x(SZLNHD), y(nt)

      save

      it = 0
      do  2  i = 1, nt, idec

          it = it + 1
          x(it) = y(i)
2     continue
      n = it

      suma = 0.
      sumd = 0.
      live = 0
      xmax = big
      do  20  i = 2, n

          if (x(i) .ge. xmax) xmax = x(i)
          if (x(i) .ne. 0.0) live = live + 1
          suma = suma + x(i)
          sumd = sumd + abs(x(i) - x(i-1))
20    continue
      suma = (suma+x(1))/float(n)
      sumd = sumd/float(n-1)
      if (suma .eq. 0.0) then
         xmed = 0.
         return
      endif
      diff = .01 * sumd
      fac  = float(live) / float(n)
      fac = 1.

      ipas =  0
      if (xmed .eq. 0.0) then
          a    =  suma
          eps  =  sumd
      endif
      ap   =  xmax
      am   = -xmax

1     continue

      ipas = ipas + 1
      if (ipas .gt. 12) then
         xmed =  suma / fac
         return
      endif
      sum  =  0.
      sumx =  0.
      np   =  0
      nm   =  0
      xp   =  xmax
      xm   = -xmax

      do  11  j = 1, n

          xx = x(j)
c         if (xx .ne. a) then
          if (abs(xx-a) .gt. diff) then

             if     (xx .ge. a) then
                     np = np + 1
                     if (xx .lt. xp) xp = xx
             elseif (xx .lt. a) then
                     nm = nm + 1
                     if (xx .gt.  xm) xm = xx
             endif
             dum  = eps + abs(xx-a)
             if (dum .gt. 1.e-30) then
                 dum  = 1. / dum
                 sum  = sum + dum
                 sumx = sumx + xx * dum
             endif
          endif
11    continue

      if (np-nm .gt. 2) then

         am = a
         aa = xp + max(0., sumx/sum - a) * amp
         if (aa .gt. ap) aa = .5 * (a + ap)
         eps = afac * abs(aa - a)
         a = aa
         go to 1

      elseif (nm-np .gt. 2) then

         ap = a
         aa = xm + min(0.,sumx/sum - a) * amp
         if (aa .lt. am) aa = .5 * (a + am)
         eps = afac * abs(aa - a)
         a = aa
         go to 1

      else

         if (mod(n,2) .eq. 0) then
            if (np .eq. nm) then
               xmed = .5 * (xp + xm)
            elseif (np .gt. nm) then
               xmed = .5 * (a + xp)
            else
               xmed = .5 * (xm + a)
            endif
         else
            if (np .eq. nm) then
               xmed = a
            elseif (np .gt. nm) then
               xmed = xp
            else
               xmed = xm
            endif
         endif

      endif

      return
      end
