C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine isample_sums(livesum, liverec, NumTrc, jm)
      implicit none

c Kelly D. Crawford	04/09/97
c
c Bertram Kaufhold	05/01/98	Modification
c

      integer NumTrc, jm
      integer livesum(NumTrc), liverec(NumTrc)

      integer i

c     Compute partial sums for livesum(1)

      livesum(1) = liverec(1)
      do i = 2, jm
         livesum(1) = livesum(1) + liverec(i)
      enddo

c     Compute partial sums for i < jm, and a full sum for i == jm

      do i = 2, jm
         livesum(i) = livesum(i-1) + liverec(i+jm-1)
      enddo

c     Compute full rolling window sums for jm+1 <= i <= NumTrc-jm+1
c     by dropping the sample value immediately above the rolling window
c     and adding the sample value at the bottom of the rolling window.

      do i = jm+1, NumTrc-jm+1
         livesum(i) = livesum(i-1) + (liverec(i+jm-1) - liverec(i-jm))
      enddo

c     Compute partial sums for i >= NumTrc-jm+2

      do i = NumTrc-jm+2, NumTrc
         livesum(i) = livesum(i-1) - liverec(i-jm)
      enddo

      end


