C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c minent reads seismic trace data from an input file,
c performs minimum entropy deconvolution and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, luout2
      integer     luin , luout, lbytes, nbytes, lbyout,lbyte
      integer     irs,ire,ns,ne,iter,nfilt, obytes2,ist,iend,nsampk
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        tri ( SZLNHD ), filter ( SZLNHD )
      real        work ( SZLNHD )
      real        alf
      character   ntap * 256, otap * 256, name*6
      character   ftap * 256
      logical     verbos, query, ulrich
      integer     argis
 
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'MINENT'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ftap,ist,iend,ns,ne,irs,ire,alf,iter,
     1             nfilt,vel,ulrich,verbos)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (ftap .ne. ' ')
     1call getln(luout2, ftap, 'w', 2)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'MINENT: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 6, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ist,iend,vel,alf,iter,nfilt,ntap,otap)
c     end if

c----------------
c     if output of filter is desired set up header
c     and output bytes
c----------------
      nfilt = nfilt/nsi
      nfilt2 = 2 * 2 * nfilt
      if (ftap .ne. ' ')  then
          obytes2 = SZTRHD + SZSMPD * nfilt2
          call savew(itr, 'NumSmp', nfilt2, LINHED)
          call wrtape ( luout2, itr, lbyout                )
      endif

c--------------------------------------------------
c  figure out design window times

      dt = real (nsi) * unitsc

      iend = iend/nsi + .5
      ist = ist/nsi
      if (ist .le. 1) ist = 1
      ist0 = ist
      veldt = vel * dt
      if (iend .eq. 0) iend = nsamp
      if (iend .gt. nsamp) iend = nsamp
      nsampo = iend - ist + 1

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do decon, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      iflag = 0
      do 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            do 1001 kk=ns,ne

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

c                 dist   = iabs(itr(119))
c                 static = itr(125)
c                 recnum = itr(106)
c                 trcnum = itr(107)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist , TRACEHEADER)
                  dist = iabs (idist)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum, TRACEHEADER)

                  ist = ist0 + dist/veldt
                  iend = ist + nsampo - 1
                  if (iend .le. nsamp) then
                      nsampk = nsampo
                  else
                      nsampk = nsamp - ist + 1
                      if (nsampk .lt. nfilt) then
                         write(LERR,*)'Design window start time GT trace
     1 length - FATAL'
                         write(LERR,*)'Increase window velocity & rerun'
                         go to 999
                      endif
                  endif
                     

                  IF(static .ne. 30000)then

c----------------------
c  check design window
c  for null data & if
c  not then process
                      call dotpr (tri(ist),1,tri(ist),1,xdot,nsampk)
                      if (xdot .gt. 1.e-20) then

                         if (ulrich) then
                             call uldcn (nsampk,tri(ist),work,nfilt,
     1                                   filter,iter,iflag)
                         else
                             call medcn (nsampk,tri(ist),work,nfilt,
     1                                   filter,iter,alf,iflag)
                          endif

c----------------------
c  if null data then
c  don't do anything
c  to data
                       else

                          call vclr (filter,1,nfilt)
                          filter(1) = 1.0
                          write(LERR,*)'Null data in design window for   
     1rec= ',recnum,' trc= ',trcnum,' : trace passed unprocessed'

                       endif

                       call fold (nfilt,filter,nsamp,tri,ny,work)
                       call vmov (work(nfilt/2),1,itr(ITHWP1),1,nsamp)
                       call wrtape( luout, itr, nbytes)

                       if (ftap .ne. ' ') then
                           call vclr (tri,1,nfilt2)
                           call vmov (filter,1,itr(ITHWP1),1,nfilt)
                           call wrtape( luout2, itr, obytes2)
                       endif

                  ELSE
                       call vclr(tri,1,nsamp)
                       call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                       call wrtape( luout, itr, nbytes)
                       if (ftap .ne. ' ') then
                           call wrtape( luout2, itr, obytes2)
                       endif

                  ENDIF

                  iflag = 1
 1001             continue
                  if(verbos)write(LERR,*)'minent processed ri ',recnum
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
 1000       continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )
      if (ftap .ne. ' ')
     1call lbclos ( luout2 )

            write(LERR,*)'end of minent, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*)
     :'execute minent by typing minent and a list of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]     (no default)              : input data file name'
        write(LER,*)
     :' -O [otap]     (no default)              : output data file name'
        write(LER,*)
     :' -F  [ftap]    (no default)              : filter output data fil
     :e name'
        write(LER,*)' '
        write(LER,*)
     :' -s[ist]       (default = 0 ms)          :  start time of design 
     :window (ms)'
        write(LER,*)
     :' -e[iend]      (default = end of trace)  :  end time of window (m
     :s)'
        write(LER,*)
     :' -v[vel]       (default = flat)          :  velocity of design wi
     :ndow (ft,m/s)'
        write(LER,*)
     :' -ns[ns]       (default = first)         : start trace number'
        write(LER,*)
     :' -ne[ne]       (default = last)          : end trace number'
        write(LER,*)
     :' -rs[irs]      (default = first)         : start record number'
        write(LER,*)
     :' -ne[ire]      (default = last)          : end record number'
        write(LER,*)' '
        write(LER,*)
     :' -alf [alf]    (def=4, Wiggins decon)    : exponent'
        write(LER,*)
     :' -i [iter]     (default = 5)             : number iterations'
        write(LER,*)
     :' -f [nfilt]    (no default)              : length of filter (ms)'
        write(LER,*)
     :' -U  if present use Ulrych exponential x-form method'
        write(LER,*)' '
        write(LER,*)
     :'usage:   minent -N[ntap] -O[otap] -F[ftap] -alf[alf] -i[iter]'
        write(LER,*)
     :'                -f[nfilt] -s[ist] -e[iend] -v[vel]'
        write(LER,*)
     :'                -ns[ns] -ne[ne] -rs[irs] -re[ire] -V'
        write(LER,*)' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ftap,ist,iend,ns,ne,irs,ire,alf,iter,
     1             nfilt,vel,ulrich,verbos)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     ftap  - c*100     output file name for filter
c     ist   - i*4  start design window
c     iend  - i*4  end design window
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     alf   - i*4 exponent
c     iter  - i*4 number iterations
c     nfilt - I*4 number filter points (ms)
c     ulrich      - l   use ulrych method or not
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), ftap*(*)
      integer * 4 ns, ne, irs, ire, iter, nfilt, ist, iend
      real    * 4 alf, vel
      logical    verbos, ulrich
      integer    argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-F', ftap, ' ', ' ' )
            call argi4 ( '-s', ist ,   1  ,  1    )
            call argi4 ( '-e', iend,   0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4( '-alf', alf, 4., 4. )
            call argr4( '-v', vel, 999999., 999999. )
            call argi4( '-i', iter, 5, 5 )
            call argi4( '-f', nfilt, 0, 0 )
            if(nfilt .eq. 0) then
               write(LERR,*)'Number filter points must be entered'
               stop
            endif
            verbos = (argis('-V') .gt. 0)
            ulrich = (argis('-U') .gt. 0)
            if (ulrich) then
               write(LERR,*)'Using Ulrych exponential transform method'
            else
               write(LERR,*)'Using standard minimum entropy formulation'
            endif
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1            ist,iend,vel,alf,iter,nfilt,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     ist   - i*4  start design window
c     iend  - i*4  end design window
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     alf   - I*4 exponent
c     iter  - I*4 number iterations
c     nfilt - I*4 number filter points (ms)
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec, iter, nfilt
      real    * 4 alf
      character ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' exponent           =  ', alf
            write(LERR,*) ' number iterations  =  ', iter
            write(LERR,*) ' number filter points = ',nfilt
            write(LERR,*) ' design start time  =  ', ist
            write(LERR,*) ' design end time    =  ', iend
            write(LERR,*) ' design window velocity =  ', vel
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
