C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ULDCN(NX,X,Y,NF,F,ITER,iflag)
C
C   X - INPUT TRACE TO FILTER
C   F - FILTER OF LENGTH NF
C   Y - OUTPUT FROM FILTER ( F * X = Y)
C   Z - EXPONENTIALLY SCALED OUTPUT TRACE (Y)
C   R - AUTOCORRELATION MATRIX OF INPUT SERIES, X
C   G - CROSS-CORRELATION OF Y**A WITH INPUT X
C
C   NORMAL EQUATIONS FOR M.E.D. --  R * F = G
C   THIS IS NONLINEAR AND IS SOLVED ITERATIVELY
C
C   ITER - NUMBER OF ITERATIONS
C   F - CONTAINS INITIAL GUESS OF FILTER ...
C        ... USUALLY WE CHOOSE THIS TO BE (0,...,0,1,0,...,0)
C
#include <f77/lhdrsz.h>

      DIMENSION Z(SZSMPM)
      DIMENSION X(*),Y(*),F(*),R(500),G(500),SPACE(3000)

      call vclr (y,1,nx)
      if (iflag .eq. 0) then
          call vclr (f,1,nf)
          f(nf/2) = 1.0
      endif

      DO 10 I=1,ITER
C
C   COMPUTE AUTOCORRELATION MATRIX FOR THIS ITERATION
C
      CALL CROSS(NX,X,NX,X,NF,R)
C
C   COMPUTE NEW FILTER OUTPUT FOR THIS ITERATION STEP
C
      CALL FOLD(NF,F,NX,X,NY,Y)
C
C   NORMALIZE FILTER OUTPUT TO UNITY
C
c     CALL NORMAG(NY,Y)
      call maxmgv (y,1,scl,indx,ny)
      call vsdiv  (y,1,scl,y,1,ny)
C
C   COMPUTE EXPONENTIAL TRACE Z
C
      DO 3 J=1,NY
      Z(J)=1. - 1./EXP(2.0*Y(J)*Y(J))
    3 CONTINUE
c     IF(I .EQ. ITER) return
C
C   COMPUTE  NORMS
C
      ZZ=0.
      SZ=0.
      DO 1 J=1,NY
      ZZ=ZZ + Z(J)*Z(J)
    1 SZ=SZ + Z(J)
      SZ2=SZ*SZ
      V=ZZ/SZ2
C
C   SCALE OUTPUT TRACE WITH ITS TRANSFORMED ELEMENTS
C
      DO 4 J=1,NY
      GAMA=(Z(J) - Z(J)*Z(J))/SZ2
      BETA=V*Z(J)/SZ
    4 Y(J)=(GAMA + BETA)*Y(J)
C
C   COMPUTE CROSS-CORRELATION VECTOR  Y**(A-1) * X
C
      CALL CROSS(NY,Y,NX,X,NF,G)
C
C   SCALE AUTOCORRELATION MATRIX
C
      SC=V/SZ
c     CALL SCALE(SC,NF,R)
      call vsdiv (r,1,1./sc,r,1,nf)
C
C   SOLVE NORMAL EQUATIONS FOR THIS STEP -- R * F = G --
C
      CALL EUREKb(NF,R,G,F,SPACE)
C
C   SCALE FILTER TOO MAX VALUE OF UNITY
C
c     CALL DRANG(F,1,NF,1,SCL)
c     SCL=1./SCL
c     CALL SCALE(SCL,NF,F)
      call maxmgv (f,1,scl,indx,nf)
      call vsdiv  (f,1,scl,f,1,nf)

   10 CONTINUE
      RETURN
      END
