C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*****************   miror   ****************************************c
c
c miror read records of data and mirrors first and last n-1 traces
c about the first and last trace to pad records to minimize edge
c effects from application of spatial filters.
c
c********************************************************************c
c
c Changes:
c
c         August 31, 2000
c          routine parse was not parsing.  Ended up being sbuf needed to 
c          to be sbuf*512 rather than character*1 sbuf(512).
c         Garossino
c
c         Added remove option (-R) per Richard Crider request 11/11/96 - jev
c
c
c     declare variables
c
c-----
c    get machine dependent parameters

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
c-----
 
      integer pmax,mmax
      parameter (pmax=10)
      parameter (mmax=100)
      integer     itr ( SZLNHD )
      integer     trlen
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire, jerr
      
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1(1)
c------

      character   ntap * 512, otap * 512, name*5
c      character*1 sbuf (512)
      character sbuf*512
      logical     query, heap1,verbos
      logical     remove, rflag
      integer     argis
      integer     abort,disth
      pointer     (wkadr1, bigar1)

c variables caught by implicit none --- Garossino
c

      integer ntrs, mode, ifound, ns, ne, iget
      integer errcd1, abort1, memsum, nrecc, jtr, jj, idst
      integer jdst, iset, jset, kk, idist, idistf, idistb, istat
      integer istrc, io, i, ndx, kdist, j, recnum, trcnum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_DstUsg,l_DstUsg,ln_DstUsg
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor

      real rmode, rntrs, rntr
 
      data lbytes / 0 /, nbytes / 0 /, name/'MIROR'/
      data abort / 0 /
c      data sbuf /512*' '/
 
c-----
c     read program parameters from command line card image file
c-----
      query = (argis ( '-?' ) .gt. 0) .or. (argis ('-H') .gt. 0) .or.
     :        (argis ( '-h' ) .gt. 0) .or. (argis ('-help') .gt. 0)
      if ( query )then
            call help(ler)
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,irs,ire,ntrs,mode,disth,verbos,remove)

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'MIROR: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

       if(ntrs.eq.0)ntrs = ntrc/2

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 6, LERR)

      if (remove) then
c         write (LERR,*) ' calling findhlh ' 
          call findhlh (itr, 'miror', 5, sbuf, LERR,HSTOFF,
     1                  SZHFWD,lbytes)
c         write (LERR,*) sbuf
          call parse ('-R', sbuf, rflag, ifound)
          if (ifound .eq. 1) then 
            write(LERR,*)' '
            write(LERR,*)'ERROR:'
            write(LERR,*)' -R option invalid when previous miror was -R'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'ERROR:'
            write(LER,*)' -R option invalid when previous miror was -R'
            write(LER,*)' '
            call lbclos(luin)
            call lbclos(luout)
            stop 100
          endif
          call parse ('-md', sbuf, rmode, ifound)
          if (ifound .eq. 0) rmode = 0.0
          mode = rmode
          rntrs = 0.0
          call parse ('-n', sbuf, rntrs, ifound)
          ntrs = rntrs
          if (ifound .eq. 0 .or. rntrs .eq. 0.0) then
              if (mode .eq. 0) then
                  rntrs = (ntrc + 2 ) * 2 / 4
              elseif (mode .eq. 1) then 
                  rntrs = (ntrc + 1) * 2 / 3
              endif
              rntr = nint (rntrs)
              ntrs = rntrs / 2 
          endif
          write (LERR,*) ' ntrc= ',ntrc
          write (LERR,*) 
          write (LERR,*) ' removing previous miror run '
          write (LERR,*) ' previous run mode = ',mode,', ntrs = ',ntrs
          write (LERR,*) ' rmode = ', rmode, ' rntrs = ', rntrs
          write (LERR,*)
      endif
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
c-----
      ns = 1
      ne = ntrc
c      write(LERR,*) ns,ne,irs,ire,ntrc,nrec
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c      write(LERR,*) ns,ne,irs,ire,ntrc,nrec

      if(verbos)then
       call verbal(nsamp, nsi, ntrc, nrec, iform,
     :                  mode, ntrs, disth,ntap,otap,remove)
      endif

c---------------------------------------------------
c  malloc space we are going to use
      heap1 = .true.

c  note also ISZBYT is the 
c  size of an item in bytes
c--------------------------

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      trlen = nsamp + ITRWRD
      iget = ntrc * trlen * ISZBYT
      call galloc (wkadr1, iget, errcd1, abort1)
      memsum=iget
      if (errcd1 .ne. 0.) heap1 = .false.

      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c---------------------------------------------------


c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      if(mode.eq.0)then
       if (remove) then 

c        if ntrs not on command line
c        jtr = ntrc + (ntrc/2) + (ntrc/2) - 2
c        ntrc = (jtr + 2 ) * 2 / 4 (force rounding)
 
         jtr = ntrc - ntrs - ntrs + 2
       else
         jtr = ntrc + ntrs + ntrs - 2
       endif
      else
       if (remove) then

c        if ntrs not on command line
c        jtr = ntrc + (ntrc/2) - 1
c        ntrc = (jtr + 1 ) * 2 / 3 (force rounding)
 
         jtr = ntrc - ntrs + 1
       else
         jtr = ntrc + ntrs - 1
       endif
      end if
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr , LINHED)

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * ISZBYT
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c     if(irs.gt.1)then
c      iget=(irs-1)*ntrc+1
c      call sisseek(luin,iget)
c     end if


c-----
c     process desired trace records
c-----
      if (.not. remove) then

c-----
c     add miror
c-----

      do jj = irs, ire
 
       idst=0
       jdst=0
       iset=0
       jset=1

c*********
       do kk = 1,ntrc
        nbytes = 0
        call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c------
        if(nbytes .eq. 0) then
         write(LERR,*)'End of file on input:'
         write(LERR,*)'  rec= ',jj,'  trace= ',kk
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif

        call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     :   idist , TRACEHEADER)
        if(kk.eq.1)then
         idistf = idist
        else 
         idistb =idist
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     :    istat , TRACEHEADER)

        if(istat.lt.30000.and.kk.gt.ntrc/5)then
         if(idst.eq.0)then
          idst = idist
         else if (iset.eq.0)then
          idst = idist - idst
          iset = 1
          jset = 0
         end if
         if(jdst.eq.0)then
          if(jset.eq.0)jdst=idist
         else if (jset.eq.0)then
          jdst = idist - jdst
          jset = 1
         endif
        endif

        istrc = (kk-1)*trlen+1
        call vmov (itr,1, bigar1(istrc),1,trlen)
       end do    
c*********
c---------------------
c  write output data

c -----------------
c - write the mirror data first

       io = 0
       do i=ntrs,2,-1
        ndx = (i-1)*trlen+1
        io = io + 1
        call vmov(bigar1(ndx),1,itr,1,trlen)
        if(disth.ne.0)then
         kdist = idistf - (i-1)*idst
         call savew(itr,'DstSgn',kdist,TRCHED)
         kdist = iabs(kdist)
         call savew(itr,'DstUsg',kdist,TRCHED)
        endif
        call savew(itr,'TrcNum',io,TRCHED)
        call wrtape(luout,itr,obytes)
       end do

c - write main body
       do i=0,ntrc-1
        ndx=i*trlen+1
        io = io + 1
        call savew(bigar1(ndx),'TrcNum',io,TRCHED)
        call wrtape(luout,bigar1(ndx),obytes)
       end do

c - write afterthought

       if(mode.ne.1)then
        do i=2,ntrs      
         j=ntrc-i
         ndx=j*trlen+1
         io = io + 1
         call vmov(bigar1(ndx),1,itr,1,trlen)
         if(disth.ne.0)then
          kdist = idistb + jdst*(i-1)
          call savew(itr,'DstSgn',kdist,TRCHED)
          kdist = iabs(kdist)
          call savew(itr,'DstUsg',kdist,TRCHED)
         endif
         call savew(itr,'TrcNum',io,TRCHED)
         call wrtape(luout,itr,obytes)
        end do
       end if

       if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
 
 
      end do

      else

c-----
c     remove miror
c-----

      do jj = irs, ire

       do i = 2, ntrs
         call rtape (luin, itr, nbytes)
         if (nbytes .eq. 0) then
           write (LERR,*) 'End of file on input:'
           write (LERR,*) '  rec = ', jj
           call lbclos (luin)
           call lbclos (luout)
           stop
         endif
       enddo

       io = 0
       
       do i = 1, jtr
         io=io+1
         call rtape (luin, itr, nbytes)
         if (nbytes .eq. 0) then
           write (LERR,*) 'End of file on input:'
           write (LERR,*) '  rec = ', jj
           call lbclos (luin)
           call lbclos (luout)
           stop
         endif
         call savew (itr, 'TrcNum',io,TRCHED)
         call wrtape (luout, itr, obytes)
       enddo
 
       if (mode .ne. 1) then

         do i = 2, ntrs
           call rtape (luin, itr, nbytes)
           if (nbytes .eq. 0) then
             write (LERR,*) 'End of file on input:'
             write (LERR,*) '  rec = ', jj
             call lbclos (luin)
             call lbclos (luout)
             stop
           endif
         enddo

       endif
      enddo

      endif


c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of miror, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'miror duplicates the n edge-most traces of a record and places'
        write(LER,*)
     :'the duplicates at the front and end of record.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute miror by typing miror and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -md[md]      (default = 0)        : operations'
        write(LER,*)
     :'                                     0 = Front and back'
        write(LER,*)
     :'                                     1 = Front only'
        write(LER,*)
     :' -n[ntrs]    (default = 1/2 input) : Number of traces to mirror'
        write(LER,*)
     :' -d[disth]      (default = 0)      : offset handling'
        write(LER,*)
     :'                                     0 = leave unchanged'
        write(LER,*)
     :'                                     1 = extrapolate using first'
        write(LER,*)
     :'                                         and last interval'
        write(LER,*) ' '
        write(LER,*) ' -R                                : remove previo
     :usly mirrored traces'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   miror -N[ntap] -O[otap] -rs[irs] -re[ire] -md[md]'
        write(LER,*)
     :'     -n[ntrs] -d[disth]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,ntrs,mode,disth,verbos,remove)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     ntrs  - I*4      Number of traces to mirror
c     mode  - I*4      0=front and back, 1=front only
c     disth - I*4      0=distances unchanged, 1=extrapolate
c     remove - L*1     undo previous miror
c
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     irs, ire,argis
      integer     mode, ntrs,disth
      logical     verbos
      logical     remove
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-md', mode,  0, 0 )
            call argi4 ( '-n' , ntrs,  0, 0)
            call argi4 ( '-d' , disth,  0, 0)
            verbos = ( argis ( '-V' ) .gt. 0 )
            remove = ( argis ( '-R' ) .gt. 0 )
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     :                  mode, ntrs, disth,ntap,otap,remove)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c     remove - L*1    undo previous miror
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec
      integer     disth,ntrs,mode
      character   ntap*(*), otap*(*)
      logical     remove
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace   =  ', nsamp
            write(LERR,*) ' sample interval      =  ', nsi
            write(LERR,*) ' traces per record    =  ', ntrc
            write(LERR,*) ' records per line     =  ', nrec
            write(LERR,*) ' format of data       =  ', iform
            write(LERR,*) ' input data set name  =  ', ntap
            write(LERR,*) ' output data set name =  ', otap
            write(LERR,*) ' operations mode      =  ', mode
            write(LERR,*) ' # traces mirrored    =  ', ntrs
            write(LERR,*) ' offset handling      =  ', disth
            if (remove) then
               write(LERR,*) ' remove mirrored traces'
            endif
 
      return
      end
