C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE XFOLD(NX,LX,X,ist,LSF,SF,nsamp,temp1,temp2)
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   
C        FORTRAN BY KEN PEACOCK  5-3-88                                 
C     SFOLD PERFORMS A SPATIAL CONVOLUTION OF A RECORD OF DATA WITH A   
C     1-D SPATIAL OPERATOR.                                             
C        INPUTS ARE...                                                  
C             NX, NUMBER OF TRACES.                                     
C             LX, LENGTH OF TRACES, SAMPLES.                            
C             X, A MATRIX OF INPUT DATA.                                
C             LSF, SPATIAL LENGTH OF FILTER, SAMPLES.                   
c             ist, start sample of filter operation
C             SF, THE SPATIAL OPERATOR.                                 
C             NY, NUMBER OF OUTPUT TRACES, NY = NX+LSF-1.               
C             Y, THE MATRIX OF OUTPUT DATA.                             
C     VERSION AS OF 5-3-88.                                             
C                                                                       
#include <f77/lhdrsz.h>
c     DIMENSION X(SZSMPM,SZSPRD),SF(*),Y(SZSMPM,SZSPRD+50)
      DIMENSION X(nsamp,nx),SF(*)
      REAL      temp1(*), temp2(*)

      mix  = lsf
      mix2 = lsf / 2 + 1
      mix1 = lsf + 1
      m21  = mix + mix2 - 1
      ns   = NX + lsf
      nm   = NX + 2*lsf

      DO   L=ist,LX                                                       


         do  ii = 1, NX
             temp1 (ii + lsf) = X (L,ii)
         enddo
         x1 = X (L,1)
         x2 = X (L,NX)
         do  ii = 1, lsf
             temp1 (ii)      = x1
             temp1 (ii + ns) = x2
         enddo

         call fold (lsf,sf,nm,temp1,nf,temp2)

         do  ii = 1, NX
             X (L, ii) = temp2 (ii+m21)
         enddo

      ENDDO

      RETURN                                                            
      END                                                               
