/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* NOT SURE WHY, BUT THIS STUFF ISN'T FOUND ON SEVERAL OF THE SYSTEMS... */

#include <localsys.h>

/*
      C version of (translated by Kelly Crawford - 06/27/95):

      include file for usp programs written by Bill Done & Paul Gutowski
 
      define logical unit numbers
*/

#define LER 2
#define LUER 2

#define LIN 0
#define LOT 1
#define LUN 9
#define LERR 37
#define LUTEMP 39
#define LPRT 1
#define LUSI 0
#define LUSO 1
#define LUCARD 20
#define LUPRT 21
#define LUTERM 22
#define LUPPRT 23
#define LUDISK 24
#define LUTERI 100
#define LUTERO 101

/*----
c      SZDTHD	- size of trace header on disk in bytes
c      SZINPH   - size integer trace plus header
c      SZTRHD	- size of trace header in pipes in bytes
c      LNTRHD   - size of trace header in samples
c      SZDVHD	- size of vanl analysis header on disk in bytes
c      SZVAHD	- size of vanl analysis header in pipes in bytes
c      SZSAMP	- size of floating point sample in bytes
c      SZSMPM	- maximum number of trace samples
c      SZLNHD	- line file size = (SZTRHD + SZSAMP*MAXSMP)/2
c      SZSPRD   - size of the spread in channels
c      SZSMPD   - size of sample in pipe (in bytes)
c      HSTOFF   - byte count at which hlh starts
c      VDVOFF   - byte count at which v-dv pairs start in vanl format data
c      SZHFWD   - size in bytes of 1/2 word
c      ITRWRD   - number of full words (memory) in trace header
c      ITHWP1   - ITRWRD + 1
c      ISZBYT   - number of bytes in a word (memory) for this system
----*/
#define SZDTHD 256
#define LNTRHD 128
#define SZDVHD 2112
#define SZSAMP 4
#define SZLNHD 10000

#ifndef CRAYSYSTEM
#   define SZTRHD 256
#   define SZSMPD 4
#   define SZSMPM 4096
#   define SZINPH 4128
#   define SZVAHD 2112
#   define SZSPRD 1000
#   define HSTOFF 1004
#   define VDVOFF 64
#   define SZHFWD 2
#   define ITRWRD 64
#   define ISZBYT 4
#   define ITHWP1 65
#else
#   define SZTRHD 1024
#   define SZSMPD 8
#   define SZSMPM 8192
#   define SZINPH 8320
#   define SZVAHD 4272
#   define SZSPRD 1500
#   define HSTOFF 2592
#   define VDVOFF 176
#   define SZHFWD 8
#   define ITRWRD 128
#   define ISZBYT 8
#   define ITHWP1 129
#endif

/* END OF THE NOT FOUND EVERYWHERE STUFF... */

/* Author:  Kelly D. Crawford
   Date:    06/12/96
   Purpose: Grabs a set of input USP datasets and generates output
            volumes for maximum, minimum and average samples.
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* USP stuff */
/*
#include <iounit.h>
#include <lhdrsz.h>
*/
#include <save_defs.h>
#include <cu_defs.h>
#include <sisio.h>

void multistat_help();
#define MAX_NUMBER_OF_INPUT_FILES 100

int main(argc, argv)
int argc;
char **argv;
{
char input_file[MAX_NUMBER_OF_INPUT_FILES][256];
int number[MAX_NUMBER_OF_INPUT_FILES];
char min_file[256], MIN_file[256];
char max_file[256], MAX_file[256];
char avg_file[256], AVG_file[256];
char std_file[256];
char var_file[256];
char skew_file[256];
char kurt_file[256];
int number_of_input_files;
float f_number_of_input_files, d;

int usp_lineheader[SZLNHD];
float **usp_input_trace;
float *min_trace, *MIN_trace;
float *max_trace, *MAX_trace;
float *avg_trace, *AVG_trace;
float *std_trace;
float *var_trace;
float *skew_trace;
float *kurt_trace;
int usp_trace_bytes;

#ifdef OLD_STUFF
float def_cutoff, cutoff;
#endif

int i, j, k, l;

/* Line header variables */
int NumSmp, NumTrc, NumRec;

int luin[MAX_NUMBER_OF_INPUT_FILES];
int min_luout, MIN_luout;
int max_luout, MAX_luout;
int avg_luout, AVG_luout;
int std_luout;
int var_luout;
int skew_luout;
int kurt_luout;
int nbytes;  /* Number of bytes read in using C_RTAPE */

/* Help? */
if (C_ARGIS("-?", &argc, argv) ||
    C_ARGIS("-h", &argc, argv) ||
    C_ARGIS("-help", &argc, argv)) {
   multistat_help();
   exit(-1);
}

/* Open the input files */
i = -1;
for (number_of_input_files = 0; ; ) {
   C_ARGSTR("-N", input_file[number_of_input_files], "", "", &argc, argv);
   if (strlen(input_file[number_of_input_files]) > 0) {
      lbopen(&(luin[number_of_input_files]),
               input_file[number_of_input_files], "r");
      C_ARGI4("-n", &(number[number_of_input_files]), i, i, &argc, argv);
      if (number[number_of_input_files] == -1) {
         fprintf(stderr, "Must have one -n for every -N.\n");
         fprintf(stderr, "All -n values must be non-negative.\n");
         fprintf(stderr, "Please respecify options and try again.\n");
         exit(-1);
      }
      number_of_input_files++;
   }
   else
      break;
}

if (number_of_input_files <= 1) {
   fprintf(stderr, "Error -- Must specify at least two input files\n");
   exit(-2);
}

f_number_of_input_files = 1.0 / (float)number_of_input_files;
for (l = 0; l < number_of_input_files; l++)
   fprintf(stderr, "luin[%d] = %d\n", l, luin[l]);

/* Open the output files */
min_luout = MIN_luout = 0;
max_luout = MAX_luout = 0;
avg_luout = AVG_luout = 0;
std_luout = var_luout = skew_luout = kurt_luout = 0;
C_ARGSTR("-min", min_file, "", "", &argc, argv);
if (strlen(min_file) > 0) lbopen(&min_luout, min_file, "w");
C_ARGSTR("-MIN", MIN_file, "", "", &argc, argv);
if (strlen(MIN_file) > 0) lbopen(&MIN_luout, MIN_file, "w");
C_ARGSTR("-max", max_file, "", "", &argc, argv);
if (strlen(max_file) > 0) lbopen(&max_luout, max_file, "w");
C_ARGSTR("-MAX", MAX_file, "", "", &argc, argv);
if (strlen(MAX_file) > 0) lbopen(&MAX_luout, MAX_file, "w");
C_ARGSTR("-avg", avg_file, "", "", &argc, argv);
if (strlen(avg_file) > 0) lbopen(&avg_luout, avg_file, "w");
C_ARGSTR("-std", std_file, "", "", &argc, argv);
if (strlen(std_file) > 0) lbopen(&std_luout, std_file, "w");
C_ARGSTR("-var", var_file, "", "", &argc, argv);
if (strlen(var_file) > 0) lbopen(&var_luout, var_file, "w");

#ifdef NOT_YET_IMPLEMENTED
C_ARGSTR("-skew", skew_file, "", "", &argc, argv);
if (strlen(skew_file) > 0) lbopen(&skew_luout, skew_file, "w");
C_ARGSTR("-kurt", kurt_file, "", "", &argc, argv);
if (strlen(kurt_file) > 0) lbopen(&kurt_luout, kurt_file, "w");
#endif

#ifdef OLD_STUFF
C_ARGSTR("-AVG", AVG_file, "", "", &argc, argv);
if (strlen(AVG_file) > 0) lbopen(&AVG_luout, AVG_file, "w");
#endif

#ifdef DEBUGGING_MODE
fprintf(stderr, "min_luout = %d, MIN_luout = %d\n", min_luout, MIN_luout);
fprintf(stderr, "max_luout = %d, MAX_luout = %d\n", max_luout, MAX_luout);
/* fprintf(stderr, "avg_luout = %d, AVG_luout = %d\n", avg_luout, AVG_luout); */
fprintf(stderr, "avg_luout = %d\n", avg_luout);
#endif

#ifdef OLD_STUFF
/* Check for a cutoff value between max and min */
def_cutoff = -38.0;
C_ARGR4("-cutoff", &cutoff, def_cutoff, def_cutoff, &argc, argv);
#endif

/* Read in the USP lineheader */
for (l = 0; l < number_of_input_files; l++)
   C_RTAPE(luin[l], usp_lineheader, &nbytes);

/* Grab values from the USP lineheader */
saver(usp_lineheader, "NumSmp", &NumSmp, LINEHEADER);
saver(usp_lineheader, "NumTrc", &NumTrc, LINEHEADER);
saver(usp_lineheader, "NumRec", &NumRec, LINEHEADER);
#ifdef DEBUGGING_MODE
fprintf(stderr, "NumSmp = %d\n", NumSmp);
fprintf(stderr, "NumTrc = %d\n", NumTrc);
fprintf(stderr, "NumRec = %d\n", NumRec);
#endif

/* Write the output line headers */
if (min_luout) C_WRTAPE(min_luout, usp_lineheader, nbytes);
if (MIN_luout) C_WRTAPE(MIN_luout, usp_lineheader, nbytes);
if (max_luout) C_WRTAPE(max_luout, usp_lineheader, nbytes);
if (MAX_luout) C_WRTAPE(MAX_luout, usp_lineheader, nbytes);
if (avg_luout) C_WRTAPE(avg_luout, usp_lineheader, nbytes);
if (AVG_luout) C_WRTAPE(AVG_luout, usp_lineheader, nbytes);
if (std_luout) C_WRTAPE(std_luout, usp_lineheader, nbytes);
if (var_luout) C_WRTAPE(var_luout, usp_lineheader, nbytes);
if (skew_luout) C_WRTAPE(skew_luout, usp_lineheader, nbytes);
if (kurt_luout) C_WRTAPE(kurt_luout, usp_lineheader, nbytes);

/* Compute number of bytes in the input and output traces */
usp_trace_bytes = SZDTHD + (NumSmp * SZSAMP);

/* Allocate space for the input and output usp traces */
usp_input_trace = (float **)malloc(sizeof(float *) * number_of_input_files);
for (l = 0; l < number_of_input_files; l++) {
   usp_input_trace[l] = (float *)malloc(usp_trace_bytes);
   memset(usp_input_trace[l], 0, usp_trace_bytes);
}
min_trace = (float *)malloc(usp_trace_bytes);
memset(min_trace, 0, usp_trace_bytes);
MIN_trace = (float *)malloc(usp_trace_bytes);
memset(MIN_trace, 0, usp_trace_bytes);
max_trace = (float *)malloc(usp_trace_bytes);
memset(max_trace, 0, usp_trace_bytes);
MAX_trace = (float *)malloc(usp_trace_bytes);
memset(MAX_trace, 0, usp_trace_bytes);
avg_trace = (float *)malloc(usp_trace_bytes);
memset(avg_trace, 0, usp_trace_bytes);
std_trace = (float *)malloc(usp_trace_bytes);
memset(std_trace, 0, usp_trace_bytes);
var_trace = (float *)malloc(usp_trace_bytes);
memset(var_trace, 0, usp_trace_bytes);
skew_trace = (float *)malloc(usp_trace_bytes);
memset(skew_trace, 0, usp_trace_bytes);
kurt_trace = (float *)malloc(usp_trace_bytes);
memset(kurt_trace, 0, usp_trace_bytes);
AVG_trace = (float *)malloc(usp_trace_bytes);
memset(AVG_trace, 0, usp_trace_bytes);

/* Main loop */
for (i = 1; i <= NumRec; i++) {
   fprintf(stderr, "Processing line %d of %d\n", i, NumRec);

   for (j = 0, k = ITRWRD; j < NumTrc; j++, k++) {
      /* Read the next set of input traces */
      for (l = 0; l < number_of_input_files; l++)
         C_RTAPE(luin[l], usp_input_trace[l], &nbytes);

      for (k = ITRWRD; k < NumSmp+ITRWRD; k++) {
         min_trace[k] = max_trace[k] = avg_trace[k] = usp_input_trace[0][k];
         MIN_trace[k] = MAX_trace[k] = AVG_trace[k] = number[0];

         /* Compute min, max, and avg samples */
         for (l = 1; l < number_of_input_files; l++) {
            avg_trace[k] += (d = usp_input_trace[l][k]);
            if (min_trace[k] > d) {
               min_trace[k] = d;
               MIN_trace[k] = number[l];
            }
            if (max_trace[k] < d) {
               max_trace[k] = d;
               MAX_trace[k] = number[l];
            }
         }
         avg_trace[k] *= f_number_of_input_files;

         /* Compute variance and standard deviation */
         if (var_luout || std_luout) {
            var_trace[k] = 0.0;
            for (l = 0; l < number_of_input_files; l++) {
               d = usp_input_trace[l][k] - avg_trace[k];
               var_trace[k] += (d * d);
            }
            var_trace[k] *= f_number_of_input_files;
            if (var_trace[k] >= 0.0) {
               std_trace[k] = sqrt(var_trace[k]);
            }
            else {
               std_trace[k] = 0.0;
            }
         }

#ifdef OLD_STUFF
         /* avg is no longer the average.  It is the max or min,
            depending on what the average trend is. */
         if (avg_trace[k] < cutoff) {
            avg_trace[k] = min_trace[k];
            AVG_trace[k] = MIN_trace[k];
         }
         else {
            avg_trace[k] = max_trace[k];
            AVG_trace[k] = MAX_trace[k];
         }
#endif
      }

      /* Grab the USP traceheader and min/max/avg values and write them out. */
      if (min_luout) {
         memcpy(min_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(min_luout, min_trace, usp_trace_bytes);
      }
      if (MIN_luout) {
         memcpy(MIN_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(MIN_luout, MIN_trace, usp_trace_bytes);
      }
      if (max_luout) {
         memcpy(max_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(max_luout, max_trace, usp_trace_bytes);
      }
      if (MAX_luout) {
         memcpy(MAX_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(MAX_luout, MAX_trace, usp_trace_bytes);
      }
      if (avg_luout) {
         memcpy(avg_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(avg_luout, avg_trace, usp_trace_bytes);
      }
      if (std_luout) {
         memcpy(std_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(std_luout, std_trace, usp_trace_bytes);
      }
      if (var_luout) {
         memcpy(var_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(var_luout, var_trace, usp_trace_bytes);
      }
      if (skew_luout) {
         memcpy(skew_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(skew_luout, skew_trace, usp_trace_bytes);
      }
      if (kurt_luout) {
         memcpy(kurt_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(kurt_luout, kurt_trace, usp_trace_bytes);
      }
      if (AVG_luout) {
         memcpy(AVG_trace, usp_input_trace[0], SZDTHD);
         C_WRTAPE(AVG_luout, AVG_trace, usp_trace_bytes);
      }
   }
}

for (l = 0; l < number_of_input_files; l++)
   lbclos(luin[l]);
if (min_luout) lbclos(min_luout);
if (MIN_luout) lbclos(MIN_luout);
if (max_luout) lbclos(max_luout);
if (MAX_luout) lbclos(MAX_luout);
if (avg_luout) lbclos(avg_luout);
if (AVG_luout) lbclos(AVG_luout);
if (std_luout) lbclos(std_luout);
if (var_luout) lbclos(var_luout);
if (skew_luout) lbclos(skew_luout);
if (kurt_luout) lbclos(kurt_luout);
fprintf(stderr, "multistat successfully completed\n");
exit(0);
}

void multistat_help() {
fprintf(stderr, "\
\n\
multistat -N <input_usp_file_1> -n <number_1>\n\
          -N <input_usp_file_2> -n <number_2>\n\
          ...\n\
          -N <input_usp_file_x> -n <number_x>\n\
          -min <minimum_sample_volume> -MIN <number_of_minimum_sample>\n\
          -max <maximum_sample_volume> -MAX <number_of_maximum_sample>\n\
          -avg <average_sample> -std <standard_deviation> -var <variance>\n\
          -? -h\n\
\n\
   -N <input_usp_file_x> - Name of the x'th input USP dataset.\n\
   -n <number_x> - A unique non-negative number associated with the x'th\n\
                   dataset.  For example, -lwin from multiple c3 runs.\n\
                   If not specified, the files will be numbered from\n\
                   1 to the number of input files, as found in order\n\
                   on the command line.\n\
\n\
   -min <minimum_sample_volume> - Volume containing the minimum samples\n\
                   from each of the input_usp_files.\n\
   -MIN <number_of_minimum_sample> - Volume containing the input dataset\n\
                   number where the minimum sample was found.\n\
\n\
   -max <maximum_sample_volume> - Volume containing the maximum samples\n\
                   from each of the input_usp_files.\n\
   -MAX <number_of_maximum_sample> - Volume containing the input dataset\n\
                   number where the maximum sample was found.\n\
\n\
   -avg <average_sample_volume> - Volume containing the average of the\n\
                   samples across all the input_usp_files.\n\
   -std <standard_deviation_sample_volume> - Volume containing the standard\n\
                   deviation of the samples across all the input_usp_files.\n\
   -var <variance_sample_volume> - Volume containing the variance of the\n\
                   samples across all the input_usp_files.\n\
\n\
   -?,-h  - Help.  You're looking at it.\n\
\n\
");
}
