C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C--- MYDSYC                                                             00000200
C                                                                       00000300
C***********************************************************************00000400
C AMOCO PRODUCTION COMPANY PROPRIETY - TO BE MAINTAINED IN CONFIDENCE   00000500
C                                                                       00000600
C PROGRAM NAME: MYDS (MULTI-DIMENSIONAL TRUE AMPLITUDE SCALING)         00000700
C                                                                       00000800
C MODIFICATION HISTORY:                                                 00000900
C                                                                       00001000
C              01/30/87     - DAVID LEWIS                               00001100
C                             1) CREATE MODEL TRACE FROM FILTERED INPUT 00001200
C                                TRACE.                                 00001300
C                             2) ACCEPT MODEL TRACE FROM SECONDARY TAPE.00001400
C                             3) ELIMINATE ACCEPTANCE OF 8FILT CARDS.   00001500
C                             4) REMOVE JOB NUMBER.                     00001600
C                             5) CONVERT TO FORTRAN 77.                 00001700
C                             6) ELIMINATE PROGRAM MYPL.                00001800
C                             7) MODIFY TO USE LOADERIZABLE RESTART     00001900
C                                PROCEDURE.                             00002000
C                             8) MODIFIED OPTION MYPL TO PUT FREQUENCY  00002100
C                                INFORMATION INTO THE TRACE HEADERS.    00002200
C                             9) MYDSYA PULLED FROM DAFDXA.             00002300
C                            10) ASSURE THAT THE NUMBER OF TRACES FOR   00002400
C                                THE FILTER PANEL DOES NOT EXCEED THE   00002500
C                                NUMBER OF INPUT TRACES.                00002600
C                                                                       00002700
C*****                                                                  00002800
C                                                                       00002900
C ABSTRACT:                                                             00003000
C                                                                       00003100
C     MYDS WILL PERFORM TIME-VARIANT NORMALIZATION OF EACH FREQUENCY    00003200
C     COMPONENT TO THE INPUT TRACE ENVELOPE.  EACH SAMPLE OF THE        00003300
C     FILTERED TRACE IS NORMALIZED TO THE INPUT TRACE BY MULTIPLYING    00003400
C     EACH FILTERED SAMPLE BY THE RATIO OF THE ENVELOPE OF THE INPUT    00003500
C     TRACE TO THE ENVELOPE OF THE FILTERED TRACE.  THE ENVELOPES       00003600
C     ARE CALCULATED BY A TRIANGULAR SMOOTHING OPERATOR.                00003700
C                                                                       00003800
C*****                                                                  00003900
C                                                                       00004000
C SUBROUTINE DESCRIPTIONS AND PARAMETERS                                00004100
C                                                                       00004200
C     THE MAIN ROUTINE CALLS MYDSET                                     00004300
C     TO READ IN THE INPUT DATA CARDS AND CHECKS THE DATA CARDS         00004400
C     AND THE INPUT DATA SET LINE HEADER FOR ERRORS.  FILSET IS CALLED  00004500
C     TO GENERATE A SMOOTHED ORMSBY FILTER FOR EACH SET OF FILTER       00004600
C     DESIGN FREQUENCIES.  FINALLY, MYDS IS CALLED TO PERFORM THE       00004700
C     FILTERING.                                                        00004800
C                                                                       00004900
C                                                                       00005000
C     GRAF3 GRAPHS THE E ARRAY IN A SIMULATED VARIABLE ARRAY.           00005100
C                                                                       00005200
C     CALL GRAF3 (LE, FDEL, ISI, IPR)                                   00005300
C                                                                       00005400
C       LE   - SET TO 126                                               00005500
C       FDEL - SET TO 1                                                 00005600
C       ISI  - SAMPLE INTERVAL                                          00005700
C       IPR  - LOGICAL UNIT NUMBER FOR PRINTER                          00005800
C                                                                       00005900
C                                                                       00006000
C     RESTRT IS CALLED IF A RESTART IS REQUESTED.                       00006100
C     RESTRT WILL CALL RSSKIP TO LOCATE THE RECORD TO RESTART ON.       00006200
C                                                                       00006300
C     CALL RESTRT (JBUF, &999, &999, IST)                               00006400
C                                                                       00006500
C       JBUF - DATA BUFFER                                              00006600
C       &999 - STATEMENT NUMBER TO BRANCH TO IF CORRECT RECORDS         00006700
C              WERE FOUND                                               00006800
C       &999 - STATEMENT NUMBER TO BRANCH TO IF CORRECT RECORDS         00006900
C              COULD NOT BE FOUND                                       00007000
C       IST  - LAST RECORD NUMBER PROCESSED TO COMPLETION.              00007100
C                                                                       00007200
C                                                                       00007300
C     GRAFF GRAPHS THE FILTER.                                          00007400
C                                                                       00007500
C     CALL GRAFF (IFLL, AGRAF)                                          00007600
C                                                                       00007700
C       IFLL  - LENGTH OF FILTER                                        00007800
C       AGRAF - FILTER                                                  00007900
C                                                                       00008000
C                                                                       00008100
C                                                                       00008200
C     ACURCY WILL DETERMINE IF THE FAST MODE CAN BE USED FOR THE        00008300
C     SPECIFIED FILTERS.                                                00008400
C                                                                       00008500
C     CALL ACURCY (FD, INC21, ISI, XFLSH, N, &999)                      00008600
C                                                                       00008700
C       FD    - SET TO 1000./NPOW*ISI BY ACURACY                        00008800
C       INC21 - SET TO 8192 (INPUT)                                     00008900
C       ISI   - SAMPLE INTERVAL                                         00009000
C       XFLSH - IF3 - IF1 (INPUT)                                       00009100
C       N     - NUMBER OF FILTERS                                       00009200
C       &999  - STATEMENT NUMBER TO BRANCH TO IF ACCURACY CHECK FAILED. 00009300
C                                                                       00009400
C                                                                       00009500
C     RSSKIP IS CALLED TO RESTART THE JOB BY CALLING FNDTRA.            00009600
C     IT WILL FIND THE FIRST RECORD AFTER THE RECORD PASSED TO IT       00009700
C     FOR BOTH THE INPUT AND OUTPUT TAPES AND SET UP THE RESTART        00009800
C     ON THAT RECORD.                                                   00009900
C                                                                       00010000
C     CALL RSSKIP (IPR, LUI, LUO, JBUF, IST)                            00010100
C                                                                       00010200
C       IPR   - LOGICAL UNIT NUMBER OF PRINTER                          00010300
C       LUI   - LOGICAL UNIT NUMBER OF INPUT TAPE DEVICE                00010400
C       LUO   - LOGICAL UNIT NUMBER OF OUTPUT TAPE DEVICE               00010500
C       JBUF  - TRACE BUFFER                                            00010600
C       IST   - LAST COMPLETED RECORD                                   00010700
C                                                                       00010800
C                                                                       00010900
C     FNDTRA IS CALLED TO FIND THE DESIRED RECORD AND TRACE.            00011000
C                                                                       00011100
C     CALL FNDTRA (IPR, JBUF, LU, IST, ITRC, ICODE, &999)               00011200
C                                                                       00011300
C       IPR   - LOGICAL UNIT NUMBER OF PRINTER                          00011400
C       JBUF  - TRACE BUFFER                                            00011500
C       LU    - LOGICAL UNIT NUMBER OF DEVICE TO READ TRACES FROM       00011600
C       IST   - FIRST RECORD TO BE LOCATED                              00011700
C       ITRC  - FIRST TRACE TO BE LOCATED                               00011800
C       ICODE - CONDITION CODE (OUTPUT)                                 00011900
C       &999  - STATEMENT NUMBER TO BRANCH TO IF NO MATCH WAS FOUND     00012000
C                                                                       00012100
C***********************************************************************00012200
C                                                                       00012300
C     MYDS - MULTI-DIMENSIONAL TRUE AMPLITUDE SCALING PROGRAM USING     00012400
C            THE 3838 ARRAY PROCESSOR                                   00012500
C                                                                       00012600
C     3838 ATTRIBUTES - REGION = DYNAMIC                                00012700
C                       OWN    = SHARE                                  00012800
C                       MAP    = DIRECT                                 00012900
C                                                                       00013000
C     3838 MAP DEFINITION - ITRACE = INPUT TRACE BUFFER                 00013100
C                           JWORK  = FLOAT/FIX WORK BUFFER              00013200
C                           IFL1   = AGC FILTER BUFFER                  00013300
C                           IFL2   = FILTER BUFFER                      00013400
C                           IK     = SCALING BUFFER                     00013500
C                           ITR1   = TRACE WORK BUFFER                  00013600
C                           ITR2   = TRACE WORK BUFFER                  00013700
C                           ITR3   = SUMMATION TRACE BUFFER             00013800
C                                                                       00013900
C                                                                       00014000
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
 
      INTEGER*4 IREG(15), IRAG(15)

      REAL*4   F(20), FILT(1001,21), WRK(1001)
C                                                                       00014200
      INTEGER*4   DSTART, L(21), ARRAY(64), CFREQ                       00014300
      INTEGER*4   STATIC(20), LENH(20), IHDR2(1500)                     00014400
C                                                                       00014500
      INTEGER*2 IBUF(85), IBUF2(85)                                     00014600
C                                                                       00014700
c.c   CHARACTER*1  IPARM(100)                                           00014800
      CHARACTER*2  CCOL                                                 00014900
      CHARACTER*4  CMYDS,CMYPL,CPGM,B4040,RST2,CKD                      00015000
      CHARACTER*8  FREC,RSTR,ATITLE                                     00015100
      CHARACTER*35 HLHAR1,HLHAR2,HLHAR3,HLHAR4,HLHAR5,HLHAR6            00015200
      CHARACTER*66 TITLE1,TITLE3                                        00015300
      CHARACTER*80 RCARD                                                00015400
	character*100 ntap, ntap2, otap, otap2, cardin
      integer argis
        logical verbos, query
	character*4 name
C                                                                       00015500
      COMMON          IHDR1(1500)                                       00015600
      COMMON /A/      ARRAY,ISTR                                        00015700
C                                                                       00015800
      COMMON /CARD/   IPCNT, IWL, LENH1, MLEN, PERH, MODE, N, ITYPE,    00015900
     *                DSTART, INTR, T0, V, IWD, IDSUM, IDAVC,           00016000
     *                IFORCE, ITECH, IDB, JDB, IFOR3, IAGC, MTFLAG      00016100
      COMMON /JUNK/   ISIA,ISVFLG,IPRR,INVERT                           00016200
      COMMON /STAT/   STATIC, LENH                                      00016300
      COMMON /DAFDXX/ ICR,IPR,IAP,LUI,LUO,XFLSH,IPANLF,LUI2,LURSTR      00016400
      COMMON /WTBOTV/ WBVEL                                             00016500
      COMMON /FREQ/   IPDR,CFREQ(4,39)                                  00016600
      COMMON/PARAMS/IREG,IRAG,NP2,NP,NNP

C                                                                       00016700
      EQUIVALENCE (IBUF(1),IHDR1(1)),                                   00016800
     * (ARRAY(2),IDWR), (ARRAY(1),IST), (TITLE,F(1)),                   00016900
     * (IBUF2(1),IHDR2(1)), (IBLANK,B4040)                              00017000
C                                                                       00017100
      DATA HLHAR1/'MYDS(XXXX MS AGC WINDOW     XX%)   '/,               00017200
     *     HLHAR2/'    (XX FILTERS  XXX,XXX,XXX,XXX)  '/,               00017300
     *     HLHAR3/'    (TO = XXXX  VELOCITY =XXXXXX)  '/,               00017400
     *     HLHAR4/'    (THRESHOLD IN DB = XXX)        '/,               00017500
     *     HLHAR5/'    (PANEL   START REC = XXXX)     '/                00017600
C                                                                       00017700
C ***      TITLE1 FOR GAMOCO HEADER FOR MYDS                            00017800
C ***      TITLE3 FOR GAMOCO HEADER FOR MYPL                            00017900
C ***      HLHAR6 FOR HLH UPDATE IF PANEL START REC DEFAULTED           00018000
C                                                                       00018100
      DATA TITLE1 /'            MULTI-DIMENSIONAL TRUE AMPLITUDE SCALING00018200
     *              '/,                                                 00018300
     *     TITLE3 /'      MULTI-DIMENSIONAL TRUE AMPLITUDE SCALING - PAN00018400
     *EL ONLY       '/,                                                 00018500
     *     HLHAR6/'    (PANEL START REC =  1ST REC)   '/                00018600
C                                                                       00018700
      DATA CCOL/'16'/                                                   00018800
      DATA CMYDS/'MYDS'/, CPGM/'MYDS'/                                  00018900
C                                                                       00019000
      DATA CMYPL/'MYPL'/,ATITLE/'LOW HIGH'/                             00019100
      DATA FREC /'1ST REC '/                                            00019200
      DATA B4040 /'    '/, RST2/'RSTR'/                                 00019300
      DATA IERCNT/0/, RSTR/'        '/                                  00019400
	data name/'MYDS'/
C                                                                       00019500
cc       check for help flag
 
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif
 
C--                                                                     00007600
C---- open printout file
C--                                                                     00007800
#include <f77/open.h>
c
      MYDFLG = 1                                                        00019600
      MTFLAG = 0                                                        00019700
C                                                                       00020600
C --- SET CONSTANTS                                                     00020700
      ICR    = LUCARD
      IPR    = LERR
ccc   IPR    = lupprt
c/c   IPR    = LOT
      IAP    = 70                                                       00021000
      IST    = 0                                                        00021100
      IDWR   = 0                                                        00021200
      LUI    = 10
      LUI2   = 11
c.c   LUI2   = 7                                                        00021400
      LUO    = 12
      LOUT   = 14                                                       00021600
c.c   LURSTR = 24                                                       00021700
      IPANLF = 0                                                        00021800
	ltest = 9
C                                                                       00021900
      IMAN   = 0                                                        00022000
C                                                                       00022100
	call gcmdln (ntap, ntap2, otap, otap2, cardin, verbos)
C *------------------------------------------------------------------* C
C *  If ntap specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntap.ne.' ')then
ccc     call getln (lui , ntap, 'r', 0)
	call lbopen (lui, ntap, 'r')
      else
        lui = 0
      endif
       if (lui .lt. 0) then
         write (LERR,*) 'Could not open input ',ntap
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If ntap2 specified, open it, otherwise assume no auxilliary input
C *------------------------------------------------------------------* C
      if (ntap2.ne.' ')then
ccc     call getln (lui2 , ntap2, 'r', 0)
	call lbopen (lui2, ntap2, 'r')
        if (lui2 .lt. 0) then
          write (LERR,*) 'Could not open auxilliary input ',ntap2
          call ccexit(100)
        endif
      endif
C *------------------------------------------------------------------* C
C *  If otap specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otap.ne.' ')then
c..	print *,'otap=',otap
ccc     call getln (luo, otap, 'w', 1)
   	call lbopen (luo, otap,'w')
c::	call lbopen (ltest,'test','w')
c..	print *,'luo=',luo
c::	print *,'ltest=',ltest
       if (luo .lt. 0) then
         write (LERR,*) 'Could not open standard output ',otap
         call ccexit(100)
      endif
      else
        luo = 1
c::	ltest = 1
ccc     luout = 1
      endif
C *------------------------------------------------------------------* C
C *  If otap2 specified, open it
C *------------------------------------------------------------------* C
      if (otap2.ne.' ')then
c.c     call getln (lout, otap2, 'w', 1)
	call lbopen (lout, otap2,'w')
ccc     call getln (luo, otap2, 'w', 1)
       if (lout .lt. 0) then
         write (LERR,*) 'Could not open auxiliary output ',otap2
         call ccexit(100)
      endif
      endif
C *------------------------------------------------------------------* C
C *  If cardin specified, open it -- fatal error if not specified
C *------------------------------------------------------------------* C
      if (cardin(1:1) .ne. ' ') then
         open (unit=ICR, file= cardin, status='old',
     1         form='formatted',access='sequential')
      else
         write(LERR,*)'No card input file name given -- FATAL'
         write(LERR,*)'Use -C[] on command line to input file name'
         stop 911
      endif
C                                                                       00026800
C --- READ FIRST CARD IN.                                               00026900
C                                                                       00027000
   80 READ (ICR, 81) RCARD, M, CKD                                      00027100
   81 FORMAT (A80, T1, I1, A4)                                          00027200
C                                                                       00027300
C --- CHECK CARD TYPE                                                   00027400
C                                                                       00027500
   82 IF ( CKD .NE. CMYPL ) GO TO 88                                    00027600
         CPGM = CMYPL                                                   00027700
         IPANLF = 1                                                     00027800
         LOUT   = LUO
c/c      LOUT   = 8                                                     00027900
   88 CONTINUE                                                          00028000
      IF ( CPGM .EQ. CMYDS ) CALL GAMOCO ( TITLE1, 1, IPR )             00028100
      IF ( CPGM .EQ. CMYPL ) CALL GAMOCO ( TITLE3, 1, IPR )             00028200
C                                                                       00028300
      IF (CKD .EQ. CPGM .AND. M .EQ. 1) GO TO 83                        00028400
C                                                                       00028500
      WRITE (IPR, 580) CPGM, CPGM                                       00028600
  580 FORMAT(/, 1X, '** M0149 ** ERROR DETECTED BY PROGRAM ', A4, /,    00028700
     *         13X, 'THE IDENTIFIER (CC 1-5) OF THE INPUT PARAMETER ',  00028800
     *              'CARD IS NOT SPECIFIED AS 1',A4,'.', / ,            00028900
     *         13X, 'VERIFY THAT YOU HAVE THE PROPER INPUT CARDS ',     00029000
     *              'BEFORE RESUBMITTING YOUR JOB.', /)                 00029100
      IERCNT = IERCNT + 1                                               00029200
C                                                                       00029300
   83 NIT = 0                                                           00029400
C                                                                       00029500
C --- OPEN INPUT TAPE                                                   00029600
C                                                                       00029700
c/c   CALL LBOPEN (LUI)                                                 00029800
C                                                                       00029900
C --- READ REEL HEADER                                                  00030000
C                                                                       00030100
      CALL RTAPE (LUI, IHDR1, NIT)                                      00030200
C                                                                       00030300
      IF (NIT .NE. 0) GO TO 84                                          00030400
C                                                                       00030500
      WRITE (IPR, 440) CPGM                                             00030600
  440 FORMAT(/, 1X, '** M0241 ** ERROR DETECTED BY PROGRAM ', A4,  /,   00030700
     *         13X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ THE ',  00030800
     *              'LINE HEADER ON THE INPUT DATA SET.', /,            00030900
     *         13X, 'VERIFY THAT YOU HAVE REQUESTED THE PROPER DATA ',  00031000
     *              'SET FOR INPUT AND ', / ,                           00031100
     *         13X, 'THAT THE DATA SET IS IN A PROPER SIS FORMAT.', /)  00031200
      IERCNT = IERCNT + 1                                               00031300
c.c84 IFOR = IBUF(33)                                                   00031400
c.c   IPDR = IBUF(85)                                                   00031500
   84   call saver(IHDR1, 'Format', IFOR, 0)
        call saver(IHDR1, 'PltDir', IPDR, 0)
      IF (IFOR .EQ. 3) GO TO 85
c.c   IF (IFOR .EQ. 1 .OR. IFOR .EQ. 3) GO TO 85                        00031600
C                                                                       00031700
      WRITE (IPR, 480) CPGM                                             00031800
  480 FORMAT(/, 1X, '** M0201 ** ERROR DETECTED BY PROGRAM ', A4, /,    00031900
     *         13X, 'FORMAT CODE READ FROM THE INPUT DATA SET LINE ',   00032000
     *              'HEADER IS NOT A 1 OR 3.', /,                       00032100
     *         13X, 'CONVERT YOUR INPUT DATA SET TO EITHER FORMAT 1 ',  00032200
     *              'OR FORMAT 3 BEFORE RESUBMITTING YOUR JOB.',/)      00032300
C                                                                       00032400
      IERCNT = IERCNT + 1                                               00032500
C                                                                       00032600
c.c85 NTR = IHDR1(13)                                                   00032700
c.c   NRC = IHDR1(14)                                                   00032800
   85   call saver(IHDR1, 'NumTrc', NTR, 0)
        call saver(IHDR1, 'NumRec', NRC, 0)
C                                                                       00032900
      NTT = NRC * NTR                                                   00033000
      IF ( NTT .GT. 288 ) NTT = 288                                     00033100
        if(NTT .GT. 288) write(ipr,601) NTT
  601 format(/,1x,'**WARNING** Total number of traces on input',/,13x,
     *  'is greater than 288.',/)
C                                                                       00033200
c.c   ISI = IHDR1(15)                                                   00033300
c.c   INI = IHDR1(16)                                                   00033400
        call saver(IHDR1, 'SmpInt', ISI, 0)
        call saver(IHDR1, 'NumSmp', INI, 0)
      IF (INI .LE. 6000) GO TO 86                                       00033500
C                                                                       00033600
      WRITE (IPR, 600) CPGM                                             00033700
  600 FORMAT(/, 1X, '** M0202 ** ERROR DETECTED BY PROGRAM ', A4, /,    00033800
     *         13X, 'THE NUMBER OF SAMPLES IN THE INPUT DATA SET LINE ',00033900
     *              'HEADER IS GREATER THAN 6000.', / ,                 00034000
     *         13X, 'REDUCE THE NUMBER OF SAMPLES PER TRACE TO NO ',    00034100
     *              'MORE THAN 6000 BEFORE RESUBMITTING YOUR JOB.', /)  00034200
C                                                                       00034300
      IERCNT = IERCNT + 1                                               00034400
C                                                                       00034500
C --- CALL THE SUBROUTINE TO READ IN THE                                00034600
C --- PARAMETERS ON THE FIRST CARD.                                     00034700
C                                                                       00034800
   86 CALL MYDSET (NIT, IPR, RCARD, CPGM)                               00034900
C                                                                       00035000
C --- CHECK INPUT PARAMETERS FOR ERRORS                                 00035100
C                                                                       00035200
      IF (N .GT. 0) GO TO 87                                            00035300
C                                                                       00035400
      WRITE (IPR, 500) CPGM, CPGM                                       00035500
  500 FORMAT(/, 1X, '** M0145 ** ERROR DETECTED BY PROGRAM ', A4, /,    00035600
     *         13X, 'THE NUMBER OF FILTERS SPECIFIED (CC 17-18 ON ',    00035700
     *              'THE 1',A4,' CARD) IS LESS THAN ZERO OR EQUAL TO ', 00035800
     *              'ZERO.', /,                                         00035900
     *         13X, 'CODE THE PROPER VALUE FOR THE NUMBER OF FILTERS ', 00036000
     *              'BEFORE RESUBMITTING YOUR JOB.', /)                 00036100
      IERCNT = IERCNT + 1                                               00036200
C                                                                       00036300
   87 IF (ITYPE .EQ. 0 .OR. ITYPE .EQ. 1) GO TO 91                      00036400
      ITYPE = 0                                                         00036500
      WRITE (IPR, 90) CPGM, CPGM                                        00036600
   90 FORMAT(/, 1X, '** M0166 ** WARNING FROM PROGRAM ', A4, /,         00036700
     *         13X, 'THE FILTER TYPE (CC 19 ON THE 1', A4, ' CARD) ',   00036800
     *              'HAS BEEN SET TO 0', /,                             00036900
     *         13X, 'BECAUSE IT WAS NOT SPECIFIED AS 0 OR 1.', / )      00037000
   91 IF (IWD .EQ. 0 .OR. IWD .EQ. 1) GO TO 93                          00037100
      IWD = 0                                                           00037200
      WRITE (IPR, 92) CPGM, CPGM                                        00037300
   92 FORMAT(/, 1X, '** M0167 ** WARNING FROM PROGRAM ', A4, /,         00037400
     *         13X, 'THE WATER BOTTOM FLAG (CC 36 ON THE 1', A4,        00037500
     *              ' CARD) HAS BEEN SET TO 0', /,                      00037600
     *         13X, 'BECAUSE IT WAS NOT SPECIFIED AS 0 OR 1.', / )      00037700
   93 IF (IFORCE .EQ. 0 .OR. IFORCE .EQ. 1) GO TO 95                    00037800
      IFORCE = 0                                                        00037900
      WRITE (IPR, 94) CPGM, CPGM                                        00038000
   94 FORMAT(/, 1X, '** M0168 ** WARNING FROM PROGRAM ', A4, /,         00038100
     *         13X, 'THE FILTER DESIGN FLAG (CC 43 ON THE 1', A4,       00038200
     *              ' CARD) HAS BEEN SET TO 0', /,                      00038300
     *         13X, 'BECAUSE IT WAS NOT SPECIFIED AS 0 OR 1.', / )      00038400
   95 IF (IDSUM .EQ. 0 .OR. IDSUM .EQ. 1) GO TO 97                      00038500
      IDSUM = 0                                                         00038600
      WRITE (IPR, 96) CPGM, CPGM                                        00038700
   96 FORMAT(/, 1X, '** M0169 ** WARNING FROM PROGRAM ', A4, /,         00038800
     *         13X, 'THE DIRECTION OF SUM (CC 38 ON THE 1', A4,         00038900
     *              ' CARD) HAS BEEN SET TO 0', /,                      00039000
     *         13X, 'BECAUSE IT WAS NOT SPECIFIED AS 0 OR 1.', / )      00039100
C                                                                       00039200
C --- MAKE SURE WE HAVE A VALID MODEL TRACE FLAG                        00039300
C                                                                       00039400
   97 IF ( MTFLAG .GE. 0 .AND. MTFLAG .LE. 2 ) GO TO 113                00039500
      MTFLAG = 0                                                        00039600
      WRITE (IPR, 112) CPGM, CPGM                                       00039700
  112 FORMAT(/, 1X, '** M0112 ** WARNING FROM PROGRAM ', A4, /,         00039800
     *         13X, 'THE MODEL TRACE FLAG (CC 45 ON THE 1', A4,         00039900
     *              ' CARD) HAS BEEN SET TO 0', /,                      00040000
     *         13X, 'BECAUSE IT WAS NOT SPECIFIED AS 0, 1, OR 2.', / )  00040100
  113 CONTINUE                                                          00040200
C                                                                       00040300
      IF (MODE .LE. 2 .AND. MODE .GE. 0) GO TO 98                       00040400
C                                                                       00040500
      WRITE (IPR, 560) CPGM, CCOL, CPGM                                 00040600
  560 FORMAT(/, 1X, '** M0148 ** ERROR DETECTED BY PROGRAM ', A4, /,    00040700
     *         13X, 'THE FILTER PARAMETER CODE (CC ',A2,' ON THE 1',    00040800
     *               A4, ' CARD) MUST BE BLANK, 0, 1, OR 2.', / ,       00040900
     *         13X, 'CODE A PROPER FILTER CODE PARAMETER ON THE 1DAFD', 00041000
     *              ' CARD BEFORE RESUBMITTING YOUR JOB.', /)           00041100
      IERCNT = IERCNT + 1                                               00041200
C                                                                       00041300
C *** SET WBVEL TO THE WATER BOTTOM VELOCITY                            00041400
C                                                                       00041500
   98 WBVEL = 4850.0                                                    00041600
      IF (IHDR1(31) .NE. IBLANK .AND. IHDR1(31) .NE. 0 .AND. IWD .NE. 0)00041700
     *    WBVEL = IHDR1(31)                                             00041800
C                                                                       00041900
      IF (N .LE. 20) GO TO 99                                           00042000
C                                                                       00042100
  470 WRITE (IPR, 460) CPGM, CPGM                                       00042200
  460 FORMAT(/, 1X, '** M0144 ** ERROR DETECTED BY PROGRAM ', A4,  /,   00042300
     *         13X, 'THE NUMBER OF FILTERS SPECIFIED (CC 17-18 ON ',    00042400
     *              'THE 1',A4,' CARD) IS GREATER THAN THE PROGRAM ',   00042500
     *              'MAXIMUM OF 20.', /,                                00042600
     *         13X, 'REDUCE THE NUMBER OF FILTERS SPECIFIED TO NOT ',   00042700
     *              'MORE THAN 20 BEFORE RESUBMITTING YOUR JOB.', /)    00042800
      IERCNT = IERCNT + 1                                               00042900
C                                                                       00043000
   99 IF (MODE .NE. 0 .AND. N .EQ. 1) GO TO 100                         00043100
      GO TO 120                                                         00043200
  100 MODE = 0                                                          00043300
      WRITE (IPR, 110) CPGM, CCOL, CPGM                                 00043400
  110 FORMAT(/, 1X, '** M0152 ** WARNING FROM PROGRAM ', A4, /,         00043500
     *         13X, 'THE FILTER PARAMETER CODE (CC ', A2,' ON THE 1',   00043600
     *               A4, ' CARD) HAS BEEN SET TO (0) ', /,              00043700
     *         13X, 'BECAUSE NUMBER OF FILTERS IS SPECIFIED AS (1).',/) 00043800
  120 CONTINUE                                                          00043900
C                                                                       00044000
C *** WRITE OUT PARAMETERS                                              00044100
C                                                                       00044200
      WRITE (IPR, 125) MODE,N,ITYPE,IFORCE,MTFLAG,T0,V,IWD,IMAN         00044300
  125 FORMAT (5X,'FILTER PARAMETERS CODE    =',I6,  /,                  00044400
     *        5X,'NUMBER OF FILTERS         =',I6,  /,                  00044500
     *        5X,'FILTER CODE               =',I6,  /,                  00044600
     *        5X,'FILTER DESIGN FLAG        =',I6,  /,                  00044700
     *        5X,'MODEL TRACE FLAG          =',I6,  /,                  00044800
     *        5X,'ANALYSIS START TIME',             /,                  00044900
     *        5X,'  T0                      =',F6.0,/,                  00045000
     *        5X,'  VELOCITY                =',F6.0,/,                  00045100
     *        5X,'WATER BOTTOM FLAG         =',I6,  /,                  00045200
     *        5X,'RESTART RECORD            =',I6     )                 00045300
C                                                                       00045400
C ***     IF PANEL TAPE ONLY WAS REQUESTED (IPANLF = 1)                 00045500
C ***     AND DSTART WAS NOT INPUT, DEFAULT DSTART TO                   00045600
C ***     THE FIRST RECORD ON THE TAPE                                  00045700
C ***     FOR NOW, SET DSTART TO -1                                     00045800
C ***     IT WILL BE RESET LATER AFTER THE FIRST RECORD IS READ         00045900
C                                                                       00046000
      IF ((DSTART .NE. 0 .AND. IPANLF .EQ. 1) .OR. IPANLF .EQ. 0)       00046100
     *    GO TO 128                                                     00046200
      DSTART = -1                                                       00046300
      WRITE (IPR, 126) CPGM, CPGM                                       00046400
  126 FORMAT(/, 1X, '** M0181 ** WARNING FROM PROGRAM ',A4, /,          00046500
     *         13X, 'PANEL START RECORD (CC 20-23 ON THE 1', A4,        00046600
     *              ' CARD) WAS NOT SPECIFIED.', /,                     00046700
     *         13X, 'IT WILL BE DEFAULTED TO THE FIRST RECORD ON ',     00046800
     *              'THE INPUT TAPE.', / )                              00046900
      WRITE (IPR, 127) FREC                                             00047000
  127 FORMAT (5X,'PANEL START RECORD        =',A8     )                 00047100
      GO TO 130                                                         00047200
  128 WRITE (IPR, 129) DSTART                                           00047300
  129 FORMAT (5X,'PANEL START RECORD        =',I6     )                 00047400
  130 CONTINUE                                                          00047500
C                                                                       00047600
      IF (DSTART .EQ. 0 .OR. ISTR .EQ. 0) GO TO 132                     00047700
C                                                                       00047800
  680 WRITE (IPR, 690) CPGM                                             00047900
  690 FORMAT(/, 1X, '** M0159 ** ERROR DETECTED BY PROGRAM ', A4, /,    00048000
     *         13X, 'THE PANEL OPTION IS NOT ALLOWED ON A RESTART.', /) 00048100
      IERCNT = IERCNT + 1                                               00048200
  132 IF (INTR .EQ. 0 .AND. DSTART .NE. 0) INTR = NTT                   00048300
C                                                                       00048400
C SET MAXIMUM NUMBER OF TRACES IN FILTER PANEL TO NTT                   00048500
C                                                                       00048600
      IF (INTR .LE. NTT) GO TO 135                                      00048700
      INTR = NTT                                                        00048800
      WRITE (IPR, 134) CPGM, CPGM, NTT, NTT                             00048900
  134 FORMAT(/, 1X, '** M0170 ** WARNING FROM PROGRAM ', A4, /,         00049000
     *         13X, 'THE NUMBER OF TRACES IN THE FILTER PANEL ',        00049100
     *             '(CC 24-26 ON THE 1',A4,' CARD) HAS BEEN SET TO ',I3,00049200
     *      /,13X, 'BECAUSE IT WAS SPECIFIED AS GREATER THAN ',I3,'.' /)00049300
C                                                                       00049400
  135 IF (IFOR3 .EQ. 3) GO TO 138
cc135 IF (IFOR3 .EQ. 1 .OR. IFOR3 .EQ. 3) GO TO 138                     00049500
      IFOR3 = 1                                                         00049600
      WRITE (IPR, 136) CPGM, CPGM                                       00049700
  136 FORMAT(/, 1X, '** M0171 ** WARNING FROM PROGRAM ', A4, /,         00049800
     *         13X, 'THE OUTPUT FORMAT (CC 76 ON THE 1', A4, ' CARD) ', 00049900
     *              'HAS BEEN SET TO 1',                                00050000
     *       /,13X, 'BECAUSE IT WAS NOT SPECIFIED AS 1 OR 3.' /)        00050100
  138 CONTINUE                                                          00050200
C                                                                       00050300
C *** WRITE OUT PARAMTERS                                               00050400
C                                                                       00050500
      WRITE (IPR,140) INTR, IDSUM, IFOR3                                00050600
  140 FORMAT (5X,'NUMBER OF TRACES IN PANEL =',I6 /                     00050700
     *        5X,'DIRECTION OF SUM          =',I6 /                     00050800
     *        5X,'OUTPUT FORMAT             =',I6 /// )                 00050900
C                                                                       00051000
      V = V * 1000.                                                     00051100
      IF (DSTART .EQ. 0) GO TO 175                                      00051200
C                                                                       00051300
C CHANGE NUMBER OF TRACES PER RECORD ON THE PANEL OUTPUT TO BE INTR     00051400
C INSTEAD OF NTR.  THIS CHANGES XREC.                                   00051500
C                                                                       00051600
      XREC = N + 1                                                      00051700
      NREC = XREC                                                       00051800
      M = 1                                                             00051900
      IT = NREC                                                         00052000
      WRITE (IPR, 20)                                                   00052100
   20 FORMAT (10X)
      WRITE (IPR, 150)                                                  00052200
C                                                                       00052300
      WRITE (IPR,160) M, IT                                             00052400
      M = NREC + 1                                                      00052500
C                                                                       00052600
C CHANGE NUMBER OF TRACES PER RECORD ON THE PANEL OUTPUT TO BE INTR     00052700
C INSTEAD OF NTR.  THIS CHANGES XREC.                                   00052800
C                                                                       00052900
      XREC = N - 1                                                      00053000
      NREC = NREC + XREC                                                00053100
      IT = XREC                                                         00053200
      WRITE (IPR, 170) M, IT                                            00053300
      WRITE (IPR, 20)                                                   00053400
  150 FORMAT (10X, 'DAFT OTAP2', 12X, 'FIRST RECORD',                   00053500
     *         6X, 'NUMBER OF RECORDS')                                 00053600
  160 FORMAT (5X, 'PANEL SEQUENTIAL DISPLAY', I11, I20)                 00053700
  170 FORMAT (5X, 'SUMMATION DISPLAY', I18, I20)                        00053800
C                                                                       00053900
C --- CHECK IF THE MODEL TRACE IS TO COME FROM AN AUXILIARY TAPE.       00054000
C                                                                       00054100
  175    IF ( MTFLAG .NE. 2 ) GO TO 180                                 00054200
C                                                                       00054300
            NIT2 = 0                                                    00054400
C                                                                       00054500
c/c         CALL LBOPEN (LUI2)                                          00054600
C                                                                       00054700
C --- READ REEL HEADER                                                  00054800
C                                                                       00054900
            CALL RTAPE (LUI2, IHDR2, NIT2)                              00055000
C                                                                       00055100
C --- CHECK IF THERE IS AN AUXILIARY TAPE.                              00055200
C                                                                       00055300
            IF (NIT2 .NE. 0) GO TO 102                                  00055400
C                                                                       00055500
            WRITE (IPR, 101) CPGM                                       00055600
  101       FORMAT(/, 1X, '** M0101 ** ERROR DETECTED BY PROGRAM ',     00055700
     *              A4,  /,                                             00055800
     *         13X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ THE ',/,00055900
     *         13X, 'LINE HEADER ON THE AUXILIARY DATA SET.', /,        00056000
     *         13X, 'VERIFY THAT YOU HAVE REQUESTED THE PROPER DATA ',  00056100
     *              'SET.', /)                                          00056200
            IERCNT = IERCNT + 1                                         00056300
C                                                                       00056400
C --- CHECK IF THE AUXILIARY TAPE IS IN A VALID FORMAT                  00056500
C                                                                       00056600
  102       call saver(IBUF2,'Format',IFMT07,0)
c.102       IFMT07 = IBUF2(33)                                          00056700
            IF (IFMT07 .EQ. 1 .OR. IFMT07 .EQ. 3) GO TO 104             00056800
C                                                                       00056900
            WRITE (IPR, 103) CPGM                                       00057000
  103       FORMAT(/, 1X, '** M0103 ** ERROR DETECTED BY PROGRAM ',     00057100
     *              A4, /,                                              00057200
     *         13X, 'FORMAT CODE READ FROM THE AUXILIARY DATA SET ',/,  00057300
     *         13X, 'LINE HEADER IS NOT A 1 OR 3.', /,                  00057400
     *         13X, 'CONVERT AUXILIARY DATA SET TO EITHER FORMAT ', /,  00057500
     *         13X, '1 OR FORMAT 3 BEFORE RESUBMITTING YOUR JOB.',/)    00057600
            IERCNT = IERCNT + 1                                         00057700
C                                                                       00057800
c.104       NTRC07 = IHDR2(13)                                          00057900
c.c         NREC07 = IHDR2(14)                                          00058000
c.c         IISI07 = IHDR2(15)                                          00058100
c.c         NSMP07 = IHDR2(16)                                          00058200
  104       call saver(IHDR2,'NumTrc',NTRC07,0)
            call saver(IHDR2,'NumRec',NREC07,0)
            call saver(IHDR2,'SmpInt',IISI07,0)
            call saver(IHDR2,'NumSmp',NSMP07,0)
C                                                                       00058300
C --- COMPARE NUMBER OF SAMPLES ON INPUT AND AUXILIARY TAPES            00058400
C                                                                       00058500
            IF (NSMP07 .EQ. INI) GO TO 106                              00058600
C                                                                       00058700
            WRITE (IPR, 105) CPGM                                       00058800
  105       FORMAT(/, 1X, '** M0105 ** ERROR DETECTED BY PROGRAM ',     00058900
     *              A4, /,                                              00059000
     *         13X, 'THE NUMBER OF SAMPLES ON AUXILIARY DATA SET NOT ', 00059100
     *              'EQUAL TO', /,                                      00059200
     *         13X, 'THAT ON THE INPUT DATA SET.', /)                   00059300
            IERCNT = IERCNT + 1                                         00059400
C                                                                       00059500
C --- COMPARE SAMPLE INTERVALS FOR THE INPUT AND AUXILIARY TAPES        00059600
C                                                                       00059700
  106       IF (IISI07 .EQ. ISI) GO TO 108                              00059800
C                                                                       00059900
            WRITE (IPR, 107) CPGM                                       00060000
  107       FORMAT(/, 1X, '** M0107 ** ERROR DETECTED BY PROGRAM ',     00060100
     *              A4, /,                                              00060200
     *         13X, 'THE SAMPLE INTERVAL FOR THE AUXILIARY DATA SET ',  00060300
     *              'NOT EQUAL TO', /,                                  00060400
     *         13X, 'THAT OF THE INPUT DATA SET.', /)                   00060500
            IERCNT = IERCNT + 1                                         00060600
C                                                                       00060700
C --- COMPARE NUMBER OF TRACES PER RECORD FOR THE INPUT AND AUXILIARY   00060800
C --- TAPES                                                             00060900
C                                                                       00061000
  108       IF (NTRC07 .EQ. NTR) GO TO 114                              00061100
C                                                                       00061200
            WRITE (IPR, 109) CPGM                                       00061300
  109       FORMAT(/, 1X, '** M0109 ** ERROR DETECTED BY PROGRAM ',     00061400
     *              A4, /,                                              00061500
     *         13X, 'THE NUMBER OF TRACES PER RECORD FOR THE ', /,      00061600
     *         13X, 'AUXILIARY DATA SET NOT EQUAL TO', /,               00061700
     *         13X, 'THAT OF THE INPUT DATA SET.', /)                   00061800
            IERCNT = IERCNT + 1                                         00061900
C                                                                       00062000
C --- COMPARE NUMBER OF RECORDS FOR THE INPUT AND AUXILIARY TAPES       00062100
C                                                                       00062200
  114       IF ( NREC07 .EQ. NRC ) GO TO 180                            00062300
C                                                                       00062400
            WRITE (IPR,115) CPGM                                        00062500
  115       FORMAT(/, 1X, '** M0115 ** ERROR DETECTED BY PROGRAM ',     00062600
     *              A4, /,                                              00062700
     *         13X, 'THE NUMBER OF RECORDS ON AUXILIARY DATA SET ', /,  00062800
     *         13X, 'IS NOT EQUAL TO THAT OF THE INPUT DATA SET.', /)   00062900
            IERCNT = IERCNT + 1                                         00063000
C                                                                       00063100
C --- CALL STCSET TO READ IN 9STAT CARDS AND SET UP LENH IF             00063200
C --- EXECUTING MYDS                                                    00063300
C                                                                       00063400
  180 CALL STCSET (N, MLEN, MODE, PERH, LENH1, ISI, ICR, RCARD)         00063500
C                                                                       00063600
      NSR2 = ISI * 2                                                    00063700
      DO 6 LL = 1, N                                                    00063800
         IF ( LENH(LL) .LT. NSR2 ) THEN                                 00063900
            WRITE (IPR,5) CPGM,CPGM                                     00064000
    5       FORMAT(/,1X,'** M0005 ** ERROR DETECTED BY PROGRAM ',A4,/,  00064100
     *            13X,'THE LENGTH OF AT LEAST ONE SMOOTHING OPERATOR',/,00064200
     *            13X,'IS LESS THAN TWICE THE INPUT SAMPLE INTERVAL.',/,00064300
     *            13X,'EXAMINE CC 6-15 ON THE 1',A4,' CARD BEFORE ',    00064400
     *            'RESUBMITTING.',/)                                    00064500
            IERCNT = IERCNT + 1                                         00064600
            GO TO 7                                                     00064700
         END IF                                                         00064800
    6 CONTINUE                                                          00064900
C                                                                       00065000
    7 CALL WRCARD (RCARD, 1, IPR)                                       00065100
C                                                                       00065200
C *** IF FILTER PARAMETER CODE (MODE) IS NOT 1 OR THE PANEL OPTION      00065300
C *** WAS SELECTED, FORCE SLOW MODE OF PROCESSING                       00065400
C                                                                       00065500
      IF ((MODE.NE.1 .OR. DSTART.NE.0) .AND. IFORCE.EQ.0) GO TO 230     00065600
      GO TO 250                                                         00065700
  230 IFORCE = 1                                                        00065800
      IF (MODE .EQ. 0)                                                  00065900
     *WRITE (IPR, 240) CPGM, CPGM                                       00066000
  240 FORMAT(/, 1X, '** M0161 ** WARNING FROM PROGRAM ', A4, /,         00066100
     *         13X, 'THE FILTER DESIGN FLAG (CC 43 ON THE 1', A4,       00066200
     *              ' CARD) HAS BEEN RESET TO (1) TO FORCE THE SLOW ',  00066300
     *              'MODE OF PROCESSING', /,                            00066400
     *         13X, 'BECAUSE THE FILTER PARAMETER CODE IS ',            00066500
     *              'SPECIFIED AS (0).', / )                            00066600
      IF (MODE .EQ. 2)                                                  00066700
     *WRITE (IPR, 242) CPGM, CPGM                                       00066800
  242 FORMAT(/, 1X, '** M0162 ** WARNING FROM PROGRAM ', A4, /,         00066900
     *         13X, 'THE FILTER DESIGN FLAG (CC 43 ON THE 1', A4,       00067000
     *              ' CARD) HAS BEEN RESET TO (1) TO FORCE THE SLOW ',  00067100
     *              'MODE OF PROCESSING', /,                            00067200
     *         13X, 'BECAUSE THE FILTER PARAMETER CODE IS ',            00067300
     *              'SPECIFIED AS (2).', / )                            00067400
      IF (DSTART .NE. 0)                                                00067500
     *WRITE (IPR, 244) CPGM, CPGM                                       00067600
  244 FORMAT(/, 1X, '** M0163 ** WARNING FROM PROGRAM ', A4, /,         00067700
     *         13X, 'THE FILTER DESIGN FLAG (CC 43 ON THE 1', A4,       00067800
     *              ' CARD) HAS BEEN RESET TO (1) TO FORCE THE SLOW ',  00067900
     *              'MODE OF PROCESSING', /,                            00068000
     *         13X, 'BECAUSE THE PANEL TAPE OPTION ',                   00068100
     *              'IS SPECIFIED.', / )                                00068200
  250 CONTINUE                                                          00068300
C                                                                       00068400
C --- THIS CHECK IS PERFORMED AFTER IFORCE HAS BEEN RESET IF NEEDED     00068500
C                                                                       00068600
      IF (IFORCE .NE. 0 .OR. ITECH .NE. 1) GO TO 260                    00068700
C                                                                       00068800
      WRITE (IPR, 620) CPGM                                             00068900
  620 FORMAT(/, 1X, '** M0150 ** ERROR DETECTED BY PROGRAM ', A4, /,    00069000
     *         13X, 'RMS SCALING (CC 45) IS NOT SUPPORTED WITH THE ',   00069100
     *              'FAST MODE OF PROCESSING.', / ,                     00069200
     *         13X, 'EITHER REMOVE THE REQUEST FOR RMS SCALING OR ',    00069300
     *              'SPECIFY THE SLOW MODE OF PROCESSING.', / )         00069400
      IERCNT = IERCNT + 1                                               00069500
C                                                                       00069600
C --- CALL FILSET TO READ IN THE 1FLTR CARDS AND SET UP THE             00069700
C --- FILT, F AND L ARRAYS                                              00069800
C                                                                       00069900
  260 CALL FILSET (FILT, N, MODE, ITECH, ITYPE, IFORCE, ISI, NIT,       00070000
     *         INI, F, L, RCARD, CPGM, IERCNT, MTFLAG, MTBPI)           00070100
c.c   IBUF(33) = IFOR3                                                  00070200
        call savew(IBUF,'Format',IFOR3,0)
C                                                                       00070300
C --- ERROR MESSAGE TO TRAP VELOCITY OUT OF RANGE                       00070400
C --- HLH CALL WILL ONLY ALLOW FOR 6 CHARACTERS                         00070500
C --- MAXIMUM VELOCITY ALLOWED IS 999.9 * 1000                          00070600
C                                                                       00070700
      IF (V .LE. 999900) GO TO 400                                      00070800
      WRITE (IPR, 390) CPGM, CPGM                                       00070900
  390 FORMAT(/, 1X, '** M0180 ** ERROR DETECTED BY PROGRAM ', A4, /,    00071000
     *         13X, 'ADJUSTMENT VELOCITY (CC 31-35 ON THE 1', A4,       00071100
     *              ' CARD) IS TOO LARGE.', /,                          00071200
     *         13X, 'VELOCITY MUST BE LESS THAN 1000 FT/MS OR M/MS.',/) 00071300
      CALL CCEXIT (100)                                                 00071400
  400 CONTINUE                                                          00071500
C                                                                       00071600
C ALLOW EITHER T0 OR V TO BE INPUT INSTEAD OF BOTH.                     00071700
C                                                                       00071800
      IF (T0 .EQ. 0. .AND. V .EQ. 0.) GO TO 420                         00071900
      LEN = T0                                                          00072000
      WRITE (HLHAR3(11:14),405) LEN                                     00072100
  405 FORMAT (I4)                                                       00072200
      NN = V + .5                                                       00072300
C                                                                       00072400
      WRITE (HLHAR3(27:32),408) NN                                      00072500
  408 FORMAT(I6)                                                        00072600
  410 CALL HLHprt (IHDR1, NIT, HLHAR3, 35, LERR)
c.410 CALL HLH (IHDR1, NIT, HLHAR3, 35)                                 00072700
  420 CONTINUE                                                          00072800
C                                                                       00072900
C ***    IF PANEL START RECORD DEFAULTED TO FIRST RECORD IN LINE,       00073000
C ***    UPDATE HLH ACCORDINGLY FROM HLHAR6                             00073100
C                                                                       00073200
      IF (DSTART .EQ. -1)                                               00073300
     *    CALL HLHprt (IHDR1, NIT, HLHAR6, 35, LERR)
c.c  *    CALL HLH (IHDR1, NIT, HLHAR6, 35)                             00073400
C                                                                       00073500
      IF (DSTART .EQ. 0 .OR. DSTART .EQ. -1) GO TO 430                  00073600
      WRITE (HLHAR5(26:29),425) DSTART                                  00073700
  425 FORMAT(I4)                                                        00073800
      CALL HLHprt (IHDR1, NIT, HLHAR5, 35, LERR)
c.c   CALL HLH (IHDR1, NIT, HLHAR5, 35)                                 00073900
C                                                                       00074000
  430 IF (IERCNT .NE. 0) CALL CCEXIT(100)                               00074100
C                                                                       00074200
C ***     OPEN OUTPUT TAPE IF NOT PANEL TAPE ONLY OPTION                00074300
C                                                                       00074400
c/c   IF (IPANLF .EQ. 0) CALL LBOPEN (LUO)                              00074500
C                                                                       00074600
C --- WRITE OUTPUT TAPE HEADER                                          00074700
C                                                                       00074800
      IF (ISTR .EQ. 0 .AND. IPANLF .EQ. 0) then
c..	print *,'writing output header,nit=',nit
c..	print *,'numrec, numtrc=',ihdr1(13),ihdr1(14)
      	CALL WRtape(LUO,IHDR1,NIT)
c::   	CALL WRtape(ltest,IHDR1,NIT)
	endif
ccc   IF (ISTR .EQ. 0 .AND. IPANLF .EQ. 0) CALL WRtape(LUO,IHDR1,NIT)
CCC   IF (ISTR .EQ. 0 .AND. IPANLF .EQ. 0) CALL WREC (LUO, IHDR1, NIT)  00074900
C --- START ACCOUNTING                                                  00075000
C SDL NEW CHARGE FACTORS DEC 06, 1985                                   00075100
C                                                                       00075200
c.c   IF (IFORCE.EQ.0)                                                  00075300
c.c  *       N21 = .00119 * FLOAT(N) + 2.476                            00075400
c.c   IF (IFORCE.EQ.1)                                                  00075500
c.c  *       N21 = .190 * FLOAT(N) + 2.369                              00075600
c.c   CALL NACCT (CPGM, IHDR1, N21)                                     00075700
c.c   IHDR1(14) = NREC                                                  00075800
        call savew(IHDR1,'NumRec',NREC,0)
C                                                                       00075900
C --- WRITE HEADER ON PANEL TAPE IF NEEDED                              00076000
C --- CHANGING NUMBER OF TRACES PER RECORD TO NUMBER OF TRACES          00076100
C --- IN THE PANEL OUTPUT                                               00076200
C                                                                       00076300
c.c   IHDR1(13) = INTR                                                  00076400
        call savew(IHDR1,'NumTrc',INTR,0)
C                                                                       00076500
C --- STORING ALTERNATE TITLE (LOW HIGH) FOR TIME-RMSV IN LINE HEADER   00076600
C --- BYTES 229-236                                                     00076700
C                                                                       00076800
c.c.........don't know what this might be used for later, but will
c.c...........just omit it for now
c.c   CALL MOVE (1, IHDR1(58), ATITLE, 8)                               00076900
C                                                                       00077000
c/c   IF (DSTART .NE. 0 .AND. IDWR .EQ. 0) CALL LBOPEN (LOUT)           00077100
      IF (DSTART .NE. 0 .AND. IDWR .EQ. 0) CALL WRtape(LOUT,IHDR1,NIT)
CCC   IF (DSTART .NE. 0 .AND. IDWR .EQ. 0) CALL WREC (LOUT, IHDR1, NIT) 00077200
c.c   IHDR1(13) = NTR                                                   00077300
        call savew(IHDR1,'NumTrc',NTR,0)
C                                                                       00077400
C     STACK AND DISPLAY FILTERS HERE IF SLOW MODE                       00077500
C                                                                       00077600
      IF(IFORCE.NE.1)GO TO 730                                          00077700
      CALL SFILS(L,ISI,IPR,FILT,WRK,IHDR1,N)                            00077800
730   CONTINUE                                                          00077900
C                                                                       00078000
C --- PREPARE FOR A RESTART                                             00078100
C                                                                       00078200
c.c   IF ( ISTR .EQ. 0 ) CALL RSTROP ( LURSTR, NTR )                    00078300
c.c   IF ( ISTR .EQ. 1 ) CALL RSTRUP ( IIRI, 2, LSTRI, IEOF, LURSTR )   00078400
C                                                                       00078500
c.c   IF ( ISTR .EQ. 0 .OR. IST .NE. 0 ) GO TO 800                      00078600
C                                                                       00078700
c.c      IF ( IEOF .EQ. 0 ) GO TO 780                                   00078800
c.c         WRITE ( IPR, 750 ) CPGM                                     00078900
c.750       FORMAT(/, 1X, '** M0750 ** ERROR DETECTED BY PROGRAM ',     00079000
c.c  *                  A4, /,                                          00079100
c.c  *             13X, '1RSTR CARD NOT FOUND OR INVALID RECORD ',      00079200
c.c  *                  'NUMBER.', /)                                   00079300
c.c         CALL CCEXIT (100)                                           00079400
c.780    CONTINUE                                                       00079500
C                                                                       00079600
c.c      IST = LSTRI                                                    00079700
  800 CONTINUE                                                          00079800
C                                                                       00079900
C --- CALL MYDS TO PROCESS THE TRACE                                    00080000
C                                                                       00080100
C?C   CALL MYDS (FILT, F, INI, IFOR, L, ISI, NTR, IST, IDWR,            00080200
	mtotal = ntr * nrc
      CALL MYDS (FILT, F, INI, IFOR, L, ISI, NTR, IST, IDWR,ltest,
     *           mtotal,CPGM, MTBPI, IFMT07, NSMP07)
CCC  *           CPGM, MTBPI, IFMT07, NSMP07)                           00080300
      CALL CCEXIT (0)                                                   00080400
      STOP                                                              00080500
      END                                                               00080600
      subroutine gcmdln ( ntap, ntap2, otap, otap2, cardin, verbos)
c     FORTRAN by M. A. Miller   10-05-92
c
c     this routine processes the command line arguments for use in
c     program MYDS
c
c     include 'iounit.inc'
#include <f77/iounit.h>
c
      character ntap*100, otap*100, cardin*100
      character ntap2*100, otap2*100
      integer argis
	logicalverbos
 
      verbos = .false.
 
      verbos = (argis('-V') .gt. 0)
      if(verbos) then
        write(LERR,*)' verbos is true'
      else
        write(LERR,*)' verbos is false'
      endif
 
      call argstr ('-N',ntap,' ',' ')
ccc   call argstr ('-N',ntap,' ',NULL)
      if(verbos) write(LERR,*)' ntap as read=',ntap
      call argstr ('-N2',ntap2,' ',' ')
      if(verbos) write(LERR,*)' ntap2 as read=',ntap2
      call argstr ('-O',otap,' ',' ')
      if(verbos) write(LERR,*)' otap as read=',otap
      call argstr ('-O2',otap2,' ',' ')
      if(verbos) write(LERR,*)' otap2 as read=',otap2
 
          call argstr ('-C',cardin,' ',' ')
          if(verbos) write(LERR,*)' cardin as read=',cardin
          call noblnk(cardin,lc)
 
        if(cardin(1:1) .ne. ' ') then
          if(verbos) write(LERR,*)' open(unit=ICR, file=cardin) '
        endif
 
      return
      end
c
c
c
      subroutine help
c     include 'iounit.inc'
#include <f77/iounit.h>
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM myds....................................'
         write(LER,*)'....Multi-Dimensional True Amplitude Scaling....'
         write(LER,*)' '
         write(LER,*)
     :' -N  [ntap]    (default=stdin) : Input data file name'
         write(LER,*)
     :' -N2 [ntap2]   (no default)    : Auxiliary input; Model traces'
         write(LER,*)
     :' -O  [otap]    (no default)    : Output data file name'
         write(LER,*)
     :' -O2 [otap2]   (no default)    : Auxiliary output; panel traces'
         write(LER,*)
     :' -C  [cardin]  (no default)    : Card image file'
         write(LER,*)
     :' -V  [verbos]  (default=no)    : Verbose output '
       write(LER,*)
     :'Usage:  ',
     :' myds -N[ntap] -N2[ntap2] -O[otap] -O2[otap2] -C[cardin]  -V'
       write(LER,*)
     :' NOTES:  '
       write(LER,*)
     :'  NTAP is for standard input.'
       write(LER,*)
     :'  NTAP2 is for auxiliary input of model traces.'
       write(LER,*)
     :'  OTAP is for standard output, OR special filter panel output',
     :' only.'
       write(LER,*)
     :'  OTAP2 is for special filter panel output in addition to the',
     :' standard output.'
       write(LER,*)
     :' See the man pages for myds to view the format for the input',
     :' data card deck.'
       write(LER,*)
     :'***************************************************************'
      return
      end


