C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************00080900
C                                                                      *00081000
C   SFILS   COMPUTES THE COSINE XFORM OF THE F ARRAY IN STEPS OF FDEL, *00081100
C           THEN STACKS THE N INPUTS INTO THE E ARRAY AND GRAPHS.      *00081200
C                                                                      *00081300
C***********************************************************************00081400
C                                                                       00081500
      SUBROUTINE SFILS(LEN,ISI,IPR,F,E,X,N)                             00081600
C                                                                       00081700
      DIMENSION F(1001,20),E(1001),LEN(20),X(1001)                      00081800
C                                                                       00081900
      FDEL = 1.0                                                        00082000
      FMAX = 500/ISI                                                    00082100
      IF(ISI.LE.4) FDEL = FMAX * .008                                   00082200
      LE = FMAX/FDEL+1.                                                 00082300
      A = 1.0                                                           00082400
      CALL MOVE(0,X,0,4004)                                             00082500
C                                                                       00082600
      DO 50 NN=1,N                                                      00082700
      LF = LEN(NN)                                                      00082800
      L = LF/2                                                          00082900
      SI=FLOAT(ISI)                                                     00083000
      FREQ = 0.0                                                        00083100
      FACT = .0062831854*SI                                             00083200
      XX = FLOAT(-(LF-1)/2)                                             00083300
C                                                                       00083400
      DO 10 J=1,LE                                                      00083500
      XN = XX                                                           00083600
      FAC = FACT * FREQ                                                 00083700
      E (J) = 0.0                                                       00083800
      I=1                                                               00083900
   20 E (J) = E (J) + F (I,NN) * COS (FAC * XN)                         00084000
      XN = XN + 1.0                                                     00084100
      I = I + 1                                                         00084200
      IF (I .LE. L) GO TO 20                                            00084300
C                                                                       00084400
      E (J) = (2. * E (J) + F (I,NN)) * A                               00084500
      X(J) = X(J) + E(J)                                                00084600
   10 FREQ = FREQ + FDEL                                                00084700
   50 CONTINUE                                                          00084800
C                                                                       00084900
      CALL GRAF3 (LE,FDEL,ISI,IPR,X)                                    00085000
C                                                                       00085100
      RETURN                                                            00085200
      END                                                               00085300

