C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       SUBROUTINE phzrot (R, Q, A, SAMP, NSAMP, DATA, loc)
C
C John Bodine originally authored "ASIG" in July of 1981. This is
C a rewrite of Johns work to remove errors, and to speed up the
C code by removing some unnecessary calculations. 
C (Dennis Frampton, March 11th, 1992).
C Carrier, threshold, and env picker added by Don Wagner, April 29, 1992)
C
C  RETURNS DESIRED COMPLEX TRACE ATTRIBUTE
C        R = INPUT SEISMIC TRACE
C        Q = QUADRATURE TRACE
C     SAMP = SAMPLE INTERVAL
C    NSAMP = NO. SAMPLES PER TRACE
C      NOP = DESIRED ATTRIBUTE
C          = 1 Carrier
C          = 2 QUADRATURE
C          = 3 ENVELOPE
C          = 4 INST. PHASE
C          = 5 RESPONSE PHASE
C          = 6 INST. FREQUENCY
C          = 7 RESPONSE FREQUENCY
C          = 8 0-PHASE DECOMPOSITION
C          = 9 90-PHASE DECOMPOSITION
C          = 10 RESPONSE AMPLITUDE
C          = 11 RESPONSE LENGTH
C          = 12 ENVELOPE SKEWNESS
C          = 13 ENVELOPE RISE TIME
C          = 14 Instantaneous Bandwidth
C
C     DATA = OUTPUT ATTRIBUTE
C     A    = OUTPUT ENVELOP TRACE
C
      REAL    R(*),Q(*),DUM(2000), DATA(*), SAMP, PI
      REAL    A(*),PH(4096), RADDEG, WC
      INTEGER NSAMP, NF, NZ
C
      PI     = 3.14159265
      RADDEG = 180./(PI)
      NF     = 101
      WC     = 3
      NZ     = NF + NSAMP
      amax   = 0.
C
C Calculate Quadrature 
C
      CALL HILBRT(NZ, NF, WC, DUM, SAMP, NSAMP, R, Q)
C
C Response Phase.
C
         DO 50 I = 1, NSAMP
              PH(I)  = PHAS(R(I), Q(I)) * RADDEG
              IF (PH(I) .GT. 180.0) THEN
                   PH(I) = PH(I) - 360.0
              ENDIF
              A(I) = 0.0
              IF (R(I) .NE. 0.0 .AND. Q(I) .NE. 0.0) THEN
                   A(I) = (R(I)**2 + Q(I)**2) ** .5
              ENDIF
              if (A(i) .ge. amax) then
                  amax = A (i)
                  loc  = I
              endif
              DATA(I) = A(I)
   50    CONTINUE
         PH(1) = PH(2)
         CALL RPHS(PH, DATA, NSAMP)

      RETURN
      END
