C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rotate (X, n, rot)

#include <f77/lhdrsz.h>

      real    X (*)
      real    amp (SZLNHD), phz (SZLNHD)
      complex C (SZLNHD)
      real    rad2deg, deg2rad
      integer ordfft
      SAVE
 
      if (rot .eq. 0.) return

      IF (N .ne. nlast) THEN
          nu = ordfft (N)
          N2 = 2 ** nu
          nlast = N
      ENDIF
 
      pi = 3.14159265
      rad2deg = 180. / pi
      deg2rad = pi / 180.

      rotr = deg2rad * rot
      nf = N2 / 2 + 1

      do  i = 1, N2
          C (i) = cmplx (0.,0.)
          amp (i) = 0.
          phz (i) = 0.
      enddo

      call rfftf  (X, C, N2)
      call rfftsc (C, N2, 3, 1)
      call cvabs  (C, 2, amp, 1, N2)

      do  i = 1, N2
          xr = real  ( C (i) )
          xi = aimag ( C (i) )
          if (xr .eq. 0.) then
             phzi = 0.
          else
             phzi = atan2 ( xi , xr )
          endif
          phz (i) = phzi + rotr
      enddo

      call cvmexp (phz, 1, amp, 1, C, 2, N2)
      call rfftsc (C, N2, -3, 0)
      call rffti  (C, X, N2)

      return
      end
