C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CHECK ( WSTART, NSAMPS, MSI, MAXLAG, WEND, IPRNTR,
     *                   NTAP, OTAP, REFIN, REFOUT, NREF, OREF )
C***********************************************************************
C
C     SUBROUTINE   - CHECK
C     LANGUAGE     - FORTRAN
C     AUTHOR       - ED ANDES
C     DATE WRITTEN - 10/??/85
C     REVISION     - OCTOBER, 1985  - ED ANDES
C                    CREATED SUBROUTINE FROM IN-LINE CODE.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        THIS ROUTINE WILL CHECK COMPUTED WINDOW TIMES FOR
C        VALIDITY.
C
C     PARAMETERS PASSED -
C       WSTART  - I*4 - COMPUTED WINDOW START TIME
C       NSAMPS  - I*4 - NUMBER OF SAMPLES ON INPUT DATA SET
C       MSI     - I*4 - INPUT SAMPLE INTERVAL
C       MAXLAG  - I*4 - LARGE LAG WINDOW MAXIMUM LAG
C       WEND    - I*4 - COMPUTED WINDOW END TIME
C       IPRNTR  - I*4 - LOGICAL UNIT NUMBER FOR PRINTER
C       NTAP    - I*4 - LOGICAL UNIT NUMBER FOR INPUT DATA TAPE
C       OTAP    - I*4 - LOGICAL UNIT NUMBER FOR OUTPUT EVENT TAPE
C       REFIN   - L*1 - FLAG FOR REFERENCE TRACE INPUT
C       REFOUT  - L*1 - FLAG FOR REFERENCE TRACE OUTPUT (IBM ONLY)
C       NREF    - I*4 - LOGICAL UNIT NUMBER FOR INPUT REFERENCE TRACES
C       OREF    - I*4 - LOGICAL UNIT NUMBER FOR OUTPUT REFERENCE TRACES
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      INTEGER     WSTART, WEND
C
      LOGICAL     REFIN, REFOUT
C
      IF ( WSTART .LE. ( ( NSAMPS - 1 ) * MSI - 2 * MAXLAG ) ) GO TO 200
           WRITE(IPRNTR,100) WSTART
  100     FORMAT(/13X,'** M6000 ** ERROR DETECTED BY SUBROUTINE CHECK:',
     *            /25X,'THE INTERPOLATED TRACE WINDOW START TIME OF',
     *            /25X, I5,' MS EXCEEDS THE TRACE LENGTH LESS TWICE',
     *            /25X,'THE LARGE LAG WINDOW MAXIMUM LAG.  VERIFY',
     *            /25X,'THAT THE WINDOW START TIME, AFTER ANY',
     *            /25X,'INTERPOLATION, DOES NOT EXCEED THE TRACE',
     *            /25X,'LENGTH LESS TWICE THE LARGE LAG WINDOW',
     *            /25X,'MAXIMUM LAG.',/)
           GO TO 800
C
  200 IF ( WSTART .GE. 0 ) GO TO 400
           WRITE(IPRNTR,300) WSTART
  300     FORMAT(/13X,'** M6100 ** ERROR DETECTED BY SUBROUTINE CHECK:',
     *           /25X,'THE INTERPOLATED WINDOW START TIME OF ',I5,
     *           /25X,'MS IS LESS THAN 0.  VERIFY WINDOW START TIMES,',
     *           /25X,'AFTER ANY INTERPOLATION, ARE NOT LESS THAN 0.',/)
           GO TO 800
C
  400 IF ( WEND .LE. ( ( NSAMPS - 1 ) * MSI - 2 * MAXLAG ) ) GO TO 600
           WRITE(IPRNTR,500) WEND
  500     FORMAT(/13X,'** M6200 ** ERROR DETECTED BY SUBROUTINE CHECK:',
     *            /25X,'THE INTERPOLATED TRACE WINDOW END TIME OF',
     *            /25X, I5,' MS EXCEEDS THE TRACE LENGTH LESS TWICE',
     *            /25X,'THE LARGE LAG WINDOW MAXIMUM LAG.  VERIFY',
     *            /25X,'THAT THE WINDOW END TIME, AFTER ANY',
     *            /25X,'INTERPOLATION, DOES NOT EXCEED THE TRACE',
     *            /25X,'LENGTH LESS TWICE THE LARGE LAG WINDOW',
     *            /25X,'MAXIMUM LAG.',/)
           GO TO 800
C
  600 IF ( WEND .GE. 0 ) RETURN
           WRITE(IPRNTR,700) WEND
  700     FORMAT(/13X,'** M6300 ** ERROR DETECTED BY SUBROUTINE CHECK:',
     *            /25X,'THE INTERPOLATED WINDOW END TIME OF ',I5,' MS',
     *            /25X,'IS LESS THAN 0.  VERIFY WINDOW END TIMES,',
     *            /25X,'AFTER ANY INTERPOLATION, ARE NOT LESS THAN',
     *            /25X,'0.',/)
  800 CONTINUE
Cray  CALL LBCLOS ( NTAP, OTAP )
      CALL LBCLOS ( NTAP ) ! Cray
      CALL LBCLOS ( OTAP ) ! Cray
      IF ( REFIN )  CALL LBCLOS ( NREF )
      IF ( REFOUT ) CALL LBCLOS ( OREF )
      CALL CCEXIT ( 100 )
      RETURN
      END
C
