C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
      SUBROUTINE FRSTIT ( XCORR, TRACE, IBUF, XLNGTH, WNDLAG,
     *                    MINLAG, MAXLAG, IWSMPL, MSI, DATA, SHIFT,
     *                    REFTR, DEAD, LWNDW, WEIGHT, KOUNT, NSAMPS,
     *                    NS, FOLD, ISWMIN, ISWMAX, XMIN,TRCARR, LENBYT,
     *                    iarr,ITRWRD,SZSMPD,KENBYT)
C***********************************************************************
C
C     SUBROUTINE   - FRSTIT
C     LANGUAGE     - FORTRAN
C     AUTHOR       - ED ANDES
C     DATE WRITTEN - 10/??/85
C     REVISION     - OCTOBER, 1985  - ED ANDES
C                    CREATED SUBROUTINE FROM IN-LINE CODE.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        FOR THE FIRST ITERATION OF A CDP, THIS SUBROUTINE
C        WILL PERFORM THE FIRST CORRELATION WITH THE REFERENCE
C        TRACE TO GET INITIAL LAGS TO APPLY TO THE TRACES BEFORE
C        CREATION OF NEW REFERENCE TRACE.
C
C     PARAMETERS PASSED -
C       XCORR  - R*4 - OUTPUT CORRELATION TRACE
C       TRACE  - R*4 - DATA TRACE TO CORRELATE WITH
C       IBUF   - I*2 - TRACE BUFFER
C       XLNGTH - I*4 - LENGTH OF XCORR
C       WNDLAG - I*4 - TRACE WINDOW LENGTH INCLUDING LAGS
C       MINLAG - I*4 - LARGE LAG WINDOW MINIMUM LAG
C       MAXLAG - I*4 - LARGE LAG WINDOW MAXIMUM LAG
C       IWSMPL - I*4 - STARTING SAMPLE OF WINDOWED TRACE
C       MSI    - I*4 - SAMPLE INTERVAL
C       DATA   - R*4 - BUFFER TO STORE TRACE IN FROM DISK
C       SHIFT  - I*4 - CONTAINS LAGS FOR ALL TRACES OF A "FOLD"
C       REFTR  - R*4 - BUFFER FOR REFERENC TRACE
C       DEAD   - I*4 - CONTAINS DEAD TRACE LI AND DI NUMBERS
C       LWNDW  - I*4 - LENGTH OF ANALYSIS WINDOW FROM PICK CARD
C       WEIGHT - R*4 - CONTAINS WEIGHTS OF PICKS
C       KOUNT  - I*4 - COUNT OF USABLE TRACES IN A FOLD
C       NSAMPS - I*4 - NUMBER OF SAMPLES PER TRACE
C       FOLD   - I*4 - PROCESSING FOLD FROM 1PICK CARD
C       ISWMIN - I*4 - SMALL WINDOW MINIMUM LAG
C       ISWMAX - I*4 - SMALL WINDOW MAXIMUM LAG
C       XMIN   - R*4 - LARGE LAG WINDOW MINIMUM LAG
C
C***********************************************************************
c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      REAL        XCORR(*), TRACE(*), DATA(*), REFTR(*),
     *            WEIGHT(512,3)
C
      INTEGER     XLNGTH, WNDLAG, DEAD(512,2), ALIGN, PRIMRY, FOLD,
     *            AMOUNT, SHIFT(512,2),ITRWRD,SZSMPD,KENBYT
C
      INTEGER     IBUF(*)
      REAL        TRCARR(iarr,fold)
C
C
      BESTSM =     0.
C
      AMOUNT = WNDLAG
C
C---- SET INDICES FOR TRACE POINTERS...
      ISTRT1 = ( IWSMPL - ( ( MAXLAG / MSI ) + 1 ) ) + 1
         IF ( ISTRT1 .LT. 1 ) ISTRT1 = 1
C
      IEND1  = ( ISTRT1 + WNDLAG ) - 1
         IF ( IEND1 .GT. NS ) AMOUNT = ( NS - ISTRT1 ) + 1
C
      ISTRT2 = ( ( ( IABS(MINLAG) - IABS(ISWMIN) ) / MSI ) + 1 )
      IEND2  = ( ( ( IABS(MINLAG) + IABS(ISWMAX) ) / MSI ) + 1 )
C
C---- LOCATE LAGS RELATIVE TO ZERO LAG...
      ALIGN  = ( XMIN / FLOAT(MSI) ) + SIGN ( 0.5, XMIN )
C
C
      DO 300 I = 1,FOLD
C
C---- IS TRACE OK ???
         IF ( DEAD(I,2) .NE. 0 ) GO TO 300
Cray         MOVE TRACE FROM TRCARR TO IBUF
         CALL MOVE(1,IBUF,TRCARR(1,I),LENBYT)
         call move (1, DATA, IBUF(ITRWRD+1), KENBYT)
C
         CALL MOVE ( 0, XCORR, 0, XLNGTH * SZSMPD )
         CALL MOVE ( 0, TRACE, 0, WNDLAG * SZSMPD )
C
C---- LOAD UP DATA TRACE...
         CALL MOVE ( 1, TRACE(1), DATA(ISTRT1), AMOUNT * SZSMPD )
C
C---- CROSS CORRELATE TRACE...
Cray     CALL APEXC ( TRACE, REFTR, XCORR, WNDLAG, LWNDW, XLNGTH )
         CALL CROSSC(TRACE,WNDLAG,REFTR,LWNDW,XCORR,XLNGTH) ! WAS APEXC
C
C---- SEARCH X-CORR TRACE FOR PEAK
C---- IN THE SMALL LAG WINDOW...
C---- ADD AN EXTRA ONE TO ISTART TO COMPENSATE
C---- WHEN SEARCHING FOR PEAKS.  YOU'RE ALWAYS
C---- SEARCHING FOR PEAKS USING ONE SAMPLE ON EITHER
C---- SIDE OF APPROPRIATE SAMPLE.   IEND WILL END ONE
C---- SAMPLE SOONER ALSO FOR THE SAME REASON...
C---- PICK PEAK WITH MAXIMUM CORRELATION COEFFICIENT...
C---- IF TWO PEAKS HAVE SAME COEFFICIENT, CHOOSE
C---- ONE NEAREST ZERO LAG...
         PRIMRY      = -10000
         WEIGHT(I,1) =      0.
C
         DO 200 IPNT = ISTRT2, IEND2
            IF ( XCORR(IPNT) .LT. 0.0 ) GO TO 200
            IF ( XCORR(IPNT-1) .GE. XCORR(IPNT)
     *                         .OR. XCORR(IPNT) .LT. XCORR(IPNT+1) )
     *                                          GO TO 200
            IF ( XCORR(IPNT) .LT. WEIGHT(I,1) ) GO TO 200
            IF ( XCORR(IPNT) .GT. WEIGHT(I,1) ) GO TO 100
            IF ( IABS(IPNT - 1 + ALIGN) .GE. IABS(PRIMRY) ) GO TO 200
  100       WEIGHT(I,1) = XCORR(IPNT)
            PRIMRY      = IPNT - 1 + ALIGN
  200    CONTINUE
C
C---- IF NO PEAK FOUND, GIVE ZERO SHIFT...
         IF ( PRIMRY .NE. -10000 )
     *        SHIFT(I,1) = PRIMRY
         BESTSM = BESTSM + SHIFT(I,1)
C
  300 CONTINUE
C
C---- CALCULATE MEAN SHIFT FOR REFERENCING LAGS...
         IAVGLG = ( BESTSM / FLOAT(KOUNT) ) + SIGN ( 0.5, BESTSM )
C
C---- BUILD NEW REFERENCE TRACE FOR ITERATIONS 2-N...
      CALL MOVE ( 0, REFTR, 0, 3000*SZSMPD )
C
C
      DO 400 I = 1,FOLD
C
         IF ( DEAD(I,2) .NE. 0 ) GO TO 400
Cray         MOVE TRACE FROM TRCARR INTO IBUF
         CALL MOVE(1,IBUF,TRCARR(1,I),LENBYT)
         call move (1, DATA, IBUF(ITRWRD+1), KENBYT)
C
C---- ADJUST LAG TO A MEAN TIME...
         SHIFT(I,1) = SHIFT(I,1) - IAVGLG
         SHIFT(I,2) = SHIFT(I,1)
C
C---- SET INDICES FOR REFERENCE TRACE RE-CREATION...
         ISTART = IWSMPL - SHIFT(I,2)
            IF ( ISTART .LT. 1 ) ISTART = 1
C
         IEND = ISTART + LWNDW - 1
            AMOUNT = LWNDW
            IF ( IEND .GT. NS ) AMOUNT = ( NS - ISTART ) + 1
C
C---- SUM ADJUSTED TRACE "N" BACK INTO COMPOSITE...
C
Cray         SUM ADJUSTED TRACE N BACK INTO COMPOSITE IN CPU
C
         JJ=ISTART
         DO 350 J=1,LWNDW
              REFTR(J)=REFTR(J)+DATA(JJ)
  350    JJ=JJ+1
C
  400 CONTINUE
C
      RETURN
      END
C
