C
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       OPNIN                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  READS FILENAME FROM COMMAND LINE AND OPENS INPUT SEISMIC  *
C            DATA FILE.                                                *
C  ENTRY POINTS:                                                       *
C      OPNIN  (MUST,ARG,FILNAM,LU,PRNTLU,IRETCD)                       *
C  ARGUMENTS:                                                          *
C      MUST    INTEGER   I - CMD LINE ARG MUST BE PRESENT              *
C      ARG     CHAR*5    I - COMMAND LINE ARGUMENT FOR INPUT FILE.     *
C      FILNAM  CHAR*120  O - FILENAME READ FROM COMMAND LINE.          *
C                            WILL BE BLANK FOR PIPED DATA.             *
C      LU      INTEGER   O - LOGICAL UNIT OF INPUT FILE.               *
C                            WILL BE 0 FOR PIPED DATA UNLESS FILE      *
C                            IS A TERMINAL.                            *
C      PRNTLU  INTEGER   I - LOGICAL UNIT OF SYSOUT FILE.              *
C      IRETCD  INTEGER   O - RETURN CODE. 0 = O.K., 1 = ERROR          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ARGUS DOWDY                        ORIGIN DATE: 88/03/21  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/21  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR - SEARCHES COMMAND LINE FOR ARGUMENT AND READS CHARACTER *
C               STRING FOLLOWING THE ARGUMENT.                         *
C      LBOPEN - OPENS SEISMIC DATA FILE                                *
C      ISATTY - RETURNS 1 IF FD IS A TERMINAL, 0 OTHERWISE             *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      PRNTLU  ( OUTPUT SEQUENTIAL ) - LOGICAL UNIT OF SYSOUT FILE     *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE OPNIN(MUST,ARG,FILNAM,LU,PRNTLU,IRETCD)
C
C     A. DOWDY   2-24-88
C
C     GET FILENAME FROM COMMAND LINE AND OPEN INPUT SEISMIC DATA FILE.
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
C
      INTEGER MUST,PRNTLU,LU,IRETCD
      CHARACTER*(*) ARG, FILNAM 
C
      IRETCD=0
C 
      LU=(-1)
c
      CALL ARGSTR(ARG,FILNAM,' ',' ')
c
      IF (FILNAM(1:1) .NE. ' ') THEN
          CALL LBOPEN(LU,FILNAM,'r')
      ELSE
          LU=0   
      ENDIF
C
      IF (LU .LT. 0) THEN
          WRITE(PRNTLU,10)
   10     FORMAT(//,' CANNOT OPEN UNIT FOR INPUT')
          IRETCD=1
      ENDIF
C
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       OPNOUT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  READS FILENAME FROM COMMAND LINE AND OPENS OUTPUT SEISMIC *
C            DATA FILE.                                                *
C  ENTRY POINTS:                                                       *
C      OPNOUT  (MUST,ARG,FILNAM,LU,PRNTLU,IRETCD)                      *
C  ARGUMENTS:                                                          *
C      MUST    INTEGER   I - CMD LINE ARG MUST APPEAR IF NON-ZERO      *
C      ARG     CHAR*5    I - COMMAND LINE ARGUMENT FOR OUTPUT FILE.    *
C      FILNAM  CHAR*120  O - FILENAME READ FROM COMMAND LINE.          *
C                            WILL BE BLANK FOR PIPED DATA.             *
C      LU      INTEGER   O - LOGICAL UNIT OF OUTPUT FILE.              *
C                            WILL BE 0 FOR PIPED DATA.                 *
C      PRNTLU  INTEGER   I - LOGICAL UNIT OF SYSOUT FILE.              *
C      IRETCD  INTEGER   O - RETURN CODE. 0 = O.K., 1 = ERROR          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:  ARGUS DOWDY                         ORIGIN DATE: 88/03/21  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/21  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR - SEARCHES COMMAND LINE FOR ARGUMENT AND READS CHARACTER *
C               STRING FOLLOWING THE ARGUMENT.                         *
C      LBOPEN - OPENS SEISMIC DATA FILE                                *
C      ISATTY - RETURNS 1 IF FD IS A TERMINAL, 0 OTHERWISE             *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      PRNTLU  ( OUTPUT SEQUENTIAL ) - LOGICAL UNIT OF SYSOUT FILE     *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE OPNOUT(MUST,ARG,FILNAM,LU,PRNTLU,IRETCD)
C
C     A. DOWDY   2-24-88
C
C     GET FILENAME FROM COMMAND LINE AND OPEN OUTPUT SEISMIC DATA FILE.
C
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

      INTEGER MUST,PRNTLU,LU,IRETCD
      CHARACTER*(*) ARG, FILNAM
C
      IRETCD=0
C
      LU=(-1)
C
      CALL ARGSTR(ARG,FILNAM,' ',' ')

      IF (FILNAM .NE. ' ') THEN
          CALL LBOPEN(LU,FILNAM,'w')
      ELSE
          LU=1
      ENDIF
C
      IF (LU .LT.0) THEN
         WRITE (PRNTLU,10)
   10    FORMAT(//,' CANNOT OPEN UNIT FOR OUTPUT')
         IRETCD=1
      ENDIF
C
      RETURN
      END
