C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE WRDSK ( NRPJOB, IDSK, IREADR, IPRNTR )
C***********************************************************************
C
C     SUBROUTINE   - WRDSK
C     LANGUAGE     - FORTRAN
C     AUTHOR       - JACQUIE VINSON
C     DATE WRITTEN - 12/06/83
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                  TO BE MAINTAINED IN CONFIDENCE
C
C     THE PURPOSE OF THIS ROUTINE HAS BEEN CHANGED TO READING THE CARD
C     IMAGES FROM A DISK FILE AND COMPUTING THE NUMBER OF RECORDS TO
C     PROCESS.    A. DOWDY   2-25-88
C
C     ABSTRACT: WRITES CARD INPUT TO DISK FILE AND CALCULATES THE
C               NUMBER OF RECORDS TO PROCESS.
C
C     PARAMETERS PASSED:
C       NRPJOB - I*4 - NUMBER OF RECORDS TO PROCESS
C       IDSK   - I*4 - DISK DATA SET LOGICAL UNIT
C       IREADR - I*4 - CARD READER LOGICAL UNIT
C       IPRNTR - I*4 - PRINTER LOGICAL UNIT
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      INTEGER     JFRI(25), JLRI(25)
C
      CHARACTER*1 CARD1(80), CNEW
C
      DATA CNEW/'N'/
C
C---- READ THE CARDS SCANNING FOR FIRST RECORD TO PROCESS FROM THE
C---- FIRST CARD AND LAST RECORD TO PROCESS FROM THE LAST CARD, SO
C---- NUMBER OF RECORDS IN JOB CAN BE SET CORRECTLY.
      I    = 1
Cray        DO NOT CALL CRDDSK.  IT READS CARD IMAGES AND WRITES THEM
Cray        TO A DISK FILE.
C
      READ(IDSK,100,END=700) CARD1
  100 FORMAT(80A1)
C
C
      IF ( CARD1(67) .EQ. CNEW )
     *     READ (CARD1,400) JFRI(I), JLRI(I)
      IF ( CARD1(67) .NE. CNEW )
     *     READ (CARD1,200) JFRI(I), JLRI(I)
  200 FORMAT (      T55, I4,      I4    )
C
      GO TO 500
C
  300 I = I + 1
      READ(IDSK,400,END=700) JFRI(I), JLRI(I)
  400 FORMAT(            T52, I5,      I5    )
C
  500 IF ( I .LE. 25 ) GO TO 300
      WRITE (IPRNTR,600)
  600 FORMAT(/13X,'** M3000 ** ERROR DETECTED BY SUBROUTINE WRDSK:',
     *       /25X,'THE MAXIMUM NUMBER OF 25 1PICK CARDS HAS BEEN',
     *       /25X,'EXCEEDED.  REDUCE THE NUMBER OF 1PICK CARDS TO',
     *       /25X,'25 OR LESS AND RESUBMIT THE JOB.',/)
      CALL CCEXIT ( 100 )
C
  700 NWIND = I - 1
      IF (JFRI(1) .NE. 0
     *            .AND. JLRI(NWIND) .NE. 0)
     *                      NRPJOB = JLRI(NWIND) - JFRI(1) + 1
C
      REWIND IDSK
      RETURN
      END
C
