C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine decon_tv( x, ns, lopp, pred, pw, y, ierr, lslide, nwin, 
     :     ovlp, decop, peo, acorr, right, work, winwork, hold1,
     :     sumb )

#include <f77/lhdrsz.h>

      integer pred, lopp, lwind, lacorr, ovlp, nwin
      integer i, lwork, lxform, ns, ierr, lslide
      integer ioff, nzro, nf, jj

      real x(*), y(*), decop(*), peo(*)
      real acorr(*), right(*), work(*)
      real winwork(*), hold1(*), sumb(*)
      real pw, xavg, xknt, offset, xmul

C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lopp   - Operator length (samples)                    |
C |   pred   - Prediction length (samples or zero crossings)|
C |   pw     - Prewhitening (fraction)                      |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+

      lacorr=(lopp+pred)*2+50
      IF(lacorr.GT.lslide)lacorr=lslide
C +----------------------------------------------------+
C | COMPUTE AND REMOVE THE AVERAGE                     |
C +----------------------------------------------------+
      imid1 = 0
      do kk=1,nwin
         if(kk.eq.1)then
            nmove=lslide+ovlp
            ilast=lslide+ovlp
            ifirst=1
            if(lslide.eq.ns)nmove=ns
            jmove=nmove
         else
            nmove=lslide+ovlp
            jmove=nmove
            ifirst=ifirst+ovlp
            imid1=ifirst
            ilast=ifirst+nmove-1
            if(ilast.gt.ns)then
               jmove=ns-ifirst+1
            endif
         endif
         do mm=1,nmove
            winwork(mm)=0.
         end do
         call vmov(x(ifirst),1,winwork,1,jmove)
         lwind=nmove
         xavg = 0.
         xknt = 0.
         jj=1
         do i=1,lwind
            if(winwork(jj).ne.0.0)then
               xavg = xavg+winwork(jj)
               xknt = xknt+1.
            endif
            jj=jj+1
         end do
         if(xknt.ne.0.0)then
            xavg = xavg/xknt
         else
            xavg = 0.
         end if
         do i=lwind,4096
            work(i)=0.
         end do
         do i=1,lwind
            work(i)=winwork(i)-xavg
         end do
C +----------------------------------------------------+
C | DO THE AUTOCORRELATION IN THE TIME DOMAIN          |
C +----------------------------------------------------+
         lwork=2*lwind
         lxform=64
         do while(lxform.lt.lwork)
            lxform=lxform+lxform
         end do
         call vclr(acorr,1,3000)
         call vclr(work(lwind+1),1,lxform-lwind)
         call acorf(work,acorr,lacorr,lxform)
         
         if (acorr(1) .lt. 1.e-30) then
            do  i = 1, lopp
               peo (i) = 0.
            enddo
            go to 10
         endif
         
         acorr(1)=acorr(1)*(1.+pw)
C +----------------------------------------------------+
C | BUILD THE DECON OPERATOR                           |
C +----------------------------------------------------+
         IF(pred.GE.0)THEN
            IF(pred.LT.1)pred=1
            IOFF=pred
         ELSE
            nzro=IABS(pred)
            IF(nzro.GE.10)nzro=1
C +------------------------------------------------------------+
C | NZCROS LOOKS FOR nzro-TH CROSSING, RETURNING IN IOFF THE   |
C | INDEX COUNT OF THE LAST SAMPLE BEFORE THE nzro-TH          |
C | CROSSING.  NF IS THE NUMBER OF ZERO CROSSING FOUND         |
C | UP TO AND INCLUDING THE nzro-TH CROSSING.                  |
C +------------------------------------------------------------+
            call NZCROS(acorr,1,nzro,IOFF,NF,LACORR)
            IF(NF.LT.nzro)THEN
               IERR=200
               call vmov(X,1,Y,1,NS)
               RETURN
            ENDIF
            IF(pred.LE.-10)THEN
               XMUL=pred
               XMUL=ABS(XMUL)/10.
               OFFSET=IOFF
               IOFF=OFFSET*XMUL
            ENDIF
         ENDIF
         call vclr(right,1,lopp)
         IF(IOFF.LE.1)THEN
            call vmov(acorr(2),1,right,1,lopp)
         ELSE
            call vmov(acorr(IOFF+1),1,right,1,lopp)
         ENDIF
         IF(pred.EQ.1)THEN
            call wiener(lopp,acorr,right,decop,peo,1,IERR)
            do i=1,lopp
               decop(i)=peo(i)
            end do
            IOFF=0
         ELSE
            call wiener(lopp,acorr,right,decop,peo,1,IERR)
         ENDIF
         if(ierr.ne.0)call vclr(decop,1,lopp)
C     +----------------------------------------------------+
C | CREATE PROPER peo FOR GIVEN PREDICTION DISTANCE    |
C +----------------------------------------------------+
         lconv = lopp+ioff
         do i=1,lconv
            work(i)=0.
         end do
         call vmov(decop(1),1,work(ioff+1),1,lopp)
         if(pred.ne.1)then
            do i=1,lconv
               work(i)=-work(i)
            end do
            work(1)=1.
         endif
         
         call vmov(work,1,peo,1,lconv)
C +----------------------------------------------------+
C | CONVOLVE THE FILTER WITH DATA                      |
C +----------------------------------------------------+
         do i=1,lconv
            work(i)=0.
         end do
         call vmov(winwork,1,work(lconv),1,lwind)
         call conv(work,1,peo(lconv),-1,hold1,1,lwind,lconv,1)
         if(kk.eq.1)then
            do i=1,lwind
               sumb(i)=hold1(i)
            end do
         else
            jj=imid1-1
            xj=ovlp
            do i=1,ovlp
               jj=jj+1
               x1=(i-1)/xj
               x2=1.0-x1
               sumb(jj)=sumb(jj)*x2+hold1(i)*x1
            end do
            do i=ovlp+1,jmove
               jj=jj+1
               sumb(jj)=hold1(i)
            end do
         endif
 10      continue
      end do
      do i=1,ns
         y(i)=sumb(i)
      end do
      CONTINUE
      RETURN
      END
