C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c ----- routine prepr3d reads navigation data in UKOOA or SEG P format -----
c       along with a set of shot skips from the observers and outputs
c       the required card deck to run pr3d.  The routine may be run in stats mode
c       where data may be gleaned from the navigation data or in default mode 
c       where the card deck will be built. 
c
c
c       CONSTRAINTS
c
c       skip data must be in same sorted order as navigation data after application
c       of any desired reverse factor.  This is required when the navigation data was
c       acquired in the opposite order to the way the line was shot.
c
c       Navigation data must fit SEG P or UKOOA format
c
c       Input data record 1 must correspond to 1st (or last if -R) shot location
c       in navigation file 
c
c       All command line parameters for station id must apply to the navigation data
c       after application of any desired reverse factor.
c
c       There should be no missing stations in the navigation data otherwise
c       the logic in this program will fail.  It assumes missing data will 
c       be defined in the skips file and not appear in the navigation data.  There
c       should be navigation data for every station used.
c

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer x,y,elev,shot,StationAtSource,StationAtSource1,rref
      integer StationAtTrace1,StationAtFirstTrace1,Rollin
      integer xmax,ymax,xmin,ymin,counter
      integer luin,lupr3d,luskip
      integer shotskips,SkipCounter,Kills
      integer RecNum,InitialRecNum
      integer leSurvey,lePr3d,leSkip
      integer argis,abort,MemRequired
      integer errcd1,errcd2,errcd3,errcd4,NegFlag


      pointer    (wkadr1, shot(2000000))
      pointer    (wkadr2, x(2000000))
      pointer    (wkadr3, y(2000000))
      pointer    (wkadr4, elev(2000000))
      pointer    (wkadr5, shotskips(200000))

      character grup*5, sorc*5, sprd*5, one*1, name*7
      character Survey*255,Pr3dfile*255,Skipfile*255

      logical metric,english,stats,verbos,query,reverse

c
c ----- inititalize data -----
c
      data xmax/0/, ymax/0/,xmin/999999999/,ymin/999999999/
      data grup/'1GRUP'/,sorc/'1SORC'/,sprd/'1SPRD'/,one/'1'/
      data name/'PREPR3D'/,abort/0/

      counter = 0
      SkipCounter = 0
      Kills = 1
      NegFlag = 0
      
      verbos = .false.
      metric = .false.
      english = .false.
      stats = .false.
      query = .false.
      reverse = .false.

c
c ----- check if help only required -----
c
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c
c ----- get cmdln paramters -----
c

      call cmdln(Survey,Pr3dfile,Skipfile,metric,english,
     :    Rollin,StationAtSource1,StationAtFirstTrace1,stats,
     :    InitialRecNum,rref,reverse,verbos)

c
c ----- open printout file
c

#include <f77/open.h>

c
c ----- open survey file -----
c
 
      leSurvey = lenth(Survey)
      call alloclun(luin)

      if(luin.lt.0)then

         write(LERR,*)'FATAL: cannot assign logical unit to'
         write(LERR,*)'       luin'
         stop

      endif        
 
      if (leSurvey .eq. 0) then
	write(LERR,*) 'No Survey specified via -N argument'
	write(LERR,*) 'FATAL'
	write(LER,*) 'prepr3d: No Survey specified via -N argument'
	write(LER,*) 'FATAL'
	stop  100
      endif
      open(unit=luin,file=Survey(1:leSurvey),status='unknown',err=995)
      write(LERR,*)' Survey Data from ',Survey(1:leSurvey)

c
c ----- open pr3d Card output file -----
c

      lePr3d = lenth(Pr3dfile)
      call alloclun(lupr3d)

      if(lupr3d.lt.0)then

         write(LERR,*)'FATAL: cannot assign logical unit to'
         write(LERR,*)'       lupr3d'
         stop

      endif        

      if (lePr3d .eq. 0) then
	write(LERR,*) 'No PR3D card file specified via -O argument'
	write(LERR,*) 'FATAL'
	write(LER,*) 'prepr3d: No PR3D card file specified via ',
     :    '-O argument'
	write(LER,*) 'FATAL'
	stop  100
      endif
      open(unit=lupr3d,file=Pr3dfile(1:lePr3d),status='unknown',err=996)
      write(LERR,*)' PR3D cards written to  ',Pr3dfile(1:lePr3d)

c
c ----- open Shot skips file if requested -----
c

      leSkip = lenth(Skipfile)

      if(Skipfile(1:1).ne.' ')then

         call alloclun(luskip)

         if(luskip.lt.0)then

            write(LERR,*)'FATAL: cannot assign logical unit to'
            write(LERR,*)'       luskip'
            stop

         endif        

         open(unit=luskip,file=Skipfile(1:leSkip),status='unknown',
     :        err=997)
         write(LERR,*)' Shot Skip Data from ',Skipfile(1:leSkip)

      endif

c
c ----- verbal output -----
c

      if(verbos)then

         write(LERR,*)' '
         write(LERR,*)' Command Line Parameters Used'
         write(LERR,*)' '
         if(metric) write(LERR,*)' metric conversion applied '
         if(english)write(LERR,*)' english conversion applied '
         if(reverse)write(LERR,*)' shots will be reversed'
         if(stats)write(LERR,*)' statistics only, no cards generated'
         write(LERR,*)' '
         write(LERR,*)' Magnitude of rollin in shots = ',Rollin
         write(LERR,*)' Station Number at first shot =',
     :        StationAtSource1
         write(LERR,*)' Station Number at first trace of first record ='
     :        ,StationAtFirstTrace1
         write(LERR,*)' Record Number (RecNum) of first output record ='
     :        ,InitialRecNum
         write(LERR,*)' Regional Reference Elevation =',rref

      endif

c
c ----- determine number of entries in survey file -----
c

      call NavCount(luin,counter,xmax,xmin,ymax,ymin,metric,english)

c
c ----- skip card output if stats flag is set -----
c

      if(stats)goto 999

c
c ----- determine number of entries in shotskip file if requested -----
c

      if(Skipfile(1:leSkip).ne.' ')then

         call FileCount(luskip,SkipCounter)

      endif

c
c ----- allocate appropriate memory -----
c

      MemRequired = counter * SZSMPD

      call galloc(wkadr1,MemRequired,errcd1,abort)
      call galloc(wkadr2,MemRequired,errcd2,abort)
      call galloc(wkadr3,MemRequired,errcd3,abort)
      call galloc(wkadr4,MemRequired,errcd4,abort)
      
      if (errcd1.ne.0.or.errcd2.ne.0.or.errcd3.ne.0.or.errcd4.ne.0)then
      
         write(LERR,*)' '
         write(LERR,*)'FATAL ......................'
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 4*MemRequired,'  bytes'
         write(LERR,*)' '
         stop

      else

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 4*MemRequired,'  bytes'
         write(LERR,*)' '

      endif

c
c ----- allocate memory for shotskip file if required -----
c

      if(Skipfile(1:leSkip).ne.' ')then

         MemRequired = SkipCounter * SZSMPD

         call galloc(wkadr5,MemRequired,errcd1,abort)

         if(errcd1.ne.0)then 
      
            write(LERR,*)' '
            write(LERR,*)'FATAL ......................'
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 1*MemRequired,'  bytes'
            write(LERR,*)' '
            stop

         else

            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 4*MemRequired,'  bytes'
            write(LERR,*)' '

         endif

      endif

c
c ----- read in shot skip data if required -----
c

      if(Skipfile(1:leSkip).ne.' ')then

         call ReadShotSkip(luskip,shotskips,SkipCounter)

      endif

c
c ----- read in survey data -----
c

      if(verbos)then

         write(LERR,*)' Survey Data '
         write(LERR,*)'  shot     x        y   elev'

      endif

      call ReadSurvey(luin,shot,x,y,elev,counter,metric,english,verbos)
      

c
c ----- sort survey data by shot point if requested -----
c

      if(reverse)then
         
         if(shot(1).lt.shot(counter))then

            do i=1,counter

               shot(i) = -shot(i)
               NegFlag = 1

            enddo

         endif

         call isort4 (counter,shot,x,y,elev)

         if(NegFlag.gt.0)then

            do i=1,counter

               shot(i) = -shot(i)

            enddo

         endif

      endif

c
c -----  output 1GRUP cards -----
c

      StationAtSource = StationAtSource1

      do i=1,counter

         write(lupr3d,'(a5,1x,2i8,10x,2i5,33x,i5)')grup,x(i),y(i),
     :        elev(i),rref,StationAtSource

         StationAtSource = StationAtSource + 1

      enddo

c
c ----- output sorc and sprd cards -----
c

      StationAtSource = StationAtSource1
      StationAtTrace1 = StationAtFirstTrace1
      RecNum = InitialRecNum

      if(Skipfile(1:leSkip).ne.' ')then

         write(LERR,*)' '
         write(LERR,*)' Skipped shots'

      endif

      DO i=1,counter

c
c ----- if skipfile exists use skip logic -----
c

         IF(Skipfile(1:leSkip).ne.' ')then

            if(shot(i).ne.shotskips(Kills)) then

               RecNum = RecNum + 1

         write(lupr3d,'(a5,1x,2i8,10x,2i5,9x,i5,5x,a1,14x,i4)')sorc,
     :        x(i),y(i),elev(i),rref,shot(i),one,RecNum

         write(lupr3d,'(a5,6x,a1,i5,59x,i4)')sprd,
     :        one,StationAtTrace1,RecNum

            else
            
               write(LERR,*)shot(i)

               if(Kills.ge.SkipCounter)then
                  Kills = SkipCounter
               else
                  Kills = Kills + 1
               endif

            endif

         ELSE

c
c ----- use logic for no shotskips -----
c

            RecNum = RecNum + 1

         write(lupr3d,'(a5,1x,2i8,10x,2i5,9x,i5,5x,a1,14x,i4)')sorc,
     :        x(i),y(i),elev(i),rref,shot(i),one,RecNum

         write(lupr3d,'(a5,6x,a1,i5,59x,i4)')sprd,
     :        one,StationAtTrace1,RecNum


         ENDIF

c
c ----- determine if shot has progressed far enough into line that trace -----
c       one can start rolling along.  
c

         StationAtSource = StationAtSource + 1
         if(StationAtSource.gt.Rollin)StationAtTrace1=StationAtTrace1+1

      ENDDO

      goto 999


 995  write(LERR,*)' FATAL: Input Navigation File ',Survey(1:leSurvey),
     :     ' Not Found.' 
      write(LERR,*)' Check existence and rerun'
      write(LERR,*)' '
      stop

 996  write(LERR,*)' FATAL: Could not open output file',
     :     Pr3dfile(1:lePr3d),' check permissions and rerun.'
      stop

 997  write(LERR,*)' FATAL: Input Shot skips File ',Skipfile(1:leSkip),
     :     ' Not Found.' 
      write(LERR,*)' Check existence and rerun'
      write(LERR,*)' '
      stop

 999  write(LERR,*)' '
      write(LERR,*)' Max and Min x and y co-ordinates'
      write(LERR,*)' '
      write(LERR,*)' Maximum x co-ord = ',xmax 
      write(LERR,*)' Maximum y co-ord = ',ymax 
      write(LERR,*) ' '
      write(LERR,*)' Minimum x co-ord = ',xmin      
      write(LERR,*)' Minimum y co-ord = ',ymin 
      write(LERR,*) ' '
      write(LERR,*)' Number of Survey Entries = ',counter
 
      close(luin)
      close(lupr3d)

      if(Skipfile(1:leSkip).ne.' ')close(luskip)

      write(LERR,*)' '
      write(LERR,*)' End of prepr3d execution'
      write(LERR,*)' Normal Termination'

      close(LERR)

      stop
      end
         

      subroutine cmdln(Survey,Pr3dfile,Skipfile,metric,english,Rollin,
     :     StationAtSource1,StationAtFirstTrace1,stats,InitialRecNum,
     :     rref,reverse,verbos)

#include <f77/iounit.h>

      integer    argis,Rollin,StationAtSource1,StationAtFirstTrace1
      integer    InitialRecNum,rref
     
      character  Survey*(*),Pr3dfile*(*),Skipfile*(*)

      logical    metric,english,stats,verbos,reverse

          call argi4('-rollin',Rollin,1,1)
          call argi4('-ss',StationAtSource1,1,1)
          call argi4('-st',StationAtFirstTrace1,1,1)
          call argi4('-rec',InitialRecNum,1,1)
          call argi4('-rref',rref,0,0)

          call argstr('-N',Survey,' ',' ') 
          call argstr('-O',Pr3dfile,' ',' ') 
          call argstr('-S',Skipfile,' ',' ') 

          stats = (argis('-stats').gt.0)
          metric = (argis('-metric').gt.0)
          english = (argis('-english').gt.0)
          reverse = (argis('-R').gt.0)

          verbos = (argis('-V').gt.0)

      return
      end

      subroutine help()

#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'prepr3d reads navigation data and outputs 1GRUP, 1SORC and'
        write(LER,*)
     :'1SPRD cards for input to pr3d.  See manual pages for details '
        write(LER,*)
     :'(on-line by typing uman prepr3d )'
        write(LER,*)
     :'Execute prepr3d by typing prepr3d and the of program parameters
     :' 
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)' '
        write(LER,*)
     :'Command Line Parameters and Defaults'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input navigation data'
        write(LER,*)
     :' -O [otap]    (no default)         : output pr3d card file'
        write(LER,*)  
     :' -S [skip]    (default = not used) : input shotskips file'
        write(LER,*)
     :' -rollin[x]   (default = 1)        : Shot Number to Start Rollalo
     :ng'
        write(LER,*)
     :' -ss[ss]      (default = 1)        : Station at 1st Shot'
        write(LER,*)
     :' -st[st]      (default = 1)        : Station at 1st Trace'
        write(LER,*)
     :' -rec[irs]    (default = 1)        : Initial Record Number'
        write(LER,*)
     :' -rref[rref]  (default = 0)        : Regional Reference Surface'
        write(LER,*)
     :' -metric      (include on command line to convert to metric units
     :)'
        write(LER,*)
     :' -english     (include on command line to convert to english unit
     :s)'
        write(LER,*)
     :' -stats       (include on command line to output navigation limit
     :s only)'
        write(LER,*)
     :' -R           (include on command line to reverse the sorted orde
     :r of navigation data)'
          write(LER,*)
     :' -V           (include on command line if verbose printout is des
     :ired)'
        write(LER,*)' '
        write(LER,*)
     :'Example:   prepr3d -Ndatain -OPr3dCards -SShotSkips -rollin61'
        write(LER,*)
     :'                   -ss1 -st1 -rec101 -rref2000 -metric -R -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      stop
      end
      
      subroutine NavCount(luin,counter,xmax,xmin,ymax,ymin,metric,
     :     english)

      integer luin,counter,xmax,xmin,ymax,ymin
      integer shot,x,y,elev

      logical metric,english

      counter = 0

      do while (1.eq.1)

         read(luin,'(20x,i5,20x,2i8,i5)',end=200)shot,x,y,elev
         counter = counter + 1

         if(x.gt.xmax)xmax = x
         if(x.lt.xmin)xmin = x
         if(y.gt.ymax)ymax = y
         if(y.lt.ymin)ymin = y

      enddo
         
 200  continue

      if(metric)then
         xmax =  nint(float(xmax) * 0.3048)
         xmin =  nint(float(xmin) * 0.3048)
         ymax =  nint(float(ymax) * 0.3048)
         ymin =  nint(float(ymin) * 0.3048)
      endif

      if(english)then
         xmax =  nint(float(xmax) / 0.3048)
         xmin =  nint(float(xmin) / 0.3048)
         ymax =  nint(float(ymax) / 0.3048)
         ymin =  nint(float(ymin) / 0.3048)
      endif

      rewind luin
      return
      end

      subroutine FileCount(lu,n)
      integer lu,n
      real value

      n = 0

      do while(1.eq.1)
         
         read(lu,*,end=100)value
         n = n + 1

      enddo

 100  rewind lu
      return
      end

      subroutine ReadShotSkip(luskip,shotskips,SkipCounter)

      integer luskip,shotskips(*),SkipCounter

      real value

      do i=1,SkipCounter

         read(luskip,*)value
         shotskips(i) = nint(value)

      enddo

      return
      end

      subroutine ReadSurvey(luin,shot,x,y,elev,counter,metric,english,
     :     verbos)
      
#include <f77/iounit.h>

      integer luin,shot(*),x(*),y(*),elev(*),counter
      logical metric, english, verbos

      do i=1,counter

         read(luin,'(20x,i5,20x,2i8,i5)')shot(i),x(i),y(i),elev(i)

c  compensate for implied decimal on UKOOA card

         x(i) = nint(float(x(i))/10.)
         y(i) = nint(float(y(i))/10.)
         elev(i) = nint(float(elev(i))/10.)

         if(verbos)write(LERR,*)shot(i),x(i),y(i),elev(i)

      enddo
      
      if(metric.or.english)then

         if(verbos)then

            write(LERR,*)' '
            write(LERR,*)' converted survey data '
            write(LERR,*)'  shot     x        y   elev'

         endif

         do i=1,counter
         
            if(metric)then

               x(i) = nint(float(x(i)) * 0.3048)
               y(i) = nint(float(y(i)) * 0.3048)
               elev(i) = nint(float(elev(i)) * 0.3048)

            endif

            if(english)then

               x(i) = nint(float(x(i)) / 0.3048)
               y(i) = nint(float(y(i)) / 0.3048)
               elev(i) = nint(float(elev(i)) / 0.3048)

            endif

            if(verbos)write(LERR,*)shot(i),x(i),y(i),elev(i)

         enddo

      endif

      return
      end
