C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine decbci (kodepc, ntpr, codepc, incld)
c
c     Routine:  DECode Binary Coded Integer
c
c     Written by:  Bill Done
c     Created on:  89/2/15
c
c     If kodepc contains the orders of principal components to be
c     excluded from a reconstruction, encoded in kodepc in binary
c     coded form, decode kodepc to indicate which principal
c     components are to be excluded from the reconstruction.
c     This is primarily used to indicate the high order (1, 2, etc.)
c     components to be excluded.  The array codepc will contain
c     an indication of whether principal component k will be
c     included (codepc(k) = 1) or excluded (codepc(k) = 0) from
c     the reconstruction.
c
c
c     LIMEXP represents the power of 2 which results in the largest
c     legal integer value on this machine
c
      integer LIMEXP
      parameter (LIMEXP = 30)
c
      integer kodepc, ntpr, codepc(ntpr)
      integer k, limit, kodsav, kexp2, kodtmp
      logical incld
c
c     integer function
c
      integer  min0
c
c     initialize elements of codepc to 1
c
      do 100 k = 1, ntpr
         codepc(k) = 1
  100 continue
c
c     if kodepc < or = 0, set to 0 and return
c
      if (kodepc .le. 0) then
         kodepc = 0
         return
      endif
c
c     interpreting kodepc as a binary coded integer, decode it to
c     indicate by a value of 0 for an element in codepc that the
c     corresponding principal component is to be excluded from the
c     reconstruction.  a value of 1 in codepc indicates the
c     corresponding principal component is to be included in the
c     reconstruction.  for example, if kodepc is expressed as the
c     series
c
c         kodepc = sum (k=1 to ntpr) a(k)*(2**k)
c
c     where a(k) = 0 or 1, then principal component k is excluded
c     from the reconstruction (codepc(k) = 0) if a(k) = 1 and included
c     (codepc(k) = 1) if a(k) = 0.  Note that there is no zeroeth
c     principal component (by my notation), so there can be no 2**(0)
c     term in the above sum.  therefore, kodepc will never be an odd
c     integer.
c
c     NOTE:  ideally in the do 200 loop, k would scan from ntpr to 1.
c            but there is a machine dependent limit on the 2**k
c            operation.  for this reason k scans from limit to 1, where
c            limit is the smaller of ntpr and limexp.  elements of
c            codepc(k), k > limexp, are left with a value of 1.

      if (incld) then
          do  150  j = 1, ntpr
              codepc(j) = 0
150       continue
      endif
c
      limit = min0 (ntpr, limexp)
      kodsav = kodepc
      do 200 k = limit, 1, -1
         kexp2 = 2**k
         kodtmp = kodsav - kexp2
         if (kodtmp .ge. 0) then
            if (incld) then
                codepc(k) = 1
            else
                codepc(k) = 0
            endif
            kodsav = kodtmp
         endif
  200 continue
      return
      end
