C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PCCALC (sfile,jj,irs,verbos,nspt, ntpr, datai, 
     1                   ibig, prcomp, covar, eigvec, vmean,
     2                   eigval, cumsum, codepc, kodepc, epsiln,
     3                   toteng, sumval, kmxvec, iprsgn, iprcom,
     4                   irec, incld, itop)
c
c     Routine:  Principal Component CALCulation, version ai
c
c     Written by:  Bill Done
c     Created on:  89/9/18
c
c     Given the data in array datai, compute the principal components
c     of that data.
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c
      integer   nelmnt, index1, index2, nvec, nrow, ncol
      integer   npcomp, ierr, k, jj, ibig, irs, irec
      real      tetemp
      real      datai(*),prcomp(*)
      real      covar(ntpr,ntpr),eigvec(ntpr,ntpr)
      real      vmean(*),eigval(*),cumsum(0:ntpr+1)
      integer   codepc(*)
      real      work(SZLNHD*2)
      character sfile*(*), xgrtag*8
      logical   verbos, incld

      data      xgrtag/'"Record='/

c
c     externals
c
      external vclr, rseaa, decbci
c
c     set some flags to false
c
c
c     zero the mean vector and the covariance matrix
c
      call vclr (vmean, 1, ntpr)
      call vclr (covar, 1, ntpr*ntpr)
      call vclr (eigvec, 1, ntpr*ntpr)
      call vclr (prcomp, 1, nspt*ntpr)
c
c     compute the mean vector (vmean)
c
      do 140 nelmnt = 1, ntpr
         do 120 nvec = 1, nspt
            index1 = nspt*(nelmnt - 1) + nvec
            vmean(nelmnt) = vmean(nelmnt) + datai(index1)
  120    continue
  140 continue
      do 160 nelmnt = 1, ntpr
         vmean(nelmnt) = vmean(nelmnt)/float(nspt)
  160 continue
c
c     compute covariance matrix.  there are nspt data vectors, each
c     data vector containing ntpr elements taken from a fixed time.
c     the data vectors are not explicitly formed.  there are ntpr
c     rows and columns in the covariance matrix, which is symmetric.
c
      do 240 nrow = 1, ntpr
         do 220 ncol = nrow, ntpr
            do 200 nvec = 1, nspt
               index1 = nspt*(nrow - 1) + nvec
               index2 = nspt*(ncol - 1) + nvec
               covar(nrow,ncol) = covar(nrow,ncol) + 
     *                     (datai(index1) - vmean(nrow))*
     *                     (datai(index2) - vmean(ncol))

  200       continue
            covar(nrow,ncol) = covar(nrow,ncol) / real(nspt)
c
c           fill out the lower triangular part of covariance matrix
c
            covar(ncol,nrow) = covar(nrow,ncol)
  220    continue
  240 continue
c
c     solve for eigenvalues and eigenvectors
c
      call rseaa (ntpr, ntpr, covar, eigval, eigvec, work, ierr)

      write(LERR,*)'Rec =  ',jj,'  rseaa error code= ',ierr
      if (verbos .AND. (mod(jj,irec).eq.0 .OR. jj .eq. irs)) then
         write(LERR,*)'                     Eigenvalues'
         write(LERR,333)(eigval(i),i=1,ntpr)
333      format(5e12.3)
      endif
c
c     find sum of eigenvalues (total energy)
c
      sumval = 0.0
      do 300 k = 1, ntpr
         sumval = sumval + eigval(k)
  300 continue
c
c     accumulate sum of eigenvalues until normalized sum (in percent)
c     exceeds toteng, save the corresponding eigenvalue index.
c     epsiln is added to the normalized cumulative sum before comparing
c     to tetemp = toteng/100. to prevent problems do to roundoff error
c     when toteng = 100.
c
c     NOTE:  eigenvalues are stored in eigval in ascending order,
c            so start accumulation from largest eigenvalue, which is
c            at eigval(ntpr).
c
      if (mod(jj,irec) .eq. 0 .OR. jj .eq. irs)
     1write (LERR,3000)
 3000 format(4x,'k',3x,' eigenvalue',3x,'cumulative sum')

      cumsum(0) = 0.0
      kmxvec = 1
      tetemp = toteng/100.
      do 320 k = 1, ntpr
         cumsum(k) = cumsum(k-1) + eigval(ntpr+1-k)/sumval
         if (verbos .AND. (mod(jj,irec).eq.0 .OR. jj .eq. irs))
     1   write (LERR,3020) k, eigval(ntpr+1-k), cumsum(k)
 3020    format(1x,i4,3x,1pe11.4,5x,0pf11.8)

                   if (sfile(1:1) .ne. ' ') then
                       write(lun,888) k, cumsum(k)
888                    format(i6,e12.3)
                       if (k .eq. ntpr) then
                           write(lun,890) xgrtag,jj
890                        format(a8,1x,i5)
                           write(lun,889)
889                        format()
                       endif
                   endif

         if (cumsum(k)+epsiln .ge. tetemp) then
            kmxvec = k
            tetemp = 1000000.
         endif
  320 continue

      if (toteng .eq. 100. .AND. kmxvec .eq. 1) then
         write(LERR,*)'For current record roundoff prevented cum sum ',
     1                 cumsum(ntpr),'  k= ',ntpr
         write(LERR,*)'from reaching 1.0. Will set kmxvec to required ',
     1                 ntpr
         kmxvec = ntpr
      endif

c
c     determine from kodepc which principal components are to be
c     included and excluded from the reconstruction and store this
c     information in array codepc.  kodepc is set as a command line
c     argument in the non-interactive mode of operation and has been
c     set to zero if in the interactive mode.
c
      call decbci (kodepc, ntpr, codepc, incld)
      if (ibig .ne. 0) then
         kmxvec = ibig
         toteng1 = 100. * cumsum(ibig)
      elseif (itop .ne. 0) then
         kmxvec = itop * ntpr / 100
         toteng1 = 100. * cumsum(ibig)
      else
         toteng1 = toteng
      endif
c
c     modify array codepc to indicate that principal components above
c     kmxvec are to be excluded from the reconstruction by making the
c     corresponding element in codepc equal to 0
c
         if (kmxvec .lt. ntpr) then
            do 340 k = kmxvec+1, ntpr
               codepc(k) = 0
  340       continue
         endif

      if (verbos .AND. (mod(jj,irec).eq.0 .OR. jj .eq. irs)) then
         write(LERR,*)' '
         write(LERR,*)'kodepc= ',kodepc,'  kmxvec= ',kmxvec
         write(LERR,*)(codepc(i),i=1,ntpr)
         write(LERR,*)' '
      endif

      write (LERR,3400) toteng1, sumval, kmxvec
 3400 format('  Energy:  ',f10.2,' % total energy',
     *          1pe11.4,' exceeded at eigenvalue order ',i4)
c
c     zero the principal component and output data arrays
c
c     call vclr (datao , 1, nspt*ntpr)
      call vclr (prcomp, 1, nspt*ntpr)
c
c     compute the ntpr principal components, each having nspt elements
c     NOTE:  the first principal component is obtained by projecting
c            (inner product) the data vectors onto the dominant (first
c            order) eigenvector, which is the eigenvector stored in
c            column ntpr of array eigvec.
c
      do 480 npcomp = 1, ntpr
         do 460 nelmnt = 1, ntpr
            do 440 k = 1, nspt
               index1 = nspt*(npcomp - 1) + k
               index2 = nspt*(nelmnt - 1) + k
               prcomp(index1) = prcomp(index1) + (datai(index2)
     *               - vmean(nelmnt))*eigvec(nelmnt,ntpr+1-npcomp)
  440       continue
  460    continue
  480 continue
c
c     reconstruct seismic data using reduced rank modeling of
c     the data based on using only those eigenvectors associated
c     with the ntpr-kmxvec largest eigenvalues. 
c
c     NOTE:  remember that eigval(ntpr) is the largest eigenvalue
c            and eigvec(*,ntpr) is its associated eigenvector and
c            are considered to be the "first order" eigenvalue and
c            eigenvector.  prcomp(*,1) is the first order principal
c            component.
c
      call vclr (datai , 1, nspt*ntpr)

      do 540 nvec = 1, kmxvec
         if (codepc(nvec) .eq. 1) then

            do 520 ncol = 1, ntpr
               do 500 k = 1, nspt
                  index1 = nspt*(ncol - 1) + k
                  index2 = nspt*(nvec - 1) + k
                  datai(index1) = datai(index1) +
     *                 prcomp(index2)*eigvec(ncol,ntpr+1-nvec)
  500          continue
  520       continue

          else

            write (LERR,5200) nvec
 5200       format(' Exclude p.c. ',i5,' from reconstruction')

         endif
  540 continue
c
c     reinsert the mean onto the reduced rank reconstruction of the data
c
      do 620 ncol = 1, ntpr
         do 600 nvec = 1, nspt
            index1 = nspt*(ncol - 1) + nvec
            datai(index1) = datai(index1) + vmean(ncol)
  600    continue
  620 continue
c
      return
      end
