C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes:

c      - original written: December 15, 1994

c     Program Description:

c     program to calculate and put values in header
c
c	James M. Gridle
c	USP Team Tulsa
c	April 1997     

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis

      real        tri ( SZLNHD ),abstri(SZLNHD)

      character   ntap*255, otap*255, name*6
      character   HdrWrd1*6, HdrWrd2*6, HdrWrd3*6
      character   LnWrd1*6, LnWrd2*6, LnWrd3*6
      real        peak,avg,rms

      logical     verbos

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    Trace_WorkSpace
      real job_peak, job_avg, job_rms

      pointer (wkadr1, Trace_WorkSpace(200000))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_HdrWrd1,l_HdrWrd1,ln_HdrWrd1
      integer ifmt_HdrWrd2,l_HdrWrd2,ln_HdrWrd2
      integer ifmt_HdrWrd3,l_HdrWrd3,ln_HdrWrd3
      integer ifmt_LnWrd1,l_LnWrd1,ln_LnWrd1
      integer ifmt_LnWrd2,l_LnWrd2,ln_LnWrd2
      integer ifmt_LnWrd3,l_LnWrd3,ln_LnWrd3
c Initialize variables

      data abort/1/
      data name/"PUTVAL"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
      job_avg = 0.
      job_peak = 0.
      job_rms = 0.
      jcount = 0
c     open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, HdrWrd1, HdrWrd2, HdrWrd3 )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'PUTVAL: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(HdrWrd1,ifmt_HdrWrd1,l_HdrWrd1,ln_HdrWrd1,
     :     TRACEHEADER)
      call savelu(HdrWrd2,ifmt_HdrWrd2,l_HdrWrd2,ln_HdrWrd2,
     :     TRACEHEADER)
      call savelu(HdrWrd3,ifmt_HdrWrd3,l_HdrWrd3,ln_HdrWrd3,
     :     TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )

      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos, HdrWrd1, HdrWrd2, 
     :     HdrWrd3)

c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (wkadr1, TraceSize * SZSMPD, errcd1, abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Trace_WorkSpace, 1, TraceSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

         
c process only live traces

            if ( StaCor .ne. 30000) then
 
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               
              do i = 1, nsamp
                 abstri(i) = abs(tri(i))
              enddo
                 
c     caluculte job average
             
c     calculate avgerage
               avg = 0.
               do i = ist,iend
                  avg=abstri(i)+avg
                  job_avg = job_avg + abstri(i)
                  jcount = jcount + 1
               enddo
               avg = avg/(iend-ist+1)    
             
        if (ifmt_HdrWrd2 .eq. SAVE_FKFLT_DEF) then
               call savew2(itr,ifmt_HdrWrd2,l_HdrWrd2,
     :              ln_HdrWrd2,avg,
     :              TRACEHEADER)
               else
                 write(LERR)HdrWrd2,' Not a Valid Floating Point 
     :                 Headerword'
                 go to 999
                  endif

c     calculate peak value
                  peak=0.
               do i = ist, iend
                  peak= max(peak,abstri(i))
c get job constant peak amplitude
                  job_peak = max(peak,job_peak)
               enddo
               
               if (ifmt_HdrWrd1 .eq. SAVE_FKFLT_DEF) then
           call savew2(itr,ifmt_HdrWrd1,l_HdrWrd1,
     :          ln_HdrWrd1,peak,
     :          TRACEHEADER)
            else
                  write(LERR)HdrWrd1,' Not a Valid Floating Point
     :              Headerword'
                      go to 999
              endif      
           

c     calculate rms value
                  rms=0.
                  do i = ist, iend
                     rms = rms + (abstri(i)-avg)**2
                  enddo

                  rms = sqrt(rms/(iend-ist+1))
               
               if (ifmt_HdrWrd3 .eq. SAVE_FKFLT_DEF) then
           call savew2(itr,ifmt_HdrWrd3,l_HdrWrd3,
     :          ln_HdrWrd3,rms,
     :          TRACEHEADER)
            else
                  write(LERR)HdrWrd3,' Not a Valid Floating Point
     :              Headerword'
                      go to 999
              endif      
                   

               call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )

            endif
c write output data

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO
c================================================================
      job_avg = job_avg/(float(jcount))
      
c rewind the data set
      call rwd(luin)

     
c  read input line header and save certain parameters

      lbytes=0
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'PUTVAL: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(HdrWrd1,ifmt_HdrWrd1,l_HdrWrd1,ln_HdrWrd1,
     :     TRACEHEADER)
      call savelu(HdrWrd2,ifmt_HdrWrd2,l_HdrWrd2,ln_HdrWrd2,
     :     TRACEHEADER)
      call savelu(HdrWrd3,ifmt_HdrWrd3,l_HdrWrd3,ln_HdrWrd3,
     :     TRACEHEADER)
c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

c process only live traces
            
            if ( StaCor .ne. 30000) then
               
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               
               do i = ist, iend
                  kcount = kcount +1
                  job_rms =job_rms + (abstri(i)-job_avg)**2
               enddo
               
              
             
            endif
            call vmov(tri,1,itr(ITHWP1), 1, nsamp)
            call wrtape(luout,itr,obytes)
         enddo
        

         call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)
      enddo
      job_rms = sqrt(job_rms/(float(kcount)))

c================================================================
c rewind and and write data one more time

      call rwd(luin)
      call rwd(luout)

     
c  read input line header and save certain parameters

      lbytes=0
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'PUTVAL: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

c     call saver(itr, 'NumSmp', nsamp, LINHED)
c     call saver(itr, 'SmpInt', nsi  , LINHED)
c     call saver(itr, 'NumTrc', ntrc , LINHED)
c     call saver(itr, 'NumRec', nrec , LINHED)
c     call saver(itr, 'Format', iform, LINHED)
      
      call savew(itr, 'MaxAmp', job_peak, LINHED)
          
      call savew(itr, 'AvgAmp', job_avg, LINHED)

      call savew(itr, 'RmsAmp', job_rms, LINHED)

c should be writing it out here   
      call wrtape ( luout, itr, lbyout )

c define pointers to header words required by your routine

c     call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
c     call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
c     call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
c     call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c     call savelu(HdrWrd1,ifmt_HdrWrd1,l_HdrWrd1,ln_HdrWrd1,
c    :     TRACEHEADER)
c     call savelu(HdrWrd2,ifmt_HdrWrd2,l_HdrWrd2,ln_HdrWrd2,
c    :     TRACEHEADER)
c     call savelu(HdrWrd3,ifmt_HdrWrd3,l_HdrWrd3,ln_HdrWrd3,
c    :     TRACEHEADER)
c BEGIN PROCESSING 

c skip unwanted input records

c     call recskp ( 1, irs-1, luin, ntrc, itr )

c     DO JJ = irs, ire
 
c skip to start trace

c        call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

c        DO KK = ns, ne

c           nbytes = 0
c           call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

c           if(nbytes .eq. 0) then
c              write(LERR,*)'Premature EOF on input at:'
c              write(LERR,*)'  rec= ',JJ,'  trace= ',KK
c              go to 999
c           endif            
           
c           call vmov(tri,1,itr(ITHWP1), 1, nsamp)
c           call wrtape(luout,itr,obytes)
c        enddo
        

c        call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)
c     enddo
c     write(6,*)job_peak,job_avg,job_rms
c================================================================
c     close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'putval: Normal Termination'
      write(LER,*)'putval: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'putval: ABNORMAL Termination'
      write(LER,*)'putval: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for PUTVAL'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' INPUT DATA MUST BE A DISK FILE !!'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-HW1[] -- Headerword for Peak Value      (Horz01)'
      write(LER,*)'-HW2[] -- Headerword for Average Value   (Horz02)'
      write(LER,*)'-HW3[] -- Headerword for RMS Value       (Horz03)'
      write(LER,*)'Job Constant Values are put into Line Headers:'
      write(LER,*)'      MaxAmp, AvgAmp, RmsAmp'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'     putval -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -HW1[] -HW2[] -HW3[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, HdrWrd1, HdrWrd2, HdrWrd3 )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis

      character  ntap*(*), otap*(*), name*(*)
      character HdrWrd1*(*), HdrWrd2*(*), HdrWrd3*(*)

      logical    verbos

      call argi4 ( '-e', iend, 0, 0 )

      call argstr ('-Hw1', HdrWrd1 , 'Horz01', 'Horz01' )
      call argstr('-hw1', HdrWrd1 , HdrWrd1, HdrWrd1 )
      call argstr('-HW1', HdrWrd1 , HdrWrd1, HdrWrd1)
 
      call argstr ('-Hw2', HdrWrd2 , 'Horz02', 'Horz02' )
      call argstr('-hw2', HdrWrd2 , HdrWrd2, HdrWrd2 )
      call argstr('-HW2', HdrWrd2 , HdrWrd2, HdrWrd2)
      
      call argstr ('-Hw3', HdrWrd3 , 'Horz03', 'Horz03' )
      call argstr('-hw3', HdrWrd3 , HdrWrd3, HdrWrd3 )
      call argstr('-HW3', HdrWrd3 , HdrWrd3, HdrWrd3)  
  
           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, verbos, HdrWrd1, HdrWrd2,
     :     HdrWrd3)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi

      character  ntap*(*), otap*(*)

      character  HdrWrd1*(*),HdrWrd2*(*), HdrWrd3*(*)
      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' Peak Value written to ',HdrWrd1
      write(LERR,*) ' Average Value written to ',HdrWrd2
      write(LERR,*) ' RMS Value written to ',HdrWrd3
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





