C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine earlym  (x, n, j, mutezn, iflag)


c   preserve early mute zone (sample 1 -> first live sample)

c   input:

c         x  -  input trace -> output trace
c         n  -  number samples/trace
c         j  -  sequential trace # within current record
c      iflag -  0=detect mute zone;  1=preserve mute zone

c  output:

c         x  -  trace with mute preserved
c    mutezn  -  for iflag=0 find first live sample & define early mute zone

      real     x(*)
      integer  mutezn(*)
      integer  n, j, iflag


      IF (iflag .eq. 0) THEN

         im = 0
         do  100  i = 1, n
             if (abs(x(i)) .gt. 1.e-30) then
                mutezn(j) = im
                return
             endif
             im = im + 1
100      continue
          mutezn(j) = im - 1

      ELSEIF (iflag .eq. 1) THEN

         if (mutezn(j) .eq. 0) return
         do  200  i = 1, mutezn(j)
             x(i) = 0.0
200      continue

      ENDIF

      return
      end
