C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      Subroutine hilbert(tdel,wc,lfhalf,f)
c
c   subroutine to generate hilbert transform filter
c
c   input:
c           tdel - sample increment in ms
c             wc - ross exponent
c                  0 = no weighting
c             lfhalf - half length of filter in samples (must be odd)
c  output:
c              f - hilbert filter
c
      real    f(-lfhalf:lfhalf)

      call vclr(f,1,2*lfhalf+1)
      fact = -2./(tdel*3.14159265)
      do  2  i = 1, lfhalf, 2
          f(+i) = fact/float(i)
          f(-i) = -f(+i)
2     continue
      if ( wc .ne. 0.0 ) then  
c_______________________________________________________________
c        apply ross weights
c
c        set the end of the tape to zero at one point BEYOND
c        the operator, in effect using this zero weight on data
c        that may or may not exist.
c_______________________________________________________________
         do  3  i = 1,lfhalf,2
          ratio=float(i)/(lfhalf+1)
          rosswgt=(abs((1.-ratio**2))**wc )
          f(+i)= f(+i)*rosswgt                       
          f(-i)= f(-i)*rosswgt
3        continue
      endif
c
      return
      end
          
