C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE foldf (A,ZA,LA,B,ZB,LB,X,LX,npow,first)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

C---  CROSS CORRELATE THE TIME SERIES IN A WITH THAT IN B
C---  WITH CORRELATION COEFFICIENTS RETURNED IN X.

      REAL      A(SZLNHD), B(SZLNHD), X(SZLNHD), tmp(SZLNHD)
      COMPLEX   ZA(SZLNHD), ZB(SZLNHD)
      integer   ordfft
      logical   first

      IF ( first ) THEN

         do  i = 1, SZLNHD
             ZA (i) = cmplx (0.,0.)
             ZB (i) = cmplx (0.,0.)
         enddo
         do  i = LA+1, SZLNHD
             A (i) = 0.
         enddo
C---  DETERMINE CORRECT POWER OF 2 FOR FFT'S
         LX = LA + LB - 1
         nu = ordfft ( LX )
         npow =  2 ** nu

c     write(LER,*)'LG= ',LA,npow,amp
c     write(LER,*)(a(ii),ii=1,la)

C---  FFT of A
         do  i = 1, LA
             tmp (i) = A (i)
         enddo
         call rfftf  (tmp, ZA, npow)
         call rfftsc (ZA, npow, 3, 1)

         first = .false.

      ENDIF

         do  i = 1, SZLNHD
             ZB (i) = cmplx (0.,0.)
         enddo
         do  i = LB+1, SZLNHD
             B (i) = 0.
         enddo

C---  CONVERT TIME REVERSAL OF B TO COMPLEX

C---  FFT of B
      call rfftf  (B, ZB, npow)
      call rfftsc (ZB, npow, 3, 1)

C---  MULTIPLY IN FREQ DOMAIN AND DO INVERSE TRANSFORM
      DO 6 N = 1, NPOW/2 + 1
         ZB(N) = ZA(N) * ZB(N)
6     CONTINUE
      call rfftsc (ZB, npow, -3, 0)
      call rffti  (ZB, B, npow)

C---  RETURN SCALED COEFFICIENTS IN X
      DO I = 1, LB
         X(i) = B(i)
      ENDDO

      RETURN
      END
